%% Writeclient writes to and reads from sockets used by socket_select.
%% Writeserver just writes to the sockets where writeclient reads.

:- compiler_options([xpp_on]).
#include "socket_defs_xsb.h"
#include "timer_defs_xsb.h"
#include "char_defs.h"

:- ['auxdefs'].
:- import tryN/5 from auxdefs.

:- import 
     socket/2, socket_connect/4, socket_set_option/3,
     socket_close/2, socket_get0/3, socket_put/3, socket_set_select/4, socket_select/6,
     socket_select_destroy/1 from socket.
:- import file_close/1 from file_io.


%% machine where server is running
machine(localhost).
%% Try something else:
%%machine(compserv1).

%% Port on which the server is listening
%% Server must bind to this port
xsb_port(6024).

client :-
	writeln('started client...'),
	machine(IPAddrOrHostname),
	xsb_port(XSB_port),
	tryN(4,
	     try_connect(Sockfd0 ,XSB_port, IPAddrOrHostname, Ecode2),
	     (writeln(sock_connect1(Sockfd0,XSB_port,IPAddrOrHostname,Ecode2)),
	     writeln('connected to server...')),
	     writeln('Cannot connect to server'),
	     Ecode2
	    ),
	%% Socket for reading replies
	set_timer(5),
	try_connect(Sockfd1, XSB_port, IPAddrOrHostname, Ecode3),
	(Ecode3 < 0
	-> writeln('Cannot connect to server'),
	   socket_close(Sockfd0,_), socket_close(Sockfd1,_), fail
	; true),
        writeln(socket_connect2(Sockfd1,XSB_port,IPAddrOrHostname,Ecode3)),

	socket_set_select(mytest2,
	    	    	  [Sockfd0, Sockfd1],
			  [Sockfd0, Sockfd1],
			  [Sockfd0, Sockfd1]),
	writeln(socket_set_select(mytest2,
	    	    	   [Sockfd0, Sockfd1],
			   [Sockfd0, Sockfd1],
			   [Sockfd0, Sockfd1])),
	client_loop,
	socket_select_destroy(mytest2),
	writeln('select destroyed...').

client :- writeln('Client error: exiting...').

client_loop:-  
  nl, write('Please enter a character or an ASCII code. ^D terminates: '),
  get0(Char),
  writeln(Char),

  socket_select(mytest2, 3, Availr, Availw, Availe, Error),
  writeln(socket_select(mytest2, 3, Availr, Availw, Availe, Error)),
  (Availw== []
     -> writeln('no available write sockets...')
    ;
    put_list(Availw, Char)
  ),
  ((Char == CH_EOF_P; Char == 4; Char == CH_EOF_C) ->
   true 
  ; client_loop).

put_list([],_).
put_list([H|T], Char):-
    ((Char == CH_EOF_P; Char == 4; Char == CH_EOF_C) ->
      socket_put(H, CH_EOF_C,_),
      socket_close(H, _),
      writeln('Exiting.'),put_list(T,Char)
  ;   (integer(Char) ->
      socket_put(H, Char, Err),
      writeln(socket_put(H, Char, Err)),
      put_list(T,Char)
  ;   write('Illegal input: '), writeln(Char),
      put_list(T,Char))
  ).            

%% Open socket and connect
try_connect(Sockfd0,XSB_port,IPAddrOrHostname,Ecode) :-
	 socket(Sockfd0, ErrCode1),
	 (ErrCode1 =\= SOCK_OK
	 -> writeln('Cannot connect to the server.'), fail
	 ; true),
	 socket_set_option(Sockfd0,linger,SOCK_NOLINGER),
	 socket_connect(Sockfd0, XSB_port, IPAddrOrHostname, Ecode).


