/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONIntermediateClientResponseControl;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class JSONResultAccessLogMessageHelper
implements Serializable {
    private static final long serialVersionUID = -1471250711708684260L;
    @Nullable
    private final AssuredReplicationLocalLevel assuredReplicationLocalLevel;
    @Nullable
    private final AssuredReplicationRemoteLevel assuredReplicationRemoteLevel;
    @Nullable
    private final Boolean responseDelayedByAssurance;
    @Nullable
    private final Boolean uncachedDataAccessed;
    @Nullable
    private final Double processingTimeMillis;
    @Nullable
    private final Double workQueueWaitTimeMillis;
    @Nullable
    private final JSONIntermediateClientResponseControl intermediateClientResponseControl;
    @NotNull
    private final List<String> referralURLs;
    @NotNull
    private final List<String> serversAccessed;
    @Nullable
    private final Long assuredReplicationTimeoutMillis;
    @Nullable
    private final Long intermediateResponsesReturned;
    @Nullable
    private final ResultCode resultCode;
    @NotNull
    private final Set<String> indexesWithKeysAccessedExceedingEntryLimit;
    @NotNull
    private final Set<String> indexesWithKeysAccessedNearEntryLimit;
    @NotNull
    private final Set<String> missingPrivileges;
    @NotNull
    private final Set<String> preAuthorizationUsedPrivileges;
    @NotNull
    private final Set<String> responseControlOIDs;
    @NotNull
    private final Set<String> usedPrivileges;
    @Nullable
    private final String additionalInformation;
    @Nullable
    private final String alternateAuthorizationDN;
    @Nullable
    private final String diagnosticMessage;
    @Nullable
    private final String matchedDN;
    @Nullable
    private final String replicationChangeID;

    JSONResultAccessLogMessageHelper(@NotNull JSONRequestAccessLogMessage logMessage) {
        this.diagnosticMessage = logMessage.getString(JSONFormattedAccessLogFields.DIAGNOSTIC_MESSAGE);
        this.additionalInformation = logMessage.getString(JSONFormattedAccessLogFields.ADDITIONAL_INFO);
        this.matchedDN = logMessage.getString(JSONFormattedAccessLogFields.MATCHED_DN);
        this.referralURLs = logMessage.getStringList(JSONFormattedAccessLogFields.REFERRAL_URLS);
        this.processingTimeMillis = logMessage.getDoubleNoThrow(JSONFormattedAccessLogFields.PROCESSING_TIME_MILLIS);
        this.workQueueWaitTimeMillis = logMessage.getDoubleNoThrow(JSONFormattedAccessLogFields.WORK_QUEUE_WAIT_TIME_MILLIS);
        this.responseControlOIDs = logMessage.getStringSet(JSONFormattedAccessLogFields.RESPONSE_CONTROL_OIDS);
        this.intermediateResponsesReturned = logMessage.getLongNoThrow(JSONFormattedAccessLogFields.INTERMEDIATE_RESPONSES_RETURNED);
        this.serversAccessed = logMessage.getStringList(JSONFormattedAccessLogFields.SERVERS_ACCESSED);
        this.uncachedDataAccessed = logMessage.getBooleanNoThrow(JSONFormattedAccessLogFields.UNCACHED_DATA_ACCESSED);
        this.usedPrivileges = logMessage.getStringSet(JSONFormattedAccessLogFields.USED_PRIVILEGES);
        this.preAuthorizationUsedPrivileges = logMessage.getStringSet(JSONFormattedAccessLogFields.PRE_AUTHORIZATION_USED_PRIVILEGES);
        this.missingPrivileges = logMessage.getStringSet(JSONFormattedAccessLogFields.MISSING_PRIVILEGES);
        this.alternateAuthorizationDN = logMessage.getString(JSONFormattedAccessLogFields.AUTHORIZATION_DN);
        this.replicationChangeID = logMessage.getString(JSONFormattedAccessLogFields.REPLICATION_CHANGE_ID);
        this.indexesWithKeysAccessedNearEntryLimit = logMessage.getStringSet(JSONFormattedAccessLogFields.INDEXES_WITH_KEYS_ACCESSED_NEAR_ENTRY_LIMIT);
        this.indexesWithKeysAccessedExceedingEntryLimit = logMessage.getStringSet(JSONFormattedAccessLogFields.INDEXES_WITH_KEYS_ACCESSED_EXCEEDING_ENTRY_LIMIT);
        Integer resultCodeInt = logMessage.getIntegerNoThrow(JSONFormattedAccessLogFields.RESULT_CODE_VALUE);
        this.resultCode = resultCodeInt == null ? null : ResultCode.valueOf(resultCodeInt);
        JSONObject assuranceRequirements = logMessage.getJSONObject().getFieldAsObject(JSONFormattedAccessLogFields.ASSURED_REPLICATION_REQUIREMENTS.getFieldName());
        if (assuranceRequirements == null) {
            this.assuredReplicationLocalLevel = null;
            this.assuredReplicationRemoteLevel = null;
            this.assuredReplicationTimeoutMillis = null;
            this.responseDelayedByAssurance = null;
        } else {
            this.assuredReplicationTimeoutMillis = assuranceRequirements.getFieldAsLong(JSONFormattedAccessLogFields.ASSURED_REPLICATION_REQUIREMENTS_ASSURANCE_TIMEOUT_MILLIS.getFieldName());
            this.responseDelayedByAssurance = assuranceRequirements.getFieldAsBoolean(JSONFormattedAccessLogFields.ASSURED_REPLICATION_REQUIREMENTS_RESPONSE_DELAYED_BY_ASSURANCE.getFieldName());
            String localLevelName = assuranceRequirements.getFieldAsString(JSONFormattedAccessLogFields.ASSURED_REPLICATION_REQUIREMENTS_LOCAL_ASSURANCE_LEVEL.getFieldName());
            this.assuredReplicationLocalLevel = localLevelName == null ? null : AssuredReplicationLocalLevel.forName(localLevelName);
            String remoteLevelName = assuranceRequirements.getFieldAsString(JSONFormattedAccessLogFields.ASSURED_REPLICATION_REQUIREMENTS_REMOTE_ASSURANCE_LEVEL.getFieldName());
            this.assuredReplicationRemoteLevel = remoteLevelName == null ? null : AssuredReplicationRemoteLevel.forName(remoteLevelName);
        }
        JSONObject intermediateClientResponseObject = logMessage.getJSONObject().getFieldAsObject(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESPONSE_CONTROL.getFieldName());
        this.intermediateClientResponseControl = intermediateClientResponseObject == null ? null : new JSONIntermediateClientResponseControl(intermediateClientResponseObject);
    }

    @Nullable
    ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Nullable
    String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Nullable
    String getMatchedDN() {
        return this.matchedDN;
    }

    @NotNull
    List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Nullable
    Double getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    @Nullable
    Double getWorkQueueWaitTimeMillis() {
        return this.workQueueWaitTimeMillis;
    }

    @NotNull
    Set<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Nullable
    Long getIntermediateResponsesReturned() {
        return this.intermediateResponsesReturned;
    }

    @NotNull
    List<String> getServersAccessed() {
        return this.serversAccessed;
    }

    @Nullable
    Boolean getUncachedDataAccessed() {
        return this.uncachedDataAccessed;
    }

    @NotNull
    Set<String> getUsedPrivileges() {
        return this.usedPrivileges;
    }

    @NotNull
    Set<String> getPreAuthorizationUsedPrivileges() {
        return this.preAuthorizationUsedPrivileges;
    }

    @NotNull
    Set<String> getMissingPrivileges() {
        return this.missingPrivileges;
    }

    @Nullable
    String getAlternateAuthorizationDN() {
        return this.alternateAuthorizationDN;
    }

    @Nullable
    String getReplicationChangeID() {
        return this.replicationChangeID;
    }

    @Nullable
    AssuredReplicationLocalLevel getAssuredReplicationLocalLevel() {
        return this.assuredReplicationLocalLevel;
    }

    @Nullable
    AssuredReplicationRemoteLevel getAssuredReplicationRemoteLevel() {
        return this.assuredReplicationRemoteLevel;
    }

    @Nullable
    Long getAssuredReplicationTimeoutMillis() {
        return this.assuredReplicationTimeoutMillis;
    }

    @Nullable
    Boolean getResponseDelayedByAssurance() {
        return this.responseDelayedByAssurance;
    }

    @NotNull
    Set<String> getIndexesWithKeysAccessedNearEntryLimit() {
        return this.indexesWithKeysAccessedNearEntryLimit;
    }

    @NotNull
    Set<String> getIndexesWithKeysAccessedExceedingEntryLimit() {
        return this.indexesWithKeysAccessedExceedingEntryLimit;
    }

    @Nullable
    JSONIntermediateClientResponseControl getIntermediateClientResponseControl() {
        return this.intermediateClientResponseControl;
    }
}

