/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef POPULATION_H
#define POPULATION_H

#include "player.h"
#include "map.h"
#include "game.h"

typedef struct population_s population_t;

#define MAXAGE 80

#define PERSON_FLAG_HASCHILD 0x1

typedef struct person_s {
    short uid;

    short livex;
    short livey;

    short workx;
    short worky;

    short savings; /* in 100's of $ */
    unsigned char happy;
    unsigned char flags;
    unsigned int edlevel:5;
    int worklevel:3;
} person_t;

typedef struct popgroup_s {
    int size;  /* number of people in this group */

    int allocsize;
    person_t *data;
} popgroup_t;

int population_init(population_t **pop);

int population_imigrate(population_t *pop, int);
int population_exigrate(population_t *pop, map_t *map, int);

int population_age1year(population_t *pop, map_t *map);
int population_born(population_t *pop, int);

int population_movehousing(population_t *pop, map_t *map);
int population_changejobs(population_t *pop, map_t *map);
void population_investment(population_t *pop, map_t *map, int, int);

int population_paysalaries(population_t *pop, map_t *map);
int population_payrent(population_t *pop, map_t *map);
int population_patronize(population_t *pop, map_t *map);
void population_payupkeep(population_t *pop, map_t *map);
void population_revenue(population_t *pop, map_t *map);
void population_calculate_happiness(population_t *pop);

popgroup_t *population_getgroup(population_t *pop, int age);

int population_getproduction(population_t *pop);
int population_investment_available(population_t *pop);

int population_property_tax(population_t *pop);

float population_homeless_rate(population_t *pop);
float population_unemployment_rate(population_t *pop);
int population_fire_everybody(population_t *pop, int x, int y);
int population_evict_everybody(population_t *pop, int x, int y);
int population_jobs_avail(population_t *pop);
int population_houses_avail(population_t *pop);

char *population_reason_string(happy_reason_t reason);
void population_newmonth(void);
extern int population_calculate_adults(population_t *pop);
extern int population_calculate_needhousing(population_t *pop);
extern void population_calculate_unemployed(population_t *pop, labor_t *labor);
extern void population_center(population_t *pop, int *x, int *y);

typedef void child_iterate_func(person_t *, void *);

extern void
population_foreach_child(population_t *pop, short uid, 
			 child_iterate_func *func, void *rock);

#endif /* POPULATION_H */
