provider "google" {
  version = "~> 1.10"
}

resource "google_compute_instance" "tagged" {
  count = 2

  name         = "tf-discover-${count.index}"
  machine_type = "f1-micro"
  tags         = ["consul-server"]

  boot_disk {
    initialize_params {
      image = "ubuntu-os-cloud/ubuntu-1404-trusty-v20160602"
    }
  }

  network_interface {
    network = "default"

    access_config {
      # Ephemeral
    }
  }

  service_account {
    scopes = ["https://www.googleapis.com/auth/compute.readonly"]
  }
}

resource "google_compute_instance" "untagged" {
  name         = "tf-discover-untagged"
  machine_type = "f1-micro"
  tags         = ["consul-not-matching"]

  boot_disk {
    initialize_params {
      image = "ubuntu-os-cloud/ubuntu-1404-trusty-v20160602"
    }
  }

  network_interface {
    network = "default"

    access_config {
      # Ephemeral
    }
  }

  service_account {
    scopes = ["https://www.googleapis.com/auth/compute.readonly"]
  }
}
