Test 6-13 - Verify vic-machine create TLS function
=======

# Purpose:
Verify vic-machine create certificates

# References:
* vic-machine-linux create -h

# Environment:
This test requires that a vSphere server is running and available



TLS Auth
=======

## Create VCH - defaults with --no-tls
1. Issue the following command:
```
vic-machine-linux create --name=${vch-name} --target=%{TEST_URL} \
    --user=%{TEST_USERNAME} --image-store=%{TEST_DATASTORE} --appliance-iso=bin/appliance.iso \
    --bootstrap-iso=bin/bootstrap.iso --password=%{TEST_PASSWORD} --no-tls --force=true \
    --bridge-network=%{BRIDGE_NETWORK} --public-network=%{PUBLIC_NETWORK} \
    --compute-resource=%{TEST_RESOURCE} --timeout %{TEST_TIMEOUT} \
    --volume-store=%{TEST_DATASTORE}/test:${vol}
```
2. Run regression tests

### Expected Outcome
* Deployment succeeds
* Regression tests pass

## Create VCH - use custom --tls-cert-path
1. Issue the following command:
```
vic-machine-linux create\
    ${vicmachinetls}\
    --name=%{VCH-NAME}\
    --target="%{TEST_USERNAME}:%{TEST_PASSWORD}@%{TEST_URL}"\
    --thumbprint=%{TEST_THUMBPRINT}\
    --image-store=%{TEST_DATASTORE}\
    --bridge-network=%{BRIDGE_NETWORK}\
    --public-network=%{PUBLIC_NETWORK}\
    --tls-cert-path=${EXECDIR}/foo-bar-certs/
```
### Expected Outcome
* Certs are generated and stored in `foo-bar-cert`
* Environment file in `foo-bar-certs/${VCH-NAME}` contains correct `DOCKER_CERT_PATH` variable definition

## Create VCH - force accept target thumbprint
1. Issue the following command:
```
vic-machine-linux create --name=${vch-name} --target="%{TEST_USERNAME}:%{TEST_PASSWORD}@%{TEST_URL}" \
    --force --image-store=%{TEST_DATASTORE} --bridge-network=%{BRIDGE_NETWORK} \
    --public-network=%{PUBLIC_NETWORK} ${vicmachinetls}
```
2. Run regression tests

### Expected Outcome
* Deployment succeed
* Regression test pass


## Create VCH - Specified keys
1. Generate key/cert files
2. Specify key, cert files during creation

### Expected Outcome
* Command should succeed,
* Docker is accessed through tls connection, and the key/cert previous generated can be used to access docker
* Regression test pass


## Create VCH - Server certificate with multiple blocks
1. Generate key/cert files with server-cert.pem containing a block other than CERTIFICATE as the
   first PEM block
2. Specify key, cert files during creation

### Expected Outcome
* vic-machine warns about failure to load x509 leaf
* Deployment succeeds


## Create VCH - Invalid keys
1. Specify key, cert files with mal-format files

### Expected Outcome
* Command fail for wrong key/cert file


## Create VCH - Reuse keys
1. Create VCH
2. Destroy VCH
3. Create VCH using keys and certificates from previous deployment

### Expected Outcome
* Deployment succeeds


## Create VCH - Server cert with untrusted CA
1. Generate CA and wildcard server cert for DOMAIN
2. Issue the following command to create the VCH with server cert and key
```
bin/vic-machine-linux create --name=%{VCH-NAME} --target="%{TEST_USERNAME}:%{TEST_PASSWORD}@%{TEST_URL}" --thumbprint=%{TEST_THUMBPRINT} --tls-server-key "bundle/*.${domain}.key.pem" --tls-server-cert "bundle/*.${domain}.cert.pem" --image-store=%{TEST_DATASTORE} --bridge-network=%{BRIDGE_NETWORK} --public-network=%{PUBLIC_NETWORK} ${vicmachinetls} --debug 1
```

### Expected Outcome
* Client authentication is done with vic-machine generated CA
* Certificate does not validate
* Provided certificate is presented on vic-admin interface


## Create VCH - Server cert with trusted CA
0. Generate CA and wildcard server cert for DOMAIN
1. Add root certificate to the system root CA store
2. Issue the following command to create the VCH with a static IP, specified hostname, server cert, and key
```
bin/vic-machine-linux create --name=%{VCH-NAME} --target="%{TEST_USERNAME}:%{TEST_PASSWORD}@%{TEST_URL}" --thumbprint=%{TEST_THUMBPRINT} --tls-server-key "bundle/*.${domain}.key.pem" --tls-server-cert "bundle/*.${domain}.cert.pem" --image-store=%{TEST_DATASTORE} --bridge-network=%{BRIDGE_NETWORK} --public-network=%{PUBLIC_NETWORK} ${vicmachinetls} --debug 1
```

### Expected Outcome
* Client authentication is done with vic-machine generated CA
* Certificate validates
* Deployment succeeds
* Provided certificate is presented on vic-admin interface


## Create VCH - Server cert with intermediate CA
0. Generate root CA, intermediate CA, and wildcard server cert for DOMAIN
1. Add root certificate to the system root CA store
2. Issue the following command to create the VCH with a static IP, specified hostname, server cert chain including intermediate CA cert, and server key
```
bin/vic-machine-linux create --name=%{VCH-NAME} --target="%{TEST_USERNAME}:%{TEST_PASSWORD}@%{TEST_URL}" --thumbprint=%{TEST_THUMBPRINT} --tls-server-key "bundle/*.${domain}.key.pem" --tls-server-cert "bundle/*.${domain}.cert.pem" --image-store=%{TEST_DATASTORE} --bridge-network=%{BRIDGE_NETWORK} --public-network=%{PUBLIC_NETWORK} ${vicmachinetls} --debug 1
```

### Expected Outcome
* Client authentication is done with vic-machine generated CA
* Certificate validates
* Deployment succeeds
* Provided certificate is presented on vic-admin interface
