/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __LINUX_MFD_MAX7360_H
#define __LINUX_MFD_MAX7360_H

#include <linux/bits.h>

#define MAX7360_MAX_KEY_ROWS		8
#define MAX7360_MAX_KEY_COLS		8
#define MAX7360_MAX_KEY_NUM		(MAX7360_MAX_KEY_ROWS * MAX7360_MAX_KEY_COLS)
#define MAX7360_ROW_SHIFT		3

#define MAX7360_MAX_GPIO		8
#define MAX7360_MAX_GPO			6
#define MAX7360_PORT_PWM_COUNT		8
#define MAX7360_PORT_RTR_PIN		(MAX7360_PORT_PWM_COUNT - 1)

/*
 * MAX7360 registers
 */
#define MAX7360_REG_KEYFIFO		0x00
#define MAX7360_REG_CONFIG		0x01
#define MAX7360_REG_DEBOUNCE		0x02
#define MAX7360_REG_INTERRUPT		0x03
#define MAX7360_REG_PORTS		0x04
#define MAX7360_REG_KEYREP		0x05
#define MAX7360_REG_SLEEP		0x06

/*
 * MAX7360 GPIO registers
 *
 * All these registers are reset together when writing bit 3 of
 * MAX7360_REG_GPIOCFG.
 */
#define MAX7360_REG_GPIOCFG		0x40
#define MAX7360_REG_GPIOCTRL		0x41
#define MAX7360_REG_GPIODEB		0x42
#define MAX7360_REG_GPIOCURR		0x43
#define MAX7360_REG_GPIOOUTM		0x44
#define MAX7360_REG_PWMCOM		0x45
#define MAX7360_REG_RTRCFG		0x46
#define MAX7360_REG_I2C_TIMEOUT		0x48
#define MAX7360_REG_GPIOIN		0x49
#define MAX7360_REG_RTR_CNT		0x4A
#define MAX7360_REG_PWMBASE		0x50
#define MAX7360_REG_PWMCFGBASE		0x58

#define MAX7360_REG_GPIO_LAST		0x5F

#define MAX7360_REG_PWM(x)		(MAX7360_REG_PWMBASE + (x))
#define MAX7360_REG_PWMCFG(x)		(MAX7360_REG_PWMCFGBASE + (x))

/*
 * Configuration register bits
 */
#define MAX7360_FIFO_EMPTY		0x3F
#define MAX7360_FIFO_OVERFLOW		0x7F
#define MAX7360_FIFO_RELEASE		BIT(6)
#define MAX7360_FIFO_COL		GENMASK(5, 3)
#define MAX7360_FIFO_ROW		GENMASK(2, 0)

#define MAX7360_CFG_SLEEP		BIT(7)
#define MAX7360_CFG_INTERRUPT		BIT(5)
#define MAX7360_CFG_KEY_RELEASE		BIT(3)
#define MAX7360_CFG_WAKEUP		BIT(1)
#define MAX7360_CFG_TIMEOUT		BIT(0)

#define MAX7360_DEBOUNCE		GENMASK(4, 0)
#define MAX7360_DEBOUNCE_MIN		9
#define MAX7360_DEBOUNCE_MAX		40
#define MAX7360_PORTS			GENMASK(8, 5)

#define MAX7360_INTERRUPT_TIME_MASK	GENMASK(4, 0)
#define MAX7360_INTERRUPT_FIFO_MASK	GENMASK(7, 5)

#define MAX7360_PORT_CFG_INTERRUPT_MASK		BIT(7)
#define MAX7360_PORT_CFG_INTERRUPT_EDGES	BIT(6)
#define MAX7360_PORT_CFG_COMMON_PWM		BIT(5)

/*
 * Autosleep register values
 */
#define MAX7360_AUTOSLEEP_8192MS	0x01
#define MAX7360_AUTOSLEEP_4096MS	0x02
#define MAX7360_AUTOSLEEP_2048MS	0x03
#define MAX7360_AUTOSLEEP_1024MS	0x04
#define MAX7360_AUTOSLEEP_512MS		0x05
#define MAX7360_AUTOSLEEP_256MS		0x06

#define MAX7360_GPIO_CFG_RTR_EN		BIT(7)
#define MAX7360_GPIO_CFG_GPIO_EN	BIT(4)
#define MAX7360_GPIO_CFG_GPIO_RST	BIT(3)

#define MAX7360_ROT_DEBOUNCE		GENMASK(3, 0)
#define MAX7360_ROT_DEBOUNCE_MIN	0
#define MAX7360_ROT_DEBOUNCE_MAX	15
#define MAX7360_ROT_INTCNT		GENMASK(6, 4)
#define MAX7360_ROT_INTCNT_DLY		BIT(7)

#define MAX7360_INT_INTI		0
#define MAX7360_INT_INTK		1

#define MAX7360_INT_GPIO		0
#define MAX7360_INT_KEYPAD		1
#define MAX7360_INT_ROTARY		2

#define MAX7360_NR_INTERNAL_IRQS	3

#endif
