/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.log4j.lf5.LogLevel;

public abstract class LogRecord
implements Serializable {
    protected static long _seqCount = 0L;
    protected LogLevel _level;
    protected String _message = "";
    protected long _sequenceNumber;
    protected long _millis = System.currentTimeMillis();
    protected String _category = "Debug";
    protected String _thread;
    protected String _thrownStackTrace;
    protected Throwable _thrown;
    protected String _ndc = "";
    protected String _location = "";

    public LogRecord() {
        this._level = LogLevel.INFO;
        this._sequenceNumber = LogRecord.getNextId();
        this._thread = Thread.currentThread().toString();
    }

    public String getCategory() {
        return this._category;
    }

    public LogLevel getLevel() {
        return this._level;
    }

    public String getLocation() {
        return this._location;
    }

    public String getMessage() {
        return this._message;
    }

    public long getMillis() {
        return this._millis;
    }

    public String getNDC() {
        return this._ndc;
    }

    protected static synchronized long getNextId() {
        return ++_seqCount;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public String getThreadDescription() {
        return this._thread;
    }

    public Throwable getThrown() {
        return this._thrown;
    }

    public String getThrownStackTrace() {
        return this._thrownStackTrace;
    }

    public boolean hasThrown() {
        Throwable thrown = this.getThrown();
        if (thrown == null) {
            return false;
        }
        String thrownString = thrown.toString();
        return thrownString != null && thrownString.trim().length() != 0;
    }

    public boolean isFatal() {
        return this.isSevereLevel() || this.hasThrown();
    }

    public abstract boolean isSevereLevel();

    public static synchronized void resetSequenceNumber() {
        _seqCount = 0L;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public void setLevel(LogLevel level) {
        this._level = level;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setMillis(long millis) {
        this._millis = millis;
    }

    public void setNDC(String ndc) {
        this._ndc = ndc;
    }

    public void setSequenceNumber(long number) {
        this._sequenceNumber = number;
    }

    public void setThreadDescription(String threadDescription) {
        this._thread = threadDescription;
    }

    public void setThrown(Throwable thrown) {
        if (thrown == null) {
            return;
        }
        this._thrown = thrown;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        thrown.printStackTrace(out);
        out.flush();
        this._thrownStackTrace = sw.toString();
        try {
            out.close();
            sw.close();
        }
        catch (IOException iOException) {}
        out = null;
        sw = null;
    }

    public void setThrownStackTrace(String trace) {
        this._thrownStackTrace = trace;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LogRecord: [" + this._level + ", " + this._message + "]");
        return buf.toString();
    }
}

