/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ManifestParser;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;
import org.java.plugin.util.ExtendedProperties;

public final class PluginRegistryImpl
implements PluginRegistry {
    static final String PACKAGE_NAME = "org.java.plugin.registry.xml";
    private static final char UNIQUE_SEPARATOR = '@';
    private static final Log log = LogFactory.getLog(class$org$java$plugin$registry$xml$PluginRegistryImpl == null ? (class$org$java$plugin$registry$xml$PluginRegistryImpl = PluginRegistryImpl.class$("org.java.plugin.registry.xml.PluginRegistryImpl")) : class$org$java$plugin$registry$xml$PluginRegistryImpl);
    private final List registrationReport = new LinkedList();
    private final Map registeredPlugins = new HashMap();
    private final Map registeredFragments = new HashMap();
    private final List listeners = Collections.synchronizedList(new LinkedList());
    private ManifestParser manifestParser;
    private boolean stopOnError = false;
    static /* synthetic */ Class class$org$java$plugin$registry$xml$PluginRegistryImpl;

    public PluginRegistryImpl() {
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registryStart", null));
    }

    public void configure(ExtendedProperties extendedProperties) {
        this.stopOnError = "true".equalsIgnoreCase(extendedProperties.getProperty("stopOnError", "false"));
        boolean bl = !"false".equalsIgnoreCase(extendedProperties.getProperty("isValidating", "true"));
        this.manifestParser = new ManifestParser(bl);
        log.info("configured, stopOnError=" + this.stopOnError + ", isValidating=" + bl);
    }

    public PluginRegistry.ManifestInfo readManifestInfo(URL uRL) throws ManifestProcessingException {
        try {
            return new ManifestInfoImpl(this.manifestParser.parseManifestInfo(uRL));
        }
        catch (Exception exception) {
            throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", uRL, exception);
        }
    }

    public Map register(URL[] uRLArray) throws ManifestProcessingException {
        UniqueIdentity uniqueIdentity;
        Object object;
        Map.Entry entry;
        Iterator iterator;
        Object object2;
        Object object3;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>();
        Object object4 = this.registeredPlugins.values().iterator();
        while (object4.hasNext()) {
            object3 = ((PluginDescriptor)object4.next()).getExtensionPoints().iterator();
            while (object3.hasNext()) {
                object2 = (ExtensionPoint)object3.next();
                linkedList.add(object2);
                Iterator iterator2 = object2.getConnectedExtensions().iterator();
                while (iterator2.hasNext()) {
                    iterator = (Extension)iterator2.next();
                    hashMap.put(iterator.getUniqueId(), (Extension)((Object)iterator));
                }
            }
        }
        object4 = new HashMap(uRLArray.length);
        object3 = new HashMap();
        object2 = new HashMap();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "manifestsParsingStart", null));
        for (int i = 0; i < uRLArray.length; ++i) {
            iterator = uRLArray[i];
            try {
                entry = this.manifestParser.parseManifest((URL)((Object)iterator));
            }
            catch (Exception exception) {
                log.error("can't parse manifest file " + iterator, exception);
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", iterator, exception);
                }
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "manifestParsingError", new Object[]{iterator, exception}));
                continue;
            }
            if (entry instanceof ModelPluginFragment) {
                object2.put(iterator, entry);
                continue;
            }
            if (!(entry instanceof ModelPluginDescriptor)) {
                log.warn("URL " + iterator + " points to XML document of unknown type");
                continue;
            }
            object3.put(iterator, entry);
        }
        log.debug("manifest files parsed, plugins.size=" + object3.size() + ", fragments.size=" + object2.size());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "manifestsParsingFinish", new Object[]{new Integer(object3.size()), new Integer(object2.size())}));
        this.checkVersions((Map)object3);
        log.debug("plug-ins versions checked, plugins.size=" + object3.size());
        this.checkVersions((Map)object2);
        log.debug("plug-in fragments versions checked, fragments.size=" + object2.size());
        RegistryChangeDataImpl registryChangeDataImpl = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringPluginsStart", null));
        iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = (URL)entry.getKey();
            uniqueIdentity = this.registerPlugin((URL)object, (ModelPluginDescriptor)entry.getValue(), registryChangeDataImpl);
            if (uniqueIdentity == null) continue;
            object4.put(object, uniqueIdentity);
        }
        object3.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringFragmentsStart", null));
        iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = (URL)entry.getKey();
            uniqueIdentity = this.registerFragment((URL)object, (ModelPluginFragment)entry.getValue(), registryChangeDataImpl);
            if (uniqueIdentity == null) continue;
            object4.put(object, uniqueIdentity);
        }
        object2.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringPluginsFinish", new Integer(this.registeredPlugins.size())));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringFragmentsFinish", new Integer(this.registeredFragments.size())));
        log.info("plug-in and fragment descriptors registered - " + object4.size());
        this.dump();
        if (object4.isEmpty()) {
            return object4;
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((ExtensionPointImpl)((Object)iterator.next())).registryChanged();
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ((ExtensionImpl)((Object)iterator.next())).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            iterator = this.registeredPlugins.values().iterator();
            while (iterator.hasNext()) {
                entry = ((PluginDescriptor)((Object)iterator.next())).getExtensionPoints().iterator();
                while (entry.hasNext()) {
                    object = ((ExtensionPoint)entry.next()).getConnectedExtensions().iterator();
                    while (object.hasNext()) {
                        uniqueIdentity = (Extension)object.next();
                        if (!hashMap.containsKey(uniqueIdentity.getUniqueId())) {
                            registryChangeDataImpl.putAddedExtension(uniqueIdentity.getUniqueId(), this.makeUniqueId(uniqueIdentity.getExtendedPluginId(), uniqueIdentity.getExtendedPointId()));
                            continue;
                        }
                        hashMap.remove(uniqueIdentity.getUniqueId());
                        if (!registryChangeDataImpl.modifiedPlugins().contains(uniqueIdentity.getDeclaringPluginDescriptor().getId()) && !registryChangeDataImpl.modifiedPlugins().contains(uniqueIdentity.getExtendedPluginId())) continue;
                        registryChangeDataImpl.putModifiedExtension(uniqueIdentity.getUniqueId(), this.makeUniqueId(uniqueIdentity.getExtendedPluginId(), uniqueIdentity.getExtendedPointId()));
                    }
                }
            }
            iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                entry = (Extension)((Object)iterator.next());
                registryChangeDataImpl.putRemovedExtension(entry.getUniqueId(), this.makeUniqueId(entry.getExtendedPluginId(), entry.getExtendedPointId()));
            }
            this.fireEvent(registryChangeDataImpl);
        }
        return object4;
    }

    private void checkVersions(Map map) throws ManifestProcessingException {
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            URL uRL = (URL)entry.getKey();
            ModelPluginManifest modelPluginManifest = (ModelPluginManifest)entry.getValue();
            if (this.registeredPlugins.containsKey(modelPluginManifest.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePlugin", modelPluginManifest.getId());
                }
                iterator.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "duplicatedPluginId", modelPluginManifest.getId()));
                continue;
            }
            if (this.registeredFragments.containsKey(modelPluginManifest.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePluginFragment", modelPluginManifest.getId());
                }
                iterator.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "duplicatedFragmentId", modelPluginManifest.getId()));
                continue;
            }
            Object[] objectArray = (Object[])hashMap.get(modelPluginManifest.getId());
            if (objectArray == null) {
                hashMap.put(modelPluginManifest.getId(), new Object[]{modelPluginManifest.getVersion(), uRL});
                continue;
            }
            if (((Version)objectArray[0]).compareTo(modelPluginManifest.getVersion()) < 0) {
                hashSet.add(objectArray[1]);
                hashMap.put(modelPluginManifest.getId(), new Object[]{modelPluginManifest.getVersion(), uRL});
                continue;
            }
            hashSet.add(uRL);
        }
        hashMap.clear();
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            map.remove(iterator.next());
        }
        hashSet.clear();
    }

    private PluginDescriptor registerPlugin(URL uRL, ModelPluginDescriptor modelPluginDescriptor, RegistryChangeDataImpl registryChangeDataImpl) throws ManifestProcessingException {
        log.debug("registering plug-in, URL - " + uRL);
        PluginDescriptorImpl pluginDescriptorImpl = null;
        try {
            pluginDescriptorImpl = new PluginDescriptorImpl(this, modelPluginDescriptor, uRL);
            registryChangeDataImpl.addedPlugins().add(pluginDescriptorImpl.getId());
            Iterator iterator = this.registeredFragments.values().iterator();
            while (iterator.hasNext()) {
                PluginFragmentImpl pluginFragmentImpl = (PluginFragmentImpl)iterator.next();
                if (!pluginFragmentImpl.matches(pluginDescriptorImpl)) continue;
                pluginDescriptorImpl.registerFragment(pluginFragmentImpl);
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "pluginRegistered", pluginDescriptorImpl.getUniqueId()));
        }
        catch (ManifestProcessingException manifestProcessingException) {
            log.error("failed registering plug-in, URL - " + uRL, manifestProcessingException);
            if (this.stopOnError) {
                throw manifestProcessingException;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "pluginRegistrationFailed", new Object[]{uRL, manifestProcessingException}));
            return null;
        }
        this.registeredPlugins.put(pluginDescriptorImpl.getId(), pluginDescriptorImpl);
        return pluginDescriptorImpl;
    }

    private PluginFragment registerFragment(URL uRL, ModelPluginFragment modelPluginFragment, RegistryChangeDataImpl registryChangeDataImpl) throws ManifestProcessingException {
        log.debug("registering plug-in fragment descriptor, URL - " + uRL);
        PluginFragmentImpl pluginFragmentImpl = null;
        try {
            pluginFragmentImpl = new PluginFragmentImpl(this, modelPluginFragment, uRL);
            boolean bl = false;
            PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)this.getPluginDescriptor(pluginFragmentImpl.getPluginId());
            if (pluginFragmentImpl.matches(pluginDescriptorImpl)) {
                pluginDescriptorImpl.registerFragment(pluginFragmentImpl);
                if (!registryChangeDataImpl.addedPlugins().contains(pluginDescriptorImpl.getId())) {
                    registryChangeDataImpl.modifiedPlugins().add(pluginDescriptorImpl.getId());
                }
                bl = true;
            }
            if (!bl) {
                log.warn("no matching plug-ins found for fragment " + pluginFragmentImpl.getUniqueId());
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(2, null, 0, "noMatchingPluginFound", pluginFragmentImpl.getUniqueId()));
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "fragmentRegistered", pluginFragmentImpl.getUniqueId()));
        }
        catch (ManifestProcessingException manifestProcessingException) {
            log.error("failed registering plug-in fragment descriptor, URL - " + uRL, manifestProcessingException);
            if (this.stopOnError) {
                throw manifestProcessingException;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "fragmentRegistrationFailed", new Object[]{uRL, manifestProcessingException}));
            return null;
        }
        this.registeredFragments.put(pluginFragmentImpl.getId(), pluginFragmentImpl);
        return pluginFragmentImpl;
    }

    public Collection unregister(String[] stringArray) {
        UniqueIdentity uniqueIdentity;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        LinkedList<ExtensionPoint> linkedList = new LinkedList<ExtensionPoint>();
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>();
        Object object6 = this.registeredPlugins.values().iterator();
        while (object6.hasNext()) {
            object5 = ((PluginDescriptor)object6.next()).getExtensionPoints().iterator();
            while (object5.hasNext()) {
                object4 = (ExtensionPoint)object5.next();
                linkedList.add((ExtensionPoint)object4);
                object3 = object4.getConnectedExtensions().iterator();
                while (object3.hasNext()) {
                    Extension extension = (Extension)object3.next();
                    hashMap.put(extension.getUniqueId(), extension);
                }
            }
        }
        object6 = new HashSet();
        object5 = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringPrepare", null));
        object4 = new HashMap();
        object3 = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = (PluginDescriptor)this.registeredPlugins.get(stringArray[i]);
            if (object2 != null) {
                object = this.getDependingPlugins((PluginDescriptor)object2).iterator();
                while (object.hasNext()) {
                    uniqueIdentity = (PluginDescriptor)object.next();
                    object4.put(uniqueIdentity.getId(), uniqueIdentity);
                    ((RegistryChangeDataImpl)object5).removedPlugins().add(uniqueIdentity.getId());
                }
                object4.put(object2.getId(), object2);
                ((RegistryChangeDataImpl)object5).removedPlugins().add(object2.getId());
                continue;
            }
            object = (PluginFragment)this.registeredFragments.get(stringArray[i]);
            if (object != null) {
                object3.put(object.getId(), object);
                continue;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(2, null, 0, "pluginToUngregisterNotFound", stringArray[i]));
        }
        Iterator<Object> iterator = object4.values().iterator();
        while (iterator.hasNext()) {
            object2 = (PluginDescriptor)iterator.next();
            object = object2.getFragments().iterator();
            while (object.hasNext()) {
                uniqueIdentity = (PluginFragment)object.next();
                if (object3.containsKey(uniqueIdentity.getId())) continue;
                object3.put(uniqueIdentity.getId(), uniqueIdentity);
            }
        }
        this.fireEvent((RegistryChangeDataImpl)object5);
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringFragmentsStart", null));
        iterator = object3.values().iterator();
        while (iterator.hasNext()) {
            object2 = (PluginFragmentImpl)iterator.next();
            this.unregisterFragment((PluginFragmentImpl)object2);
            if (!object4.containsKey(((PluginFragmentImpl)object2).getPluginId())) {
                ((RegistryChangeDataImpl)object5).modifiedPlugins().add(((PluginFragmentImpl)object2).getPluginId());
            }
            object6.add(((PluginFragmentImpl)object2).getUniqueId());
        }
        object3.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringPluginsStart", null));
        iterator = object4.values().iterator();
        while (iterator.hasNext()) {
            object2 = (PluginDescriptorImpl)iterator.next();
            this.unregisterPlugin((PluginDescriptorImpl)object2);
            object6.add(((PluginDescriptorImpl)object2).getUniqueId());
        }
        object4.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringPluginsFinish", new Integer(this.registeredPlugins.size())));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringFragmentsFinish", new Integer(this.registeredFragments.size())));
        log.info("plug-in and fragment descriptors unregistered - " + object6.size());
        this.dump();
        if (object6.isEmpty()) {
            return object6;
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((ExtensionPointImpl)iterator.next()).registryChanged();
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ((ExtensionImpl)iterator.next()).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            iterator = this.registeredPlugins.values().iterator();
            while (iterator.hasNext()) {
                object2 = ((PluginDescriptor)iterator.next()).getExtensionPoints().iterator();
                while (object2.hasNext()) {
                    object = ((ExtensionPoint)object2.next()).getConnectedExtensions().iterator();
                    while (object.hasNext()) {
                        uniqueIdentity = (Extension)object.next();
                        if (!hashMap.containsKey(uniqueIdentity.getUniqueId())) {
                            ((RegistryChangeDataImpl)object5).putAddedExtension(uniqueIdentity.getUniqueId(), this.makeUniqueId(uniqueIdentity.getExtendedPluginId(), uniqueIdentity.getExtendedPointId()));
                            continue;
                        }
                        hashMap.remove(uniqueIdentity.getUniqueId());
                        if (!((RegistryChangeDataImpl)object5).modifiedPlugins().contains(uniqueIdentity.getDeclaringPluginDescriptor().getId()) && !((RegistryChangeDataImpl)object5).modifiedPlugins().contains(uniqueIdentity.getExtendedPluginId())) continue;
                        ((RegistryChangeDataImpl)object5).putModifiedExtension(uniqueIdentity.getUniqueId(), this.makeUniqueId(uniqueIdentity.getExtendedPluginId(), uniqueIdentity.getExtendedPointId()));
                    }
                }
            }
            iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                object2 = (Extension)iterator.next();
                ((RegistryChangeDataImpl)object5).putRemovedExtension(object2.getUniqueId(), this.makeUniqueId(object2.getExtendedPluginId(), object2.getExtendedPointId()));
            }
            this.fireEvent((RegistryChangeDataImpl)object5);
        }
        return object6;
    }

    private void unregisterPlugin(PluginDescriptorImpl pluginDescriptorImpl) {
        this.registeredPlugins.remove(pluginDescriptorImpl.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "pluginUnregistered", pluginDescriptorImpl.getUniqueId()));
    }

    private void unregisterFragment(PluginFragmentImpl pluginFragmentImpl) {
        PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)this.registeredPlugins.get(pluginFragmentImpl.getPluginId());
        if (pluginDescriptorImpl != null) {
            pluginDescriptorImpl.unregisterFragment(pluginFragmentImpl);
        }
        this.registeredFragments.remove(pluginFragmentImpl.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "fragmentUnregistered", pluginFragmentImpl.getUniqueId()));
    }

    private void dump() {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PLUG-IN REGISTRY DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tPlug-ins: " + this.registeredPlugins.size() + "\r\n");
        Iterator iterator = this.registeredPlugins.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("\tFragments: " + this.registeredFragments.size() + "\r\n");
        iterator = this.registeredFragments.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
        stringBuffer.append("-------------- DUMP END -----------------\r\n");
        log.debug(stringBuffer.toString());
    }

    public ExtensionPoint getExtensionPoint(String string, String string2) {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown extension point ID - " + this.makeUniqueId(string, string2));
        }
        Iterator iterator = pluginDescriptor.getExtensionPoints().iterator();
        while (iterator.hasNext()) {
            ExtensionPoint extensionPoint = (ExtensionPoint)iterator.next();
            if (!extensionPoint.getId().equals(string2)) continue;
            if (extensionPoint.isValid()) {
                return extensionPoint;
            }
            log.warn("extension point " + extensionPoint.getUniqueId() + " is invalid and ignored by registry");
            break;
        }
        throw new IllegalArgumentException("unknown extension point ID - " + this.makeUniqueId(string, string2));
    }

    public ExtensionPoint getExtensionPoint(String string) {
        return this.getExtensionPoint(this.extractPluginId(string), this.extractId(string));
    }

    public boolean isExtensionPointAvailable(String string, String string2) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            return false;
        }
        Iterator iterator = pluginDescriptor.getExtensionPoints().iterator();
        while (iterator.hasNext()) {
            ExtensionPoint extensionPoint = (ExtensionPoint)iterator.next();
            if (!extensionPoint.getId().equals(string2)) continue;
            return extensionPoint.isValid();
        }
        return false;
    }

    public boolean isExtensionPointAvailable(String string) {
        return this.isExtensionPointAvailable(this.extractPluginId(string), this.extractId(string));
    }

    public PluginDescriptor getPluginDescriptor(String string) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        return pluginDescriptor;
    }

    public boolean isPluginDescriptorAvailable(String string) {
        return this.registeredPlugins.containsKey(string);
    }

    public Collection getPluginDescriptors() {
        return this.registeredPlugins.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.registeredPlugins.values());
    }

    public Collection getOldPluginDescriptors(String string) {
        return Collections.EMPTY_LIST;
    }

    public Collection getPluginFragments() {
        return this.registeredFragments.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.registeredFragments.values());
    }

    public Collection getOldPluginFragments(String string) {
        return Collections.EMPTY_LIST;
    }

    public Collection getDependingPlugins(PluginDescriptor pluginDescriptor) {
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        Iterator iterator = this.getPluginDescriptors().iterator();
        block0: while (iterator.hasNext()) {
            PluginDescriptor pluginDescriptor2 = (PluginDescriptor)iterator.next();
            if (pluginDescriptor2.getId().equals(pluginDescriptor.getId())) continue;
            Iterator iterator2 = pluginDescriptor2.getPrerequisites().iterator();
            while (iterator2.hasNext()) {
                PluginPrerequisite pluginPrerequisite = (PluginPrerequisite)iterator2.next();
                if (!pluginPrerequisite.getPluginId().equals(pluginDescriptor.getId()) || !pluginPrerequisite.matches()) continue;
                if (hashMap.containsKey(pluginDescriptor2.getId())) continue block0;
                hashMap.put(pluginDescriptor2.getId(), pluginDescriptor2);
                Iterator iterator3 = this.getDependingPlugins(pluginDescriptor2).iterator();
                while (iterator3.hasNext()) {
                    PluginDescriptor pluginDescriptor3 = (PluginDescriptor)iterator3.next();
                    if (hashMap.containsKey(pluginDescriptor3.getId())) continue;
                    hashMap.put(pluginDescriptor3.getId(), pluginDescriptor3);
                }
                continue block0;
            }
        }
        return hashMap.values();
    }

    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver) {
        return this.checkIntegrity(pathResolver, false);
    }

    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver, boolean bl) {
        IntegrityChecker integrityChecker = new IntegrityChecker(this, bl ? this.registrationReport : Collections.EMPTY_LIST);
        integrityChecker.doCheck(pathResolver);
        return integrityChecker;
    }

    public IntegrityCheckReport getRegistrationReport() {
        return new IntegrityChecker(this, this.registrationReport);
    }

    public String makeUniqueId(String string, String string2) {
        return string + '@' + string2;
    }

    public String makeUniqueId(String string, Version version) {
        return string + '@' + version;
    }

    public String extractPluginId(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return string.substring(0, n);
    }

    public String extractId(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return string.substring(n + 1);
    }

    public Version extractVersion(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return Version.parse(string.substring(n + 1));
    }

    public void registerListener(PluginRegistry.RegistryChangeListener registryChangeListener) {
        if (this.listeners.contains(registryChangeListener)) {
            throw new IllegalArgumentException("listener " + registryChangeListener + " already registered");
        }
        this.listeners.add(registryChangeListener);
    }

    public void unregisterListener(PluginRegistry.RegistryChangeListener registryChangeListener) {
        if (!this.listeners.remove(registryChangeListener)) {
            throw new IllegalArgumentException("unknown listener " + registryChangeListener);
        }
    }

    void fireEvent(RegistryChangeDataImpl registryChangeDataImpl) {
        registryChangeDataImpl.dump();
        if (this.listeners.isEmpty()) {
            return;
        }
        PluginRegistry.RegistryChangeListener[] registryChangeListenerArray = this.listeners.toArray(new PluginRegistry.RegistryChangeListener[this.listeners.size()]);
        registryChangeDataImpl.beforeEventFire();
        log.debug("propagating registry change event");
        for (int i = 0; i < registryChangeListenerArray.length; ++i) {
            registryChangeListenerArray[i].registryChanged(registryChangeDataImpl);
        }
        log.debug("registry change event propagated");
        registryChangeDataImpl.afterEventFire();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ManifestInfoImpl
    implements PluginRegistry.ManifestInfo {
        private final ModelManifestInfo model;

        ManifestInfoImpl(ModelManifestInfo modelManifestInfo) {
            this.model = modelManifestInfo;
        }

        public String getId() {
            return this.model.getId();
        }

        public Version getVersion() {
            return this.model.getVersion();
        }

        public String getVendor() {
            return this.model.getVendor();
        }

        public String getPluginId() {
            return this.model.getPluginId();
        }

        public Version getPluginVersion() {
            return this.model.getPluginVersion();
        }

        public String getMatchingRule() {
            return this.model.getMatch();
        }
    }

    private static final class RegistryChangeDataImpl
    implements PluginRegistry.RegistryChangeData {
        private Set addedPlugins;
        private Set removedPlugins;
        private Set modifiedPlugins;
        private Map addedExtensions;
        private Map removedExtensions;
        private Map modifiedExtensions;

        protected RegistryChangeDataImpl() {
            this.reset();
        }

        private void reset() {
            this.addedPlugins = new HashSet();
            this.removedPlugins = new HashSet();
            this.modifiedPlugins = new HashSet();
            this.addedExtensions = new HashMap();
            this.removedExtensions = new HashMap();
            this.modifiedExtensions = new HashMap();
        }

        protected void beforeEventFire() {
            this.addedPlugins = Collections.unmodifiableSet(this.addedPlugins);
            this.removedPlugins = Collections.unmodifiableSet(this.removedPlugins);
            this.modifiedPlugins = Collections.unmodifiableSet(this.modifiedPlugins);
            this.addedExtensions = Collections.unmodifiableMap(this.addedExtensions);
            this.removedExtensions = Collections.unmodifiableMap(this.removedExtensions);
            this.modifiedExtensions = Collections.unmodifiableMap(this.modifiedExtensions);
        }

        protected void afterEventFire() {
            this.reset();
        }

        protected void dump() {
            Log log = LogFactory.getLog(this.getClass());
            if (!log.isDebugEnabled()) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PLUG-IN REGISTRY CHANGES DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tAdded plug-ins: " + this.addedPlugins.size() + "\r\n");
            Iterator<Object> iterator = this.addedPlugins.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tRemoved plug-ins: " + this.removedPlugins.size() + "\r\n");
            iterator = this.removedPlugins.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tModified plug-ins: " + this.modifiedPlugins.size() + "\r\n");
            iterator = this.modifiedPlugins.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tAdded extensions: " + this.addedExtensions.size() + "\r\n");
            iterator = this.addedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tRemoved extensions: " + this.removedExtensions.size() + "\r\n");
            iterator = this.removedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tModified extensions: " + this.modifiedExtensions.size() + "\r\n");
            iterator = this.modifiedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
            stringBuffer.append("-------------- DUMP END -----------------\r\n");
            log.debug(stringBuffer.toString());
        }

        public Set addedPlugins() {
            return this.addedPlugins;
        }

        public Set removedPlugins() {
            return this.removedPlugins;
        }

        public Set modifiedPlugins() {
            return this.modifiedPlugins;
        }

        void putAddedExtension(String string, String string2) {
            this.addedExtensions.put(string, string2);
        }

        public Set addedExtensions() {
            return this.addedExtensions.keySet();
        }

        public Set addedExtensions(String string) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.addedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }

        void putRemovedExtension(String string, String string2) {
            this.removedExtensions.put(string, string2);
        }

        public Set removedExtensions() {
            return this.removedExtensions.keySet();
        }

        public Set removedExtensions(String string) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.removedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }

        void putModifiedExtension(String string, String string2) {
            this.modifiedExtensions.put(string, string2);
        }

        public Set modifiedExtensions() {
            return this.modifiedExtensions.keySet();
        }

        public Set modifiedExtensions(String string) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.modifiedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

