/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.ValueAnimator;

public abstract class AbstractValueAnimator<T>
implements ValueAnimator<T> {
    private T currentValue;
    private int currentCount = 0;
    private int startWait = 0;
    private int stopWait = 0;
    private int completedAt = -1;

    public AbstractValueAnimator(T initial, int startWait, int stopWait) {
        this.currentValue = initial;
        this.startWait = startWait;
        this.stopWait = stopWait;
    }

    @Override
    public T nextValue() {
        if (this.currentCount >= this.startWait && !this.hasFinished() && this.completedAt <= 0) {
            this.currentValue = this.makeNextValue();
        }
        ++this.currentCount;
        return this.currentValue;
    }

    protected abstract T makeNextValue();

    protected abstract void resetToInitial();

    @Override
    public final void reset() {
        this.resetToInitial();
        this.currentCount = 0;
        this.completedAt = -1;
    }

    protected abstract boolean complete();

    @Override
    public final boolean hasFinished() {
        boolean comp = this.complete();
        if (!comp) {
            return false;
        }
        if (this.completedAt < 0) {
            this.completedAt = this.currentCount;
        }
        return this.currentCount - this.completedAt >= this.stopWait;
    }
}

