/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Stack;
import org.openimaj.util.pair.ObjectDoublePair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class IncrementalByteKDTree {
    KDNode _root = null;

    public IncrementalByteKDTree() {
    }

    public IncrementalByteKDTree(Collection<byte[]> coords) {
        this.insertAll(coords);
    }

    public IncrementalByteKDTree(byte[][] coords) {
        this.insertAll(coords);
    }

    public void insertAll(Collection<byte[]> coords) {
        for (byte[] c : coords) {
            this.insert(c);
        }
    }

    public void insertAll(byte[][] coords) {
        for (byte[] c : coords) {
            this.insert(c);
        }
    }

    public void insert(byte[] point) {
        if (this._root == null) {
            this._root = new KDNode(point, 0);
        } else {
            double ordinate2;
            KDNode tmpNode;
            int discriminate;
            double ordinate1;
            KDNode curNode = this._root;
            do {
                tmpNode = curNode;
            } while ((curNode = (ordinate1 = (double)point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = (double)tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
            if (++discriminate >= point.length) {
                discriminate = 0;
            }
            if (ordinate1 > ordinate2) {
                tmpNode.right = new KDNode(point, discriminate);
            } else {
                tmpNode.left = new KDNode(point, discriminate);
            }
        }
    }

    static final boolean isContained(byte[] point, byte[] lower, byte[] upper) {
        for (int i = 0; i < point.length; ++i) {
            double ordinate1 = point[i];
            double ordinate2 = lower[i];
            double ordinate3 = upper[i];
            if (!(ordinate1 < ordinate2) && !(ordinate1 > ordinate3)) continue;
            return false;
        }
        return true;
    }

    public List<byte[]> rangeSearch(byte[] lowerExtreme, byte[] upperExtreme) {
        ArrayList<byte[]> results = new ArrayList<byte[]>(1000);
        Stack<KDNode> stack = new Stack<KDNode>();
        if (this._root == null) {
            return results;
        }
        stack.push(this._root);
        while (!stack.empty()) {
            KDNode tmpNode = (KDNode)stack.pop();
            int discriminate = tmpNode.discriminateDim;
            double ordinate1 = tmpNode.point[discriminate];
            double ordinate2 = lowerExtreme[discriminate];
            if (ordinate1 >= ordinate2 && tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (ordinate1 <= (ordinate2 = (double)upperExtreme[discriminate]) && tmpNode.right != null) {
                stack.push(tmpNode.right);
            }
            if (!IncrementalByteKDTree.isContained(tmpNode.point, lowerExtreme, upperExtreme)) continue;
            results.add(tmpNode.point);
        }
        return results;
    }

    protected static final double distance(byte[] a, byte[] b) {
        double s = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double fa = a[i];
            double fb = b[i];
            s += (fa - fb) * (fa - fb);
        }
        return s;
    }

    public ObjectDoublePair<byte[]> findNearestNeighbour(byte[] query) {
        Stack<KDNode> stack = this.walkdown(query);
        ObjectDoublePair<byte[]> state = new ObjectDoublePair<byte[]>();
        state.first = stack.peek().point;
        state.second = IncrementalByteKDTree.distance(query, (byte[])state.first);
        if (state.second == 0.0) {
            return state;
        }
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtree(current, query, state);
        }
        return state;
    }

    public List<ObjectDoublePair<byte[]>> findNearestNeighbours(byte[] query, int k) {
        Stack<KDNode> stack = this.walkdown(query);
        BoundedPriorityQueue<ObjectDoublePair<byte[]>> state = new BoundedPriorityQueue<ObjectDoublePair<byte[]>>(k, (Comparator<ObjectDoublePair<byte[]>>)ObjectDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ObjectDoublePair initialState = new ObjectDoublePair();
        initialState.first = stack.peek().point;
        initialState.second = IncrementalByteKDTree.distance(query, (byte[])initialState.first);
        state.add(initialState);
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtreeK(current, query, state, k);
        }
        return state.toOrderedListDestructive();
    }

    private void checkSubtree(KDNode node, byte[] query, ObjectDoublePair<byte[]> state) {
        if (node == null) {
            return;
        }
        double dist = IncrementalByteKDTree.distance(query, node.point);
        if (dist < state.second) {
            state.first = node.point;
            state.second = dist;
        }
        if (state.second == 0.0) {
            return;
        }
        double d = node.point[node.discriminateDim] - query[node.discriminateDim];
        if (d * d > state.second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtree(node.right, query, state);
            } else {
                this.checkSubtree(node.left, query, state);
            }
        } else {
            this.checkSubtree(node.left, query, state);
            this.checkSubtree(node.right, query, state);
        }
    }

    private void checkSubtreeK(KDNode node, byte[] query, PriorityQueue<ObjectDoublePair<byte[]>> state, int k) {
        double d;
        if (node == null) {
            return;
        }
        double dist = IncrementalByteKDTree.distance(query, node.point);
        boolean cont = false;
        for (ObjectDoublePair<byte[]> s : state) {
            if (!((byte[])s.first).equals(node.point)) continue;
            cont = true;
            break;
        }
        if (!cont) {
            ObjectDoublePair<Object> s;
            if (state.size() < k) {
                s = new ObjectDoublePair();
                s.first = node.point;
                s.second = dist;
                state.add(s);
            } else if (dist < state.peek().second) {
                s = state.poll();
                s.first = node.point;
                s.second = dist;
                state.add(s);
            }
        }
        if ((d = (double)(node.point[node.discriminateDim] - query[node.discriminateDim])) * d > state.peek().second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtreeK(node.right, query, state, k);
            } else {
                this.checkSubtreeK(node.left, query, state, k);
            }
        } else {
            this.checkSubtreeK(node.left, query, state, k);
            this.checkSubtreeK(node.right, query, state, k);
        }
    }

    private Stack<KDNode> walkdown(byte[] point) {
        double ordinate2;
        KDNode tmpNode;
        int discriminate;
        double ordinate1;
        if (this._root == null) {
            return null;
        }
        Stack<KDNode> stack = new Stack<KDNode>();
        KDNode curNode = this._root;
        do {
            tmpNode = curNode;
            stack.push(tmpNode);
            if (tmpNode.point != point) continue;
            return stack;
        } while ((curNode = (ordinate1 = (double)point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = (double)tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
        if (++discriminate >= point.length) {
            discriminate = 0;
        }
        return stack;
    }

    public List<byte[]> radiusSearch(byte[] centre, byte radius) {
        byte[] lower = (byte[])centre.clone();
        byte[] upper = (byte[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = (byte)(lower[n] - radius);
            int n2 = i++;
            upper[n2] = (byte)(upper[n2] + radius);
        }
        List<byte[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<byte[]> radiusList = new ArrayList<byte[]>(rangeList.size());
        double radSq = radius * radius;
        for (byte[] r : rangeList) {
            if (!(IncrementalByteKDTree.distance(centre, r) < radSq)) continue;
            radiusList.add(r);
        }
        return radiusList;
    }

    public List<ObjectDoublePair<byte[]>> radiusDistanceSearch(byte[] centre, byte radius) {
        byte[] lower = (byte[])centre.clone();
        byte[] upper = (byte[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = (byte)(lower[n] - radius);
            int n2 = i++;
            upper[n2] = (byte)(upper[n2] + radius);
        }
        List<byte[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<ObjectDoublePair<byte[]>> radiusList = new ArrayList<ObjectDoublePair<byte[]>>(rangeList.size());
        double radSq = radius * radius;
        for (byte[] r : rangeList) {
            double dist = IncrementalByteKDTree.distance(centre, r);
            if (!(dist < radSq)) continue;
            radiusList.add(new ObjectDoublePair<byte[]>(r, dist));
        }
        return radiusList;
    }

    private static class KDNode {
        int discriminateDim;
        byte[] point;
        KDNode left;
        KDNode right;

        KDNode(byte[] point, int discriminate) {
            this.point = point;
            this.right = null;
            this.left = null;
            this.discriminateDim = discriminate;
        }
    }
}

