/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.awt.Color;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

public strictfp final class RangeColorModel
extends ColorModel {
    private final double _valueMin;
    private final double _valueScale;
    private final int _redMin;
    private final int _redRange;
    private final int _greenMin;
    private final int _greenRange;
    private final int _blueMin;
    private final int _blueRange;

    public RangeColorModel(Raster raster) {
        this(raster, Color.BLACK, Color.WHITE);
    }

    public RangeColorModel(Raster raster, Color minColor, Color maxColor) {
        super(DataBuffer.getDataTypeSize(5), new int[]{DataBuffer.getDataTypeSize(0), DataBuffer.getDataTypeSize(0), DataBuffer.getDataTypeSize(0), DataBuffer.getDataTypeSize(0)}, new ICC_ColorSpace(ICC_Profile.getInstance(1000)), true, false, 2, 5);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        DataBuffer buffer = raster.getDataBuffer();
        for (int i = 0; i < buffer.getSize(); ++i) {
            double d = buffer.getElemDouble(i);
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        this._valueMin = min;
        this._valueScale = 1.0 / (max - min);
        this._redMin = minColor.getRed();
        this._redRange = maxColor.getRed() - minColor.getRed();
        this._greenMin = minColor.getGreen();
        this._greenRange = maxColor.getGreen() - minColor.getGreen();
        this._blueMin = minColor.getBlue();
        this._blueRange = maxColor.getBlue() - minColor.getBlue();
    }

    @Override
    public int getAlpha(Object pixel) {
        double value = ((double[])pixel)[0];
        if (Double.isNaN(value)) {
            return 0;
        }
        return 255;
    }

    @Override
    public int getRed(Object pixel) {
        double value = ((double[])pixel)[0];
        if (Double.isNaN(value)) {
            return 0;
        }
        return (int)StrictMath.round((value - this._valueMin) * this._valueScale * (double)this._redRange) + this._redMin;
    }

    @Override
    public int getGreen(Object pixel) {
        double value = ((double[])pixel)[0];
        if (Double.isNaN(value)) {
            return 0;
        }
        return (int)StrictMath.round((value - this._valueMin) * this._valueScale * (double)this._greenRange) + this._greenMin;
    }

    @Override
    public int getBlue(Object pixel) {
        double value = ((double[])pixel)[0];
        if (Double.isNaN(value)) {
            return 0;
        }
        return (int)StrictMath.round((value - this._valueMin) * this._valueScale * (double)this._blueRange) + this._blueMin;
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return raster.getDataBuffer().getDataType() == 5 && raster.getNumBands() == 1;
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm.getDataType() == 5 && sm.getNumBands() == 1;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new BandedSampleModel(5, w, h, 1);
    }

    @Override
    public int getRed(int pixel) {
        throw new IllegalArgumentException("pixel values not representable as int");
    }

    @Override
    public int getGreen(int pixel) {
        throw new IllegalArgumentException("pixel values not representable as int");
    }

    @Override
    public int getBlue(int pixel) {
        throw new IllegalArgumentException("pixel values not representable as int");
    }

    @Override
    public int getAlpha(int pixel) {
        throw new IllegalArgumentException("pixel values not representable as int");
    }
}

