/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.myworldgis.util.GeometryUtils;
import org.myworldgis.util.JTSUtils;

public strictfp final class ProjectionUtils {
    private static final int MAX_SEGMENTS = 180;
    private static final Comparator<WrappingIntersection> INDEX_ASCENDING_COMPARATOR = new Comparator<WrappingIntersection>(){

        @Override
        public int compare(WrappingIntersection i1, WrappingIntersection i2) {
            if (i1.index < i2.index) {
                return -1;
            }
            if (i1.index > i2.index) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<WrappingIntersection> LAT_ASCENDING_COMPARATOR = new Comparator<WrappingIntersection>(){

        @Override
        public int compare(WrappingIntersection i1, WrappingIntersection i2) {
            if (i1.lat < i2.lat) {
                return -1;
            }
            if (i1.lat > i2.lat) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<WrappingIntersection> LAT_DESCENDING_COMPARATOR = new Comparator<WrappingIntersection>(){

        @Override
        public int compare(WrappingIntersection i1, WrappingIntersection i2) {
            if (i2.lat < i1.lat) {
                return -1;
            }
            if (i2.lat > i1.lat) {
                return 1;
            }
            return 0;
        }
    };
    private static final double EDGE_SHIFT_EPSILON = 1.0E-5;
    private static final int LONGITUDE_SEGMENT_COUNT = 72;
    private static final double LATITUDE_FILL_INCREMENT = 0.08726646259971647;
    private static double AZIMUTH_FILL_INCREMENT = Math.PI / 180;

    public static Polygon createRhumbPoly(Polygon poly) {
        LinearRing shell = (LinearRing)ProjectionUtils.createRhumbLine(poly.getExteriorRing());
        LinearRing[] holes = new LinearRing[poly.getNumInteriorRing()];
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            holes[i] = (LinearRing)ProjectionUtils.createRhumbLine(poly.getInteriorRingN(i));
        }
        return poly.getFactory().createPolygon(shell, holes);
    }

    public static LineString createRhumbLine(LineString line) {
        ArrayList<Coordinate> newCoords = new ArrayList<Coordinate>(line.getNumPoints() * 3);
        Coordinate pt0 = line.getCoordinateN(0);
        for (int i = 1; i < line.getNumPoints(); ++i) {
            Coordinate pt1 = line.getCoordinateN(i);
            double dx = GeometryUtils.wrap_longitude(pt0.x - pt1.x);
            double dy = pt0.y - pt1.y;
            double length = StrictMath.sqrt(dx * dx + dy * dy);
            int nsegs = StrictMath.min(StrictMath.max((int)(length / 0.01745), 0), 180);
            double[] segments = GeometryUtils.rhumb_line(pt0.x, pt0.y, pt1.x, pt1.y, nsegs, false);
            for (int j = 0; j < segments.length; j += 2) {
                newCoords.add(new Coordinate(segments[j], segments[j + 1]));
            }
        }
        newCoords.add(line.getCoordinateN(line.getNumPoints() - 1));
        GeometryFactory factory = line.getFactory();
        Coordinate[] coordArray = newCoords.toArray(new Coordinate[newCoords.size()]);
        if (line instanceof LinearRing) {
            return factory.createLinearRing(coordArray);
        }
        return factory.createLineString(coordArray);
    }

    public static Polygon createGreatCirclePoly(Polygon poly) {
        LinearRing shell = (LinearRing)ProjectionUtils.createGreatCircleLine(poly.getExteriorRing());
        LinearRing[] holes = new LinearRing[poly.getNumInteriorRing()];
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            holes[i] = (LinearRing)ProjectionUtils.createGreatCircleLine(poly.getInteriorRingN(i));
        }
        return poly.getFactory().createPolygon(shell, holes);
    }

    public static LineString createGreatCircleLine(LineString poly) {
        ArrayList<Coordinate> newCoords = new ArrayList<Coordinate>(poly.getNumPoints() * 3);
        Coordinate pt0 = poly.getCoordinateN(0);
        for (int i = 1; i < poly.getNumPoints(); ++i) {
            Coordinate pt1 = poly.getCoordinateN(i);
            double dx = GeometryUtils.wrap_longitude(pt0.x - pt1.x);
            double dy = pt0.y - pt1.y;
            double length = StrictMath.sqrt(dx * dx + dy * dy);
            int nsegs = StrictMath.min(StrictMath.max((int)(length / 0.01745), 0), 180);
            double[] segments = GeometryUtils.great_circle(pt0.x, pt0.y, pt1.x, pt1.y, nsegs, false);
            for (int j = 0; j < segments.length; j += 2) {
                newCoords.add(new Coordinate(segments[j], segments[j + 1]));
            }
        }
        newCoords.add(poly.getCoordinateN(poly.getNumPoints() - 1));
        GeometryFactory factory = poly.getFactory();
        Coordinate[] coordArray = newCoords.toArray(new Coordinate[newCoords.size()]);
        if (poly instanceof LinearRing) {
            return factory.createLinearRing(coordArray);
        }
        return factory.createLineString(coordArray);
    }

    public static MultiLineString wrap(LineString line, double centerLon) {
        GeometryFactory factory = line.getFactory();
        ArrayList<LineString> result = new ArrayList<LineString>(2);
        double leftEdgeLon = GeometryUtils.wrap_longitude(centerLon - 3.141582653589793);
        double rightEdgeLon = GeometryUtils.wrap_longitude(centerLon + 3.141582653589793);
        Coordinate c1 = line.getCoordinateN(0);
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(line.getNumPoints());
        coords.add(c1);
        double transformedLon1 = GeometryUtils.wrap_longitude_positive(c1.x - centerLon);
        for (int i = 1; i < line.getNumPoints(); ++i) {
            Coordinate c2 = line.getCoordinateN(i);
            double transformedLon2 = GeometryUtils.wrap_longitude_positive(c2.x - centerLon);
            if (transformedLon1 > 1.5707963267948966 && transformedLon1 < Math.PI && transformedLon2 > Math.PI && transformedLon2 < 4.71238898038469) {
                double lat = c1.y + (c2.y - c1.y) * ((Math.PI - transformedLon1) / (transformedLon2 - transformedLon1));
                coords.add(new Coordinate(rightEdgeLon, lat));
                result.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                coords.clear();
                coords.add(new Coordinate(leftEdgeLon, lat));
            } else if (transformedLon1 > Math.PI && transformedLon1 < 4.71238898038469 && transformedLon2 > 1.5707963267948966 && transformedLon2 < Math.PI) {
                double lat = c1.y + (c2.y - c1.y) * ((Math.PI - transformedLon1) / (transformedLon2 - transformedLon1));
                coords.add(new Coordinate(leftEdgeLon, lat));
                result.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                coords.clear();
                coords.add(new Coordinate(rightEdgeLon, lat));
            } else if (transformedLon2 == Math.PI) {
                double transformedLon3;
                if (transformedLon1 < Math.PI) {
                    coords.add(new Coordinate(rightEdgeLon, c2.y));
                    if (i < line.getNumPoints() - 1) {
                        Coordinate c3 = line.getCoordinateN(i + 1);
                        transformedLon3 = (float)GeometryUtils.wrap_longitude_positive(c3.x - centerLon);
                        if (transformedLon3 > Math.PI && transformedLon3 < 4.71238898038469) {
                            result.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                            coords.clear();
                            coords.add(new Coordinate(leftEdgeLon, c2.y));
                        }
                    }
                } else if (transformedLon1 > Math.PI) {
                    coords.add(new Coordinate(leftEdgeLon, c2.y));
                    if (i < line.getNumPoints() - 1) {
                        Coordinate c3 = line.getCoordinateN(i + 1);
                        transformedLon3 = (float)GeometryUtils.wrap_longitude_positive(c3.x - centerLon);
                        if (transformedLon3 < Math.PI && transformedLon2 > 1.5707963267948966) {
                            result.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                            coords.clear();
                            coords.add(new Coordinate(rightEdgeLon, c2.y));
                        }
                    }
                }
            } else {
                coords.add(c2);
            }
            c1 = c2;
            transformedLon1 = transformedLon2;
        }
        if (result.size() == 0) {
            return factory.createMultiLineString(new LineString[]{line});
        }
        if (result.size() == 1) {
            return factory.createMultiLineString(new LineString[]{(LineString)result.get(0)});
        }
        return factory.createMultiLineString(result.toArray(new LineString[result.size()]));
    }

    public static MultiPolygon wrap(Polygon poly, double centerLon) {
        List<LinearRing> newRings = ProjectionUtils.wrap((LinearRing)poly.getExteriorRing(), centerLon);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            newRings.addAll(ProjectionUtils.wrap((LinearRing)poly.getInteriorRingN(i), centerLon));
        }
        return JTSUtils.buildPolygonGeometry(newRings.toArray(new LinearRing[newRings.size()]), poly.getFactory(), true);
    }

    public static List<LinearRing> wrap(LinearRing ring, double centerLon) {
        Coordinate c1 = ring.getCoordinateN(0);
        double transformedLon1 = GeometryUtils.wrap_longitude_positive(c1.x - centerLon);
        ArrayList<WrappingIntersection> intersections = null;
        for (int i = 1; i < ring.getNumPoints(); ++i) {
            Coordinate c2 = ring.getCoordinateN(i);
            double transformedLon2 = GeometryUtils.wrap_longitude_positive(c2.x - centerLon);
            if (transformedLon1 > 1.5707963267948966 && transformedLon1 < Math.PI && transformedLon2 > Math.PI && transformedLon2 < 4.71238898038469) {
                double lat = c1.y + (c2.y - c1.y) * ((Math.PI - transformedLon1) / (transformedLon2 - transformedLon1));
                if (intersections == null) {
                    intersections = new ArrayList<WrappingIntersection>(2);
                }
                intersections.add(new WrappingIntersection(i, lat, true, false));
            } else if (transformedLon1 > Math.PI && transformedLon1 < 4.71238898038469 && transformedLon2 > 1.5707963267948966 && transformedLon2 < Math.PI) {
                double lat = c1.y + (c2.y - c1.y) * ((Math.PI - transformedLon1) / (transformedLon2 - transformedLon1));
                if (intersections == null) {
                    intersections = new ArrayList(2);
                }
                intersections.add(new WrappingIntersection(i, lat, false, false));
            } else if (transformedLon1 == Math.PI) {
                Coordinate c0 = i == 1 ? ring.getCoordinateN(ring.getNumPoints() - 2) : ring.getCoordinateN(i - 2);
                double transformedLon0 = GeometryUtils.wrap_longitude_positive(c0.x - centerLon);
                if (transformedLon0 < Math.PI) {
                    if (transformedLon2 > Math.PI) {
                        if (intersections == null) {
                            intersections = new ArrayList(2);
                        }
                        intersections.add(new WrappingIntersection(i - 2, c1.y, true, true));
                    } else if (transformedLon2 < Math.PI) {
                        c1.x -= 1.0E-5;
                    }
                } else if (transformedLon0 > Math.PI) {
                    if (transformedLon2 < Math.PI) {
                        if (intersections == null) {
                            intersections = new ArrayList(2);
                        }
                        intersections.add(new WrappingIntersection(i - 2, c1.y, false, true));
                    } else if (transformedLon2 > Math.PI) {
                        c1.x += 1.0E-5;
                    }
                }
            } else if (transformedLon2 == Math.PI) {
                Coordinate c3 = i == ring.getNumPoints() - 1 ? ring.getCoordinateN(1) : ring.getCoordinateN(i + 1);
                double transformedLon3 = GeometryUtils.wrap_longitude_positive(c3.x - centerLon);
                if (transformedLon1 < Math.PI && transformedLon3 < Math.PI) {
                    c2.x -= 1.0E-5;
                    transformedLon2 -= 1.0E-5;
                } else if (transformedLon1 > Math.PI && transformedLon3 > Math.PI) {
                    c2.x += 1.0E-5;
                    transformedLon2 += 1.0E-5;
                }
            }
            c1 = c2;
            transformedLon1 = transformedLon2;
        }
        if (intersections == null) {
            ArrayList<LinearRing> result = new ArrayList<LinearRing>(1);
            result.add(ring);
            return result;
        }
        if (intersections.size() == 1) {
            ArrayList<LinearRing> result = new ArrayList<LinearRing>(1);
            result.add(ProjectionUtils.wrapCircularRing(ring, (WrappingIntersection)intersections.get(0), centerLon));
            return result;
        }
        if ((intersections.size() & 1) != 0) {
            throw new IllegalStateException("data crosses the dateline an odd number of times; may not be in Geographic coordinates");
        }
        return ProjectionUtils.wrapComplicatedRing(ring, (List<WrappingIntersection>)intersections, centerLon);
    }

    private static LinearRing wrapCircularRing(LinearRing ring, WrappingIntersection intersection, double centerLon) {
        int i;
        double lon;
        double lonIncrement;
        double latGoal;
        ArrayList<Coordinate> newPoints = new ArrayList<Coordinate>(ring.getNumPoints() + 144);
        for (int i2 = 0; i2 < intersection.index; ++i2) {
            newPoints.add(ring.getCoordinateN(i2));
        }
        double lat = intersection.lat;
        if (intersection.isLeftToRight) {
            latGoal = -1.5707863267948965;
            lonIncrement = -0.0872661848219387;
            lon = GeometryUtils.wrap_longitude(centerLon + 3.141582653589793);
        } else {
            latGoal = 1.5707863267948965;
            lonIncrement = 0.0872661848219387;
            lon = GeometryUtils.wrap_longitude(centerLon - 3.141582653589793);
        }
        int latSegCount = (int)StrictMath.floor(StrictMath.abs(latGoal - lat) / 0.08726646259971647);
        double latIncrement = (latGoal - lat) / (double)latSegCount;
        for (i = 0; i < latSegCount; ++i) {
            newPoints.add(new Coordinate(lon, lat));
            lat += latIncrement;
        }
        for (i = 0; i < 72; ++i) {
            newPoints.add(new Coordinate(lon, lat));
            lon = GeometryUtils.wrap_longitude(lon + lonIncrement);
        }
        for (i = 0; i < latSegCount; ++i) {
            newPoints.add(new Coordinate(lon, lat));
            lat -= latIncrement;
        }
        for (i = intersection.index; i < ring.getNumPoints(); ++i) {
            newPoints.add(ring.getCoordinateN(i));
        }
        return ring.getFactory().createLinearRing(newPoints.toArray(new Coordinate[newPoints.size()]));
    }

    private static List<LinearRing> wrapComplicatedRing(LinearRing ring, List<WrappingIntersection> intersections, double centerLon) {
        int i;
        int i2;
        int end;
        int start;
        double rightEdgeLon;
        GeometryFactory factory = ring.getFactory();
        ArrayList<LinearRing> result = new ArrayList<LinearRing>(4);
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(ring.getNumPoints());
        double leftEdgeLon = GeometryUtils.wrap_longitude(centerLon - 3.141582653589793);
        if (leftEdgeLon == (rightEdgeLon = GeometryUtils.wrap_longitude(centerLon + 3.141582653589793))) {
            leftEdgeLon += 1.0E-5;
            rightEdgeLon -= 1.0E-5;
        }
        ArrayList<WrappingIntersection> indexList = new ArrayList<WrappingIntersection>(intersections);
        Collections.sort(indexList, INDEX_ASCENDING_COMPARATOR);
        ArrayList<WrappingIntersection> latList = new ArrayList<WrappingIntersection>(intersections);
        Collections.sort(latList, LAT_ASCENDING_COMPARATOR);
        WrappingIntersection current = (WrappingIntersection)latList.get(0);
        block0: while (current != null) {
            WrappingIntersection next;
            WrappingIntersection first = current;
            coords.add(new Coordinate(leftEdgeLon, first.lat));
            do {
                if (current.isLeftToRight) {
                    next = ProjectionUtils.nextIntersection(current, indexList);
                    start = current.index;
                    if (current.isOnPoint && ++start == ring.getNumPoints()) {
                        start = 0;
                    }
                    end = next.index;
                    if (next.isOnPoint && --end < 0) {
                        end = ring.getNumPoints() - 1;
                    }
                    if (start < end) {
                        for (i2 = start; i2 < end; ++i2) {
                            coords.add(ring.getCoordinateN(i2));
                        }
                    } else {
                        for (i2 = start; i2 < ring.getNumPoints(); ++i2) {
                            coords.add(ring.getCoordinateN(i2));
                        }
                        for (i2 = 0; i2 < end; ++i2) {
                            coords.add(ring.getCoordinateN(i2));
                        }
                    }
                } else {
                    next = ProjectionUtils.nextIntersection(current, latList);
                    coords.add(new Coordinate(leftEdgeLon, next.lat));
                }
                current.markUsed();
            } while (!(current = next).isUsed() && current != first);
            if (coords.size() > 2) {
                coords.add((Coordinate)((Coordinate)coords.get(0)).clone());
                result.add(factory.createLinearRing(coords.toArray(new Coordinate[coords.size()])));
            }
            coords.clear();
            current = null;
            for (i = 0; i < latList.size(); ++i) {
                if (((WrappingIntersection)latList.get(i)).isUsed()) continue;
                current = (WrappingIntersection)latList.get(i);
                continue block0;
            }
        }
        for (int i3 = 0; i3 < latList.size(); ++i3) {
            ((WrappingIntersection)latList.get(i3)).markUnused();
        }
        Collections.sort(latList, LAT_DESCENDING_COMPARATOR);
        current = (WrappingIntersection)latList.get(0);
        block7: while (current != null) {
            WrappingIntersection next;
            WrappingIntersection first = current;
            coords.add(new Coordinate(rightEdgeLon, first.lat));
            do {
                if (current.isLeftToRight) {
                    next = ProjectionUtils.nextIntersection(current, latList);
                    coords.add(new Coordinate(rightEdgeLon, next.lat));
                } else {
                    next = ProjectionUtils.nextIntersection(current, indexList);
                    start = current.index;
                    if (current.isOnPoint && ++start == ring.getNumPoints()) {
                        start = 0;
                    }
                    end = next.index;
                    if (next.isOnPoint && --end < 0) {
                        end = ring.getNumPoints() - 1;
                    }
                    if (start < end) {
                        for (i2 = start; i2 < end; ++i2) {
                            coords.add(ring.getCoordinateN(i2));
                        }
                    } else {
                        for (i2 = start; i2 < ring.getNumPoints(); ++i2) {
                            coords.add(ring.getCoordinateN(i2));
                        }
                        for (i2 = 0; i2 < end; ++i2) {
                            coords.add(ring.getCoordinateN(i2));
                        }
                    }
                }
                current.markUsed();
            } while (!(current = next).isUsed() && current != first);
            coords.add((Coordinate)((Coordinate)coords.get(0)).clone());
            result.add(factory.createLinearRing(coords.toArray(new Coordinate[coords.size()])));
            coords.clear();
            current = null;
            for (i = 0; i < latList.size(); ++i) {
                if (((WrappingIntersection)latList.get(i)).isUsed()) continue;
                current = (WrappingIntersection)latList.get(i);
                continue block7;
            }
        }
        return result;
    }

    private static WrappingIntersection nextIntersection(WrappingIntersection after, List<WrappingIntersection> intersections) {
        int index = intersections.indexOf(after) + 1;
        while (true) {
            if (index == intersections.size()) {
                index = 0;
            }
            WrappingIntersection testInt = intersections.get(index);
            if (testInt.isLeftToRight != after.isLeftToRight) {
                return testInt;
            }
            if (testInt == after) {
                return null;
            }
            ++index;
        }
    }

    public static MultiLineString clip(LineString line, Coordinate center, double maxC) {
        GeometryFactory factory = line.getFactory();
        ArrayList<LineString> result = new ArrayList<LineString>();
        ArrayList<Coordinate> currentSegment = new ArrayList<Coordinate>();
        Coordinate pt = line.getCoordinateN(0);
        double c = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, pt.x, pt.y);
        int index = 0;
        while (index < line.getNumPoints()) {
            double az;
            while (c > maxC && ++index < line.getNumPoints()) {
                pt = line.getCoordinateN(index);
                c = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, pt.x, pt.y);
            }
            if (index > 0) {
                if (currentSegment.size() > 1) {
                    result.add(factory.createLineString(currentSegment.toArray(new Coordinate[currentSegment.size()])));
                }
                currentSegment.clear();
                pt = line.getCoordinateN(index - 1);
                az = GeometryUtils.spherical_azimuth(center.x, center.y, pt.x, pt.y);
                currentSegment.add(GeometryUtils.spherical_between(center.x, center.y, maxC, az));
            } else if (index < line.getNumPoints()) {
                if (currentSegment.size() > 1) {
                    result.add(factory.createLineString(currentSegment.toArray(new Coordinate[currentSegment.size()])));
                }
                currentSegment.clear();
                currentSegment.add(line.getCoordinateN(index));
                ++index;
            }
            if (index >= line.getNumPoints()) break;
            while (c <= maxC) {
                currentSegment.add(line.getCoordinateN(index));
                if (++index >= line.getNumPoints()) break;
                pt = line.getCoordinateN(index);
                c = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, pt.x, pt.y);
            }
            if (index < line.getNumPoints()) {
                pt = line.getCoordinateN(index - 1);
                az = GeometryUtils.spherical_azimuth(center.x, center.y, pt.x, pt.y);
                currentSegment.add(GeometryUtils.spherical_between(center.x, center.y, maxC, az));
            }
            if (currentSegment.size() > 1) {
                result.add(factory.createLineString(currentSegment.toArray(new Coordinate[currentSegment.size()])));
            }
            currentSegment.clear();
        }
        if (result.size() == 1) {
            return factory.createMultiLineString(new LineString[]{(LineString)result.get(0)});
        }
        return factory.createMultiLineString(result.toArray(new LineString[result.size()]));
    }

    public static MultiPolygon clip(Polygon poly, Coordinate center, double maxC) {
        List<LinearRing> newRings = ProjectionUtils.clip((LinearRing)poly.getExteriorRing(), center, maxC);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            newRings.addAll(ProjectionUtils.clip((LinearRing)poly.getInteriorRingN(i), center, maxC));
        }
        return JTSUtils.buildPolygonGeometry(newRings.toArray(new LinearRing[newRings.size()]), poly.getFactory(), false);
    }

    private static List<LinearRing> clip(LinearRing ring, Coordinate center, double maxC) {
        Coordinate pt;
        Coordinate pt2;
        int firstOutsideIndex = 0;
        double c = 0.0;
        do {
            pt2 = ring.getCoordinateN(firstOutsideIndex);
        } while ((c = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, pt2.x, pt2.y)) <= maxC && ++firstOutsideIndex < ring.getNumPoints());
        if (firstOutsideIndex == ring.getNumPoints()) {
            ArrayList<LinearRing> result = new ArrayList<LinearRing>(1);
            result.add(ring);
            return result;
        }
        int firstInsideIndex = --firstOutsideIndex;
        do {
            firstInsideIndex = (firstInsideIndex + 1) % ring.getNumPoints();
            pt = ring.getCoordinateN(firstInsideIndex);
        } while ((c = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, pt.x, pt.y)) >= maxC && firstInsideIndex != firstOutsideIndex);
        if (firstInsideIndex == firstOutsideIndex) {
            return new ArrayList<LinearRing>(0);
        }
        return ProjectionUtils.clipComplexRing(ring, center, maxC);
    }

    private static List<LinearRing> clipComplexRing(final LinearRing ring, Coordinate center, double maxC) {
        GeometryFactory factory = ring.getFactory();
        ArrayList<LinearRing> result = new ArrayList<LinearRing>();
        ArrayList<ClippingIntersection> intersectionsByIndex = new ArrayList<ClippingIntersection>();
        Coordinate temp = new Coordinate();
        Coordinate current = ring.getCoordinateN(0);
        double currentC = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, current.x, current.y);
        boolean curIsInside = currentC < maxC;
        for (int curIndex = 0; curIndex < ring.getNumPoints() - 2; ++curIndex) {
            boolean nextIsInside;
            int nextIndex = curIndex + 1;
            Coordinate next = ring.getCoordinateN(nextIndex);
            double nextC = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, next.x, next.y);
            boolean bl = nextIsInside = nextC < maxC;
            if (curIsInside != nextIsInside) {
                double u = curIsInside ? (maxC - currentC) / (nextC - currentC) : (currentC - maxC) / (currentC - nextC);
                double iLon = current.x + u * (next.x - current.x);
                double iLat = current.y + u * (next.y - current.y);
                double iAz = GeometryUtils.spherical_azimuth(center.x, center.y, iLon, iLat);
                temp = GeometryUtils.spherical_between(center.x, center.y, maxC, iAz, temp);
                intersectionsByIndex.add(new ClippingIntersection(nextIndex, temp.x, temp.y, iAz, nextIsInside));
            }
            current = next;
            currentC = nextC;
            curIsInside = nextIsInside;
        }
        ArrayList<ClippingIntersection> intersectionsByAzimuth = new ArrayList<ClippingIntersection>(intersectionsByIndex);
        Collections.sort(intersectionsByAzimuth, new Comparator<ClippingIntersection>(){

            @Override
            public int compare(ClippingIntersection i1, ClippingIntersection i2) {
                if (i1.azimuth < i2.azimuth) {
                    return -1;
                }
                if (i1.azimuth > i2.azimuth) {
                    return 1;
                }
                if (i1.isEntry == i2.isEntry) {
                    return 0;
                }
                ClippingIntersection entry = i1.isEntry ? i1 : i2;
                ClippingIntersection exit = i1.isEntry ? i2 : i1;
                boolean wrapsAround = false;
                int index = entry.index;
                while (index != exit.index) {
                    if (index == 0) {
                        wrapsAround = true;
                        break;
                    }
                    index = (index + 1) % ring.getNumPoints();
                }
                if (wrapsAround) {
                    if (i1.index > i2.index) {
                        return -1;
                    }
                    if (i1.index < i2.index) {
                        return 1;
                    }
                } else {
                    if (i1.index < i2.index) {
                        return -1;
                    }
                    if (i1.index > i2.index) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        ClippingIntersection currentExit = null;
        for (int i = 0; i < intersectionsByIndex.size(); ++i) {
            if (((ClippingIntersection)intersectionsByIndex.get((int)i)).isEntry) continue;
            currentExit = (ClippingIntersection)intersectionsByIndex.get(i);
            break;
        }
        block2: while (currentExit != null) {
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            ClippingIntersection lastEntry = null;
            ClippingIntersection firstExit = currentExit;
            while (true) {
                if (lastEntry != null) {
                    int i;
                    if (lastEntry.index < currentExit.index) {
                        for (i = lastEntry.index; i < currentExit.index; ++i) {
                            coords.add(ring.getCoordinateN(i));
                        }
                    } else {
                        for (i = lastEntry.index; i < ring.getNumPoints() - 1; ++i) {
                            coords.add(ring.getCoordinateN(i));
                        }
                        for (i = 0; i < currentExit.index; ++i) {
                            coords.add(ring.getCoordinateN(i));
                        }
                    }
                    lastEntry.markUsed();
                }
                if (currentExit.isUsed()) break;
                coords.add(new Coordinate(currentExit.lon, currentExit.lat));
                ClippingIntersection currentEntry = ProjectionUtils.nextIntersection(currentExit, intersectionsByAzimuth, true);
                if (currentEntry == null) break;
                double azDifference = StrictMath.abs(currentEntry.azimuth - currentExit.azimuth);
                if (azDifference > Math.PI) {
                    azDifference = Math.PI * 2 - azDifference;
                }
                int count = (int)StrictMath.floor(azDifference / AZIMUTH_FILL_INCREMENT) - 1;
                double azimuth = currentExit.azimuth + AZIMUTH_FILL_INCREMENT;
                for (int i = 0; i < count; ++i) {
                    coords.add(GeometryUtils.spherical_between(center.x, center.y, maxC, azimuth, new Coordinate()));
                    azimuth += AZIMUTH_FILL_INCREMENT;
                }
                coords.add(new Coordinate(currentEntry.lon, currentEntry.lat));
                currentExit.markUsed();
                currentExit = ProjectionUtils.nextIntersection(currentEntry, intersectionsByIndex, false);
                lastEntry = currentEntry;
            }
            coords.add(new Coordinate(firstExit.lon, firstExit.lat));
            if (coords.size() > 3) {
                result.add(factory.createLinearRing(coords.toArray(new Coordinate[coords.size()])));
            }
            currentExit = null;
            for (int i = 0; i < intersectionsByIndex.size(); ++i) {
                ClippingIntersection testInt = (ClippingIntersection)intersectionsByIndex.get(i);
                if (testInt.isEntry || testInt.isUsed()) continue;
                currentExit = testInt;
                continue block2;
            }
        }
        return result;
    }

    private static ClippingIntersection nextIntersection(ClippingIntersection currentIntersection, List<ClippingIntersection> intersections, boolean entry) {
        int start = currentIntersection != null ? intersections.indexOf(currentIntersection) : 0;
        int index = start + 1;
        while (true) {
            if (index == intersections.size()) {
                index = 0;
            }
            ClippingIntersection testInt = intersections.get(index);
            if (testInt.isEntry == entry) {
                return testInt;
            }
            if (index == start) {
                return null;
            }
            ++index;
        }
    }

    private strictfp static final class ClippingIntersection {
        final int index;
        final double lon;
        final double lat;
        final double azimuth;
        final boolean isEntry;
        private boolean _used;

        public ClippingIntersection(int index, double lon, double lat, double azimuth, boolean isEntry) {
            this.index = index;
            this.lon = lon;
            this.lat = lat;
            this.azimuth = azimuth;
            this.isEntry = isEntry;
            this._used = false;
        }

        boolean isUsed() {
            return this._used;
        }

        void markUsed() {
            this._used = true;
        }

        public String toString() {
            return "i[" + this.index / 2 + " " + this.isEntry + " " + this.azimuth + " (" + this.lat + "," + this.lon + ")]";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ClippingIntersection && ((ClippingIntersection)obj).lon == this.lon && ((ClippingIntersection)obj).lat == this.lat && ((ClippingIntersection)obj).azimuth == this.azimuth && ((ClippingIntersection)obj).isEntry == this.isEntry;
        }

        private long doublePow(int base, double pow) {
            return Double.doubleToLongBits(Math.pow(base, pow));
        }

        public int hashCode() {
            boolean entryInt = this.isEntry;
            return (int)((double)(this.doublePow(2, this.lon) * this.doublePow(3, this.lat) * this.doublePow(5, this.azimuth)) * Math.pow(7.0, (double)entryInt) % 2.147483647E9);
        }
    }

    private strictfp static final class WrappingIntersection {
        final int index;
        final double lat;
        final boolean isLeftToRight;
        final boolean isOnPoint;
        private boolean _used;

        public WrappingIntersection(int index, double lat, boolean leftToRight, boolean isOnPoint) {
            this.index = index;
            this.lat = lat;
            this.isLeftToRight = leftToRight;
            this.isOnPoint = isOnPoint;
            this._used = false;
        }

        boolean isUsed() {
            return this._used;
        }

        void markUsed() {
            this._used = true;
        }

        void markUnused() {
            this._used = false;
        }
    }
}

