/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.myworldgis.util.JTSUtils;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.core.AgentKind;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public strictfp abstract class SpatialRelationship {
    static Geometry getGeometry(Object arg) throws ExtensionException {
        if (arg instanceof VectorDataset) {
            Collection<VectorFeature> features = ((VectorDataset)arg).getFeatures();
            Geometry[] geoms = new Geometry[features.size()];
            int gIndex = 0;
            Iterator<VectorFeature> i = features.iterator();
            while (i.hasNext()) {
                geoms[gIndex++] = i.next().getGeometry();
            }
            return JTSUtils.flatten(GISExtension.getState().factory().createGeometryCollection(geoms));
        }
        if (arg instanceof VectorFeature) {
            return ((VectorFeature)arg).getGeometry();
        }
        if (arg instanceof Agent) {
            return GISExtension.getState().agentGeometry((Agent)arg);
        }
        if (arg instanceof AgentSet) {
            AgentSet set = (AgentSet)arg;
            Geometry[] geoms = new Geometry[set.count()];
            int gIndex = 0;
            Iterator i = set.agents().iterator();
            while (i.hasNext()) {
                geoms[gIndex++] = GISExtension.getState().agentGeometry((Agent)i.next());
            }
            return JTSUtils.flatten(GISExtension.getState().factory().createGeometryCollection(geoms));
        }
        if (arg instanceof LogoList) {
            LogoList list = (LogoList)arg;
            Geometry[] geoms = new Geometry[list.size()];
            int gIndex = 0;
            Iterator i = list.javaIterator();
            while (i.hasNext()) {
                geoms[gIndex++] = SpatialRelationship.getGeometry(i.next());
            }
            return JTSUtils.flatten(GISExtension.getState().factory().createGeometryCollection(geoms));
        }
        throw new ExtensionException("not a VectorFeature, Agent, AgentSet, or List: " + arg);
    }

    public strictfp static final class Intersecting
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.PatchsetType(), (int[])new int[]{Syntax.WildcardType()}, (int)Syntax.PatchsetType(), (int)Syntax.NormalPrecedence());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            AgentSet set = (AgentSet)args[0].get();
            PreparedGeometry pGeom = PreparedGeometryFactory.prepare((Geometry)SpatialRelationship.getGeometry(args[1].get()));
            LinkedList<org.nlogo.agent.Agent> agents = new LinkedList<org.nlogo.agent.Agent>();
            for (Agent agent : set.agents()) {
                if (!pGeom.intersects(GISExtension.getState().agentGeometry(agent))) continue;
                agents.add((org.nlogo.agent.Agent)agent);
            }
            return org.nlogo.agent.AgentSet.fromArray((AgentKind)set.kind(), (org.nlogo.agent.Agent[])agents.toArray(new org.nlogo.agent.Agent[agents.size()]));
        }
    }

    public strictfp static final class GetRelationship
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.StringType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            Geometry geom0 = SpatialRelationship.getGeometry(args[0].get());
            Geometry geom1 = SpatialRelationship.getGeometry(args[1].get());
            return geom0.relate(geom1).toString();
        }
    }

    public strictfp static final class GeneralTest
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType(), Syntax.StringType()}, (int)Syntax.BooleanType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            Geometry geom0 = SpatialRelationship.getGeometry(args[0].get());
            Geometry geom1 = SpatialRelationship.getGeometry(args[1].get());
            String pattern = args[2].getString();
            if (geom0.relate(geom1).matches(pattern)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    public strictfp static final class ContainedByTest
    extends DefaultTest {
        @Override
        protected boolean relates(Geometry geom0, Geometry geom1) {
            return geom0.coveredBy(geom1);
        }
    }

    public strictfp static final class ContainsTest
    extends DefaultTest {
        @Override
        protected boolean relates(Geometry geom0, Geometry geom1) {
            return geom0.covers(geom1);
        }
    }

    public strictfp static final class IntersectionTest
    extends DefaultTest {
        @Override
        protected boolean relates(Geometry geom0, Geometry geom1) {
            return geom0.intersects(geom1);
        }
    }

    private strictfp static abstract class DefaultTest
    extends GISExtension.Reporter {
        private DefaultTest() {
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.BooleanType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            Geometry geom1;
            Geometry geom0 = SpatialRelationship.getGeometry(args[0].get());
            if (this.relates(geom0, geom1 = SpatialRelationship.getGeometry(args[1].get()))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        protected abstract boolean relates(Geometry var1, Geometry var2);
    }
}

