/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.IOException;
import org.myworldgis.netlogo.CoordinateTransformation;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.projection.Projection;
import org.nlogo.api.Agent;
import org.nlogo.api.Color;
import org.nlogo.api.Context;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.Link;
import org.nlogo.api.LogoException;
import org.nlogo.api.OutputDestination;
import org.nlogo.api.OutputDestinationJ;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.File;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.nvm.ExtensionContext;
import org.nlogo.nvm.Workspace;
import org.nlogo.workspace.AbstractWorkspace;
import org.nlogo.workspace.ExtendableWorkspace;

public strictfp final class GISExtensionState
implements ExtensionObject {
    private final org.nlogo.workspace.ExtensionManager _em;
    private final GeometryFactory _factory;
    private Projection _projection;
    private int _datasetCount;
    private CoordinateTransformation _transformation;
    private java.awt.Color _color;
    private Object _nlColor;
    private double _coverageSingleCellThreshold;
    private double _coverageMultipleCellThreshold;
    private static ExtendableWorkspace _workspace;
    private static final ExtensionException noCoordinateTransformationSetException;

    public GISExtensionState(ExtensionManager em) {
        this._em = (org.nlogo.workspace.ExtensionManager)em;
        this._factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));
        this._projection = null;
        this._datasetCount = 0;
        this._transformation = null;
        this.setNetLogoColor(Color.BoxedBlack());
        this._coverageSingleCellThreshold = 0.1;
        this._coverageMultipleCellThreshold = 0.33;
        _workspace = this._em.workspace();
    }

    public void displayWarning(String warning) {
        if (_workspace instanceof HeadlessWorkspace) {
            _workspace.warningMessage(warning);
        } else if (_workspace instanceof AbstractWorkspace) {
            AbstractWorkspace ws = (AbstractWorkspace)_workspace;
            ws.outputObject((Object)warning, null, true, false, (OutputDestination)OutputDestinationJ.NORMAL());
        }
    }

    public void displayWarning(String warning, Object owner) {
        if (_workspace instanceof HeadlessWorkspace) {
            _workspace.warningMessage(warning);
        } else if (_workspace instanceof AbstractWorkspace) {
            AbstractWorkspace ws = (AbstractWorkspace)_workspace;
            try {
                ws.outputObject((Object)warning, owner, true, false, (OutputDestination)OutputDestinationJ.NORMAL());
            }
            catch (LogoException e) {
                this.displayWarning(warning);
            }
        }
    }

    public File getFile(String path) {
        try {
            String fullPath = this._em.workspace().fileManager().attachPrefix(path);
            if (this._em.workspace().fileManager().fileExists(fullPath)) {
                return this._em.workspace().fileManager().getFile(fullPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public GeometryFactory factory() {
        return this._factory;
    }

    public Projection getProjection() {
        return this._projection;
    }

    public void setProjection(Projection newProjection, Context c) {
        if (this._datasetCount > 0 && c != null) {
            Workspace ws = ((ExtensionContext)c).workspace();
            try {
                ws.outputObject((Object)"GIS Extension Warning: datasets previously loaded will not be re-projected to match the new projection.", (Object)c.getAgent(), true, false, (OutputDestination)OutputDestinationJ.NORMAL());
            }
            catch (LogoException logoException) {
                // empty catch block
            }
        }
        this._projection = newProjection;
        this._datasetCount = 0;
    }

    public void datasetLoadNotify() {
        ++this._datasetCount;
    }

    public Coordinate netLogoToGIS(Coordinate pt, Coordinate storage) throws ExtensionException {
        if (this._transformation == null) {
            throw noCoordinateTransformationSetException;
        }
        return this._transformation.netLogoToGIS(pt, storage);
    }

    public Coordinate gisToNetLogo(Coordinate pt, Coordinate storage) throws ExtensionException {
        if (this._transformation == null) {
            throw noCoordinateTransformationSetException;
        }
        return this._transformation.gisToNetLogo(pt, storage);
    }

    public CoordinateTransformation getTransformation() throws ExtensionException {
        if (this._transformation == null) {
            throw noCoordinateTransformationSetException;
        }
        return this._transformation;
    }

    public boolean isTransformationSet() {
        return this._transformation != null;
    }

    public void setTransformation(CoordinateTransformation newTransformation) {
        this._transformation = newTransformation;
    }

    public Geometry agentGeometry(Agent agent) throws ExtensionException {
        if (agent instanceof Turtle) {
            Turtle t = (Turtle)agent;
            return this._factory.createPoint(this.netLogoToGIS(new Coordinate(t.xcor(), t.ycor()), null));
        }
        if (agent instanceof Patch) {
            Patch p = (Patch)agent;
            Coordinate bl = this.netLogoToGIS(new Coordinate((double)p.pxcor() - 0.5, (double)p.pycor() - 0.5), null);
            Coordinate tr = this.netLogoToGIS(new Coordinate((double)p.pxcor() + 0.5, (double)p.pycor() + 0.5), null);
            return this._factory.toGeometry(new Envelope(bl, tr));
        }
        if (agent instanceof Link) {
            Turtle t1 = ((Link)agent).end1();
            Turtle t2 = ((Link)agent).end2();
            Coordinate c1 = this.netLogoToGIS(new Coordinate(t1.xcor(), t1.ycor()), null);
            Coordinate c2 = this.netLogoToGIS(new Coordinate(t2.xcor(), t2.ycor()), null);
            return this._factory.createLineString(new Coordinate[]{c1, c2});
        }
        throw new ExtensionException("unrecognized agent type: " + Dump.logoObject((Object)agent));
    }

    public java.awt.Color getColor() {
        return this._color;
    }

    public Object getNetLogoColor() {
        return this._nlColor;
    }

    public void setColor(java.awt.Color newColor) {
        this._color = newColor;
        this._nlColor = Color.getRGBListByARGB((int)(-16777216 + (newColor.getRed() << 16) + (newColor.getGreen() << 8) + newColor.getBlue()));
    }

    public void setNetLogoColor(Object newColor) {
        this._nlColor = newColor;
        this._color = Color.getColor((Object)newColor);
    }

    public double getCoverageSingleCellThreshold() {
        return this._coverageSingleCellThreshold;
    }

    public void setCoverageSingleCellThreshold(double newThreshold) {
        this._coverageSingleCellThreshold = newThreshold;
    }

    public double getCoverageMultipleCellThreshold() {
        return this._coverageMultipleCellThreshold;
    }

    public void setCoverageMultipleCellThreshold(double newThreshold) {
        this._coverageMultipleCellThreshold = newThreshold;
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        return "";
    }

    public String getExtensionName() {
        return "gis";
    }

    public String getNLTypeName() {
        return "State";
    }

    public boolean recursivelyEqual(Object obj) {
        if (obj instanceof VectorDataset) {
            GISExtensionState s = (GISExtensionState)obj;
            return s == this;
        }
        return false;
    }

    static {
        noCoordinateTransformationSetException = new ExtensionException("you must define a coordinate transformation before using any other GIS features. You can use gis:set-transformation directly, or use `gis:set-world-envelope gis:envelope-of dataset` to automatically frame up a given dataset.");
    }
}

