/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import jdk.internal.platform.cgroupv1.Metrics;

public class SubSystem {
    String root;
    String mountPoint;
    String path;

    public SubSystem(String string, String string2) {
        this.root = string;
        this.mountPoint = string2;
    }

    public void setPath(String string) {
        if (this.root != null && string != null) {
            if (this.root.equals("/")) {
                this.path = string.equals("/") ? this.mountPoint + string : this.mountPoint;
            } else if (this.root.equals(string)) {
                this.path = this.mountPoint;
            } else if (this.root.indexOf(string) == 0 && string.length() > this.root.length()) {
                String string2 = string.substring(this.root.length());
                this.path = this.mountPoint + string2;
            }
        }
    }

    public String path() {
        return this.path;
    }

    public static String getStringValue(SubSystem subSystem, String string) {
        if (subSystem == null) {
            return null;
        }
        try {
            return subSystem.readStringValue(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readStringValue(String string) throws IOException {
        PrivilegedExceptionAction<BufferedReader> privilegedExceptionAction = () -> Files.newBufferedReader(Paths.get(this.path(), string));
        try (BufferedReader bufferedReader = AccessController.doPrivileged(privilegedExceptionAction);){
            String string2;
            String string3 = string2 = bufferedReader.readLine();
            return string3;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Metrics.unwrapIOExceptionAndRethrow(privilegedActionException);
            throw new InternalError(privilegedActionException.getCause());
        }
    }

    public static long getLongValue(SubSystem subSystem, String string) {
        String string2 = SubSystem.getStringValue(subSystem, string);
        if (string2 == null) {
            return 0L;
        }
        long l = Long.parseLong(string2);
        return l;
    }

    public static double getDoubleValue(SubSystem subSystem, String string) {
        String string2 = SubSystem.getStringValue(subSystem, string);
        if (string2 == null) {
            return 0.0;
        }
        double d = Double.parseDouble(string2);
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getLongEntry(SubSystem subSystem, String string2, String string3) {
        Object var3_3 = null;
        if (subSystem == null) {
            return 0L;
        }
        try (Stream<String> stream = Metrics.readFilePrivileged(Paths.get(subSystem.path(), string2));){
            Optional<String> optional = stream.map(string -> string.split(" ")).filter(stringArray -> ((String[])stringArray).length == 2 && stringArray[0].equals(string3)).map(stringArray -> stringArray[1]).findFirst();
            long l = optional.isPresent() ? Long.parseLong(optional.get()) : 0L;
            return l;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static int getIntValue(SubSystem subSystem, String string) {
        String string2 = SubSystem.getStringValue(subSystem, string);
        if (string2 == null) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public static int[] StringRangeToIntArray(String string) {
        String[] stringArray;
        int[] nArray = new int[]{};
        if (string == null) {
            return nArray;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : stringArray = string.split(",")) {
            if (string2.contains("-")) {
                String[] stringArray2 = string2.split("-");
                if (stringArray2.length != 2) continue;
                int n = Integer.parseInt(stringArray2[0]);
                int n2 = Integer.parseInt(stringArray2[1]);
                for (int i = n; i <= n2; ++i) {
                    arrayList.add(i);
                }
                continue;
            }
            arrayList.add(Integer.parseInt(string2));
        }
        arrayList.sort(null);
        nArray = new int[arrayList.size()];
        int n = 0;
        for (Integer n3 : arrayList) {
            nArray[n++] = n3;
        }
        return nArray;
    }
}

