/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.nlogo.core.CompilerException;
import org.nlogo.core.LiteralParser;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\r\u001a\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\u0007\u0001C\u0001i!9\u0001\b\u0001b\u0001\n\u0003I\u0004BB#\u0001A\u0003%!\bC\u0004G\u0001\t\u0007I\u0011A$\t\r1\u0003\u0001\u0015!\u0003I\u0011\u001di\u0005A1A\u0005\u00029Caa\u0015\u0001!\u0002\u0013y\u0005b\u0002+\u0001\u0005\u0004%\tA\u0014\u0005\u0007+\u0002\u0001\u000b\u0011B(\t\u000fY\u0003!\u0019!C\u0001/\"1\u0001\r\u0001Q\u0001\naCQ!\u0019\u0001\u0005\u0002]CQA\u0019\u0001\u0005\n\rDQA\u001a\u0001\u0005\u0002\u001dDQA\u001b\u0001\u0005\u0002-DQA\u001c\u0001\u0005\u0002=DQ!\u001d\u0001\u0005\u0002IDQ\u0001\u001e\u0001\u0005\u0002U4a!!\u0003\u0001\u0001\u0005-\u0001BB\u001a\u0016\t\u0003\ty\u0002C\u0004\u0002&U!\t!a\n\u0003\u0015Q\u0013\u0018M\\:mCR|'O\u0003\u0002\u001b7\u0005\u00191\u000fZ7\u000b\u0005qi\u0012!\u00028m_\u001e|'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-A\u0003n_\u0012,G\u000e\u0005\u0002*U5\t\u0011$\u0003\u0002,3\t)Qj\u001c3fY\u0006A1m\\7qS2,'\u000f\u0005\u0002/c5\tqF\u0003\u000217\u0005!1m\u001c:f\u0013\t\u0011tFA\u0007MSR,'/\u00197QCJ\u001cXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U2t\u0007\u0005\u0002*\u0001!)qe\u0001a\u0001Q!)Af\u0001a\u0001[\u000511\u000f^8dWN,\u0012A\u000f\t\u0004w\u0001\u0013U\"\u0001\u001f\u000b\u0005ur\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003\u007f\r\n!bY8mY\u0016\u001cG/[8o\u0013\t\tEH\u0001\u0006MSN$()\u001e4gKJ\u0004\"!K\"\n\u0005\u0011K\"!B*u_\u000e\\\u0017aB:u_\u000e\\7\u000fI\u0001\u0006e\u0006$Xm]\u000b\u0002\u0011B\u00191\bQ%\u0011\u0005%R\u0015BA&\u001a\u0005\u0011\u0011\u0016\r^3\u0002\rI\fG/Z:!\u0003)\u0019wN\u001c<feR,'o]\u000b\u0002\u001fB\u00191\b\u0011)\u0011\u0005%\n\u0016B\u0001*\u001a\u0005%\u0019uN\u001c<feR,'/A\u0006d_:4XM\u001d;feN\u0004\u0013AE2p]N$\u0018M\u001c;D_:4XM\u001d;feN\f1cY8ogR\fg\u000e^\"p]Z,'\u000f^3sg\u0002\n!\u0001\u001a;\u0016\u0003a\u0003\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t1\fgn\u001a\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&L\u0001\u0004TiJLgnZ\u0001\u0004IR\u0004\u0013AB:pkJ\u001cW-\u0001\tqe>\u001cW\rZ;sK\u001a{'OU1uKR\u0011\u0001\f\u001a\u0005\u0006K>\u0001\r!S\u0001\u0002e\u0006)\u0002O]8dK\u0012,(/\u001a$pe\u000e{gN^3si\u0016\u0014HC\u0001-i\u0011\u0015I\u0007\u00031\u0001Q\u0003\u0005\u0019\u0017AH5oSRL\u0017\r\u001c,bYV,W\t\u001f9sKN\u001c\u0018n\u001c8G_J\u001cFo\\2l)\tAF\u000eC\u0003n#\u0001\u0007!)A\u0001t\u0003\tJg.\u001b;jC24\u0016\r\\;f\u000bb\u0004(/Z:tS>tgi\u001c:D_:4XM\u001d;feR\u0011\u0001\f\u001d\u0005\u0006SJ\u0001\r\u0001U\u0001\u0016kB$\u0017\r^3Ti>\u001c7.\u0012=qe\u0016\u001c8/[8o)\tA6\u000fC\u0003n'\u0001\u0007!)\u0001\u0006jg\u000e{gn\u001d;b]R$\"A^=\u0011\u0005\t:\u0018B\u0001=$\u0005\u001d\u0011un\u001c7fC:DQ!\u001c\u000bA\u0002i\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{\u000ej\u0011A \u0006\u0003\u007f~\ta\u0001\u0010:p_Rt\u0014bAA\u0002G\u00051\u0001K]3eK\u001aL1aXA\u0004\u0015\r\t\u0019a\t\u0002\u0010'R|7m[\"p[B\f'/\u0019;peN)Q#!\u0004\u0002\u0014A\u0019\u0011,a\u0004\n\u0007\u0005E!L\u0001\u0004PE*,7\r\u001e\t\u0006\u0003+\tYBQ\u0007\u0003\u0003/Q1!!\u0007]\u0003\u0011)H/\u001b7\n\t\u0005u\u0011q\u0003\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014HCAA\u0011!\r\t\u0019#F\u0007\u0002\u0001\u000591m\\7qCJ,GCBA\u0015\u0003_\t\u0019\u0004E\u0002#\u0003WI1!!\f$\u0005\rIe\u000e\u001e\u0005\u0007\u0003c9\u0002\u0019\u0001\"\u0002\u0005M\f\u0004BBA\u001b/\u0001\u0007!)\u0001\u0002te\u0001")
public class Translator {
    private final LiteralParser compiler;
    private final ListBuffer<Stock> stocks;
    private final ListBuffer<Rate> rates;
    private final ListBuffer<Converter> converters;
    private final ListBuffer<Converter> constantConverters;
    private final String dt;
    private volatile byte bitmap$init$0;

    public ListBuffer<Stock> stocks() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/sdm/Translator.scala: 13");
        }
        return this.stocks;
    }

    public ListBuffer<Rate> rates() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/sdm/Translator.scala: 14");
        }
        return this.rates;
    }

    public ListBuffer<Converter> converters() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/sdm/Translator.scala: 15");
        }
        return this.converters;
    }

    public ListBuffer<Converter> constantConverters() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/sdm/Translator.scala: 16");
        }
        return this.constantConverters;
    }

    public String dt() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/sdm/Translator.scala: 17");
        }
        return this.dt;
    }

    public String source() {
        Stock[] sortedStocks = (Stock[])this.stocks().toArray(ClassTag$.MODULE$.apply(Stock.class));
        Arrays.sort((Object[])sortedStocks, new StockComparator());
        ObjectRef<String> globals = ObjectRef.create("");
        ObjectRef<String> procedures = ObjectRef.create("");
        ObjectRef<String> plots2 = ObjectRef.create("");
        globals.elem = new StringBuilder(43).append((String)globals.elem).append(";; System dynamics model globals\nglobals [\n").toString();
        procedures.elem = new StringBuilder(88).append((String)procedures.elem).append(";; Initializes the system dynamics model.\n;; Call this in your model's SETUP procedure.\n").toString();
        procedures.elem = new StringBuilder(49).append((String)procedures.elem).append("to system-dynamics-setup\n  reset-ticks\n  set dt ").append(this.dt()).append("\n").toString();
        if (!this.constantConverters().isEmpty()) {
            globals.elem = new StringBuilder(15).append((String)globals.elem).append("  ;; constants\n").toString();
            procedures.elem = new StringBuilder(32).append((String)procedures.elem).append("  ;; initialize constant values\n").toString();
            this.constantConverters().foreach((Function1<Converter, Object> & Serializable & scala.Serializable)cc -> {
                Translator.$anonfun$source$1(this, globals, procedures, cc);
                return BoxedUnit.UNIT;
            });
        }
        if (!this.stocks().isEmpty()) {
            globals.elem = new StringBuilder(18).append((String)globals.elem).append("  ;; stock values\n").toString();
            procedures.elem = new StringBuilder(29).append((String)procedures.elem).append("  ;; initialize stock values\n").toString();
            new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sortedStocks)).foreach((Function1<Stock, Object> & Serializable & scala.Serializable)s -> {
                Translator.$anonfun$source$2(this, globals, procedures, s);
                return BoxedUnit.UNIT;
            });
        }
        globals.elem = new StringBuilder(52).append((String)globals.elem).append("  ;; size of each step, see SYSTEM-DYNAMICS-GO\n  dt\n").toString();
        globals.elem = new StringBuilder(3).append((String)globals.elem).append("]\n\n").toString();
        procedures.elem = new StringBuilder(5).append((String)procedures.elem).append("end\n\n").toString();
        procedures.elem = new StringBuilder(90).append((String)procedures.elem).append(";; Step through the system dynamics model by performing next iteration of Euler's method.\n").toString();
        procedures.elem = new StringBuilder(43).append((String)procedures.elem).append(";; Call this in your model's GO procedure.\n").toString();
        procedures.elem = new StringBuilder(22).append((String)procedures.elem).append("to system-dynamics-go\n").toString();
        plots2.elem = new StringBuilder(64).append((String)plots2.elem).append(";; Plot the current state of the system dynamics model's stocks\n").toString();
        plots2.elem = new StringBuilder(55).append((String)plots2.elem).append(";; Call this procedure in your plot's update commands.\n").toString();
        plots2.elem = new StringBuilder(27).append((String)plots2.elem).append("to system-dynamics-do-plot\n").toString();
        if (!this.converters().isEmpty() || !this.rates().isEmpty()) {
            procedures.elem = new StringBuilder(53).append((String)procedures.elem).append("\n  ;; compute variable and flow values once per step\n").toString();
            this.converters().foreach((Function1<Converter, Object> & Serializable & scala.Serializable)c -> {
                procedures.elem = new StringBuilder(14).append((String)procedures.elem).append("  let local-").append(c.name()).append(" ").append(c.name()).append("\n").toString();
                return BoxedUnit.UNIT;
            });
            this.rates().foreach((Function1<Rate, Object> & Serializable & scala.Serializable)r -> {
                procedures.elem = new StringBuilder(14).append((String)procedures.elem).append("  let local-").append(r.name()).append(" ").append(r.name()).append("\n").toString();
                return BoxedUnit.UNIT;
            });
        }
        if (!this.stocks().isEmpty()) {
            procedures.elem = new StringBuilder(102).append((String)procedures.elem).append("\n  ;; update stock values\n  ;; use temporary variables so order of computation doesn't affect result.\n").toString();
            new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sortedStocks)).foreach((Function1<Stock, Object> & Serializable & scala.Serializable)s -> {
                Translator.$anonfun$source$5(this, procedures, plots2, s);
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sortedStocks)).foreach((Function1<Stock, Object> & Serializable & scala.Serializable)s -> {
                procedures.elem = new StringBuilder(12).append((String)procedures.elem).append("  set ").append(s.name()).append(" new-").append(s.name()).append("\n").toString();
                return BoxedUnit.UNIT;
            });
        }
        procedures.elem = new StringBuilder(24).append((String)procedures.elem).append("\n  tick-advance dt\nend\n\n").toString();
        plots2.elem = new StringBuilder(5).append((String)plots2.elem).append("end\n\n").toString();
        this.rates().foreach((Function1<Rate, Object> & Serializable & scala.Serializable)r -> {
            procedures.elem = new StringBuilder(0).append((String)procedures.elem).append(this.procedureForRate(r)).toString();
            return BoxedUnit.UNIT;
        });
        this.converters().foreach((Function1<Converter, Object> & Serializable & scala.Serializable)c -> {
            procedures.elem = new StringBuilder(0).append((String)procedures.elem).append(this.procedureForConverter(c)).toString();
            return BoxedUnit.UNIT;
        });
        return new StringBuilder(0).append((String)globals.elem).append((String)procedures.elem).append((String)plots2.elem).toString();
    }

    private String procedureForRate(Rate r) {
        return new StringBuilder(61).append(";; Report value of flow\nto-report ").append(r.name()).append("\n").append("  report ( ").append((Object)(r.expression() == null ? "0" : r.expression())).append("\n  ) * ").append("dt").append("\n").append("end\n\n").toString();
    }

    public String procedureForConverter(Converter c) {
        return new StringBuilder(54).append(";; Report value of variable\nto-report ").append(c.name()).append("\n").append("  report ").append((Object)(c.expression() == null ? "0" : c.expression())).append("\n").append("end\n\n").toString();
    }

    public String initialValueExpressionForStock(Stock s) {
        return new StringBuilder(8).append("  set ").append(s.name()).append(" ").append((Object)(s.initialValueExpression() != null ? s.initialValueExpression() : "0")).append("\n").toString();
    }

    public String initialValueExpressionForConverter(Converter c) {
        return new StringBuilder(8).append("  set ").append(c.name()).append(" ").append((Object)(c.expression() != null ? c.expression() : "0")).append("\n").toString();
    }

    public String updateStockExpression(Stock s) {
        ObjectRef<String> expr = ObjectRef.create(new StringBuilder(11).append("  let new-").append(s.name()).append((Object)(s.nonNegative() ? " max( list 0 ( " : " ( ")).append(s.name()).append(" ").toString());
        this.rates().foreach((Function1<Rate, Object> & Serializable & scala.Serializable)r -> {
            Translator.$anonfun$updateStockExpression$1(s, expr, r);
            return BoxedUnit.UNIT;
        });
        if (s.nonNegative()) {
            expr.elem = new StringBuilder(2).append((String)expr.elem).append(") ").toString();
        }
        return new StringBuilder(2).append((String)expr.elem).append(")\n").toString();
    }

    public boolean isConstant(String s) {
        try {
            this.compiler.readFromString(s);
            return true;
        }
        catch (CompilerException compilerException) {
            return false;
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$1(ModelElement element) {
        return !element.name().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$source$1(Translator $this, ObjectRef globals$1, ObjectRef procedures$1, Converter cc) {
        globals$1.elem = new StringBuilder(3).append((String)globals$1.elem).append("  ").append(cc.name()).append("\n").toString();
        procedures$1.elem = new StringBuilder(0).append((String)procedures$1.elem).append($this.initialValueExpressionForConverter(cc)).toString();
    }

    public static final /* synthetic */ void $anonfun$source$2(Translator $this, ObjectRef globals$1, ObjectRef procedures$1, Stock s) {
        globals$1.elem = new StringBuilder(3).append((String)globals$1.elem).append("  ").append(s.name()).append("\n").toString();
        procedures$1.elem = new StringBuilder(0).append((String)procedures$1.elem).append($this.initialValueExpressionForStock(s)).toString();
    }

    public static final /* synthetic */ void $anonfun$source$5(Translator $this, ObjectRef procedures$1, ObjectRef plots$1, Stock s) {
        procedures$1.elem = new StringBuilder(0).append((String)procedures$1.elem).append($this.updateStockExpression(s)).toString();
        plots$1.elem = new StringBuilder(27).append((String)plots$1.elem).append("  if plot-pen-exists? \"").append(s.name()).append("\" [\n").toString();
        plots$1.elem = new StringBuilder(28).append((String)plots$1.elem).append("    set-current-plot-pen \"").append(s.name()).append("\"\n").toString();
        plots$1.elem = new StringBuilder(18).append((String)plots$1.elem).append("    plotxy ticks ").append(s.name()).append("\n").toString();
        plots$1.elem = new StringBuilder(4).append((String)plots$1.elem).append("  ]\n").toString();
    }

    public static final /* synthetic */ void $anonfun$updateStockExpression$1(Stock s$1, ObjectRef expr$1, Rate r) {
        block8: {
            block7: {
                String string2;
                String string3;
                block6: {
                    String string4 = r.source().name();
                    String string5 = s$1.name();
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        expr$1.elem = new StringBuilder(9).append((String)expr$1.elem).append("- local-").append(r.name()).append(" ").toString();
                    }
                    string3 = r.sink().name();
                    string2 = s$1.name();
                    if (string3 != null) break block6;
                    if (string2 != null) {
                        return;
                    }
                    break block7;
                }
                if (!string3.equals(string2)) break block8;
            }
            expr$1.elem = new StringBuilder(9).append((String)expr$1.elem).append("+ local-").append(r.name()).append(" ").toString();
        }
    }

    public Translator(Model model, LiteralParser compiler) {
        this.compiler = compiler;
        this.stocks = new ListBuffer();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.rates = new ListBuffer();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.converters = new ListBuffer();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.constantConverters = new ListBuffer();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.dt = Double.toString(model.dt());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        model.elements().withFilter((Function1<ModelElement, Object> & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean(Translator.$anonfun$new$1(element))).foreach((Function1<ModelElement, Object> & Serializable & scala.Serializable)element -> {
            Object object;
            if (element instanceof Reservoir) {
                object = BoxedUnit.UNIT;
            } else if (element instanceof Stock) {
                Stock stock = (Stock)element;
                object = this.stocks().$plus$eq((Object)stock);
            } else {
                Converter converter;
                Rate rate;
                object = element instanceof Rate ? (!(rate = (Rate)element).expression().isEmpty() ? this.rates().$plus$eq((Object)rate) : BoxedUnit.UNIT) : (element instanceof Converter ? (!(converter = (Converter)element).expression().isEmpty() ? (this.isConstant(converter.expression().toUpperCase()) ? this.constantConverters().$plus$eq((Object)converter) : this.converters().$plus$eq((Object)converter)) : BoxedUnit.UNIT) : BoxedUnit.UNIT);
            }
            return object;
        });
    }

    public class StockComparator
    implements Comparator<Stock> {
        @Override
        public Comparator<Stock> reversed() {
            return Comparator.super.reversed();
        }

        @Override
        public Comparator<Stock> thenComparing(Comparator<? super Stock> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        @Override
        public <U> Comparator<Stock> thenComparing(Function<? super Stock, ? extends U> x$1, Comparator<? super U> x$2) {
            return Comparator.super.thenComparing(x$1, x$2);
        }

        @Override
        public <U extends Comparable<? super U>> Comparator<Stock> thenComparing(Function<? super Stock, ? extends U> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        @Override
        public Comparator<Stock> thenComparingInt(ToIntFunction<? super Stock> x$1) {
            return Comparator.super.thenComparingInt(x$1);
        }

        @Override
        public Comparator<Stock> thenComparingLong(ToLongFunction<? super Stock> x$1) {
            return Comparator.super.thenComparingLong(x$1);
        }

        @Override
        public Comparator<Stock> thenComparingDouble(ToDoubleFunction<? super Stock> x$1) {
            return Comparator.super.thenComparingDouble(x$1);
        }

        @Override
        public int compare(Stock s1, Stock s2) {
            String sname1 = s1.name().toUpperCase();
            String sname2 = s2.name().toUpperCase();
            String sexp1 = s1.initialValueExpression().toUpperCase();
            String sexp2 = s2.initialValueExpression().toUpperCase();
            if (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp1)) {
                if (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp2)) {
                    return sname1.compareTo(sname2);
                }
                return -1;
            }
            if (this.org$nlogo$sdm$Translator$StockComparator$$$outer().isConstant(sexp2)) {
                return 1;
            }
            return sname1.compareTo(sname2);
        }

        public /* synthetic */ Translator org$nlogo$sdm$Translator$StockComparator$$$outer() {
            return Translator.this;
        }

        public StockComparator() {
            if (Translator.this == null) {
                throw null;
            }
        }
    }
}

