/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.nio.IntBuffer;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Color$;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Observer;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Patch;
import org.nlogo.api.Patch3D;
import org.nlogo.api.World;
import org.nlogo.api.WorldRenderable;
import org.nlogo.gl.render.AgentRenderer$;
import org.nlogo.gl.render.ShapeRenderer;
import org.nlogo.gl.render.TextureRenderer;
import org.nlogo.gl.render.TextureUtils$;
import scala.Array$;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\t\u0012\tiA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003M\u0001\u0011\u0005Q\nC\u0003k\u0001\u0011\u00051\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003|\u0001\u0011\u0005A\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u0004\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\ti\u0001+\u0019;dQJ+g\u000eZ3sKJT!AE\n\u0002\rI,g\u000eZ3s\u0015\t!R#\u0001\u0002hY*\u0011acF\u0001\u0006]2|wm\u001c\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0007\t\u00039ui\u0011!E\u0005\u0003=E\u0011q\u0002V3yiV\u0014XMU3oI\u0016\u0014XM]\u0001\u0006o>\u0014H\u000e\u001a\n\u0004C\rJc\u0001\u0002\u0012\u0001\u0001\u0001\u0012A\u0002\u0010:fM&tW-\\3oiz\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u000b\u0002\u0007\u0005\u0004\u0018.\u0003\u0002)K\t)qk\u001c:mIB\u0011AEK\u0005\u0003W\u0015\u0012qbV8sY\u0012\u0014VM\u001c3fe\u0006\u0014G.Z\u0001\bIJ\fw/\u001b8h!\t!c&\u0003\u00020K\t\u0001BI]1xS:<\u0017J\u001c;fe\u001a\f7-Z\u0001\u000eg\"\f\u0007/\u001a*f]\u0012,'/\u001a:\u0011\u0005q\u0011\u0014BA\u001a\u0012\u00055\u0019\u0006.\u00199f%\u0016tG-\u001a:fe\u00061A(\u001b8jiz\"BAN\u001c;wA\u0011A\u0004\u0001\u0005\u0006?\u0011\u0001\r\u0001\u000f\n\u0004s\rJc\u0001\u0002\u0012\u0001\u0001aBQ\u0001\f\u0003A\u00025BQ\u0001\r\u0003A\u0002E\nabZ3u!\u0006$8\r[\"p_J$7\u000f\u0006\u0002?\u000fB\u0019qH\u0011#\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013Q!\u0011:sCf\u0004\"aP#\n\u0005\u0019\u0003%!\u0002$m_\u0006$\b\"\u0002%\u0006\u0001\u0004I\u0015!\u00029bi\u000eD\u0007C\u0001\u0013K\u0013\tYUEA\u0003QCR\u001c\u0007.\u0001\fsK:$WM]%oI&4\u0018\u000eZ;bY2\u000b'-\u001a7t)\u0015q\u0015\u000b\u00181f!\tyt*\u0003\u0002Q\u0001\n!QK\\5u\u0011\u0015!b\u00011\u0001S!\t\u0019&,D\u0001U\u0015\t)f+\u0001\u0004pa\u0016tw\r\u001c\u0006\u0003/b\u000baA[8hC6\u0004(\"A-\u0002\u0007\r|W.\u0003\u0002\\)\n\u0019q\t\u0014\u001a\t\u000b!3\u0001\u0019A/\u0011\u0005\u0011r\u0016BA0&\u0005\u001d\u0001\u0016\r^2ig\u0011CQ!\u0019\u0004A\u0002\t\f\u0001BZ8oiNK'0\u001a\t\u0003\u007f\rL!\u0001\u001a!\u0003\u0007%sG\u000fC\u0003g\r\u0001\u0007q-A\u0005qCR\u001c\u0007nU5{KB\u0011q\b[\u0005\u0003S\u0002\u0013a\u0001R8vE2,\u0017\u0001\u0004:f]\u0012,'\u000fT1cK2\u001cH\u0003\u0002(m[:DQ\u0001F\u0004A\u0002ICQ!Y\u0004A\u0002\tDQAZ\u0004A\u0002\u001d\f1B]3oI\u0016\u0014H*\u00192fYRAa*\u001d:umbL(\u0010C\u0003\u0015\u0011\u0001\u0007!\u000bC\u0003t\u0011\u0001\u0007A)A\u0002d_2DQ!\u001e\u0005A\u0002\u0011\u000b1A]8x\u0011\u00159\b\u00021\u0001E\u0003\r!W\r\u001d\u0005\u0006\u0011\"\u0001\r!\u0013\u0005\u0006C\"\u0001\rA\u0019\u0005\u0006M\"\u0001\raZ\u0001\u000ee\u0016tG-\u001a:PkRd\u0017N\\3\u0015\u00079kh\u0010C\u0003\u0015\u0013\u0001\u0007!\u000bC\u0003I\u0013\u0001\u0007\u0011*\u0001\tsK:$WM\u001d%jO\"$H.[4iiR)a*a\u0001\u0002\u0006!)AC\u0003a\u0001%\")\u0001J\u0003a\u0001\u0013\u0006\u0011\"/\u001a8eKJ\u0004\u0016\r^2i)\u0016DH/\u001e:f)\rq\u00151\u0002\u0005\u0006)-\u0001\rAU\u0001\u000ee\u0016tG-\u001a:QCR\u001c\u0007.Z:\u0015\u00079\u000b\t\u0002C\u0003\u0015\u0019\u0001\u0007!\u000bF\u0004O\u0003+\t9\"!\u0007\t\u000bQi\u0001\u0019\u0001*\t\u000b\u0005l\u0001\u0019\u00012\t\u000b\u0019l\u0001\u0019A4\u0002\u001bI,g\u000eZ3s)\u0016DH/\u001e:f)\rq\u0015q\u0004\u0005\u0006)9\u0001\rAU\u0001\u0015G\u0006d7-\u001e7bi\u0016$V\r\u001f;ve\u0016\u001c\u0016N_3\u0015\u000b9\u000b)#a\n\t\u000bQy\u0001\u0019\u0001*\t\u000f\u0005%r\u00021\u0001\u0002,\u0005a\u0001/\u0019;dQ\u0016\u001c(\t\\1oWB\u0019q(!\f\n\u0007\u0005=\u0002IA\u0004C_>dW-\u00198")
public class PatchRenderer
extends TextureRenderer {
    private final World world;
    private final DrawingInterface drawing;
    private final ShapeRenderer shapeRenderer;

    /*
     * WARNING - void declaration
     */
    public float[] getPatchCoords(Patch patch) {
        void var2_2;
        float[] coords = (float[])Array$.MODULE$.apply(Predef$.MODULE$.wrapFloatArray(new float[]{patch.pxcor(), patch.pycor(), 0.0f}), ClassTag$.MODULE$.Float());
        coords[0] = (float)this.world.wrappedObserverX(coords[0]);
        coords[1] = (float)this.world.wrappedObserverY(coords[1]);
        return var2_2;
    }

    public void renderIndividualLabels(GL2 gl, Patch3D patch, int fontSize, double patchSize) {
        if (this.world.patchesWithLabels() > 0) {
            float scale = 0.3f;
            if (patch.hasLabel()) {
                gl.glPushMatrix();
                float[] coords = this.getPatchCoords(patch);
                this.renderLabel(gl, scale * coords[0], scale * coords[1], scale * coords[2], patch, fontSize, patchSize);
                gl.glPopMatrix();
                return;
            }
        }
    }

    public void renderLabels(GL2 gl, int fontSize, double patchSize) {
        if (this.world.patchesWithLabels() > 0) {
            int numPatches = this.world.patchColors().length;
            float scale = 0.3f;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPatches).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)id -> {
                Patch patch = $this.world.getPatch(id);
                if (patch.hasLabel()) {
                    gl.glPushMatrix();
                    float[] coords = this.getPatchCoords(patch);
                    this.renderLabel(gl, scale * coords[0], scale * coords[1], scale * coords[2], patch, fontSize, patchSize);
                    gl.glPopMatrix();
                }
            });
        }
    }

    public void renderLabel(GL2 gl, float col, float row, float dep, Patch patch, int fontSize, double patchSize) {
        Observer observer = this.world.observer();
        ObserverOrientation orientation = observer.orientation().get();
        gl.glTranslated((double)col, (double)row, (double)dep);
        gl.glRotated(-orientation.heading(), 0.0, 0.0, 1.0);
        gl.glRotated(90.0, 1.0, 0.0, 0.0);
        if (observer.perspective() instanceof AgentFollowingPerspective) {
            gl.glRotated(-orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(-orientation.roll(), 0.0, 0.0, 1.0);
        } else {
            gl.glRotated(orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(orientation.roll(), 0.0, 0.0, 1.0);
        }
        AgentRenderer$.MODULE$.renderString(gl, this.world, patch.labelString(), patch.labelColor(), fontSize, patchSize);
    }

    public void renderOutline(GL2 gl, Patch patch) {
        gl.glPushMatrix();
        float scale = 0.3f;
        float[] rgb = Color$.MODULE$.getColor(patch.pcolor()).getRGBColorComponents(null);
        gl.glColor3f((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f);
        gl.glPolygonMode(1032, 6913);
        gl.glEnable(10754);
        gl.glPolygonOffset(-1.0f, -1.0f);
        gl.glScaled((double)scale, (double)scale, (double)scale);
        float[] coords = this.getPatchCoords(patch);
        gl.glTranslated((double)coords[0], (double)coords[1], (double)coords[2]);
        gl.glBegin(7);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glEnd();
        gl.glDisable(10754);
        gl.glPolygonMode(1032, 6914);
        gl.glPopMatrix();
    }

    public void renderHightlight(GL2 gl, Patch patch) {
        gl.glPushMatrix();
        float scale = 0.3f;
        gl.glScaled((double)scale, (double)scale, (double)scale);
        float[] coords = this.getPatchCoords(patch);
        gl.glTranslated((double)coords[0], (double)coords[1], -0.5);
        gl.glScaled(3.3333, 3.3333, 3.3333);
        this.shapeRenderer.renderHalo(gl, false, 1.8999809999999997);
        gl.glPopMatrix();
    }

    public void renderPatchTexture(GL2 gl) {
        this.renderPatches(gl);
    }

    public void renderPatches(GL2 gl) {
        this.calculateTextureSize(gl, this.world.patchesAllBlack());
        this.renderTexture(gl);
    }

    public void renderPatches(GL2 gl, int fontSize, double patchSize) {
    }

    private void renderTexture(GL2 gl) {
        gl.glEnable(3553);
        gl.glDisable(2896);
        if (!this.drawing.isBlank()) {
            gl.glDepthMask(false);
        }
        if (!this.world.patchesAllBlack()) {
            if (this.newTexture) {
                if (this.texture != 0) {
                    gl.glDeleteTextures(1, IntBuffer.wrap((int[])Array$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{this.texture}), ClassTag$.MODULE$.Int())));
                }
                this.texture = TextureUtils$.MODULE$.genTexture(gl);
                gl.glBindTexture(3553, this.texture);
                TextureUtils$.MODULE$.makeTexture(gl, this.textureSize);
                ((WorldRenderable)((Object)this.world)).markPatchColorsDirty();
                this.newTexture = false;
            } else {
                gl.glBindTexture(3553, this.texture);
            }
        }
        gl.glPushMatrix();
        if (this.world.patchesAllBlack()) {
            gl.glScalef((float)this.world.worldWidth(), (float)this.world.worldHeight(), 1.0f);
            TextureUtils$.MODULE$.renderEmptyPlane(gl, 1.0f, 1.0f, 1.0f);
        } else {
            TextureUtils$.MODULE$.setParameters(gl);
            this.renderTextureTiles(gl, this.world.worldWidth(), this.world.worldHeight(), this.textureSize, this.world.patchColors(), ((WorldRenderable)((Object)this.world)).patchColorsDirty());
            ((WorldRenderable)((Object)this.world)).markPatchColorsClean();
        }
        if (!this.drawing.isBlank()) {
            gl.glDepthMask(true);
        }
        gl.glEnable(2896);
        gl.glPopMatrix();
        gl.glBindTexture(3553, 0);
    }

    private void calculateTextureSize(GL2 gl, boolean patchesBlank) {
        int newSize;
        if (!(patchesBlank && this.textureSize != 0 || this.textureSize == (newSize = TextureUtils$.MODULE$.calculateTextureSize(gl, this.world.worldWidth(), this.world.worldHeight())))) {
            this.newTexture = true;
            this.textureSize = newSize;
            this.tiles = TextureUtils$.MODULE$.createTileArray(this.world.worldWidth(), this.world.worldHeight(), this.textureSize);
            return;
        }
    }

    public PatchRenderer(World world, DrawingInterface drawing, ShapeRenderer shapeRenderer) {
        this.world = world;
        this.drawing = drawing;
        this.shapeRenderer = shapeRenderer;
        super(world);
    }
}

