/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.lang.reflect.Field;
import org.nlogo.api.ExtensionException;

public strictfp abstract class ColorSchemes {
    private static final int maxColorScheme = 12;
    private static final String[] schemeTypes = new String[]{"Sequential", "Divergent", "Qualitative"};

    public static int[][][] getRGBArray(String schemeType, String legendName) throws ExtensionException {
        Object colorScheme = new int[12][][];
        Class selectedClass = null;
        if (schemeType.equals("org.nlogo.render.Sequential") || schemeType.equals("Sequential")) {
            selectedClass = Sequential.class;
        } else if (schemeType.equals("org.nlogo.render.Divergent") || schemeType.equals("Divergent")) {
            selectedClass = Divergent.class;
        } else if (schemeType.equals("org.nlogo.render.Qualitative") || schemeType.equals("Qualitative")) {
            selectedClass = Qualitative.class;
        } else {
            throw new ExtensionException("Scheme Type must be Sequential, Divergent, or Qualitative");
        }
        try {
            Field field = selectedClass.getDeclaredField(legendName);
            colorScheme = (int[][][])field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new ExtensionException("Scheme Type must be Sequential, Divergent, or Qualitative");
        }
        catch (IllegalArgumentException e) {
            throw new ExtensionException("The scheme " + legendName + " is not a string. ");
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException("the currently executing method does not have accessto the definition of the specified field");
        }
        return colorScheme;
    }

    public static int[][] getRGBArray(String schemeName, String legendName, int legendSize) throws ExtensionException {
        int i;
        Object colorScheme = new int[12][][];
        Object colorLegend = null;
        if (legendSize < 3) {
            throw new ExtensionException("The minimum size of a color classes is 3 but your thrid argument is " + legendSize);
        }
        colorScheme = ColorSchemes.getRGBArray(schemeName, legendName);
        for (i = 0; i < ((int[][][])colorScheme).length && colorScheme[i].length != legendSize; ++i) {
        }
        if (i < ((int[][][])colorScheme).length) {
            colorLegend = new int[legendSize][];
            colorLegend = colorScheme[i];
        } else {
            colorLegend = null;
        }
        return colorLegend;
    }

    public static Color[] getColorArray(String schemeTypeName, String colorSchemeName, int colorSchemeSize) throws ExtensionException {
        Color[] chosenColorLegend = new Color[colorSchemeSize];
        int[][] colorArray = ColorSchemes.getRGBArray(schemeTypeName, colorSchemeName, colorSchemeSize);
        if (colorSchemeSize < 3) {
            throw new ExtensionException("The minimum size of a color classes is 3 but your thrid argument is " + colorSchemeSize);
        }
        for (int i = 0; i < colorArray.length; ++i) {
            chosenColorLegend[i] = new Color(colorArray[i][0], colorArray[i][1], colorArray[i][2]);
        }
        return chosenColorLegend;
    }

    public static int[] getIntArray(String schemeTypeName, String colorSchemeName, int colorSchemeSize) throws ExtensionException {
        if (colorSchemeSize < 3) {
            throw new ExtensionException("The minimum size of a color classes is 3 but your thrid argument is " + colorSchemeSize);
        }
        int[] colorInt = new int[colorSchemeSize];
        int[][] colorArray = ColorSchemes.getRGBArray(schemeTypeName, colorSchemeName, colorSchemeSize);
        for (int i = 0; i < colorArray.length; ++i) {
            colorInt[i] = colorArray[i][0] << 16 | colorArray[i][1] << 8 | colorArray[i][2];
        }
        return colorInt;
    }

    public static String[] getschemeTypes() {
        return schemeTypes;
    }

    public static int[][][][] getRGBArray(String schemeType) throws ExtensionException {
        int[][][][] colorScheme = null;
        Class selectedClass = null;
        if (schemeType.equals("Sequential")) {
            selectedClass = Sequential.class;
        } else if (schemeType.equals("Divergent")) {
            selectedClass = Divergent.class;
        } else if (schemeType.equals("Qualitative")) {
            selectedClass = Qualitative.class;
        } else {
            throw new ExtensionException("Scheme Type must be Sequential, Divergent, or Qualitative");
        }
        try {
            Field[] fields = selectedClass.getDeclaredFields();
            colorScheme = new int[fields.length][12][][];
            for (int i = 0; i < fields.length; ++i) {
                colorScheme[i] = (int[][][])fields[i].get(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException("the currently executing method does not have accessto the definition of the specified field");
        }
        return colorScheme;
    }

    public static int getMaximumLegendSize(String schemeType) throws ExtensionException {
        int[][][][] colorschemes = ColorSchemes.getRGBArray(schemeType);
        int max = 0;
        for (int i = 0; i < colorschemes.length; ++i) {
            max = Math.max(colorschemes[i].length, max);
        }
        return max + 2;
    }
}

