/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix.eigenvalues;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import ch.akuhn.matrix.eigenvalues.FewEigenvalues;
import java.util.Random;

public class SingularValues {
    public double[] value;
    public Vector[] vectorLeft;
    public Vector[] vectorRight;
    Matrix A;
    private int nev;

    public SingularValues(Matrix A, int nev) {
        this.A = A;
        this.nev = nev;
    }

    public SingularValues decompose() {
        Eigenvalues eigen = new FewEigenvalues(this.A.rowCount()){

            @Override
            protected Vector callback(Vector v) {
                return SingularValues.this.A.mult(SingularValues.this.A.transposeMultiply(v));
            }
        }.greatest(this.nev).run();
        this.nev = eigen.nev;
        this.value = new double[this.nev];
        this.vectorLeft = eigen.vector;
        this.vectorRight = new Vector[this.nev];
        for (int i = 0; i < this.nev; ++i) {
            this.value[i] = Math.sqrt(eigen.value[i]);
            this.vectorRight[i] = this.A.transposeMultiply(this.vectorLeft[i]);
            this.vectorRight[i].timesEquals(1.0 / this.vectorRight[i].norm());
        }
        return this;
    }

    public static void main(String ... args) {
        SparseMatrix A = Matrix.sparse(400, 5000);
        Random rand = new Random(1L);
        for (int i = 0; i < A.rowCount(); ++i) {
            for (int j = 0; j < A.columnCount(); ++j) {
                if (rand.nextDouble() > 0.2) continue;
                A.put(i, j, rand.nextDouble() * 23.0);
            }
        }
        SingularValues singular = new SingularValues(A, 10).decompose();
        System.out.println(singular.value);
    }
}

