/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jcodec.common.NIOUtils;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class UrlBox
extends FullBox {
    private String url;

    public static String fourcc() {
        return "url ";
    }

    public UrlBox(String url) {
        super(new Header(UrlBox.fourcc()));
        this.url = url;
    }

    public UrlBox(Header atom) {
        super(atom);
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        if ((this.flags & 1) != 0) {
            return;
        }
        Charset utf8 = Charset.forName("utf-8");
        this.url = NIOUtils.readNullTermString(input, utf8);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        Charset utf8 = Charset.forName("utf-8");
        if (this.url != null) {
            NIOUtils.write(out, ByteBuffer.wrap(this.url.getBytes(utf8)));
            out.put((byte)0);
        }
    }

    public String getUrl() {
        return this.url;
    }
}

