/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mkv.CuesFactory;
import org.jcodec.containers.mkv.MKVType;
import org.jcodec.containers.mkv.SeekHeadFactory;
import org.jcodec.containers.mkv.boxes.EbmlBase;
import org.jcodec.containers.mkv.boxes.EbmlBin;
import org.jcodec.containers.mkv.boxes.EbmlDate;
import org.jcodec.containers.mkv.boxes.EbmlFloat;
import org.jcodec.containers.mkv.boxes.EbmlMaster;
import org.jcodec.containers.mkv.boxes.EbmlString;
import org.jcodec.containers.mkv.boxes.EbmlUint;
import org.jcodec.containers.mkv.boxes.MkvBlock;
import org.jcodec.containers.mkv.muxer.MKVMuxerTrack;

public class MKVMuxer {
    private List<MKVMuxerTrack> tracks = new ArrayList<MKVMuxerTrack>();
    private MKVMuxerTrack videoTrack = null;
    private EbmlMaster mkvInfo;
    private EbmlMaster mkvTracks;
    private EbmlMaster mkvCues;
    private EbmlMaster mkvSeekHead;
    private List<EbmlMaster> clusterList = new LinkedList<EbmlMaster>();

    public MKVMuxerTrack createVideoTrack(Size dimentions, String codecId) {
        if (this.videoTrack == null) {
            this.videoTrack = new MKVMuxerTrack();
            this.tracks.add(this.videoTrack);
            this.videoTrack.codecId = codecId;
            this.videoTrack.frameDimentions = dimentions;
            this.videoTrack.trackNo = this.tracks.size();
        }
        return this.videoTrack;
    }

    public void mux(SeekableByteChannel s) throws IOException {
        ArrayList<EbmlMaster> mkvFile = new ArrayList<EbmlMaster>();
        EbmlMaster ebmlHeader = this.defaultEbmlHeader();
        mkvFile.add(ebmlHeader);
        EbmlMaster segmentElem = (EbmlMaster)MKVType.createByType(MKVType.Segment);
        this.mkvInfo = this.muxInfo();
        this.mkvTracks = this.muxTracks();
        this.mkvCues = (EbmlMaster)MKVType.createByType(MKVType.Cues);
        this.mkvSeekHead = this.muxSeekHead();
        this.muxCues();
        segmentElem.add(this.mkvSeekHead);
        segmentElem.add(this.mkvInfo);
        segmentElem.add(this.mkvTracks);
        segmentElem.add(this.mkvCues);
        for (EbmlMaster aCluster : this.clusterList) {
            segmentElem.add(aCluster);
        }
        mkvFile.add(segmentElem);
        for (EbmlMaster el : mkvFile) {
            el.mux(s);
        }
    }

    private EbmlMaster defaultEbmlHeader() {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.EBML);
        MKVMuxer.createChild(master, MKVType.EBMLVersion, 1L);
        MKVMuxer.createChild(master, MKVType.EBMLReadVersion, 1L);
        MKVMuxer.createChild(master, MKVType.EBMLMaxIDLength, 4L);
        MKVMuxer.createChild(master, MKVType.EBMLMaxSizeLength, 8L);
        MKVMuxer.createChild(master, MKVType.DocType, "webm");
        MKVMuxer.createChild(master, MKVType.DocTypeVersion, 2L);
        MKVMuxer.createChild(master, MKVType.DocTypeReadVersion, 2L);
        return master;
    }

    private EbmlMaster muxInfo() {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.Info);
        int frameDurationInNanoseconds = 40000000;
        MKVMuxer.createChild(master, MKVType.TimecodeScale, frameDurationInNanoseconds);
        MKVMuxer.createChild(master, MKVType.WritingApp, "JCodec v0.1.7");
        MKVMuxer.createChild(master, MKVType.MuxingApp, "JCodec MKVStreamingMuxer v0.1.7");
        MkvBlock lastBlock = this.videoTrack.trackBlocks.get(this.videoTrack.trackBlocks.size() - 1);
        MKVMuxer.createChild(master, MKVType.Duration, (double)((lastBlock.absoluteTimecode + 1L) * (long)frameDurationInNanoseconds) * 1.0);
        MKVMuxer.createChild(master, MKVType.DateUTC, new Date());
        return master;
    }

    private EbmlMaster muxTracks() {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.Tracks);
        for (int i = 0; i < this.tracks.size(); ++i) {
            MKVMuxerTrack track = this.tracks.get(i);
            EbmlMaster trackEntryElem = (EbmlMaster)MKVType.createByType(MKVType.TrackEntry);
            MKVMuxer.createChild(trackEntryElem, MKVType.TrackNumber, track.trackNo);
            MKVMuxer.createChild(trackEntryElem, MKVType.TrackUID, track.trackNo);
            if (MKVMuxerTrack.MKVMuxerTrackType.VIDEO.equals((Object)track.type)) {
                MKVMuxer.createChild(trackEntryElem, MKVType.TrackType, 1L);
                MKVMuxer.createChild(trackEntryElem, MKVType.Name, "Track " + (i + 1) + " Video");
                MKVMuxer.createChild(trackEntryElem, MKVType.CodecID, track.codecId);
                EbmlMaster trackVideoElem = (EbmlMaster)MKVType.createByType(MKVType.Video);
                MKVMuxer.createChild(trackVideoElem, MKVType.PixelWidth, track.frameDimentions.getWidth());
                MKVMuxer.createChild(trackVideoElem, MKVType.PixelHeight, track.frameDimentions.getHeight());
                trackEntryElem.add(trackVideoElem);
            } else {
                MKVMuxer.createChild(trackEntryElem, MKVType.TrackType, 2L);
                MKVMuxer.createChild(trackEntryElem, MKVType.Name, "Track " + (i + 1) + " Audio");
                MKVMuxer.createChild(trackEntryElem, MKVType.CodecID, track.codecId);
            }
            master.add(trackEntryElem);
        }
        return master;
    }

    private void muxCues() {
        CuesFactory cf = new CuesFactory(this.mkvSeekHead.size() + this.mkvInfo.size() + this.mkvTracks.size(), this.videoTrack.trackNo - 1);
        for (MkvBlock aBlock : this.videoTrack.trackBlocks) {
            EbmlMaster mkvCluster = this.singleBlockedCluster(aBlock);
            this.clusterList.add(mkvCluster);
            cf.add(CuesFactory.CuePointMock.make(mkvCluster));
        }
        EbmlMaster indexedCues = cf.createCues();
        for (EbmlBase aCuePoint : indexedCues.children) {
            this.mkvCues.add(aCuePoint);
        }
    }

    private EbmlMaster singleBlockedCluster(MkvBlock aBlock) {
        EbmlMaster mkvCluster = (EbmlMaster)MKVType.createByType(MKVType.Cluster);
        MKVMuxer.createChild(mkvCluster, MKVType.Timecode, aBlock.absoluteTimecode - (long)aBlock.timecode);
        mkvCluster.add(aBlock);
        return mkvCluster;
    }

    private EbmlMaster muxSeekHead() {
        SeekHeadFactory shi = new SeekHeadFactory();
        shi.add(this.mkvInfo);
        shi.add(this.mkvTracks);
        shi.add(this.mkvCues);
        return shi.indexSeekHead();
    }

    public static void createChild(EbmlMaster parent, MKVType type, long value) {
        EbmlUint se = (EbmlUint)MKVType.createByType(type);
        se.set(value);
        parent.add(se);
    }

    public static void createChild(EbmlMaster parent, MKVType type, String value) {
        EbmlString se = (EbmlString)MKVType.createByType(type);
        se.set(value);
        parent.add(se);
    }

    public static void createChild(EbmlMaster parent, MKVType type, Date value) {
        EbmlDate se = (EbmlDate)MKVType.createByType(type);
        se.setDate(value);
        parent.add(se);
    }

    public static void createChild(EbmlMaster parent, MKVType type, ByteBuffer value) {
        EbmlBin se = (EbmlBin)MKVType.createByType(type);
        se.set(value);
        parent.add(se);
    }

    public static void createChild(EbmlMaster parent, MKVType type, double value) {
        try {
            EbmlFloat se = (EbmlFloat)MKVType.createByType(type);
            se.set(value);
            parent.add(se);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Element of type " + (Object)((Object)type) + " can't be cast to EbmlFloat", cce);
        }
    }
}

