/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12.bitstream;

import java.nio.ByteBuffer;
import org.jcodec.codecs.mpeg12.bitstream.CopyrightExtension;
import org.jcodec.codecs.mpeg12.bitstream.MPEGHeader;
import org.jcodec.codecs.mpeg12.bitstream.PictureCodingExtension;
import org.jcodec.codecs.mpeg12.bitstream.PictureDisplayExtension;
import org.jcodec.codecs.mpeg12.bitstream.PictureSpatialScalableExtension;
import org.jcodec.codecs.mpeg12.bitstream.PictureTemporalScalableExtension;
import org.jcodec.codecs.mpeg12.bitstream.QuantMatrixExtension;
import org.jcodec.codecs.mpeg12.bitstream.SequenceHeader;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;

public class PictureHeader
implements MPEGHeader {
    public static final int Quant_Matrix_Extension = 3;
    public static final int Copyright_Extension = 4;
    public static final int Picture_Display_Extension = 7;
    public static final int Picture_Coding_Extension = 8;
    public static final int Picture_Spatial_Scalable_Extension = 9;
    public static final int Picture_Temporal_Scalable_Extension = 16;
    public static final int IntraCoded = 1;
    public static final int PredictiveCoded = 2;
    public static final int BiPredictiveCoded = 3;
    public int temporal_reference;
    public int picture_coding_type;
    public int vbv_delay;
    public int full_pel_forward_vector;
    public int forward_f_code;
    public int full_pel_backward_vector;
    public int backward_f_code;
    public QuantMatrixExtension quantMatrixExtension;
    public CopyrightExtension copyrightExtension;
    public PictureDisplayExtension pictureDisplayExtension;
    public PictureCodingExtension pictureCodingExtension;
    public PictureSpatialScalableExtension pictureSpatialScalableExtension;
    public PictureTemporalScalableExtension pictureTemporalScalableExtension;
    private boolean hasExtensions;

    public PictureHeader(int temporal_reference, int picture_coding_type, int vbv_delay, int full_pel_forward_vector, int forward_f_code, int full_pel_backward_vector, int backward_f_code) {
        this.temporal_reference = temporal_reference;
        this.picture_coding_type = picture_coding_type;
        this.vbv_delay = vbv_delay;
        this.full_pel_forward_vector = full_pel_forward_vector;
        this.forward_f_code = forward_f_code;
        this.full_pel_backward_vector = full_pel_backward_vector;
        this.backward_f_code = backward_f_code;
    }

    private PictureHeader() {
    }

    public static PictureHeader read(ByteBuffer bb) {
        BitReader in = new BitReader(bb);
        PictureHeader ph = new PictureHeader();
        ph.temporal_reference = in.readNBit(10);
        ph.picture_coding_type = in.readNBit(3);
        ph.vbv_delay = in.readNBit(16);
        if (ph.picture_coding_type == 2 || ph.picture_coding_type == 3) {
            ph.full_pel_forward_vector = in.read1Bit();
            ph.forward_f_code = in.readNBit(3);
        }
        if (ph.picture_coding_type == 3) {
            ph.full_pel_backward_vector = in.read1Bit();
            ph.backward_f_code = in.readNBit(3);
        }
        while (in.read1Bit() == 1) {
            in.readNBit(8);
        }
        return ph;
    }

    public static void readExtension(ByteBuffer bb, PictureHeader ph, SequenceHeader sh) {
        ph.hasExtensions = true;
        BitReader in = new BitReader(bb);
        int extType = in.readNBit(4);
        switch (extType) {
            case 3: {
                ph.quantMatrixExtension = QuantMatrixExtension.read(in);
                break;
            }
            case 4: {
                ph.copyrightExtension = CopyrightExtension.read(in);
                break;
            }
            case 7: {
                ph.pictureDisplayExtension = PictureDisplayExtension.read(in, sh.sequenceExtension, ph.pictureCodingExtension);
                break;
            }
            case 8: {
                ph.pictureCodingExtension = PictureCodingExtension.read(in);
                break;
            }
            case 9: {
                ph.pictureSpatialScalableExtension = PictureSpatialScalableExtension.read(in);
                break;
            }
            case 16: {
                ph.pictureTemporalScalableExtension = PictureTemporalScalableExtension.read(in);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported extension: " + extType);
            }
        }
    }

    @Override
    public void write(ByteBuffer os) {
        BitWriter out = new BitWriter(os);
        out.writeNBit(this.temporal_reference, 10);
        out.writeNBit(this.picture_coding_type, 3);
        out.writeNBit(this.vbv_delay, 16);
        if (this.picture_coding_type == 2 || this.picture_coding_type == 3) {
            out.write1Bit(this.full_pel_forward_vector);
            out.write1Bit(this.forward_f_code);
        }
        if (this.picture_coding_type == 3) {
            out.write1Bit(this.full_pel_backward_vector);
            out.writeNBit(this.backward_f_code, 3);
        }
        out.write1Bit(0);
        out.flush();
        this.writeExtensions(os);
    }

    private void writeExtensions(ByteBuffer out) {
        if (this.quantMatrixExtension != null) {
            out.putInt(181);
            this.quantMatrixExtension.write(out);
        }
        if (this.copyrightExtension != null) {
            out.putInt(181);
            this.copyrightExtension.write(out);
        }
        if (this.pictureCodingExtension != null) {
            out.putInt(181);
            this.pictureCodingExtension.write(out);
        }
        if (this.pictureDisplayExtension != null) {
            out.putInt(181);
            this.pictureDisplayExtension.write(out);
        }
        if (this.pictureSpatialScalableExtension != null) {
            out.putInt(181);
            this.pictureSpatialScalableExtension.write(out);
        }
        if (this.pictureTemporalScalableExtension != null) {
            out.putInt(181);
            this.pictureTemporalScalableExtension.write(out);
        }
    }

    public boolean hasExtensions() {
        return this.hasExtensions;
    }
}

