/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode.deblock;

import org.jcodec.codecs.h264.io.model.MBType;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.tools.MathUtil;

public class DeblockingFilter {
    static int[] alphaTab = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 5, 6, 7, 8, 9, 10, 12, 13, 15, 17, 20, 22, 25, 28, 32, 36, 40, 45, 50, 56, 63, 71, 80, 90, 101, 113, 127, 144, 162, 182, 203, 226, 255, 255};
    static int[] betaTab = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18};
    static int[][] tcs = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 8, 9, 10, 11, 13}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 10, 11, 12, 13, 15, 17}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 8, 9, 10, 11, 13, 14, 16, 18, 20, 23, 25}};
    private int[][] nCoeff;
    private int[][][][] mvs;
    private MBType[] mbTypes;
    private int[][] mbQps;
    private SliceHeader[] shs;
    private boolean[] tr8x8Used;
    private Picture[][][] refsUsed;
    static int[] inverse = new int[]{0, 1, 4, 5, 2, 3, 6, 7, 8, 9, 12, 13, 10, 11, 14, 15};

    public DeblockingFilter(int bitDepthLuma, int bitDepthChroma, int[][] nCoeff, int[][][][] mvs, MBType[] mbTypes, int[][] mbQps, SliceHeader[] shs, boolean[] tr8x8Used, Picture[][][] refsUsed) {
        this.nCoeff = nCoeff;
        this.mvs = mvs;
        this.mbTypes = mbTypes;
        this.mbQps = mbQps;
        this.shs = shs;
        this.tr8x8Used = tr8x8Used;
        this.refsUsed = refsUsed;
    }

    public void deblockFrame(Picture result) {
        ColorSpace color = result.getColor();
        int[][] bsV = new int[4][4];
        int[][] bsH = new int[4][4];
        for (int i = 0; i < this.shs.length; ++i) {
            this.calcBsH(result, i, bsH);
            this.calcBsV(result, i, bsV);
            for (int c = 0; c < color.nComp; ++c) {
                this.fillVerticalEdge(result, c, i, bsV);
                this.fillHorizontalEdge(result, c, i, bsH);
            }
        }
    }

    private int calcBoundaryStrenth(boolean atMbBoundary, boolean leftIntra, boolean rightIntra, int leftCoeff, int rightCoeff, int[] mvA0, int[] mvB0, int[] mvA1, int[] mvB1, int mbAddrA, int mbAddrB) {
        Picture rb1;
        int nB;
        if (atMbBoundary && (leftIntra || rightIntra)) {
            return 4;
        }
        if (leftIntra || rightIntra) {
            return 3;
        }
        if (leftCoeff > 0 || rightCoeff > 0) {
            return 2;
        }
        int nA = (mvA0[2] == -1 ? 0 : 1) + (mvA1[2] == -1 ? 0 : 1);
        if (nA != (nB = (mvB0[2] == -1 ? 0 : 1) + (mvB1[2] == -1 ? 0 : 1))) {
            return 1;
        }
        Picture ra0 = mvA0[2] < 0 ? null : this.refsUsed[mbAddrA][0][mvA0[2]];
        Picture ra1 = mvA1[2] < 0 ? null : this.refsUsed[mbAddrA][1][mvA1[2]];
        Picture rb0 = mvB0[2] < 0 ? null : this.refsUsed[mbAddrB][0][mvB0[2]];
        Picture picture = rb1 = mvB1[2] < 0 ? null : this.refsUsed[mbAddrB][1][mvB1[2]];
        if (ra0 != rb0 && ra0 != rb1 || ra1 != rb0 && ra1 != rb1 || rb0 != ra0 && rb0 != ra1 || rb1 != ra0 && rb1 != ra1) {
            return 1;
        }
        if (ra0 == ra1 && ra1 == rb0 && rb0 == rb1) {
            return ra0 != null && (this.mvThresh(mvA0, mvB0) || this.mvThresh(mvA1, mvB0) || this.mvThresh(mvA0, mvB1) || this.mvThresh(mvA1, mvB1)) ? 1 : 0;
        }
        if (ra0 == rb0 && ra1 == rb1) {
            return ra0 != null && this.mvThresh(mvA0, mvB0) || ra1 != null && this.mvThresh(mvA1, mvB1) ? 1 : 0;
        }
        if (ra0 == rb1 && ra1 == rb0) {
            return ra0 != null && this.mvThresh(mvA0, mvB1) || ra1 != null && this.mvThresh(mvA1, mvB0) ? 1 : 0;
        }
        return 0;
    }

    private boolean mvThresh(int[] v0, int[] v1) {
        return Math.abs(v0[0] - v1[0]) >= 4 || Math.abs(v0[1] - v1[1]) >= 4;
    }

    private static int getIdxBeta(int sliceBetaOffset, int avgQp) {
        return MathUtil.clip(avgQp + sliceBetaOffset, 0, 51);
    }

    private static int getIdxAlpha(int sliceAlphaC0Offset, int avgQp) {
        return MathUtil.clip(avgQp + sliceAlphaC0Offset, 0, 51);
    }

    private void calcBsH(Picture pic, int mbAddr, int[][] bs) {
        int thisBlkY;
        int thisBlkX;
        int blkX;
        boolean thisIntra;
        SliceHeader sh = this.shs[mbAddr];
        int mbWidth = sh.sps.pic_width_in_mbs_minus1 + 1;
        int mbX = mbAddr % mbWidth;
        int mbY = mbAddr / mbWidth;
        boolean topAvailable = mbY > 0 && (sh.disable_deblocking_filter_idc != 2 || this.shs[mbAddr - mbWidth] == sh);
        boolean bl = thisIntra = this.mbTypes[mbAddr] != null && this.mbTypes[mbAddr].isIntra();
        if (topAvailable) {
            boolean topIntra = this.mbTypes[mbAddr - mbWidth] != null && this.mbTypes[mbAddr - mbWidth].isIntra();
            for (blkX = 0; blkX < 4; ++blkX) {
                thisBlkX = (mbX << 2) + blkX;
                thisBlkY = mbY << 2;
                bs[0][blkX] = this.calcBoundaryStrenth(true, topIntra, thisIntra, this.nCoeff[thisBlkY][thisBlkX], this.nCoeff[thisBlkY - 1][thisBlkX], this.mvs[0][thisBlkY][thisBlkX], this.mvs[0][thisBlkY - 1][thisBlkX], this.mvs[1][thisBlkY][thisBlkX], this.mvs[1][thisBlkY - 1][thisBlkX], mbAddr, mbAddr - mbWidth);
            }
        }
        for (int blkY = 1; blkY < 4; ++blkY) {
            for (blkX = 0; blkX < 4; ++blkX) {
                thisBlkX = (mbX << 2) + blkX;
                thisBlkY = (mbY << 2) + blkY;
                bs[blkY][blkX] = this.calcBoundaryStrenth(false, thisIntra, thisIntra, this.nCoeff[thisBlkY][thisBlkX], this.nCoeff[thisBlkY - 1][thisBlkX], this.mvs[0][thisBlkY][thisBlkX], this.mvs[0][thisBlkY - 1][thisBlkX], this.mvs[1][thisBlkY][thisBlkX], this.mvs[1][thisBlkY - 1][thisBlkX], mbAddr, mbAddr);
            }
        }
    }

    private void fillHorizontalEdge(Picture pic, int comp, int mbAddr, int[][] bs) {
        int thisBlkY;
        int thisBlkX;
        int blkX;
        SliceHeader sh = this.shs[mbAddr];
        int mbWidth = sh.sps.pic_width_in_mbs_minus1 + 1;
        int alpha = sh.slice_alpha_c0_offset_div2 << 1;
        int beta = sh.slice_beta_offset_div2 << 1;
        int mbX = mbAddr % mbWidth;
        int mbY = mbAddr / mbWidth;
        boolean topAvailable = mbY > 0 && (sh.disable_deblocking_filter_idc != 2 || this.shs[mbAddr - mbWidth] == sh);
        int curQp = this.mbQps[comp][mbAddr];
        int cW = 2 - pic.getColor().compWidth[comp];
        int cH = 2 - pic.getColor().compHeight[comp];
        if (topAvailable) {
            int topQp = this.mbQps[comp][mbAddr - mbWidth];
            int avgQp = topQp + curQp + 1 >> 1;
            for (blkX = 0; blkX < 4; ++blkX) {
                thisBlkX = (mbX << 2) + blkX;
                thisBlkY = mbY << 2;
                this.filterBlockEdgeHoris(pic, comp, thisBlkX << cW, thisBlkY << cH, DeblockingFilter.getIdxAlpha(alpha, avgQp), DeblockingFilter.getIdxBeta(beta, avgQp), bs[0][blkX], 1 << cW);
            }
        }
        boolean skip4x4 = comp == 0 && this.tr8x8Used[mbAddr] || cH == 1;
        for (int blkY = 1; blkY < 4; ++blkY) {
            if (skip4x4 && (blkY & 1) == 1) continue;
            for (blkX = 0; blkX < 4; ++blkX) {
                thisBlkX = (mbX << 2) + blkX;
                thisBlkY = (mbY << 2) + blkY;
                this.filterBlockEdgeHoris(pic, comp, thisBlkX << cW, thisBlkY << cH, DeblockingFilter.getIdxAlpha(alpha, curQp), DeblockingFilter.getIdxBeta(beta, curQp), bs[blkY][blkX], 1 << cW);
            }
        }
    }

    private void calcBsV(Picture pic, int mbAddr, int[][] bs) {
        int thisBlkY;
        int thisBlkX;
        int blkY;
        boolean thisIntra;
        SliceHeader sh = this.shs[mbAddr];
        int mbWidth = sh.sps.pic_width_in_mbs_minus1 + 1;
        int mbX = mbAddr % mbWidth;
        int mbY = mbAddr / mbWidth;
        boolean leftAvailable = mbX > 0 && (sh.disable_deblocking_filter_idc != 2 || this.shs[mbAddr - 1] == sh);
        boolean bl = thisIntra = this.mbTypes[mbAddr] != null && this.mbTypes[mbAddr].isIntra();
        if (leftAvailable) {
            boolean leftIntra = this.mbTypes[mbAddr - 1] != null && this.mbTypes[mbAddr - 1].isIntra();
            for (blkY = 0; blkY < 4; ++blkY) {
                thisBlkX = mbX << 2;
                thisBlkY = (mbY << 2) + blkY;
                bs[blkY][0] = this.calcBoundaryStrenth(true, leftIntra, thisIntra, this.nCoeff[thisBlkY][thisBlkX], this.nCoeff[thisBlkY][thisBlkX - 1], this.mvs[0][thisBlkY][thisBlkX], this.mvs[0][thisBlkY][thisBlkX - 1], this.mvs[1][thisBlkY][thisBlkX], this.mvs[1][thisBlkY][thisBlkX - 1], mbAddr, mbAddr - 1);
            }
        }
        for (int blkX = 1; blkX < 4; ++blkX) {
            for (blkY = 0; blkY < 4; ++blkY) {
                thisBlkX = (mbX << 2) + blkX;
                thisBlkY = (mbY << 2) + blkY;
                bs[blkY][blkX] = this.calcBoundaryStrenth(false, thisIntra, thisIntra, this.nCoeff[thisBlkY][thisBlkX], this.nCoeff[thisBlkY][thisBlkX - 1], this.mvs[0][thisBlkY][thisBlkX], this.mvs[0][thisBlkY][thisBlkX - 1], this.mvs[1][thisBlkY][thisBlkX], this.mvs[1][thisBlkY][thisBlkX - 1], mbAddr, mbAddr);
            }
        }
    }

    private void fillVerticalEdge(Picture pic, int comp, int mbAddr, int[][] bs) {
        int thisBlkY;
        int thisBlkX;
        int blkY;
        SliceHeader sh = this.shs[mbAddr];
        int mbWidth = sh.sps.pic_width_in_mbs_minus1 + 1;
        int alpha = sh.slice_alpha_c0_offset_div2 << 1;
        int beta = sh.slice_beta_offset_div2 << 1;
        int mbX = mbAddr % mbWidth;
        int mbY = mbAddr / mbWidth;
        boolean leftAvailable = mbX > 0 && (sh.disable_deblocking_filter_idc != 2 || this.shs[mbAddr - 1] == sh);
        int curQp = this.mbQps[comp][mbAddr];
        int cW = 2 - pic.getColor().compWidth[comp];
        int cH = 2 - pic.getColor().compHeight[comp];
        if (leftAvailable) {
            int leftQp = this.mbQps[comp][mbAddr - 1];
            int avgQpV = leftQp + curQp + 1 >> 1;
            for (blkY = 0; blkY < 4; ++blkY) {
                thisBlkX = mbX << 2;
                thisBlkY = (mbY << 2) + blkY;
                this.filterBlockEdgeVert(pic, comp, thisBlkX << cW, thisBlkY << cH, DeblockingFilter.getIdxAlpha(alpha, avgQpV), DeblockingFilter.getIdxBeta(beta, avgQpV), bs[blkY][0], 1 << cH);
            }
        }
        boolean skip4x4 = comp == 0 && this.tr8x8Used[mbAddr] || cW == 1;
        for (int blkX = 1; blkX < 4; ++blkX) {
            if (skip4x4 && (blkX & 1) == 1) continue;
            for (blkY = 0; blkY < 4; ++blkY) {
                thisBlkX = (mbX << 2) + blkX;
                thisBlkY = (mbY << 2) + blkY;
                this.filterBlockEdgeVert(pic, comp, thisBlkX << cW, thisBlkY << cH, DeblockingFilter.getIdxAlpha(alpha, curQp), DeblockingFilter.getIdxBeta(beta, curQp), bs[blkY][blkX], 1 << cH);
            }
        }
    }

    private void filterBlockEdgeHoris(Picture pic, int comp, int x, int y, int indexAlpha, int indexBeta, int bs, int blkW) {
        int stride = pic.getPlaneWidth(comp);
        int offset = y * stride + x;
        for (int pixOff = 0; pixOff < blkW; ++pixOff) {
            int p2Idx = offset - 3 * stride + pixOff;
            int p1Idx = offset - 2 * stride + pixOff;
            int p0Idx = offset - stride + pixOff;
            int q0Idx = offset + pixOff;
            int q1Idx = offset + stride + pixOff;
            int q2Idx = offset + 2 * stride + pixOff;
            if (bs == 4) {
                int p3Idx = offset - 4 * stride + pixOff;
                int q3Idx = offset + 3 * stride + pixOff;
                this.filterBs4(indexAlpha, indexBeta, pic.getPlaneData(comp), p3Idx, p2Idx, p1Idx, p0Idx, q0Idx, q1Idx, q2Idx, q3Idx, comp != 0);
                continue;
            }
            if (bs <= 0) continue;
            this.filterBs(bs, indexAlpha, indexBeta, pic.getPlaneData(comp), p2Idx, p1Idx, p0Idx, q0Idx, q1Idx, q2Idx, comp != 0);
        }
    }

    private void filterBlockEdgeVert(Picture pic, int comp, int x, int y, int indexAlpha, int indexBeta, int bs, int blkH) {
        int stride = pic.getPlaneWidth(comp);
        for (int i = 0; i < blkH; ++i) {
            int offsetQ = (y + i) * stride + x;
            int p2Idx = offsetQ - 3;
            int p1Idx = offsetQ - 2;
            int p0Idx = offsetQ - 1;
            int q0Idx = offsetQ;
            int q1Idx = offsetQ + 1;
            int q2Idx = offsetQ + 2;
            if (bs == 4) {
                int p3Idx = offsetQ - 4;
                int q3Idx = offsetQ + 3;
                this.filterBs4(indexAlpha, indexBeta, pic.getPlaneData(comp), p3Idx, p2Idx, p1Idx, p0Idx, q0Idx, q1Idx, q2Idx, q3Idx, comp != 0);
                continue;
            }
            if (bs <= 0) continue;
            this.filterBs(bs, indexAlpha, indexBeta, pic.getPlaneData(comp), p2Idx, p1Idx, p0Idx, q0Idx, q1Idx, q2Idx, comp != 0);
        }
    }

    private void filterBs(int bs, int indexAlpha, int indexBeta, int[] pels, int p2Idx, int p1Idx, int p0Idx, int q0Idx, int q1Idx, int q2Idx, boolean isChroma) {
        int diff;
        boolean conditionQ;
        boolean conditionP;
        int tC;
        boolean filterEnabled;
        int p1 = pels[p1Idx];
        int p0 = pels[p0Idx];
        int q0 = pels[q0Idx];
        int q1 = pels[q1Idx];
        int alphaThresh = alphaTab[indexAlpha];
        int betaThresh = betaTab[indexBeta];
        boolean bl = filterEnabled = Math.abs(p0 - q0) < alphaThresh && Math.abs(p1 - p0) < betaThresh && Math.abs(q1 - q0) < betaThresh;
        if (!filterEnabled) {
            return;
        }
        int tC0 = tcs[bs - 1][indexAlpha];
        if (!isChroma) {
            int ap = Math.abs(pels[p2Idx] - p0);
            int aq = Math.abs(pels[q2Idx] - q0);
            tC = tC0 + (ap < betaThresh ? 1 : 0) + (aq < betaThresh ? 1 : 0);
            conditionP = ap < betaThresh;
            conditionQ = aq < betaThresh;
        } else {
            tC = tC0 + 1;
            conditionP = false;
            conditionQ = false;
        }
        int sigma = (q0 - p0 << 2) + (p1 - q1) + 4 >> 3;
        sigma = sigma < -tC ? -tC : (sigma > tC ? tC : sigma);
        int p0n = p0 + sigma;
        p0n = p0n < 0 ? 0 : p0n;
        int q0n = q0 - sigma;
        int n = q0n = q0n < 0 ? 0 : q0n;
        if (conditionP) {
            int p2 = pels[p2Idx];
            diff = p2 + (p0 + q0 + 1 >> 1) - (p1 << 1) >> 1;
            diff = diff < -tC0 ? -tC0 : (diff > tC0 ? tC0 : diff);
            int p1n = p1 + diff;
            pels[p1Idx] = MathUtil.clip(p1n, 0, 255);
        }
        if (conditionQ) {
            int q2 = pels[q2Idx];
            diff = q2 + (p0 + q0 + 1 >> 1) - (q1 << 1) >> 1;
            diff = diff < -tC0 ? -tC0 : (diff > tC0 ? tC0 : diff);
            int q1n = q1 + diff;
            pels[q1Idx] = MathUtil.clip(q1n, 0, 255);
        }
        pels[q0Idx] = MathUtil.clip(q0n, 0, 255);
        pels[p0Idx] = MathUtil.clip(p0n, 0, 255);
    }

    private void filterBs4(int indexAlpha, int indexBeta, int[] pels, int p3Idx, int p2Idx, int p1Idx, int p0Idx, int q0Idx, int q1Idx, int q2Idx, int q3Idx, boolean isChroma) {
        boolean conditionQ;
        boolean conditionP;
        boolean filterEnabled;
        int p0 = pels[p0Idx];
        int q0 = pels[q0Idx];
        int p1 = pels[p1Idx];
        int q1 = pels[q1Idx];
        int alphaThresh = alphaTab[indexAlpha];
        int betaThresh = betaTab[indexBeta];
        boolean bl = filterEnabled = Math.abs(p0 - q0) < alphaThresh && Math.abs(p1 - p0) < betaThresh && Math.abs(q1 - q0) < betaThresh;
        if (!filterEnabled) {
            return;
        }
        if (isChroma) {
            conditionP = false;
            conditionQ = false;
        } else {
            int ap = Math.abs(pels[p2Idx] - p0);
            int aq = Math.abs(pels[q2Idx] - q0);
            conditionP = ap < betaThresh && Math.abs(p0 - q0) < (alphaThresh >> 2) + 2;
            boolean bl2 = conditionQ = aq < betaThresh && Math.abs(p0 - q0) < (alphaThresh >> 2) + 2;
        }
        if (conditionP) {
            int p3 = pels[p3Idx];
            int p2 = pels[p2Idx];
            int p0n = p2 + 2 * p1 + 2 * p0 + 2 * q0 + q1 + 4 >> 3;
            int p1n = p2 + p1 + p0 + q0 + 2 >> 2;
            int p2n = 2 * p3 + 3 * p2 + p1 + p0 + q0 + 4 >> 3;
            pels[p0Idx] = MathUtil.clip(p0n, 0, 255);
            pels[p1Idx] = MathUtil.clip(p1n, 0, 255);
            pels[p2Idx] = MathUtil.clip(p2n, 0, 255);
        } else {
            int p0n = 2 * p1 + p0 + q1 + 2 >> 2;
            pels[p0Idx] = MathUtil.clip(p0n, 0, 255);
        }
        if (conditionQ && !isChroma) {
            int q2 = pels[q2Idx];
            int q3 = pels[q3Idx];
            int q0n = p1 + 2 * p0 + 2 * q0 + 2 * q1 + q2 + 4 >> 3;
            int q1n = p0 + q0 + q1 + q2 + 2 >> 2;
            int q2n = 2 * q3 + 3 * q2 + q1 + q0 + p0 + 4 >> 3;
            pels[q0Idx] = MathUtil.clip(q0n, 0, 255);
            pels[q1Idx] = MathUtil.clip(q1n, 0, 255);
            pels[q2Idx] = MathUtil.clip(q2n, 0, 255);
        } else {
            int q0n = 2 * q1 + q0 + p1 + 2 >> 2;
            pels[q0Idx] = MathUtil.clip(q0n, 0, 255);
        }
    }
}

