/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264;

import java.nio.ByteBuffer;
import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.decode.CoeffTransformer;
import org.jcodec.codecs.h264.encode.DumbRateControl;
import org.jcodec.codecs.h264.encode.RateControl;
import org.jcodec.codecs.h264.io.CAVLC;
import org.jcodec.codecs.h264.io.model.MBType;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.RefPicMarkingIDR;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.codecs.h264.io.write.CAVLCWriter;
import org.jcodec.codecs.h264.io.write.SliceHeaderWriter;
import org.jcodec.common.ArrayUtil;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Size;
import org.jcodec.common.tools.MathUtil;

public class H264Encoder
implements VideoEncoder {
    private CAVLC[] cavlc;
    private int[][] leftRow;
    private int[][] topLine;
    private RateControl rc;

    public H264Encoder() {
        this(new DumbRateControl());
    }

    public H264Encoder(RateControl rc) {
        this.rc = rc;
    }

    @Override
    public ByteBuffer encodeFrame(Picture pic, ByteBuffer _out) {
        return this.encodeFrame(pic, _out, true, 0);
    }

    public ByteBuffer encodeFrame(Picture pic, ByteBuffer _out, boolean idr, int poc) {
        ByteBuffer dup = _out.duplicate();
        SeqParameterSet sps = this.initSPS(new Size(pic.getCroppedWidth(), pic.getCroppedHeight()));
        PictureParameterSet pps = this.initPPS();
        if (idr) {
            dup.putInt(1);
            new NALUnit(NALUnitType.SPS, 3).write(dup);
            this.writeSPS(dup, sps);
            dup.putInt(1);
            new NALUnit(NALUnitType.PPS, 3).write(dup);
            this.writePPS(dup, pps);
        }
        int mbWidth = sps.pic_width_in_mbs_minus1 + 1;
        this.leftRow = new int[][]{new int[16], new int[8], new int[8]};
        this.topLine = new int[][]{new int[mbWidth << 4], new int[mbWidth << 3], new int[mbWidth << 3]};
        this.encodeSlice(sps, pps, pic, dup, idr, poc);
        dup.flip();
        return dup;
    }

    private void writePPS(ByteBuffer dup, PictureParameterSet pps) {
        ByteBuffer tmp = ByteBuffer.allocate(1024);
        pps.write(tmp);
        tmp.flip();
        H264Utils.escapeNAL(tmp, dup);
    }

    private void writeSPS(ByteBuffer dup, SeqParameterSet sps) {
        ByteBuffer tmp = ByteBuffer.allocate(1024);
        sps.write(tmp);
        tmp.flip();
        H264Utils.escapeNAL(tmp, dup);
    }

    public PictureParameterSet initPPS() {
        PictureParameterSet pps = new PictureParameterSet();
        pps.pic_init_qp_minus26 = this.rc.getInitQp() - 26;
        return pps;
    }

    public SeqParameterSet initSPS(Size sz) {
        SeqParameterSet sps = new SeqParameterSet();
        sps.pic_width_in_mbs_minus1 = (sz.getWidth() + 15 >> 4) - 1;
        sps.pic_height_in_map_units_minus1 = (sz.getHeight() + 15 >> 4) - 1;
        sps.chroma_format_idc = ColorSpace.YUV420;
        sps.profile_idc = 66;
        sps.level_idc = 40;
        sps.frame_mbs_only_flag = true;
        int codedWidth = sps.pic_width_in_mbs_minus1 + 1 << 4;
        int codedHeight = sps.pic_height_in_map_units_minus1 + 1 << 4;
        sps.frame_cropping_flag = codedWidth != sz.getWidth() || codedHeight != sz.getHeight();
        sps.frame_crop_right_offset = codedWidth - sz.getWidth() + 1 >> 1;
        sps.frame_crop_bottom_offset = codedHeight - sz.getHeight() + 1 >> 1;
        return sps;
    }

    private void encodeSlice(SeqParameterSet sps, PictureParameterSet pps, Picture pic, ByteBuffer dup, boolean idr, int poc) {
        this.cavlc = new CAVLC[]{new CAVLC(sps, pps, 2, 2), new CAVLC(sps, pps, 1, 1), new CAVLC(sps, pps, 1, 1)};
        this.rc.reset();
        int qp = this.rc.getInitQp();
        dup.putInt(1);
        new NALUnit(idr ? NALUnitType.IDR_SLICE : NALUnitType.NON_IDR_SLICE, 2).write(dup);
        SliceHeader sh = new SliceHeader();
        sh.slice_type = SliceType.I;
        if (idr) {
            sh.refPicMarkingIDR = new RefPicMarkingIDR(false, false);
        }
        sh.pps = pps;
        sh.sps = sps;
        sh.pic_order_cnt_lsb = poc << 1;
        ByteBuffer buf = ByteBuffer.allocate(pic.getWidth() * pic.getHeight());
        BitWriter sliceData = new BitWriter(buf);
        new SliceHeaderWriter().write(sh, idr, 2, sliceData);
        Picture outMB = Picture.create(16, 16, ColorSpace.YUV420);
        for (int mbY = 0; mbY < sps.pic_height_in_map_units_minus1 + 1; ++mbY) {
            for (int mbX = 0; mbX < sps.pic_width_in_mbs_minus1 + 1; ++mbX) {
                int qpDelta;
                BitWriter candidate;
                CAVLCWriter.writeUE(sliceData, 23);
                do {
                    candidate = sliceData.fork();
                    qpDelta = this.rc.getQpDelta();
                    this.encodeMacroblock(pic, mbX, mbY, candidate, outMB, qp + qpDelta, qpDelta);
                } while (!this.rc.accept(candidate.position() - sliceData.position()));
                sliceData = candidate;
                qp += qpDelta;
                this.collectPredictors(outMB, mbX);
            }
        }
        sliceData.write1Bit(1);
        sliceData.flush();
        buf = sliceData.getBuffer();
        buf.flip();
        H264Utils.escapeNAL(buf, dup);
    }

    private void collectPredictors(Picture outMB, int mbX) {
        System.arraycopy(outMB.getPlaneData(0), 240, this.topLine[0], mbX << 4, 16);
        System.arraycopy(outMB.getPlaneData(1), 56, this.topLine[1], mbX << 3, 8);
        System.arraycopy(outMB.getPlaneData(2), 56, this.topLine[2], mbX << 3, 8);
        this.copyCol(outMB.getPlaneData(0), 15, 16, this.leftRow[0]);
        this.copyCol(outMB.getPlaneData(1), 7, 8, this.leftRow[1]);
        this.copyCol(outMB.getPlaneData(2), 7, 8, this.leftRow[2]);
    }

    private void copyCol(int[] planeData, int off, int stride, int[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = planeData[off];
            off += stride;
        }
    }

    private void encodeMacroblock(Picture pic, int mbX, int mbY, BitWriter out, Picture outMB, int qp, int qpDelta) {
        CAVLCWriter.writeUE(out, 0);
        CAVLCWriter.writeSE(out, qpDelta);
        this.luma(pic, mbX, mbY, out, qp, outMB);
        this.chroma(pic, mbX, mbY, out, qp, outMB);
    }

    private void chroma(Picture pic, int mbX, int mbY, BitWriter out, int qp, Picture outMB) {
        int cw = pic.getColor().compWidth[1];
        int ch = pic.getColor().compHeight[1];
        int x = mbX << 4 - cw;
        int y = mbY << 4 - ch;
        int[][] ac1 = this.transformChroma(pic, 1, qp, cw, ch, x, y, outMB);
        int[][] ac2 = this.transformChroma(pic, 2, qp, cw, ch, x, y, outMB);
        int[] dc1 = this.extractDC(ac1);
        int[] dc2 = this.extractDC(ac2);
        this.writeDC(1, mbX, mbY, out, qp, mbX << 1, mbY << 1, dc1);
        this.writeDC(2, mbX, mbY, out, qp, mbX << 1, mbY << 1, dc2);
        this.writeAC(1, mbX, mbY, out, mbX << 1, mbY << 1, ac1, qp);
        this.writeAC(2, mbX, mbY, out, mbX << 1, mbY << 1, ac2, qp);
        this.restorePlane(dc1, ac1, qp);
        this.putChroma(outMB.getData()[1], 1, x, y, ac1);
        this.restorePlane(dc2, ac2, qp);
        this.putChroma(outMB.getData()[2], 2, x, y, ac2);
    }

    private void luma(Picture pic, int mbX, int mbY, BitWriter out, int qp, Picture outMB) {
        int x = mbX << 4;
        int y = mbY << 4;
        int[][] ac = this.transform(pic, 0, qp, 0, 0, x, y);
        int[] dc = this.extractDC(ac);
        this.writeDC(0, mbX, mbY, out, qp, mbX << 2, mbY << 2, dc);
        this.writeAC(0, mbX, mbY, out, mbX << 2, mbY << 2, ac, qp);
        this.restorePlane(dc, ac, qp);
        this.putLuma(outMB.getPlaneData(0), this.lumaDCPred(x, y), ac, 4);
    }

    private void putChroma(int[] mb, int comp, int x, int y, int[][] ac) {
        this.putBlk(mb, this.chromaPredBlk0(comp, x, y), ac[0], 3, 0, 0);
        this.putBlk(mb, this.chromaPredBlk1(comp, x, y), ac[1], 3, 4, 0);
        this.putBlk(mb, this.chromaPredBlk2(comp, x, y), ac[2], 3, 0, 4);
        this.putBlk(mb, this.chromaPredBlk3(comp, x, y), ac[3], 3, 4, 4);
    }

    private void putLuma(int[] planeData, int pred, int[][] ac, int log2stride) {
        for (int blk = 0; blk < ac.length; ++blk) {
            this.putBlk(planeData, pred, ac[blk], log2stride, H264Const.BLK_X[blk], H264Const.BLK_Y[blk]);
        }
    }

    private void putBlk(int[] planeData, int pred, int[] block, int log2stride, int blkX, int blkY) {
        int stride = 1 << log2stride;
        int srcOff = 0;
        int dstOff = (blkY << log2stride) + blkX;
        for (int line = 0; line < 4; ++line) {
            planeData[dstOff] = MathUtil.clip(block[srcOff] + pred, 0, 255);
            planeData[dstOff + 1] = MathUtil.clip(block[srcOff + 1] + pred, 0, 255);
            planeData[dstOff + 2] = MathUtil.clip(block[srcOff + 2] + pred, 0, 255);
            planeData[dstOff + 3] = MathUtil.clip(block[srcOff + 3] + pred, 0, 255);
            srcOff += 4;
            dstOff += stride;
        }
    }

    private void restorePlane(int[] dc, int[][] ac, int qp) {
        if (dc.length == 4) {
            CoeffTransformer.invDC2x2(dc);
            CoeffTransformer.dequantizeDC2x2(dc, qp);
        } else if (dc.length == 8) {
            CoeffTransformer.invDC4x2(dc);
            CoeffTransformer.dequantizeDC4x2(dc, qp);
        } else {
            CoeffTransformer.invDC4x4(dc);
            CoeffTransformer.dequantizeDC4x4(dc, qp);
            CoeffTransformer.reorderDC4x4(dc);
        }
        for (int i = 0; i < ac.length; ++i) {
            CoeffTransformer.dequantizeAC(ac[i], qp);
            ac[i][0] = dc[i];
            CoeffTransformer.idct4x4(ac[i]);
        }
    }

    private int[] extractDC(int[][] ac) {
        int[] dc = new int[ac.length];
        for (int i = 0; i < ac.length; ++i) {
            dc[i] = ac[i][0];
            ac[i][0] = 0;
        }
        return dc;
    }

    private void writeAC(int comp, int mbX, int mbY, BitWriter out, int mbLeftBlk, int mbTopBlk, int[][] ac, int qp) {
        for (int i = 0; i < ac.length; ++i) {
            CoeffTransformer.quantizeAC(ac[i], qp);
            this.cavlc[comp].writeACBlock(out, mbLeftBlk + H264Const.MB_BLK_OFF_LEFT[i], mbTopBlk + H264Const.MB_BLK_OFF_TOP[i], MBType.I_16x16, MBType.I_16x16, ac[i], H264Const.totalZeros16, 1, 15, CoeffTransformer.zigzag4x4);
        }
    }

    private void writeDC(int comp, int mbX, int mbY, BitWriter out, int qp, int mbLeftBlk, int mbTopBlk, int[] dc) {
        if (dc.length == 4) {
            CoeffTransformer.quantizeDC2x2(dc, qp);
            CoeffTransformer.fvdDC2x2(dc);
            this.cavlc[comp].writeChrDCBlock(out, dc, H264Const.totalZeros4, 0, dc.length, new int[]{0, 1, 2, 3});
        } else if (dc.length == 8) {
            CoeffTransformer.quantizeDC4x2(dc, qp);
            CoeffTransformer.fvdDC4x2(dc);
            this.cavlc[comp].writeChrDCBlock(out, dc, H264Const.totalZeros8, 0, dc.length, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        } else {
            CoeffTransformer.reorderDC4x4(dc);
            CoeffTransformer.quantizeDC4x4(dc, qp);
            CoeffTransformer.fvdDC4x4(dc);
            this.cavlc[comp].writeLumaDCBlock(out, mbLeftBlk, mbTopBlk, MBType.I_16x16, MBType.I_16x16, dc, H264Const.totalZeros16, 0, 16, CoeffTransformer.zigzag4x4);
        }
    }

    private int[][] transformChroma(Picture pic, int comp, int qp, int cw, int ch, int x, int y, Picture outMB) {
        int[][] ac = new int[16 >> cw + ch][16];
        this.takeSubtract(pic.getPlaneData(comp), pic.getPlaneWidth(comp), pic.getPlaneHeight(comp), x, y, ac[0], this.chromaPredBlk0(comp, x, y));
        CoeffTransformer.fdct4x4(ac[0]);
        this.takeSubtract(pic.getPlaneData(comp), pic.getPlaneWidth(comp), pic.getPlaneHeight(comp), x + 4, y, ac[1], this.chromaPredBlk1(comp, x, y));
        CoeffTransformer.fdct4x4(ac[1]);
        this.takeSubtract(pic.getPlaneData(comp), pic.getPlaneWidth(comp), pic.getPlaneHeight(comp), x, y + 4, ac[2], this.chromaPredBlk2(comp, x, y));
        CoeffTransformer.fdct4x4(ac[2]);
        this.takeSubtract(pic.getPlaneData(comp), pic.getPlaneWidth(comp), pic.getPlaneHeight(comp), x + 4, y + 4, ac[3], this.chromaPredBlk3(comp, x, y));
        CoeffTransformer.fdct4x4(ac[3]);
        return ac;
    }

    private final int chromaPredOne(int[] pix, int x) {
        return pix[x] + pix[x + 1] + pix[x + 2] + pix[x + 3] + 2 >> 2;
    }

    private final int chromaPredTwo(int[] pix1, int[] pix2, int x, int y) {
        return pix1[x] + pix1[x + 1] + pix1[x + 2] + pix1[x + 3] + pix2[y] + pix2[y + 1] + pix2[y + 2] + pix2[y + 3] + 4 >> 3;
    }

    private int chromaPredBlk0(int comp, int x, int y) {
        int predY = y & 7;
        if (x != 0 && y != 0) {
            return this.chromaPredTwo(this.leftRow[comp], this.topLine[comp], predY, x);
        }
        if (x != 0) {
            return this.chromaPredOne(this.leftRow[comp], predY);
        }
        if (y != 0) {
            return this.chromaPredOne(this.topLine[comp], x);
        }
        return 128;
    }

    private int chromaPredBlk1(int comp, int x, int y) {
        int predY = y & 7;
        if (y != 0) {
            return this.chromaPredOne(this.topLine[comp], x + 4);
        }
        if (x != 0) {
            return this.chromaPredOne(this.leftRow[comp], predY);
        }
        return 128;
    }

    private int chromaPredBlk2(int comp, int x, int y) {
        int predY = y & 7;
        if (x != 0) {
            return this.chromaPredOne(this.leftRow[comp], predY + 4);
        }
        if (y != 0) {
            return this.chromaPredOne(this.topLine[comp], x);
        }
        return 128;
    }

    private int chromaPredBlk3(int comp, int x, int y) {
        int predY = y & 7;
        if (x != 0 && y != 0) {
            return this.chromaPredTwo(this.leftRow[comp], this.topLine[comp], predY + 4, x + 4);
        }
        if (x != 0) {
            return this.chromaPredOne(this.leftRow[comp], predY + 4);
        }
        if (y != 0) {
            return this.chromaPredOne(this.topLine[comp], x + 4);
        }
        return 128;
    }

    private int lumaDCPred(int x, int y) {
        if (x == 0 && y == 0) {
            return 128;
        }
        if (y == 0) {
            return ArrayUtil.sum(this.leftRow[0]) + 8 >> 4;
        }
        if (x == 0) {
            return ArrayUtil.sum(this.topLine[0], x, 16) + 8 >> 4;
        }
        return ArrayUtil.sum(this.leftRow[0]) + ArrayUtil.sum(this.topLine[0], x, 16) + 16 >> 5;
    }

    private int[][] transform(Picture pic, int comp, int qp, int cw, int ch, int x, int y) {
        int dcc = this.lumaDCPred(x, y);
        int[][] ac = new int[16 >> cw + ch][16];
        for (int i = 0; i < ac.length; ++i) {
            int[] coeff = ac[i];
            this.takeSubtract(pic.getPlaneData(comp), pic.getPlaneWidth(comp), pic.getPlaneHeight(comp), x + H264Const.BLK_X[i], y + H264Const.BLK_Y[i], coeff, dcc);
            CoeffTransformer.fdct4x4(coeff);
        }
        return ac;
    }

    private final void takeSubtract(int[] planeData, int planeWidth, int planeHeight, int x, int y, int[] coeff, int dc) {
        if (x + 4 < planeWidth && y + 4 < planeHeight) {
            this.takeSubtractSafe(planeData, planeWidth, planeHeight, x, y, coeff, dc);
        } else {
            this.takeSubtractUnsafe(planeData, planeWidth, planeHeight, x, y, coeff, dc);
        }
    }

    private final void takeSubtractSafe(int[] planeData, int planeWidth, int planeHeight, int x, int y, int[] coeff, int dc) {
        int i = 0;
        int srcOff = y * planeWidth + x;
        int dstOff = 0;
        while (i < 4) {
            coeff[dstOff] = planeData[srcOff] - dc;
            coeff[dstOff + 1] = planeData[srcOff + 1] - dc;
            coeff[dstOff + 2] = planeData[srcOff + 2] - dc;
            coeff[dstOff + 3] = planeData[srcOff + 3] - dc;
            ++i;
            srcOff += planeWidth;
            dstOff += 4;
        }
    }

    private final void takeSubtractUnsafe(int[] planeData, int planeWidth, int planeHeight, int x, int y, int[] coeff, int dc) {
        int j;
        int off;
        int i;
        int outOff = 0;
        for (i = y; i < Math.min(y + 4, planeHeight); ++i) {
            off = i * planeWidth + Math.min(x, planeWidth);
            for (j = x; j < Math.min(x + 4, planeWidth); ++j) {
                coeff[outOff++] = planeData[off++] - dc;
            }
            --off;
            while (j < x + 4) {
                coeff[outOff++] = planeData[off] - dc;
                ++j;
            }
        }
        while (i < y + 4) {
            off = planeHeight * planeWidth - planeWidth + Math.min(x, planeWidth);
            for (j = x; j < Math.min(x + 4, planeWidth); ++j) {
                coeff[outOff++] = planeData[off++] - dc;
            }
            --off;
            while (j < x + 4) {
                coeff[outOff++] = planeData[off] - dc;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public ColorSpace[] getSupportedColorSpaces() {
        return new ColorSpace[]{ColorSpace.YUV420J};
    }
}

