/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.voronoi;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.utils.Polyside;

public class ThiessenPolygon {
    final boolean open;
    private final Vertex vertex;
    final IQuadEdge[] edges;
    final double area;
    final Rectangle2D bounds;

    public ThiessenPolygon(Vertex vertex, List<IQuadEdge> edgeList, boolean open) {
        this.vertex = vertex;
        this.edges = edgeList.toArray(new IQuadEdge[edgeList.size()]);
        this.open = open;
        Vertex v = edgeList.get(0).getA();
        this.bounds = new Rectangle2D.Double(v.getX(), v.getY(), 0.0, 0.0);
        double s = 0.0;
        for (IQuadEdge e : edgeList) {
            Vertex A = e.getA();
            Vertex B = e.getB();
            s += A.getX() * B.getY() - A.getY() * B.getX();
            this.bounds.add(B.getX(), B.getY());
        }
        this.area = s / 2.0;
    }

    public List<IQuadEdge> getEdges() {
        return Arrays.asList(this.edges);
    }

    public double getArea() {
        return this.area;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public boolean isPointInPolygon(double x, double y) {
        List<IQuadEdge> edgeList = Arrays.asList(this.edges);
        Polyside.Result result = Polyside.isPointInPolygon(edgeList, x, y);
        return result.isCovered();
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getIndex() {
        return this.vertex.getIndex();
    }

    public String toString() {
        return String.format("ThiessenPolygon vertex=%s", this.vertex.getLabel());
    }
}

