/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;
import org.la4j.vector.functor.VectorAccumulator;
import org.la4j.vector.functor.VectorFunction;
import org.la4j.vector.functor.VectorPredicate;
import org.la4j.vector.functor.VectorProcedure;

public abstract class AbstractSafeVector
implements Vector {
    protected Vector self;
    protected Factory factory;

    public AbstractSafeVector(Vector vector) {
        this.self = vector;
        this.factory = vector.factory().safe();
    }

    @Override
    public double get(int i) {
        this.ensureIndexInLength(i);
        return this.self.get(i);
    }

    @Override
    public void set(int i, double value) {
        this.ensureIndexInLength(i);
        this.self.set(i, value);
    }

    @Override
    public void assign(double value) {
        this.self.assign(value);
    }

    @Override
    public int length() {
        return this.self.length();
    }

    @Override
    public Vector add(double value) {
        return this.self.add(value, this.factory);
    }

    @Override
    public Vector add(double value, Factory factory) {
        return this.self.add(value, factory);
    }

    @Override
    public Vector add(Vector vector) {
        return this.self.add(vector, this.factory);
    }

    @Override
    public Vector add(Vector vector, Factory factory) {
        return this.self.add(vector, factory);
    }

    @Override
    public Vector multiply(double value) {
        return this.self.multiply(value, this.factory);
    }

    @Override
    public Vector multiply(double value, Factory factory) {
        return this.self.multiply(value, factory);
    }

    @Override
    public Vector multiply(Vector vector) {
        return this.self.multiply(vector, this.factory);
    }

    @Override
    public Vector multiply(Vector vector, Factory factory) {
        return this.self.multiply(vector, factory);
    }

    @Override
    public Vector multiply(Matrix matrix) {
        return this.self.multiply(matrix, this.factory);
    }

    @Override
    public Vector multiply(Matrix matrix, Factory factory) {
        return this.self.multiply(matrix, factory);
    }

    @Override
    public Vector subtract(double value) {
        return this.self.subtract(value, this.factory);
    }

    @Override
    public Vector subtract(double value, Factory factory) {
        return this.self.subtract(value, factory);
    }

    @Override
    public Vector subtract(Vector vector) {
        return this.self.subtract(vector, this.factory);
    }

    @Override
    public Vector subtract(Vector vector, Factory factory) {
        return this.self.subtract(vector, factory);
    }

    @Override
    public Vector divide(double value) {
        return this.self.divide(value, this.factory);
    }

    @Override
    public Vector divide(double value, Factory factory) {
        return this.self.divide(value, factory);
    }

    @Override
    public double product(Vector vector) {
        return this.self.product(vector);
    }

    @Override
    public double norm() {
        return this.self.norm();
    }

    @Override
    public Vector normalize() {
        return this.self.normalize(this.factory);
    }

    @Override
    public Vector normalize(Factory factory) {
        return this.self.normalize(factory);
    }

    @Override
    public void swap(int i, int j) {
        this.ensureIndexInLength(i);
        this.ensureIndexInLength(j);
        this.self.swap(i, j);
    }

    @Override
    public Vector blank() {
        return this.self.blank(this.factory);
    }

    @Override
    public Vector blank(Factory factory) {
        return this.self.blank(factory);
    }

    @Override
    public Vector copy() {
        return this.self.copy(this.factory);
    }

    @Override
    public Vector copy(Factory factory) {
        return this.self.copy(factory);
    }

    @Override
    public Vector resize(int length) {
        return this.self.resize(length, this.factory);
    }

    @Override
    public Vector resize(int length, Factory factory) {
        return this.self.resize(length, factory);
    }

    @Override
    public Vector sliceLeft(int until) {
        return this.self.sliceLeft(until, this.factory);
    }

    @Override
    public Vector sliceLeft(int until, Factory factory) {
        return this.self.sliceLeft(until, factory);
    }

    @Override
    public Vector sliceRight(int from) {
        return this.self.sliceRight(from, this.factory);
    }

    @Override
    public Vector sliceRight(int from, Factory factory) {
        return this.self.sliceRight(from, factory);
    }

    @Override
    public Vector slice(int from, int until) {
        return this.self.slice(from, until, this.factory);
    }

    @Override
    public Vector slice(int from, int until, Factory factory) {
        return this.self.slice(from, until, factory);
    }

    @Override
    public Factory factory() {
        return this.factory;
    }

    @Override
    public void each(VectorProcedure procedure) {
        this.self.each(procedure);
    }

    @Override
    public Vector transform(VectorFunction function) {
        return this.self.transform(function, this.factory);
    }

    @Override
    public Vector transform(VectorFunction function, Factory factory) {
        return this.self.transform(function, factory);
    }

    @Override
    public Vector transform(int i, VectorFunction function) {
        return this.self.transform(i, function, this.factory);
    }

    @Override
    public Vector transform(int i, VectorFunction function, Factory factory) {
        return this.self.transform(i, function, factory);
    }

    @Override
    public void update(VectorFunction function) {
        this.self.update(function);
    }

    @Override
    public void update(int i, VectorFunction function) {
        this.self.update(i, function);
    }

    @Override
    public double fold(VectorAccumulator accumulator) {
        return this.self.fold(accumulator);
    }

    @Override
    public boolean is(VectorPredicate predicate) {
        return this.self.is(predicate);
    }

    @Override
    public Vector safe() {
        return this;
    }

    @Override
    public Vector unsafe() {
        return this.self;
    }

    public boolean equals(Object obj) {
        return this.self.equals(obj);
    }

    public int hashCode() {
        return this.self.hashCode();
    }

    public String toString() {
        return this.self.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.self.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.self.writeExternal(out);
    }

    protected void ensureIndexInLength(int i) {
        if (i >= this.self.length() || i < 0) {
            throw new IllegalArgumentException("Index out of bounds: " + i);
        }
    }
}

