/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;

public class EigenDecompositor
implements MatrixDecompositor {
    public static final int MAX_ITERATIONS = 10000000;

    @Override
    public Matrix[] decompose(Matrix matrix, Factory factory) {
        if (matrix.is(Matrices.SYMMETRIC_MATRIX)) {
            return this.decomposeSymmetricMatrix(matrix, factory);
        }
        if (matrix.rows() == matrix.columns()) {
            return this.decomposeNonSymmetricMatrix(matrix, factory);
        }
        throw new IllegalArgumentException("Can't decompose rectangle matrix");
    }

    private Matrix[] decomposeSymmetricMatrix(Matrix matrix, Factory factory) {
        Matrix d = matrix.copy();
        Vector r = this.generateR(d, factory);
        Matrix v = factory.createIdentityMatrix(matrix.rows());
        int iteration = 0;
        do {
            int k = this.findMax(r, -1);
            int l = this.findMax(d.getRow(k), k);
            Matrix u = this.generateU(d, factory, k, l);
            v = v.multiply(u);
            d = u.transpose().multiply(d.multiply(u));
            r.set(k, this.generateRi(d.getRow(k), k));
            r.set(l, this.generateRi(d.getRow(l), l));
        } while (r.norm() > Matrices.EPS && ++iteration < 10000000);
        if (iteration > 10000000) {
            throw new IllegalArgumentException("Can't decompose this matrix.");
        }
        return new Matrix[]{v, d};
    }

    private int findMax(Vector vector, int exl) {
        int result = exl == 0 ? 1 : 0;
        for (int i = 0; i < vector.length(); ++i) {
            if (i == exl || !(Math.abs(vector.get(result)) < Math.abs(vector.get(i)))) continue;
            result = i;
        }
        return result;
    }

    private Vector generateR(Matrix matrix, Factory factory) {
        Vector result = factory.createVector(matrix.rows());
        for (int i = 0; i < matrix.rows(); ++i) {
            result.set(i, this.generateRi(matrix.getRow(i), i));
        }
        return result;
    }

    private double generateRi(Vector vector, int position) {
        double summand = 0.0;
        for (int i = 0; i < vector.length(); ++i) {
            if (i == position) continue;
            summand += vector.get(i) * vector.get(i);
        }
        return summand;
    }

    private Matrix generateU(Matrix matrix, Factory factory, int k, int l) {
        Matrix result = factory.createIdentityMatrix(matrix.rows());
        double alpha = 0.0;
        double beta = 0.0;
        if (matrix.get(k, k) - matrix.get(l, l) < Matrices.EPS) {
            alpha = beta = Math.sqrt(0.5);
        } else {
            double mu = 2.0 * matrix.get(k, l) / (matrix.get(k, k) - matrix.get(l, l));
            mu = 1.0 / Math.sqrt(1.0 + mu * mu);
            alpha = Math.sqrt(0.5 * (1.0 + mu));
            beta = Math.signum(mu) * Math.sqrt(0.5 * (1.0 - mu));
        }
        result.set(k, k, alpha);
        result.set(l, l, alpha);
        result.set(k, l, -beta);
        result.set(l, k, beta);
        return result;
    }

    private Matrix[] decomposeNonSymmetricMatrix(Matrix matrix, Factory factory) {
        Matrix A = matrix.copy();
        int n = matrix.columns();
        Matrix v = factory.createIdentityMatrix(n);
        Vector d = factory.createVector(n);
        Vector e = factory.createVector(n);
        Matrix h = A.copy();
        Vector ort = factory.createVector(n);
        this.orthes(h, v, ort);
        this.hqr2(h, v, d, e);
        Matrix dd = factory.createMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dd.set(i, j, 0.0);
            }
            dd.set(i, i, d.get(i));
            if (e.get(i) > 0.0) {
                dd.set(i, i + 1, e.get(i));
                continue;
            }
            if (!(e.get(i) < 0.0)) continue;
            dd.set(i, i - 1, e.get(i));
        }
        return new Matrix[]{v, dd};
    }

    private void orthes(Matrix h, Matrix v, Vector ort) {
        int m;
        int n = ort.length();
        int low = 0;
        int high = n - 1;
        for (m = low + 1; m <= high - 1; ++m) {
            double f;
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(h.get(i, m - 1));
            }
            if (scale == 0.0) continue;
            double hh = 0.0;
            for (int i = high; i >= m; --i) {
                ort.set(i, h.get(i, m - 1) / scale);
                hh += ort.get(i) * ort.get(i);
            }
            double g = Math.sqrt(hh);
            if (ort.get(m) > Matrices.EPS) {
                g = -g;
            }
            hh -= ort.get(m) * g;
            ort.update(m, Vectors.asMinusFunction(g));
            for (int j = m; j < n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m; --i) {
                    f += ort.get(i) * h.get(i, j);
                }
                f /= hh;
                for (i = m; i <= high; ++i) {
                    h.update(i, j, Matrices.asMinusFunction(f * ort.get(i)));
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += ort.get(j) * h.get(i, j);
                }
                f /= hh;
                for (j = m; j <= high; ++j) {
                    h.update(i, j, Matrices.asMinusFunction(f * ort.get(j)));
                }
            }
            ort.set(m, scale * ort.get(m));
            h.set(m, m - 1, scale * g);
        }
        for (m = high - 1; m >= low + 1; --m) {
            if (!(Math.abs(h.get(m, m - 1)) > Matrices.EPS)) continue;
            for (int i = m + 1; i <= high; ++i) {
                ort.set(i, h.get(i, m - 1));
            }
            for (int j = m; j <= high; ++j) {
                int i;
                double g = 0.0;
                for (i = m; i <= high; ++i) {
                    g += ort.get(i) * v.get(i, j);
                }
                g = g / ort.get(m) / h.get(m, m - 1);
                for (i = m; i <= high; ++i) {
                    v.update(i, j, Matrices.asPlusFunction(g * ort.get(i)));
                }
            }
        }
    }

    private void hqr2(Matrix H, Matrix V, Vector d, Vector e) {
        double y;
        int i;
        int j;
        double x;
        double w;
        int l;
        int j2;
        int nn = e.length();
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = 0.0;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < low | i2 > high) {
                d.set(i2, H.get(i2, i2));
                e.set(i2, 0.0);
            }
            for (j2 = Math.max(i2 - 1, 0); j2 < nn; ++j2) {
                norm += Math.abs(H.get(i2, j2));
            }
        }
        int iter = 0;
        while (n >= low) {
            int m;
            for (l = n; l > low; --l) {
                s = Math.abs(H.get(l - 1, l - 1)) + Math.abs(H.get(l, l));
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(H.get(l, l - 1)) < eps * s) break;
            }
            if (l == n) {
                H.update(n, n, Matrices.asPlusFunction(exshift));
                d.set(n, H.get(n, n));
                e.set(n, 0.0);
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = H.get(n, n - 1) * H.get(n - 1, n);
                p = (H.get(n - 1, n - 1) - H.get(n, n)) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                H.update(n, n, Matrices.asPlusFunction(exshift));
                H.update(n - 1, n - 1, Matrices.asPlusFunction(exshift));
                x = H.get(n, n);
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    d.set(n - 1, x + z);
                    d.set(n, d.get(n - 1));
                    if (z != 0.0) {
                        d.set(n, x - w / z);
                    }
                    e.set(n - 1, 0.0);
                    e.set(n, 0.0);
                    x = H.get(n, n - 1);
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = H.get(n - 1, j);
                        H.set(n - 1, j, q * z + p * H.get(n, j));
                        H.set(n, j, q * H.get(n, j) - p * z);
                    }
                    for (i = 0; i <= n; ++i) {
                        z = H.get(i, n - 1);
                        H.set(i, n - 1, q * z + p * H.get(i, n));
                        H.set(i, n, q * H.get(i, n) - p * z);
                    }
                    for (i = low; i <= high; ++i) {
                        z = V.get(i, n - 1);
                        V.set(i, n - 1, q * z + p * V.get(i, n));
                        V.set(i, n, q * V.get(i, n) - p * z);
                    }
                } else {
                    d.set(n - 1, x + p);
                    d.set(n, x + p);
                    e.set(n - 1, z);
                    e.set(n, -z);
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = H.get(n, n);
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = H.get(n - 1, n - 1);
                w = H.get(n, n - 1) * H.get(n - 1, n);
            }
            if (iter == 10) {
                exshift += x;
                for (i = low; i <= n; ++i) {
                    H.update(i, i, Matrices.asMinusFunction(x));
                }
                s = Math.abs(H.get(n, n - 1)) + Math.abs(H.get(n - 1, n - 2));
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    for (i = low; i <= n; ++i) {
                        H.update(i, i, Matrices.asMinusFunction(s));
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = H.get(m, m);
                r = x - z;
                s = y - z;
                p = (r * s - w) / H.get(m + 1, m) + H.get(m, m + 1);
                q = H.get(m + 1, m + 1) - z - r - s;
                r = H.get(m + 2, m + 1);
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(H.get(m, m - 1)) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(H.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(H.get(m + 1, m + 1))))) break;
            }
            for (int i3 = m + 2; i3 <= n; ++i3) {
                H.set(i3, i3 - 2, 0.0);
                if (i3 <= m + 2) continue;
                H.set(i3, i3 - 3, 0.0);
            }
            for (int k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = H.get(k, k - 1);
                    q = H.get(k + 1, k - 1);
                    r = notlast ? H.get(k + 2, k - 1) : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x == 0.0) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    H.set(k, k - 1, -s * x);
                } else if (l != m) {
                    H.update(k, k - 1, Matrices.INV_FUNCTION);
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < nn; ++j3) {
                    p = H.get(k, j3) + q * H.get(k + 1, j3);
                    if (notlast) {
                        H.update(k + 2, j3, Matrices.asMinusFunction((p += r * H.get(k + 2, j3)) * z));
                    }
                    H.update(k, j3, Matrices.asMinusFunction(p * x));
                    H.update(k + 1, j3, Matrices.asMinusFunction(p * y));
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * H.get(i4, k) + y * H.get(i4, k + 1);
                    if (notlast) {
                        H.update(i4, k + 2, Matrices.asMinusFunction((p += z * H.get(i4, k + 2)) * r));
                    }
                    H.update(i4, k, Matrices.asMinusFunction(p));
                    H.update(i4, k + 1, Matrices.asMinusFunction(p * q));
                }
                for (i4 = low; i4 <= high; ++i4) {
                    p = x * V.get(i4, k) + y * V.get(i4, k + 1);
                    if (notlast) {
                        V.update(i4, k + 2, Matrices.asMinusFunction((p += z * V.get(i4, k + 2)) * r));
                    }
                    V.update(i4, k, Matrices.asMinusFunction(p));
                    V.update(i4, k + 1, Matrices.asMinusFunction(p * q));
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = d.get(n);
            q = e.get(n);
            if (q == 0.0) {
                l = n;
                H.set(n, n, 1.0);
                for (i = n - 1; i >= 0; --i) {
                    int j4;
                    w = H.get(i, i) - p;
                    r = 0.0;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += H.get(i, j4) * H.get(j4, n);
                    }
                    if (e.get(i) < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (e.get(i) == 0.0) {
                        if (w != 0.0) {
                            H.set(i, n, -r / w);
                        } else {
                            H.set(i, n, -r / (eps * norm));
                        }
                    } else {
                        x = H.get(i, i + 1);
                        y = H.get(i + 1, i);
                        q = (d.get(i) - p) * (d.get(i) - p) + e.get(i) * e.get(i);
                        t = (x * s - z * r) / q;
                        H.set(i, n, t);
                        if (Math.abs(x) > Math.abs(z)) {
                            H.set(i + 1, n, (-r - w * t) / x);
                        } else {
                            H.set(i + 1, n, (-s - y * t) / z);
                        }
                    }
                    t = Math.abs(H.get(i, n));
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i; j4 <= n; ++j4) {
                        H.update(j4, n, Matrices.asDivFunction(t));
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(H.get(n, n - 1)) > Math.abs(H.get(n - 1, n))) {
                H.set(n - 1, n - 1, q / H.get(n, n - 1));
                H.set(n - 1, n, -(H.get(n, n) - p) / H.get(n, n - 1));
            } else {
                double[] cdiv = this.cdiv(0.0, -H.get(n - 1, n), H.get(n - 1, n - 1) - p, q);
                H.set(n - 1, n - 1, cdiv[0]);
                H.set(n - 1, n, cdiv[1]);
            }
            H.set(n, n - 1, 0.0);
            H.set(n, n, 1.0);
            for (i = n - 2; i >= 0; --i) {
                double[] cdiv;
                double ra = 0.0;
                double sa = 0.0;
                for (int j5 = l; j5 <= n; ++j5) {
                    ra += H.get(i, j5) * H.get(j5, n - 1);
                    sa += H.get(i, j5) * H.get(j5, n);
                }
                w = H.get(i, i) - p;
                if (e.get(i) < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (e.get(i) == 0.0) {
                    cdiv = this.cdiv(-ra, -sa, w, q);
                    H.set(i, n - 1, cdiv[0]);
                    H.set(i, n, cdiv[1]);
                } else {
                    double vi;
                    x = H.get(i, i + 1);
                    y = H.get(i + 1, i);
                    double vr = (d.get(i) - p) * (d.get(i) - p) + e.get(i) * e.get(i) - q * q;
                    if (vr == 0.0 & (vi = (d.get(i) - p) * 2.0 * q) == 0.0) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    cdiv = this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    H.set(i, n - 1, cdiv[0]);
                    H.set(i, n, cdiv[1]);
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        H.set(i + 1, n - 1, (-ra - w * H.get(i, n - 1) + q * H.get(i, n)) / x);
                        H.set(i + 1, n, (-sa - w * H.get(i, n) - q * H.get(i, n - 1)) / x);
                    } else {
                        cdiv = this.cdiv(-r - y * H.get(i, n - 1), -s - y * H.get(i, n), z, q);
                        H.set(i + 1, n - 1, cdiv[0]);
                        H.set(i + 1, n, cdiv[1]);
                    }
                }
                t = Math.max(Math.abs(H.get(i, n - 1)), Math.abs(H.get(i, n)));
                if (!(eps * t * t > 1.0)) continue;
                for (int j6 = i; j6 <= n; ++j6) {
                    H.update(j6, n - 1, Matrices.asDivFunction(t));
                    H.update(j6, n, Matrices.asDivFunction(t));
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (!(i5 < low | i5 > high)) continue;
            for (j = i5; j < nn; ++j) {
                V.set(i5, j, H.get(i5, j));
            }
        }
        for (j2 = nn - 1; j2 >= low; --j2) {
            for (i = low; i <= high; ++i) {
                z = 0.0;
                for (int k = low; k <= Math.min(j2, high); ++k) {
                    z += V.get(i, k) * H.get(k, j2);
                }
                V.set(i, j2, z);
            }
        }
    }

    private double[] cdiv(double xr, double xi, double yr, double yi) {
        double cdivi;
        double cdivr;
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            cdivr = (xr + r * xi) / d;
            cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            cdivr = (r * xr + xi) / d;
            cdivi = (r * xi - xr) / d;
        }
        return new double[]{cdivr, cdivi};
    }
}

