/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.audio.Audio;
import org.openimaj.audio.SampleChunk;

public abstract class AudioStream
extends Audio
implements Iterable<SampleChunk> {
    public abstract SampleChunk nextSampleChunk();

    public abstract void reset();

    public abstract long getLength();

    public void seek(long timestamp) {
    }

    @Override
    public Iterator<SampleChunk> iterator() {
        return new Iterator<SampleChunk>(){
            private SampleChunk next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                this.next = AudioStream.this.nextSampleChunk();
                return this.next != null;
            }

            @Override
            public SampleChunk next() {
                if (this.next == null) {
                    this.next = AudioStream.this.nextSampleChunk();
                }
                SampleChunk ret = this.next;
                this.next = null;
                if (ret == null) {
                    throw new NoSuchElementException();
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
    }
}

