/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import java.io.Closeable;
import java.util.Iterator;
import org.openimaj.image.Image;
import org.openimaj.video.VideoIterator;

public abstract class Video<T extends Image<?, T>>
implements Iterable<T>,
Closeable {
    protected int currentFrame;

    public abstract T getNextFrame();

    public abstract T getCurrentFrame();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract long getTimeStamp();

    public abstract double getFPS();

    public synchronized int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public synchronized void setCurrentFrameIndex(long newFrame) {
        if ((long)this.currentFrame == newFrame) {
            return;
        }
        if ((long)this.currentFrame > newFrame) {
            this.reset();
        }
        while ((long)this.currentFrame < newFrame && this.getNextFrame() != null) {
        }
    }

    public void seek(double timestamp) {
    }

    public abstract boolean hasNextFrame();

    public abstract long countFrames();

    public abstract void reset();

    @Override
    public Iterator<T> iterator() {
        return new VideoIterator(this);
    }

    @Override
    public void close() {
    }
}

