/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.event.DirectEvent;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.event.EventRedirector;
import com.sun.javafx.event.EventUtil;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.PopupWindowPeerListener;
import com.sun.javafx.stage.WindowCloseRequestHandler;
import com.sun.javafx.stage.WindowEventDispatcher;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class PopupWindow
extends Window {
    private final List<PopupWindow> children = new ArrayList<PopupWindow>();
    private final InvalidationListener popupWindowUpdater = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            PopupWindow.this.cachedExtendedBounds = null;
            PopupWindow.this.cachedAnchorBounds = null;
            PopupWindow.this.updateWindow(PopupWindow.this.getAnchorX(), PopupWindow.this.getAnchorY());
        }
    };
    private ChangeListener<Boolean> changeListener = (observable, oldValue, newValue) -> {
        if (oldValue.booleanValue() && !newValue.booleanValue()) {
            this.hide();
        }
    };
    private WeakChangeListener<Boolean> weakOwnerNodeListener = new WeakChangeListener<Boolean>(this.changeListener);
    private ReadOnlyObjectWrapper<Window> ownerWindow = new ReadOnlyObjectWrapper(this, "ownerWindow");
    private ReadOnlyObjectWrapper<Node> ownerNode = new ReadOnlyObjectWrapper(this, "ownerNode");
    private BooleanProperty autoFix = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            PopupWindow.this.handleAutofixActivation(PopupWindow.this.isShowing(), this.get());
        }

        @Override
        public Object getBean() {
            return PopupWindow.this;
        }

        @Override
        public String getName() {
            return "autoFix";
        }
    };
    private BooleanProperty autoHide = new BooleanPropertyBase(){

        @Override
        protected void invalidated() {
            PopupWindow.this.handleAutohideActivation(PopupWindow.this.isShowing(), this.get());
        }

        @Override
        public Object getBean() {
            return PopupWindow.this;
        }

        @Override
        public String getName() {
            return "autoHide";
        }
    };
    private ObjectProperty<EventHandler<Event>> onAutoHide = new SimpleObjectProperty<EventHandler<Event>>(this, "onAutoHide");
    private BooleanProperty hideOnEscape = new SimpleBooleanProperty(this, "hideOnEscape", true);
    private BooleanProperty consumeAutoHidingEvents = new SimpleBooleanProperty(this, "consumeAutoHidingEvents", true);
    private Window rootWindow;
    private final ReadOnlyDoubleWrapper anchorX = new ReadOnlyDoubleWrapper(this, "anchorX", Double.NaN);
    private final ReadOnlyDoubleWrapper anchorY = new ReadOnlyDoubleWrapper(this, "anchorY", Double.NaN);
    private final ObjectProperty<AnchorLocation> anchorLocation = new ObjectPropertyBase<AnchorLocation>(AnchorLocation.WINDOW_TOP_LEFT){

        @Override
        protected void invalidated() {
            PopupWindow.this.cachedAnchorBounds = null;
            PopupWindow.this.updateWindow(PopupWindow.this.windowToAnchorX(PopupWindow.this.getX()), PopupWindow.this.windowToAnchorY(PopupWindow.this.getY()));
        }

        @Override
        public Object getBean() {
            return PopupWindow.this;
        }

        @Override
        public String getName() {
            return "anchorLocation";
        }
    };
    private Bounds cachedExtendedBounds;
    private Bounds cachedAnchorBounds;
    private ChangeListener<Boolean> ownerFocusedListener;
    private boolean autofixActive;
    private boolean autohideActive;

    public PopupWindow() {
        Pane popupRoot = new Pane();
        popupRoot.setBackground(Background.EMPTY);
        popupRoot.getStyleClass().add("popup");
        final Scene scene = SceneHelper.createPopupScene(popupRoot);
        scene.setFill(null);
        super.setScene(scene);
        popupRoot.layoutBoundsProperty().addListener(this.popupWindowUpdater);
        popupRoot.boundsInLocalProperty().addListener(this.popupWindowUpdater);
        scene.rootProperty().addListener(new InvalidationListener(){
            private Node oldRoot;
            {
                this.oldRoot = scene.getRoot();
            }

            @Override
            public void invalidated(Observable observable) {
                Parent newRoot = scene.getRoot();
                if (this.oldRoot != newRoot) {
                    if (this.oldRoot != null) {
                        this.oldRoot.layoutBoundsProperty().removeListener(PopupWindow.this.popupWindowUpdater);
                        this.oldRoot.boundsInLocalProperty().removeListener(PopupWindow.this.popupWindowUpdater);
                        this.oldRoot.getStyleClass().remove("popup");
                    }
                    if (newRoot != null) {
                        newRoot.layoutBoundsProperty().addListener(PopupWindow.this.popupWindowUpdater);
                        newRoot.boundsInLocalProperty().addListener(PopupWindow.this.popupWindowUpdater);
                        newRoot.getStyleClass().add("popup");
                    }
                    this.oldRoot = newRoot;
                    PopupWindow.this.cachedExtendedBounds = null;
                    PopupWindow.this.cachedAnchorBounds = null;
                    PopupWindow.this.updateWindow(PopupWindow.this.getAnchorX(), PopupWindow.this.getAnchorY());
                }
            }
        });
    }

    @Deprecated
    protected ObservableList<Node> getContent() {
        Parent rootNode = this.getScene().getRoot();
        if (rootNode instanceof Group) {
            return ((Group)rootNode).getChildren();
        }
        if (rootNode instanceof Pane) {
            return ((Pane)rootNode).getChildren();
        }
        throw new IllegalStateException("The content of the Popup can't be accessed");
    }

    public final Window getOwnerWindow() {
        return (Window)this.ownerWindow.get();
    }

    public final ReadOnlyObjectProperty<Window> ownerWindowProperty() {
        return this.ownerWindow.getReadOnlyProperty();
    }

    public final Node getOwnerNode() {
        return (Node)this.ownerNode.get();
    }

    public final ReadOnlyObjectProperty<Node> ownerNodeProperty() {
        return this.ownerNode.getReadOnlyProperty();
    }

    @Override
    protected final void setScene(Scene scene) {
        throw new UnsupportedOperationException();
    }

    public final void setAutoFix(boolean value) {
        this.autoFix.set(value);
    }

    public final boolean isAutoFix() {
        return this.autoFix.get();
    }

    public final BooleanProperty autoFixProperty() {
        return this.autoFix;
    }

    public final void setAutoHide(boolean value) {
        this.autoHide.set(value);
    }

    public final boolean isAutoHide() {
        return this.autoHide.get();
    }

    public final BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public final void setOnAutoHide(EventHandler<Event> value) {
        this.onAutoHide.set(value);
    }

    public final EventHandler<Event> getOnAutoHide() {
        return (EventHandler)this.onAutoHide.get();
    }

    public final ObjectProperty<EventHandler<Event>> onAutoHideProperty() {
        return this.onAutoHide;
    }

    public final void setHideOnEscape(boolean value) {
        this.hideOnEscape.set(value);
    }

    public final boolean isHideOnEscape() {
        return this.hideOnEscape.get();
    }

    public final BooleanProperty hideOnEscapeProperty() {
        return this.hideOnEscape;
    }

    public final void setConsumeAutoHidingEvents(boolean value) {
        this.consumeAutoHidingEvents.set(value);
    }

    public final boolean getConsumeAutoHidingEvents() {
        return this.consumeAutoHidingEvents.get();
    }

    public final BooleanProperty consumeAutoHidingEventsProperty() {
        return this.consumeAutoHidingEvents;
    }

    public void show(Window owner) {
        this.validateOwnerWindow(owner);
        this.showImpl(owner);
    }

    public void show(Node ownerNode, double anchorX, double anchorY) {
        if (ownerNode == null) {
            throw new NullPointerException("The owner node must not be null");
        }
        Scene ownerNodeScene = ownerNode.getScene();
        if (ownerNodeScene == null || ownerNodeScene.getWindow() == null) {
            throw new IllegalArgumentException("The owner node needs to be associated with a window");
        }
        Window newOwnerWindow = ownerNodeScene.getWindow();
        this.validateOwnerWindow(newOwnerWindow);
        this.ownerNode.set(ownerNode);
        if (ownerNode != null) {
            ownerNode.visibleProperty().addListener(this.weakOwnerNodeListener);
        }
        this.updateWindow(anchorX, anchorY);
        this.showImpl(newOwnerWindow);
    }

    public void show(Window ownerWindow, double anchorX, double anchorY) {
        this.validateOwnerWindow(ownerWindow);
        this.updateWindow(anchorX, anchorY);
        this.showImpl(ownerWindow);
    }

    private void showImpl(Window owner) {
        this.ownerWindow.set(owner);
        if (owner instanceof PopupWindow) {
            ((PopupWindow)owner).children.add(this);
        }
        if (owner != null) {
            owner.showingProperty().addListener(this.weakOwnerNodeListener);
        }
        Scene sceneValue = this.getScene();
        SceneHelper.parentEffectiveOrientationInvalidated(sceneValue);
        Scene ownerScene = PopupWindow.getRootWindow(owner).getScene();
        if (ownerScene != null) {
            if (ownerScene.getUserAgentStylesheet() != null) {
                sceneValue.setUserAgentStylesheet(ownerScene.getUserAgentStylesheet());
            }
            sceneValue.getStylesheets().setAll((Collection<String>)ownerScene.getStylesheets());
            if (sceneValue.getCursor() == null) {
                sceneValue.setCursor(ownerScene.getCursor());
            }
        }
        if (PopupWindow.getRootWindow(owner).isShowing()) {
            this.show();
        }
    }

    @Override
    public void hide() {
        for (PopupWindow c : this.children) {
            if (!c.isShowing()) continue;
            c.hide();
        }
        this.children.clear();
        super.hide();
        if (this.getOwnerWindow() != null) {
            this.getOwnerWindow().showingProperty().removeListener(this.weakOwnerNodeListener);
        }
        if (this.getOwnerNode() != null) {
            this.getOwnerNode().visibleProperty().removeListener(this.weakOwnerNodeListener);
        }
    }

    @Override
    @Deprecated
    protected void impl_visibleChanging(boolean visible) {
        super.impl_visibleChanging(visible);
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow]");
        Toolkit toolkit = Toolkit.getToolkit();
        if (visible && this.impl_peer == null) {
            StageStyle popupStyle;
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new AllPermission());
                }
                popupStyle = StageStyle.TRANSPARENT;
            }
            catch (SecurityException e) {
                popupStyle = StageStyle.UNDECORATED;
            }
            this.impl_peer = toolkit.createTKPopupStage(this, popupStyle, this.getOwnerWindow().impl_getPeer(), this.acc);
            this.peerListener = new PopupWindowPeerListener(this);
        }
    }

    @Override
    @Deprecated
    protected void impl_visibleChanged(boolean visible) {
        super.impl_visibleChanged(visible);
        Window ownerWindowValue = this.getOwnerWindow();
        if (visible) {
            this.rootWindow = PopupWindow.getRootWindow(ownerWindowValue);
            this.startMonitorOwnerEvents(ownerWindowValue);
            this.bindOwnerFocusedProperty(ownerWindowValue);
            this.setFocused(ownerWindowValue.isFocused());
            this.handleAutofixActivation(true, this.isAutoFix());
            this.handleAutohideActivation(true, this.isAutoHide());
        } else {
            this.stopMonitorOwnerEvents(ownerWindowValue);
            this.unbindOwnerFocusedProperty(ownerWindowValue);
            this.setFocused(false);
            this.handleAutofixActivation(false, this.isAutoFix());
            this.handleAutohideActivation(false, this.isAutoHide());
            this.rootWindow = null;
        }
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow] finished");
    }

    public final void setAnchorX(double value) {
        this.updateWindow(value, this.getAnchorY());
    }

    public final double getAnchorX() {
        return this.anchorX.get();
    }

    public final ReadOnlyDoubleProperty anchorXProperty() {
        return this.anchorX.getReadOnlyProperty();
    }

    public final void setAnchorY(double value) {
        this.updateWindow(this.getAnchorX(), value);
    }

    public final double getAnchorY() {
        return this.anchorY.get();
    }

    public final ReadOnlyDoubleProperty anchorYProperty() {
        return this.anchorY.getReadOnlyProperty();
    }

    public final void setAnchorLocation(AnchorLocation value) {
        this.anchorLocation.set(value);
    }

    public final AnchorLocation getAnchorLocation() {
        return (AnchorLocation)((Object)this.anchorLocation.get());
    }

    public final ObjectProperty<AnchorLocation> anchorLocationProperty() {
        return this.anchorLocation;
    }

    @Override
    void setXInternal(double value) {
        this.updateWindow(this.windowToAnchorX(value), this.getAnchorY());
    }

    @Override
    void setYInternal(double value) {
        this.updateWindow(this.getAnchorX(), this.windowToAnchorY(value));
    }

    @Override
    void notifyLocationChanged(double newX, double newY) {
        super.notifyLocationChanged(newX, newY);
        this.anchorX.set(this.windowToAnchorX(newX));
        this.anchorY.set(this.windowToAnchorY(newY));
    }

    private Bounds getExtendedBounds() {
        if (this.cachedExtendedBounds == null) {
            Parent rootNode = this.getScene().getRoot();
            this.cachedExtendedBounds = this.union(rootNode.getLayoutBounds(), rootNode.getBoundsInLocal());
        }
        return this.cachedExtendedBounds;
    }

    private Bounds getAnchorBounds() {
        if (this.cachedAnchorBounds == null) {
            this.cachedAnchorBounds = this.getAnchorLocation().isContentLocation() ? this.getScene().getRoot().getLayoutBounds() : this.getExtendedBounds();
        }
        return this.cachedAnchorBounds;
    }

    private void updateWindow(double newAnchorX, double newAnchorY) {
        AnchorLocation anchorLocationValue = this.getAnchorLocation();
        Parent rootNode = this.getScene().getRoot();
        Bounds extendedBounds = this.getExtendedBounds();
        Bounds anchorBounds = this.getAnchorBounds();
        double anchorXCoef = anchorLocationValue.getXCoef();
        double anchorYCoef = anchorLocationValue.getYCoef();
        double anchorDeltaX = anchorXCoef * anchorBounds.getWidth();
        double anchorDeltaY = anchorYCoef * anchorBounds.getHeight();
        double anchorScrMinX = newAnchorX - anchorDeltaX;
        double anchorScrMinY = newAnchorY - anchorDeltaY;
        if (this.autofixActive) {
            Rectangle2D screenBounds;
            Screen currentScreen = Utils.getScreenForPoint(newAnchorX, newAnchorY);
            Rectangle2D rectangle2D = screenBounds = Utils.hasFullScreenStage(currentScreen) ? currentScreen.getBounds() : currentScreen.getVisualBounds();
            if (anchorXCoef <= 0.5) {
                anchorScrMinX = Math.min(anchorScrMinX, screenBounds.getMaxX() - anchorBounds.getWidth());
                anchorScrMinX = Math.max(anchorScrMinX, screenBounds.getMinX());
            } else {
                anchorScrMinX = Math.max(anchorScrMinX, screenBounds.getMinX());
                anchorScrMinX = Math.min(anchorScrMinX, screenBounds.getMaxX() - anchorBounds.getWidth());
            }
            if (anchorYCoef <= 0.5) {
                anchorScrMinY = Math.min(anchorScrMinY, screenBounds.getMaxY() - anchorBounds.getHeight());
                anchorScrMinY = Math.max(anchorScrMinY, screenBounds.getMinY());
            } else {
                anchorScrMinY = Math.max(anchorScrMinY, screenBounds.getMinY());
                anchorScrMinY = Math.min(anchorScrMinY, screenBounds.getMaxY() - anchorBounds.getHeight());
            }
        }
        double windowScrMinX = anchorScrMinX - anchorBounds.getMinX() + extendedBounds.getMinX();
        double windowScrMinY = anchorScrMinY - anchorBounds.getMinY() + extendedBounds.getMinY();
        this.setWidth(extendedBounds.getWidth());
        this.setHeight(extendedBounds.getHeight());
        rootNode.setTranslateX(-extendedBounds.getMinX());
        rootNode.setTranslateY(-extendedBounds.getMinY());
        if (!Double.isNaN(windowScrMinX)) {
            super.setXInternal(windowScrMinX);
        }
        if (!Double.isNaN(windowScrMinY)) {
            super.setYInternal(windowScrMinY);
        }
        this.anchorX.set(anchorScrMinX + anchorDeltaX);
        this.anchorY.set(anchorScrMinY + anchorDeltaY);
    }

    private Bounds union(Bounds bounds1, Bounds bounds2) {
        double minX = Math.min(bounds1.getMinX(), bounds2.getMinX());
        double minY = Math.min(bounds1.getMinY(), bounds2.getMinY());
        double maxX = Math.max(bounds1.getMaxX(), bounds2.getMaxX());
        double maxY = Math.max(bounds1.getMaxY(), bounds2.getMaxY());
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    private double windowToAnchorX(double windowX) {
        Bounds anchorBounds = this.getAnchorBounds();
        return windowX - this.getExtendedBounds().getMinX() + anchorBounds.getMinX() + this.getAnchorLocation().getXCoef() * anchorBounds.getWidth();
    }

    private double windowToAnchorY(double windowY) {
        Bounds anchorBounds = this.getAnchorBounds();
        return windowY - this.getExtendedBounds().getMinY() + anchorBounds.getMinY() + this.getAnchorLocation().getYCoef() * anchorBounds.getHeight();
    }

    private static Window getRootWindow(Window win) {
        while (win instanceof PopupWindow) {
            win = ((PopupWindow)win).getOwnerWindow();
        }
        return win;
    }

    void doAutoHide() {
        this.hide();
        if (this.getOnAutoHide() != null) {
            this.getOnAutoHide().handle(new Event(this, this, Event.ANY));
        }
    }

    @Override
    WindowEventDispatcher createInternalEventDispatcher() {
        return new WindowEventDispatcher(new PopupEventRedirector(this), new WindowCloseRequestHandler(this), new EventHandlerManager(this));
    }

    @Override
    Window getWindowOwner() {
        return this.getOwnerWindow();
    }

    private void startMonitorOwnerEvents(Window ownerWindowValue) {
        EventRedirector parentEventRedirector = ownerWindowValue.getInternalEventDispatcher().getEventRedirector();
        parentEventRedirector.addEventDispatcher(this.getEventDispatcher());
    }

    private void stopMonitorOwnerEvents(Window ownerWindowValue) {
        EventRedirector parentEventRedirector = ownerWindowValue.getInternalEventDispatcher().getEventRedirector();
        parentEventRedirector.removeEventDispatcher(this.getEventDispatcher());
    }

    private void bindOwnerFocusedProperty(Window ownerWindowValue) {
        this.ownerFocusedListener = (observable, oldValue, newValue) -> this.setFocused((boolean)newValue);
        ownerWindowValue.focusedProperty().addListener(this.ownerFocusedListener);
    }

    private void unbindOwnerFocusedProperty(Window ownerWindowValue) {
        ownerWindowValue.focusedProperty().removeListener(this.ownerFocusedListener);
        this.ownerFocusedListener = null;
    }

    private void handleAutofixActivation(boolean visible, boolean autofix) {
        boolean newAutofixActive;
        boolean bl = newAutofixActive = visible && autofix;
        if (this.autofixActive != newAutofixActive) {
            this.autofixActive = newAutofixActive;
            if (newAutofixActive) {
                Screen.getScreens().addListener(this.popupWindowUpdater);
                this.updateWindow(this.getAnchorX(), this.getAnchorY());
            } else {
                Screen.getScreens().removeListener(this.popupWindowUpdater);
            }
        }
    }

    private void handleAutohideActivation(boolean visible, boolean autohide) {
        boolean newAutohideActive;
        boolean bl = newAutohideActive = visible && autohide;
        if (this.autohideActive != newAutohideActive) {
            this.autohideActive = newAutohideActive;
            if (newAutohideActive) {
                this.rootWindow.increaseFocusGrabCounter();
            } else {
                this.rootWindow.decreaseFocusGrabCounter();
            }
        }
    }

    private void validateOwnerWindow(Window owner) {
        if (owner == null) {
            throw new NullPointerException("Owner window must not be null");
        }
        if (PopupWindow.wouldCreateCycle(owner, this)) {
            throw new IllegalArgumentException("Specified owner window would create cycle in the window hierarchy");
        }
        if (this.isShowing() && this.getOwnerWindow() != owner) {
            throw new IllegalStateException("Popup is already shown with different owner window");
        }
    }

    private static boolean wouldCreateCycle(Window parent, Window child) {
        while (parent != null) {
            if (parent == child) {
                return true;
            }
            parent = parent.getWindowOwner();
        }
        return false;
    }

    static class PopupEventRedirector
    extends EventRedirector {
        private static final KeyCombination ESCAPE_KEY_COMBINATION = KeyCombination.keyCombination("Esc");
        private final PopupWindow popupWindow;

        public PopupEventRedirector(PopupWindow popupWindow) {
            super(popupWindow);
            this.popupWindow = popupWindow;
        }

        @Override
        protected void handleRedirectedEvent(Object eventSource, Event event) {
            if (event instanceof KeyEvent) {
                this.handleKeyEvent((KeyEvent)event);
                return;
            }
            EventType<? extends Event> eventType = event.getEventType();
            if (eventType == MouseEvent.MOUSE_PRESSED || eventType == ScrollEvent.SCROLL) {
                this.handleAutoHidingEvents(eventSource, event);
                return;
            }
            if (eventType == FocusUngrabEvent.FOCUS_UNGRAB) {
                this.handleFocusUngrabEvent();
                return;
            }
        }

        private void handleKeyEvent(KeyEvent event) {
            if (event.isConsumed()) {
                return;
            }
            Scene scene = this.popupWindow.getScene();
            if (scene != null) {
                EventTarget eventTarget;
                Node sceneFocusOwner = scene.getFocusOwner();
                EventTarget eventTarget2 = eventTarget = sceneFocusOwner != null ? sceneFocusOwner : scene;
                if (EventUtil.fireEvent(eventTarget, new DirectEvent(event.copyFor(this.popupWindow, eventTarget))) == null) {
                    event.consume();
                    return;
                }
            }
            if (event.getEventType() == KeyEvent.KEY_PRESSED && ESCAPE_KEY_COMBINATION.match(event)) {
                this.handleEscapeKeyPressedEvent(event);
            }
        }

        private void handleEscapeKeyPressedEvent(Event event) {
            if (this.popupWindow.isHideOnEscape()) {
                this.popupWindow.doAutoHide();
                if (this.popupWindow.getConsumeAutoHidingEvents()) {
                    event.consume();
                }
            }
        }

        private void handleAutoHidingEvents(Object eventSource, Event event) {
            if (this.popupWindow.getOwnerWindow() != eventSource) {
                return;
            }
            if (this.popupWindow.isAutoHide() && !this.isOwnerNodeEvent(event)) {
                Event.fireEvent(this.popupWindow, new FocusUngrabEvent());
                this.popupWindow.doAutoHide();
                if (this.popupWindow.getConsumeAutoHidingEvents()) {
                    event.consume();
                }
            }
        }

        private void handleFocusUngrabEvent() {
            if (this.popupWindow.isAutoHide()) {
                this.popupWindow.doAutoHide();
            }
        }

        private boolean isOwnerNodeEvent(Event event) {
            Node ownerNode = this.popupWindow.getOwnerNode();
            if (ownerNode == null) {
                return false;
            }
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof Node)) {
                return false;
            }
            Node node = (Node)eventTarget;
            do {
                if (node != ownerNode) continue;
                return true;
            } while ((node = node.getParent()) != null);
            return false;
        }
    }

    public static enum AnchorLocation {
        WINDOW_TOP_LEFT(0.0, 0.0, false),
        WINDOW_TOP_RIGHT(1.0, 0.0, false),
        WINDOW_BOTTOM_LEFT(0.0, 1.0, false),
        WINDOW_BOTTOM_RIGHT(1.0, 1.0, false),
        CONTENT_TOP_LEFT(0.0, 0.0, true),
        CONTENT_TOP_RIGHT(1.0, 0.0, true),
        CONTENT_BOTTOM_LEFT(0.0, 1.0, true),
        CONTENT_BOTTOM_RIGHT(1.0, 1.0, true);

        private final double xCoef;
        private final double yCoef;
        private final boolean contentLocation;

        private AnchorLocation(double xCoef, double yCoef, boolean contentLocation) {
            this.xCoef = xCoef;
            this.yCoef = yCoef;
            this.contentLocation = contentLocation;
        }

        double getXCoef() {
            return this.xCoef;
        }

        double getYCoef() {
            return this.yCoef;
        }

        boolean isContentLocation() {
            return this.contentLocation;
        }
    }
}

