/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.glass.ui.CommonDialogs;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.Window;

public final class FileChooser {
    private StringProperty title;
    private ObjectProperty<File> initialDirectory;
    private ObjectProperty<String> initialFileName;
    private ObservableList<ExtensionFilter> extensionFilters = FXCollections.observableArrayList();
    private ObjectProperty<ExtensionFilter> selectedExtensionFilter;

    public final void setTitle(String value) {
        this.titleProperty().set(value);
    }

    public final String getTitle() {
        return this.title != null ? (String)this.title.get() : null;
    }

    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty(this, "title");
        }
        return this.title;
    }

    public final void setInitialDirectory(File value) {
        this.initialDirectoryProperty().set(value);
    }

    public final File getInitialDirectory() {
        return this.initialDirectory != null ? (File)this.initialDirectory.get() : null;
    }

    public final ObjectProperty<File> initialDirectoryProperty() {
        if (this.initialDirectory == null) {
            this.initialDirectory = new SimpleObjectProperty<File>(this, "initialDirectory");
        }
        return this.initialDirectory;
    }

    public final void setInitialFileName(String value) {
        this.initialFileNameProperty().set(value);
    }

    public final String getInitialFileName() {
        return this.initialFileName != null ? (String)this.initialFileName.get() : null;
    }

    public final ObjectProperty<String> initialFileNameProperty() {
        if (this.initialFileName == null) {
            this.initialFileName = new SimpleObjectProperty<String>(this, "initialFileName");
        }
        return this.initialFileName;
    }

    public ObservableList<ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public final ObjectProperty<ExtensionFilter> selectedExtensionFilterProperty() {
        if (this.selectedExtensionFilter == null) {
            this.selectedExtensionFilter = new SimpleObjectProperty<ExtensionFilter>(this, "selectedExtensionFilter");
        }
        return this.selectedExtensionFilter;
    }

    public final void setSelectedExtensionFilter(ExtensionFilter filter) {
        this.selectedExtensionFilterProperty().setValue(filter);
    }

    public final ExtensionFilter getSelectedExtensionFilter() {
        return this.selectedExtensionFilter != null ? (ExtensionFilter)this.selectedExtensionFilter.get() : null;
    }

    public File showOpenDialog(Window ownerWindow) {
        List<File> selectedFiles = this.showDialog(ownerWindow, FileChooserType.OPEN);
        return selectedFiles != null && selectedFiles.size() > 0 ? selectedFiles.get(0) : null;
    }

    public List<File> showOpenMultipleDialog(Window ownerWindow) {
        List<File> selectedFiles = this.showDialog(ownerWindow, FileChooserType.OPEN_MULTIPLE);
        return selectedFiles != null && selectedFiles.size() > 0 ? Collections.unmodifiableList(selectedFiles) : null;
    }

    public File showSaveDialog(Window ownerWindow) {
        List<File> selectedFiles = this.showDialog(ownerWindow, FileChooserType.SAVE);
        return selectedFiles != null && selectedFiles.size() > 0 ? selectedFiles.get(0) : null;
    }

    private ExtensionFilter findSelectedFilter(CommonDialogs.ExtensionFilter filter) {
        if (filter != null) {
            String description = filter.getDescription();
            List<String> extensions = filter.getExtensions();
            for (ExtensionFilter ef : this.extensionFilters) {
                if (!description.equals(ef.getDescription()) || !extensions.equals(ef.getExtensions())) continue;
                return ef;
            }
        }
        return null;
    }

    private List<File> showDialog(Window ownerWindow, FileChooserType fileChooserType) {
        CommonDialogs.FileChooserResult result = Toolkit.getToolkit().showFileChooser(ownerWindow != null ? ownerWindow.impl_getPeer() : null, this.getTitle(), this.getInitialDirectory(), this.getInitialFileName(), fileChooserType, this.extensionFilters, this.getSelectedExtensionFilter());
        if (result == null) {
            return null;
        }
        List<File> files = result.getFiles();
        if (files != null && files.size() > 0) {
            this.selectedExtensionFilterProperty().set(this.findSelectedFilter(result.getExtensionFilter()));
        }
        return files;
    }

    public static final class ExtensionFilter {
        private final String description;
        private final List<String> extensions;

        public ExtensionFilter(String description, String ... extensions) {
            ExtensionFilter.validateArgs(description, extensions);
            this.description = description;
            this.extensions = Collections.unmodifiableList(Arrays.asList((Object[])extensions.clone()));
        }

        public ExtensionFilter(String description, List<String> extensions) {
            String[] extensionsArray = extensions != null ? extensions.toArray(new String[extensions.size()]) : null;
            ExtensionFilter.validateArgs(description, extensionsArray);
            this.description = description;
            this.extensions = Collections.unmodifiableList(Arrays.asList(extensionsArray));
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        private static void validateArgs(String description, String[] extensions) {
            if (description == null) {
                throw new NullPointerException("Description must not be null");
            }
            if (description.isEmpty()) {
                throw new IllegalArgumentException("Description must not be empty");
            }
            if (extensions == null) {
                throw new NullPointerException("Extensions must not be null");
            }
            if (extensions.length == 0) {
                throw new IllegalArgumentException("At least one extension must be defined");
            }
            for (String extension : extensions) {
                if (extension == null) {
                    throw new NullPointerException("Extension must not be null");
                }
                if (!extension.isEmpty()) continue;
                throw new IllegalArgumentException("Extension must not be empty");
            }
        }
    }
}

