/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.NamedArg;

public class CornerRadii {
    public static final CornerRadii EMPTY = new CornerRadii(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, false, false, false, false, false, false, false);
    private double topLeftHorizontalRadius;
    private double topLeftVerticalRadius;
    private double topRightVerticalRadius;
    private double topRightHorizontalRadius;
    private double bottomRightHorizontalRadius;
    private double bottomRightVerticalRadius;
    private double bottomLeftVerticalRadius;
    private double bottomLeftHorizontalRadius;
    private final boolean topLeftHorizontalRadiusAsPercentage;
    private final boolean topLeftVerticalRadiusAsPercentage;
    private final boolean topRightVerticalRadiusAsPercentage;
    private final boolean topRightHorizontalRadiusAsPercentage;
    private final boolean bottomRightHorizontalRadiusAsPercentage;
    private final boolean bottomRightVerticalRadiusAsPercentage;
    private final boolean bottomLeftVerticalRadiusAsPercentage;
    private final boolean bottomLeftHorizontalRadiusAsPercentage;
    final boolean hasPercentBasedRadii;
    final boolean uniform;
    private final int hash;

    public final double getTopLeftHorizontalRadius() {
        return this.topLeftHorizontalRadius;
    }

    public final double getTopLeftVerticalRadius() {
        return this.topLeftVerticalRadius;
    }

    public final double getTopRightVerticalRadius() {
        return this.topRightVerticalRadius;
    }

    public final double getTopRightHorizontalRadius() {
        return this.topRightHorizontalRadius;
    }

    public final double getBottomRightHorizontalRadius() {
        return this.bottomRightHorizontalRadius;
    }

    public final double getBottomRightVerticalRadius() {
        return this.bottomRightVerticalRadius;
    }

    public final double getBottomLeftVerticalRadius() {
        return this.bottomLeftVerticalRadius;
    }

    public final double getBottomLeftHorizontalRadius() {
        return this.bottomLeftHorizontalRadius;
    }

    public final boolean isTopLeftHorizontalRadiusAsPercentage() {
        return this.topLeftHorizontalRadiusAsPercentage;
    }

    public final boolean isTopLeftVerticalRadiusAsPercentage() {
        return this.topLeftVerticalRadiusAsPercentage;
    }

    public final boolean isTopRightVerticalRadiusAsPercentage() {
        return this.topRightVerticalRadiusAsPercentage;
    }

    public final boolean isTopRightHorizontalRadiusAsPercentage() {
        return this.topRightHorizontalRadiusAsPercentage;
    }

    public final boolean isBottomRightHorizontalRadiusAsPercentage() {
        return this.bottomRightHorizontalRadiusAsPercentage;
    }

    public final boolean isBottomRightVerticalRadiusAsPercentage() {
        return this.bottomRightVerticalRadiusAsPercentage;
    }

    public final boolean isBottomLeftVerticalRadiusAsPercentage() {
        return this.bottomLeftVerticalRadiusAsPercentage;
    }

    public final boolean isBottomLeftHorizontalRadiusAsPercentage() {
        return this.bottomLeftHorizontalRadiusAsPercentage;
    }

    public final boolean isUniform() {
        return this.uniform;
    }

    public CornerRadii(@NamedArg(value="radius") double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radii value may not be < 0");
        }
        this.bottomLeftVerticalRadius = this.bottomLeftHorizontalRadius = radius;
        this.bottomRightVerticalRadius = this.bottomLeftHorizontalRadius;
        this.bottomRightHorizontalRadius = this.bottomLeftHorizontalRadius;
        this.topRightHorizontalRadius = this.bottomLeftHorizontalRadius;
        this.topRightVerticalRadius = this.bottomLeftHorizontalRadius;
        this.topLeftVerticalRadius = this.bottomLeftHorizontalRadius;
        this.topLeftHorizontalRadius = this.bottomLeftHorizontalRadius;
        this.bottomLeftHorizontalRadiusAsPercentage = false;
        this.bottomLeftVerticalRadiusAsPercentage = false;
        this.bottomRightVerticalRadiusAsPercentage = false;
        this.bottomRightHorizontalRadiusAsPercentage = false;
        this.topRightHorizontalRadiusAsPercentage = false;
        this.topRightVerticalRadiusAsPercentage = false;
        this.topLeftVerticalRadiusAsPercentage = false;
        this.topLeftHorizontalRadiusAsPercentage = false;
        this.hasPercentBasedRadii = false;
        this.uniform = true;
        this.hash = this.preComputeHash();
    }

    public CornerRadii(@NamedArg(value="radius") double radius, @NamedArg(value="asPercent") boolean asPercent) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radii value may not be < 0");
        }
        this.bottomLeftVerticalRadius = this.bottomLeftHorizontalRadius = radius;
        this.bottomRightVerticalRadius = this.bottomLeftHorizontalRadius;
        this.bottomRightHorizontalRadius = this.bottomLeftHorizontalRadius;
        this.topRightHorizontalRadius = this.bottomLeftHorizontalRadius;
        this.topRightVerticalRadius = this.bottomLeftHorizontalRadius;
        this.topLeftVerticalRadius = this.bottomLeftHorizontalRadius;
        this.topLeftHorizontalRadius = this.bottomLeftHorizontalRadius;
        this.bottomLeftVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage = asPercent;
        this.bottomRightVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.bottomRightHorizontalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topRightHorizontalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topRightVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topLeftVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topLeftHorizontalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.uniform = true;
        this.hasPercentBasedRadii = asPercent;
        this.hash = this.preComputeHash();
    }

    public CornerRadii(@NamedArg(value="topLeft") double topLeft, @NamedArg(value="topRight") double topRight, @NamedArg(value="bottomRight") double bottomRight, @NamedArg(value="bottomLeft") double bottomLeft, @NamedArg(value="asPercent") boolean asPercent) {
        if (topLeft < 0.0 || topRight < 0.0 || bottomRight < 0.0 || bottomLeft < 0.0) {
            throw new IllegalArgumentException("No radii value may be < 0");
        }
        this.topLeftHorizontalRadius = this.topLeftVerticalRadius = topLeft;
        this.topRightVerticalRadius = this.topRightHorizontalRadius = topRight;
        this.bottomRightHorizontalRadius = this.bottomRightVerticalRadius = bottomRight;
        this.bottomLeftVerticalRadius = this.bottomLeftHorizontalRadius = bottomLeft;
        this.bottomLeftVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage = asPercent;
        this.bottomRightVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.bottomRightHorizontalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topRightHorizontalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topRightVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topLeftVerticalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.topLeftHorizontalRadiusAsPercentage = this.bottomLeftHorizontalRadiusAsPercentage;
        this.uniform = topLeft == topRight && topLeft == bottomLeft && topLeft == bottomRight;
        this.hasPercentBasedRadii = asPercent;
        this.hash = this.preComputeHash();
    }

    public CornerRadii(@NamedArg(value="topLeftHorizontalRadius") double topLeftHorizontalRadius, @NamedArg(value="topLeftVerticalRadius") double topLeftVerticalRadius, @NamedArg(value="topRightVerticalRadius") double topRightVerticalRadius, @NamedArg(value="topRightHorizontalRadius") double topRightHorizontalRadius, @NamedArg(value="bottomRightHorizontalRadius") double bottomRightHorizontalRadius, @NamedArg(value="bottomRightVerticalRadius") double bottomRightVerticalRadius, @NamedArg(value="bottomLeftVerticalRadius") double bottomLeftVerticalRadius, @NamedArg(value="bottomLeftHorizontalRadius") double bottomLeftHorizontalRadius, @NamedArg(value="topLeftHorizontalRadiusAsPercent") boolean topLeftHorizontalRadiusAsPercent, @NamedArg(value="topLeftVerticalRadiusAsPercent") boolean topLeftVerticalRadiusAsPercent, @NamedArg(value="topRightVerticalRadiusAsPercent") boolean topRightVerticalRadiusAsPercent, @NamedArg(value="topRightHorizontalRadiusAsPercent") boolean topRightHorizontalRadiusAsPercent, @NamedArg(value="bottomRightHorizontalRadiusAsPercent") boolean bottomRightHorizontalRadiusAsPercent, @NamedArg(value="bottomRightVerticalRadiusAsPercent") boolean bottomRightVerticalRadiusAsPercent, @NamedArg(value="bottomLeftVerticalRadiusAsPercent") boolean bottomLeftVerticalRadiusAsPercent, @NamedArg(value="bottomLeftHorizontalRadiusAsPercent") boolean bottomLeftHorizontalRadiusAsPercent) {
        if (topLeftHorizontalRadius < 0.0 || topLeftVerticalRadius < 0.0 || topRightVerticalRadius < 0.0 || topRightHorizontalRadius < 0.0 || bottomRightHorizontalRadius < 0.0 || bottomRightVerticalRadius < 0.0 || bottomLeftVerticalRadius < 0.0 || bottomLeftHorizontalRadius < 0.0) {
            throw new IllegalArgumentException("No radii value may be < 0");
        }
        this.topLeftHorizontalRadius = topLeftHorizontalRadius;
        this.topLeftVerticalRadius = topLeftVerticalRadius;
        this.topRightVerticalRadius = topRightVerticalRadius;
        this.topRightHorizontalRadius = topRightHorizontalRadius;
        this.bottomRightHorizontalRadius = bottomRightHorizontalRadius;
        this.bottomRightVerticalRadius = bottomRightVerticalRadius;
        this.bottomLeftVerticalRadius = bottomLeftVerticalRadius;
        this.bottomLeftHorizontalRadius = bottomLeftHorizontalRadius;
        this.topLeftHorizontalRadiusAsPercentage = topLeftHorizontalRadiusAsPercent;
        this.topLeftVerticalRadiusAsPercentage = topLeftVerticalRadiusAsPercent;
        this.topRightVerticalRadiusAsPercentage = topRightVerticalRadiusAsPercent;
        this.topRightHorizontalRadiusAsPercentage = topRightHorizontalRadiusAsPercent;
        this.bottomRightHorizontalRadiusAsPercentage = bottomRightHorizontalRadiusAsPercent;
        this.bottomRightVerticalRadiusAsPercentage = bottomRightVerticalRadiusAsPercent;
        this.bottomLeftVerticalRadiusAsPercentage = bottomLeftVerticalRadiusAsPercent;
        this.bottomLeftHorizontalRadiusAsPercentage = bottomLeftHorizontalRadiusAsPercent;
        this.hash = this.preComputeHash();
        this.hasPercentBasedRadii = topLeftHorizontalRadiusAsPercent || topLeftVerticalRadiusAsPercent || topRightVerticalRadiusAsPercent || topRightHorizontalRadiusAsPercent || bottomRightHorizontalRadiusAsPercent || bottomRightVerticalRadiusAsPercent || bottomLeftVerticalRadiusAsPercent || bottomLeftHorizontalRadiusAsPercent;
        this.uniform = topLeftHorizontalRadius == topRightHorizontalRadius && topLeftVerticalRadius == topRightVerticalRadius && topLeftHorizontalRadius == bottomRightHorizontalRadius && topLeftVerticalRadius == bottomRightVerticalRadius && topLeftHorizontalRadius == bottomLeftHorizontalRadius && topLeftVerticalRadius == bottomLeftVerticalRadius && topLeftHorizontalRadiusAsPercent == topRightHorizontalRadiusAsPercent && topLeftVerticalRadiusAsPercent == topRightVerticalRadiusAsPercent && topLeftHorizontalRadiusAsPercent == bottomRightHorizontalRadiusAsPercent && topLeftVerticalRadiusAsPercent == bottomRightVerticalRadiusAsPercent && topLeftHorizontalRadiusAsPercent == bottomLeftHorizontalRadiusAsPercent && topLeftVerticalRadiusAsPercent == bottomLeftVerticalRadiusAsPercent;
    }

    private int preComputeHash() {
        long temp = this.topLeftHorizontalRadius != 0.0 ? Double.doubleToLongBits(this.topLeftHorizontalRadius) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.topLeftVerticalRadius != 0.0 ? Double.doubleToLongBits(this.topLeftVerticalRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.topRightVerticalRadius != 0.0 ? Double.doubleToLongBits(this.topRightVerticalRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.topRightHorizontalRadius != 0.0 ? Double.doubleToLongBits(this.topRightHorizontalRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.bottomRightHorizontalRadius != 0.0 ? Double.doubleToLongBits(this.bottomRightHorizontalRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.bottomRightVerticalRadius != 0.0 ? Double.doubleToLongBits(this.bottomRightVerticalRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.bottomLeftVerticalRadius != 0.0 ? Double.doubleToLongBits(this.bottomLeftVerticalRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.bottomLeftHorizontalRadius != 0.0 ? Double.doubleToLongBits(this.bottomLeftHorizontalRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.topLeftHorizontalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + (this.topLeftVerticalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + (this.topRightVerticalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + (this.topRightHorizontalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + (this.bottomRightHorizontalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + (this.bottomRightVerticalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + (this.bottomLeftVerticalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + (this.bottomLeftHorizontalRadiusAsPercentage ? 1 : 0);
        result = 31 * result + result;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CornerRadii that = (CornerRadii)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (Double.compare(that.bottomLeftHorizontalRadius, this.bottomLeftHorizontalRadius) != 0) {
            return false;
        }
        if (this.bottomLeftHorizontalRadiusAsPercentage != that.bottomLeftHorizontalRadiusAsPercentage) {
            return false;
        }
        if (Double.compare(that.bottomLeftVerticalRadius, this.bottomLeftVerticalRadius) != 0) {
            return false;
        }
        if (this.bottomLeftVerticalRadiusAsPercentage != that.bottomLeftVerticalRadiusAsPercentage) {
            return false;
        }
        if (Double.compare(that.bottomRightVerticalRadius, this.bottomRightVerticalRadius) != 0) {
            return false;
        }
        if (this.bottomRightVerticalRadiusAsPercentage != that.bottomRightVerticalRadiusAsPercentage) {
            return false;
        }
        if (Double.compare(that.bottomRightHorizontalRadius, this.bottomRightHorizontalRadius) != 0) {
            return false;
        }
        if (this.bottomRightHorizontalRadiusAsPercentage != that.bottomRightHorizontalRadiusAsPercentage) {
            return false;
        }
        if (Double.compare(that.topLeftVerticalRadius, this.topLeftVerticalRadius) != 0) {
            return false;
        }
        if (this.topLeftVerticalRadiusAsPercentage != that.topLeftVerticalRadiusAsPercentage) {
            return false;
        }
        if (Double.compare(that.topLeftHorizontalRadius, this.topLeftHorizontalRadius) != 0) {
            return false;
        }
        if (this.topLeftHorizontalRadiusAsPercentage != that.topLeftHorizontalRadiusAsPercentage) {
            return false;
        }
        if (Double.compare(that.topRightHorizontalRadius, this.topRightHorizontalRadius) != 0) {
            return false;
        }
        if (this.topRightHorizontalRadiusAsPercentage != that.topRightHorizontalRadiusAsPercentage) {
            return false;
        }
        if (Double.compare(that.topRightVerticalRadius, this.topRightVerticalRadius) != 0) {
            return false;
        }
        return this.topRightVerticalRadiusAsPercentage == that.topRightVerticalRadiusAsPercentage;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        if (this.isUniform()) {
            return "CornerRadii [uniform radius = " + this.topLeftHorizontalRadius + "]";
        }
        return "CornerRadii [" + (this.topLeftHorizontalRadius == this.topLeftVerticalRadius ? "topLeft=" + this.topLeftHorizontalRadius : "topLeftHorizontalRadius=" + this.topLeftHorizontalRadius + ", topLeftVerticalRadius=" + this.topLeftVerticalRadius) + (this.topRightHorizontalRadius == this.topRightVerticalRadius ? ", topRight=" + this.topRightHorizontalRadius : ", topRightVerticalRadius=" + this.topRightVerticalRadius + ", topRightHorizontalRadius=" + this.topRightHorizontalRadius) + (this.bottomRightHorizontalRadius == this.bottomRightVerticalRadius ? ", bottomRight=" + this.bottomRightHorizontalRadius : ", bottomRightHorizontalRadius=" + this.bottomRightHorizontalRadius + ", bottomRightVerticalRadius=" + this.bottomRightVerticalRadius) + (this.bottomLeftHorizontalRadius == this.bottomLeftVerticalRadius ? ", bottomLeft=" + this.bottomLeftHorizontalRadius : ", bottomLeftVerticalRadius=" + this.bottomLeftVerticalRadius + ", bottomLeftHorizontalRadius=" + this.bottomLeftHorizontalRadius) + ']';
    }
}

