/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.NamedArg;
import javafx.geometry.Side;

public class BackgroundPosition {
    public static final BackgroundPosition DEFAULT = new BackgroundPosition(Side.LEFT, 0.0, true, Side.TOP, 0.0, true);
    public static final BackgroundPosition CENTER = new BackgroundPosition(Side.LEFT, 0.5, true, Side.TOP, 0.5, true);
    final Side horizontalSide;
    final Side verticalSide;
    final double horizontalPosition;
    final double verticalPosition;
    final boolean horizontalAsPercentage;
    final boolean verticalAsPercentage;
    private final int hash;

    public final Side getHorizontalSide() {
        return this.horizontalSide;
    }

    public final Side getVerticalSide() {
        return this.verticalSide;
    }

    public final double getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public final double getVerticalPosition() {
        return this.verticalPosition;
    }

    public final boolean isHorizontalAsPercentage() {
        return this.horizontalAsPercentage;
    }

    public final boolean isVerticalAsPercentage() {
        return this.verticalAsPercentage;
    }

    public BackgroundPosition(@NamedArg(value="horizontalSide") Side horizontalSide, @NamedArg(value="horizontalPosition") double horizontalPosition, @NamedArg(value="horizontalAsPercentage") boolean horizontalAsPercentage, @NamedArg(value="verticalSide") Side verticalSide, @NamedArg(value="verticalPosition") double verticalPosition, @NamedArg(value="verticalAsPercentage") boolean verticalAsPercentage) {
        if (horizontalSide == Side.TOP || horizontalSide == Side.BOTTOM) {
            throw new IllegalArgumentException("The horizontalSide must be LEFT or RIGHT");
        }
        if (verticalSide == Side.LEFT || verticalSide == Side.RIGHT) {
            throw new IllegalArgumentException("The verticalSide must be TOP or BOTTOM");
        }
        this.horizontalSide = horizontalSide == null ? Side.LEFT : horizontalSide;
        this.verticalSide = verticalSide == null ? Side.TOP : verticalSide;
        this.horizontalPosition = horizontalPosition;
        this.verticalPosition = verticalPosition;
        this.horizontalAsPercentage = horizontalAsPercentage;
        this.verticalAsPercentage = verticalAsPercentage;
        int result = this.horizontalSide.hashCode();
        result = 31 * result + this.verticalSide.hashCode();
        long temp = this.horizontalPosition != 0.0 ? Double.doubleToLongBits(this.horizontalPosition) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.verticalPosition != 0.0 ? Double.doubleToLongBits(this.verticalPosition) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.horizontalAsPercentage ? 1 : 0);
        this.hash = result = 31 * result + (this.verticalAsPercentage ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundPosition that = (BackgroundPosition)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (this.horizontalAsPercentage != that.horizontalAsPercentage) {
            return false;
        }
        if (Double.compare(that.horizontalPosition, this.horizontalPosition) != 0) {
            return false;
        }
        if (this.verticalAsPercentage != that.verticalAsPercentage) {
            return false;
        }
        if (Double.compare(that.verticalPosition, this.verticalPosition) != 0) {
            return false;
        }
        if (this.horizontalSide != that.horizontalSide) {
            return false;
        }
        return this.verticalSide == that.verticalSide;
    }

    public int hashCode() {
        return this.hash;
    }
}

