/*
 * Decompiled with CFR 0.152.
 */
package javafx.print;

public final class PrintResolution {
    private int cfRes;
    private int fRes;

    PrintResolution(int crossFeedResolution, int feedResolution) throws IllegalArgumentException {
        if (crossFeedResolution <= 0 || feedResolution <= 0) {
            throw new IllegalArgumentException("Values must be positive");
        }
        this.cfRes = crossFeedResolution;
        this.fRes = feedResolution;
    }

    public int getCrossFeedResolution() {
        return this.cfRes;
    }

    public int getFeedResolution() {
        return this.fRes;
    }

    public boolean equals(Object o) {
        try {
            PrintResolution other = (PrintResolution)o;
            return this.cfRes == other.cfRes && this.fRes == other.fRes;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.cfRes << 16 | this.fRes;
    }

    public String toString() {
        return "Feed res=" + this.fRes + "dpi. Cross Feed res=" + this.cfRes + "dpi.";
    }
}

