/*
 * Decompiled with CFR 0.152.
 */
package javafx.concurrent;

import java.security.AccessController;
import java.security.Permission;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.EventHelper;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;

public abstract class Task<V>
extends FutureTask<V>
implements Worker<V>,
EventTarget {
    private AtomicReference<ProgressUpdate> progressUpdate = new AtomicReference();
    private AtomicReference<String> messageUpdate = new AtomicReference();
    private AtomicReference<String> titleUpdate = new AtomicReference();
    private AtomicReference<V> valueUpdate = new AtomicReference();
    private volatile boolean started = false;
    private ObjectProperty<Worker.State> state = new SimpleObjectProperty<Worker.State>(this, "state", Worker.State.READY);
    private final ObjectProperty<V> value = new SimpleObjectProperty<V>(this, "value");
    private final ObjectProperty<Throwable> exception = new SimpleObjectProperty<Throwable>(this, "exception");
    private final DoubleProperty workDone = new SimpleDoubleProperty(this, "workDone", -1.0);
    private final DoubleProperty totalWork = new SimpleDoubleProperty(this, "totalWork", -1.0);
    private final DoubleProperty progress = new SimpleDoubleProperty(this, "progress", -1.0);
    private final BooleanProperty running = new SimpleBooleanProperty(this, "running", false);
    private final StringProperty message = new SimpleStringProperty(this, "message", "");
    private final StringProperty title = new SimpleStringProperty(this, "title", "");
    private static final Permission modifyThreadPerm = new RuntimePermission("modifyThread");
    private EventHelper eventHelper = null;

    public Task() {
        this(new TaskCallable());
    }

    private Task(TaskCallable<V> callableAdapter) {
        super(callableAdapter);
        ((TaskCallable)callableAdapter).task = this;
    }

    protected abstract V call() throws Exception;

    final void setState(Worker.State value) {
        this.checkThread();
        Worker.State s = this.getState();
        if (s != Worker.State.CANCELLED) {
            this.state.set(value);
            this.setRunning(value == Worker.State.SCHEDULED || value == Worker.State.RUNNING);
            switch ((Worker.State)((Object)this.state.get())) {
                case CANCELLED: {
                    this.fireEvent(new WorkerStateEvent(this, WorkerStateEvent.WORKER_STATE_CANCELLED));
                    this.cancelled();
                    break;
                }
                case FAILED: {
                    this.fireEvent(new WorkerStateEvent(this, WorkerStateEvent.WORKER_STATE_FAILED));
                    this.failed();
                    break;
                }
                case READY: {
                    break;
                }
                case RUNNING: {
                    this.fireEvent(new WorkerStateEvent(this, WorkerStateEvent.WORKER_STATE_RUNNING));
                    this.running();
                    break;
                }
                case SCHEDULED: {
                    this.fireEvent(new WorkerStateEvent(this, WorkerStateEvent.WORKER_STATE_SCHEDULED));
                    this.scheduled();
                    break;
                }
                case SUCCEEDED: {
                    this.fireEvent(new WorkerStateEvent(this, WorkerStateEvent.WORKER_STATE_SUCCEEDED));
                    this.succeeded();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should be unreachable");
                }
            }
        }
    }

    @Override
    public final Worker.State getState() {
        this.checkThread();
        return (Worker.State)((Object)this.state.get());
    }

    @Override
    public final ReadOnlyObjectProperty<Worker.State> stateProperty() {
        this.checkThread();
        return this.state;
    }

    public final ObjectProperty<EventHandler<WorkerStateEvent>> onScheduledProperty() {
        this.checkThread();
        return this.getEventHelper().onScheduledProperty();
    }

    public final EventHandler<WorkerStateEvent> getOnScheduled() {
        this.checkThread();
        return this.eventHelper == null ? null : this.eventHelper.getOnScheduled();
    }

    public final void setOnScheduled(EventHandler<WorkerStateEvent> value) {
        this.checkThread();
        this.getEventHelper().setOnScheduled(value);
    }

    protected void scheduled() {
    }

    public final ObjectProperty<EventHandler<WorkerStateEvent>> onRunningProperty() {
        this.checkThread();
        return this.getEventHelper().onRunningProperty();
    }

    public final EventHandler<WorkerStateEvent> getOnRunning() {
        this.checkThread();
        return this.eventHelper == null ? null : this.eventHelper.getOnRunning();
    }

    public final void setOnRunning(EventHandler<WorkerStateEvent> value) {
        this.checkThread();
        this.getEventHelper().setOnRunning(value);
    }

    protected void running() {
    }

    public final ObjectProperty<EventHandler<WorkerStateEvent>> onSucceededProperty() {
        this.checkThread();
        return this.getEventHelper().onSucceededProperty();
    }

    public final EventHandler<WorkerStateEvent> getOnSucceeded() {
        this.checkThread();
        return this.eventHelper == null ? null : this.eventHelper.getOnSucceeded();
    }

    public final void setOnSucceeded(EventHandler<WorkerStateEvent> value) {
        this.checkThread();
        this.getEventHelper().setOnSucceeded(value);
    }

    protected void succeeded() {
    }

    public final ObjectProperty<EventHandler<WorkerStateEvent>> onCancelledProperty() {
        this.checkThread();
        return this.getEventHelper().onCancelledProperty();
    }

    public final EventHandler<WorkerStateEvent> getOnCancelled() {
        this.checkThread();
        return this.eventHelper == null ? null : this.eventHelper.getOnCancelled();
    }

    public final void setOnCancelled(EventHandler<WorkerStateEvent> value) {
        this.checkThread();
        this.getEventHelper().setOnCancelled(value);
    }

    protected void cancelled() {
    }

    public final ObjectProperty<EventHandler<WorkerStateEvent>> onFailedProperty() {
        this.checkThread();
        return this.getEventHelper().onFailedProperty();
    }

    public final EventHandler<WorkerStateEvent> getOnFailed() {
        this.checkThread();
        return this.eventHelper == null ? null : this.eventHelper.getOnFailed();
    }

    public final void setOnFailed(EventHandler<WorkerStateEvent> value) {
        this.checkThread();
        this.getEventHelper().setOnFailed(value);
    }

    protected void failed() {
    }

    private void setValue(V v) {
        this.checkThread();
        this.value.set(v);
    }

    @Override
    public final V getValue() {
        this.checkThread();
        return (V)this.value.get();
    }

    @Override
    public final ReadOnlyObjectProperty<V> valueProperty() {
        this.checkThread();
        return this.value;
    }

    private void _setException(Throwable value) {
        this.checkThread();
        this.exception.set(value);
    }

    @Override
    public final Throwable getException() {
        this.checkThread();
        return (Throwable)this.exception.get();
    }

    @Override
    public final ReadOnlyObjectProperty<Throwable> exceptionProperty() {
        this.checkThread();
        return this.exception;
    }

    private void setWorkDone(double value) {
        this.checkThread();
        this.workDone.set(value);
    }

    @Override
    public final double getWorkDone() {
        this.checkThread();
        return this.workDone.get();
    }

    @Override
    public final ReadOnlyDoubleProperty workDoneProperty() {
        this.checkThread();
        return this.workDone;
    }

    private void setTotalWork(double value) {
        this.checkThread();
        this.totalWork.set(value);
    }

    @Override
    public final double getTotalWork() {
        this.checkThread();
        return this.totalWork.get();
    }

    @Override
    public final ReadOnlyDoubleProperty totalWorkProperty() {
        this.checkThread();
        return this.totalWork;
    }

    private void setProgress(double value) {
        this.checkThread();
        this.progress.set(value);
    }

    @Override
    public final double getProgress() {
        this.checkThread();
        return this.progress.get();
    }

    @Override
    public final ReadOnlyDoubleProperty progressProperty() {
        this.checkThread();
        return this.progress;
    }

    private void setRunning(boolean value) {
        this.checkThread();
        this.running.set(value);
    }

    @Override
    public final boolean isRunning() {
        this.checkThread();
        return this.running.get();
    }

    @Override
    public final ReadOnlyBooleanProperty runningProperty() {
        this.checkThread();
        return this.running;
    }

    @Override
    public final String getMessage() {
        this.checkThread();
        return (String)this.message.get();
    }

    @Override
    public final ReadOnlyStringProperty messageProperty() {
        this.checkThread();
        return this.message;
    }

    @Override
    public final String getTitle() {
        this.checkThread();
        return (String)this.title.get();
    }

    @Override
    public final ReadOnlyStringProperty titleProperty() {
        this.checkThread();
        return this.title;
    }

    @Override
    public final boolean cancel() {
        return this.cancel(true);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean flag = AccessController.doPrivileged(() -> super.cancel(mayInterruptIfRunning), null, modifyThreadPerm);
        if (flag) {
            if (this.isFxApplicationThread()) {
                this.setState(Worker.State.CANCELLED);
            } else {
                this.runLater(() -> this.setState(Worker.State.CANCELLED));
            }
        }
        return flag;
    }

    protected void updateProgress(long workDone, long max) {
        this.updateProgress((double)workDone, (double)max);
    }

    protected void updateProgress(double workDone, double max) {
        if (Double.isInfinite(workDone) || Double.isNaN(workDone)) {
            workDone = -1.0;
        }
        if (Double.isInfinite(max) || Double.isNaN(max)) {
            max = -1.0;
        }
        if (workDone < 0.0) {
            workDone = -1.0;
        }
        if (max < 0.0) {
            max = -1.0;
        }
        if (workDone > max) {
            workDone = max;
        }
        if (this.isFxApplicationThread()) {
            this._updateProgress(workDone, max);
        } else if (this.progressUpdate.getAndSet(new ProgressUpdate(workDone, max)) == null) {
            this.runLater(() -> {
                ProgressUpdate update = this.progressUpdate.getAndSet(null);
                this._updateProgress(update.workDone, update.totalWork);
            });
        }
    }

    private void _updateProgress(double workDone, double max) {
        this.setTotalWork(max);
        this.setWorkDone(workDone);
        if (workDone == -1.0) {
            this.setProgress(-1.0);
        } else {
            this.setProgress(workDone / max);
        }
    }

    protected void updateMessage(String message) {
        if (this.isFxApplicationThread()) {
            this.message.set(message);
        } else if (this.messageUpdate.getAndSet(message) == null) {
            this.runLater(new Runnable(){

                @Override
                public void run() {
                    String message = Task.this.messageUpdate.getAndSet(null);
                    Task.this.message.set(message);
                }
            });
        }
    }

    protected void updateTitle(String title) {
        if (this.isFxApplicationThread()) {
            this.title.set(title);
        } else if (this.titleUpdate.getAndSet(title) == null) {
            this.runLater(new Runnable(){

                @Override
                public void run() {
                    String title = Task.this.titleUpdate.getAndSet(null);
                    Task.this.title.set(title);
                }
            });
        }
    }

    protected void updateValue(V value) {
        if (this.isFxApplicationThread()) {
            this.value.set(value);
        } else if (this.valueUpdate.getAndSet(value) == null) {
            this.runLater(() -> this.value.set(this.valueUpdate.getAndSet(null)));
        }
    }

    private void checkThread() {
        if (this.started && !this.isFxApplicationThread()) {
            throw new IllegalStateException("Task must only be used from the FX Application Thread");
        }
    }

    void runLater(Runnable r) {
        Platform.runLater(r);
    }

    boolean isFxApplicationThread() {
        return Platform.isFxApplicationThread();
    }

    private EventHelper getEventHelper() {
        if (this.eventHelper == null) {
            this.eventHelper = new EventHelper(this);
        }
        return this.eventHelper;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.checkThread();
        this.getEventHelper().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.checkThread();
        this.getEventHelper().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.checkThread();
        this.getEventHelper().addEventFilter(eventType, eventFilter);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.checkThread();
        this.getEventHelper().removeEventFilter(eventType, eventFilter);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.checkThread();
        this.getEventHelper().setEventHandler(eventType, eventHandler);
    }

    public final void fireEvent(Event event) {
        this.checkThread();
        this.getEventHelper().fireEvent(event);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        this.checkThread();
        return this.getEventHelper().buildEventDispatchChain(tail);
    }

    private static final class TaskCallable<V>
    implements Callable<V> {
        private Task<V> task;

        private TaskCallable() {
        }

        @Override
        public V call() throws Exception {
            ((Task)this.task).started = true;
            this.task.runLater(() -> {
                this.task.setState(Worker.State.SCHEDULED);
                this.task.setState(Worker.State.RUNNING);
            });
            try {
                V result = this.task.call();
                if (!this.task.isCancelled()) {
                    this.task.runLater(() -> {
                        this.task.updateValue(result);
                        this.task.setState(Worker.State.SUCCEEDED);
                    });
                    return result;
                }
                return null;
            }
            catch (Throwable th) {
                this.task.runLater(() -> {
                    ((Task)this.task)._setException(th);
                    this.task.setState(Worker.State.FAILED);
                });
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw new Exception(th);
            }
        }
    }

    private static final class ProgressUpdate {
        private final double workDone;
        private final double totalWork;

        private ProgressUpdate(double p, double m) {
            this.workDone = p;
            this.totalWork = m;
        }
    }
}

