/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.LinkedList;

final class DataURLConnection
extends URLConnection {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final String mediaType;
    private final byte[] data;
    private final InputStream inputStream;

    DataURLConnection(URL url) throws IOException {
        super(url);
        String s;
        String content = url.toString();
        content = content.substring(content.indexOf(58) + 1);
        int commaPosition = content.indexOf(44);
        if (commaPosition < 0) {
            throw new ProtocolException("Invalid URL, ',' not found in: " + this.getURL());
        }
        String metadata = content.substring(0, commaPosition);
        String dataString = content.substring(commaPosition + 1);
        String mimeType = null;
        LinkedList<String> parameters = new LinkedList<String>();
        Charset charset = null;
        boolean base64 = false;
        String[] components = metadata.split(";", -1);
        for (int i = 0; i < components.length; ++i) {
            String component = components[i];
            if (component.equalsIgnoreCase("base64")) {
                base64 = true;
                continue;
            }
            if (i == 0 && !component.contains("=")) {
                mimeType = component;
                continue;
            }
            parameters.add(component);
            if (!component.toLowerCase().startsWith("charset=")) continue;
            try {
                charset = Charset.forName(component.substring(8));
                continue;
            }
            catch (IllegalArgumentException ex) {
                UnsupportedEncodingException ex2 = new UnsupportedEncodingException();
                ex2.initCause(ex);
                throw ex2;
            }
        }
        if (mimeType == null || mimeType.isEmpty()) {
            mimeType = "text/plain";
        }
        if (charset == null) {
            charset = US_ASCII;
            if (mimeType.toLowerCase().startsWith("text/")) {
                parameters.addFirst("charset=" + charset.name());
            }
        }
        StringBuilder mediaTypeBuilder = new StringBuilder();
        mediaTypeBuilder.append(mimeType);
        for (String parameter : parameters) {
            mediaTypeBuilder.append(';').append(parameter);
        }
        this.mediaType = mediaTypeBuilder.toString();
        if (base64) {
            s = DataURLConnection.urlDecode(dataString, US_ASCII);
            s = s.replaceAll("\\s+", "");
            this.data = Base64.getMimeDecoder().decode(s);
        } else {
            s = DataURLConnection.urlDecode(dataString, charset);
            this.data = s.getBytes(charset);
        }
        this.inputStream = new ByteArrayInputStream(this.data);
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return this.mediaType;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public int getContentLength() {
        return this.data != null ? this.data.length : -1;
    }

    private static String urlDecode(String str, Charset charset) {
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        byte[] bytes = null;
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (c == '%') {
                if (bytes == null) {
                    bytes = new byte[(length - i) / 3];
                }
                int count = 0;
                int proceedTo = i;
                while (i < length && (c = str.charAt(i)) == '%') {
                    byte b;
                    if (i + 2 >= length) {
                        proceedTo = length;
                        break;
                    }
                    try {
                        b = (byte)Integer.parseInt(str.substring(i + 1, i + 3), 16);
                    }
                    catch (NumberFormatException ex) {
                        proceedTo = i + 3;
                        break;
                    }
                    bytes[count++] = b;
                    i += 3;
                }
                if (count > 0) {
                    sb.append(new String(bytes, 0, count, charset));
                }
                while (i < proceedTo) {
                    sb.append(str.charAt(i++));
                }
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }
}

