/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import org.w3c.dom.xpath.XPathNSResolver;

public class XPathNSResolverImpl
implements XPathNSResolver {
    private final long peer;

    XPathNSResolverImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static XPathNSResolver create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new XPathNSResolverImpl(peer);
    }

    long getPeer() {
        return this.peer;
    }

    public boolean equals(Object that) {
        return that instanceof XPathNSResolverImpl && this.peer == ((XPathNSResolverImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    static long getPeer(XPathNSResolver arg) {
        return arg == null ? 0L : ((XPathNSResolverImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static XPathNSResolver getImpl(long peer) {
        return XPathNSResolverImpl.create(peer);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return XPathNSResolverImpl.lookupNamespaceURIImpl(this.getPeer(), prefix);
    }

    static native String lookupNamespaceURIImpl(long var0, String var2);

    private static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            XPathNSResolverImpl.dispose(this.peer);
        }
    }
}

