/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.LinearConvolveRenderState;
import com.sun.scenario.effect.impl.state.RenderState;
import java.nio.FloatBuffer;

public class BoxRenderState
extends LinearConvolveRenderState {
    private static final int[] MAX_BOX_SIZES = new int[]{BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 0), BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 1), BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 2), BoxRenderState.getMaxSizeForKernelSize(MAX_KERNEL_SIZE, 3)};
    private final boolean isShadow;
    private final int blurPasses;
    private final float spread;
    private Color4f shadowColor;
    private RenderState.EffectCoordinateSpace space;
    private BaseTransform inputtx;
    private BaseTransform resulttx;
    private final float inputSizeH;
    private final float inputSizeV;
    private final int spreadPass;
    private float[] samplevectors;
    private int validatedPass;
    private float passSize;
    private FloatBuffer weights;
    private float weightsValidSize;
    private float weightsValidSpread;
    private boolean swCompatible;

    public static int getMaxSizeForKernelSize(int kernelSize, int blurPasses) {
        if (blurPasses == 0) {
            return Integer.MAX_VALUE;
        }
        int passSize = kernelSize - 1 | 1;
        passSize = (passSize - 1) / blurPasses | 1;
        assert (BoxRenderState.getKernelSize(passSize, blurPasses) <= kernelSize);
        return passSize;
    }

    public static int getKernelSize(int passSize, int blurPasses) {
        int kernelSize = passSize < 1 ? 1 : passSize;
        kernelSize = (kernelSize - 1) * blurPasses + 1;
        return kernelSize |= 1;
    }

    public BoxRenderState(float hsize, float vsize, int blurPasses, float spread, boolean isShadow, Color4f shadowColor, BaseTransform filtertx) {
        boolean custom;
        this.isShadow = isShadow;
        this.shadowColor = shadowColor;
        this.spread = spread;
        this.blurPasses = blurPasses;
        if (filtertx == null) {
            filtertx = BaseTransform.IDENTITY_TRANSFORM;
        }
        double txScaleX = Math.hypot(filtertx.getMxx(), filtertx.getMyx());
        double txScaleY = Math.hypot(filtertx.getMxy(), filtertx.getMyy());
        float fSizeH = (float)((double)hsize * txScaleX);
        float fSizeV = (float)((double)vsize * txScaleY);
        int maxPassSize = MAX_BOX_SIZES[blurPasses];
        if (fSizeH > (float)maxPassSize) {
            txScaleX = (float)maxPassSize / hsize;
            fSizeH = maxPassSize;
        }
        if (fSizeV > (float)maxPassSize) {
            txScaleY = (float)maxPassSize / vsize;
            fSizeV = maxPassSize;
        }
        this.inputSizeH = fSizeH;
        this.inputSizeV = fSizeV;
        this.spreadPass = fSizeV > 1.0f ? 1 : 0;
        boolean bl = custom = txScaleX != filtertx.getMxx() || 0.0 != filtertx.getMyx() || txScaleY != filtertx.getMyy() || 0.0 != filtertx.getMxy();
        if (custom) {
            this.space = RenderState.EffectCoordinateSpace.CustomSpace;
            this.inputtx = BaseTransform.getScaleInstance(txScaleX, txScaleY);
            this.resulttx = filtertx.copy().deriveWithScale(1.0 / txScaleX, 1.0 / txScaleY, 1.0);
        } else {
            this.space = RenderState.EffectCoordinateSpace.RenderSpace;
            this.inputtx = filtertx;
            this.resulttx = BaseTransform.IDENTITY_TRANSFORM;
        }
    }

    public int getBoxPixelSize(int pass) {
        float size = this.passSize;
        if (size < 1.0f) {
            size = 1.0f;
        }
        int boxsize = (int)Math.ceil(size) | 1;
        return boxsize;
    }

    public int getBlurPasses() {
        return this.blurPasses;
    }

    public float getSpread() {
        return this.spread;
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public Color4f getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public float[] getPassShadowColorComponents() {
        return this.validatedPass == 0 ? BLACK_COMPONENTS : this.shadowColor.getPremultipliedRGBComponents();
    }

    @Override
    public RenderState.EffectCoordinateSpace getEffectTransformSpace() {
        return this.space;
    }

    @Override
    public BaseTransform getInputTransform(BaseTransform filterTransform) {
        return this.inputtx;
    }

    @Override
    public BaseTransform getResultTransform(BaseTransform filterTransform) {
        return this.resulttx;
    }

    public EffectPeer<BoxRenderState> getPassPeer(Renderer r, FilterContext fctx) {
        String name;
        if (this.isPassNop()) {
            return null;
        }
        int ksize = this.getPassKernelSize();
        int psize = BoxRenderState.getPeerSize(ksize);
        Effect.AccelType actype = r.getAccelType();
        switch (actype) {
            case NONE: 
            case SIMD: {
                if (this.swCompatible && this.spread == 0.0f) {
                    name = this.isShadow() ? "BoxShadow" : "BoxBlur";
                    break;
                }
            }
            default: {
                name = this.isShadow() ? "LinearConvolveShadow" : "LinearConvolve";
            }
        }
        EffectPeer peer = r.getPeerInstance(fctx, name, psize);
        return peer;
    }

    @Override
    public Rectangle getInputClip(int i, Rectangle filterClip) {
        int klenv;
        int klenh;
        if (filterClip != null && ((klenh = this.getInputKernelSize(0)) | (klenv = this.getInputKernelSize(1))) > 1) {
            filterClip = new Rectangle(filterClip);
            filterClip.grow(klenh / 2, klenv / 2);
        }
        return filterClip;
    }

    @Override
    public ImageData validatePassInput(ImageData src, int pass) {
        float iSize;
        this.validatedPass = pass;
        BaseTransform srcTx = src.getTransform();
        this.samplevectors = new float[2];
        this.samplevectors[pass] = 1.0f;
        float f = iSize = pass == 0 ? this.inputSizeH : this.inputSizeV;
        if (srcTx.isTranslateOrIdentity()) {
            this.swCompatible = true;
            this.passSize = iSize;
        } else {
            try {
                srcTx.inverseDeltaTransform(this.samplevectors, 0, this.samplevectors, 0, 1);
            }
            catch (NoninvertibleTransformException ex) {
                this.passSize = 0.0f;
                this.samplevectors[1] = 0.0f;
                this.samplevectors[0] = 0.0f;
                this.swCompatible = true;
                return src;
            }
            double srcScale = Math.hypot(this.samplevectors[0], this.samplevectors[1]);
            float pSize = (float)((double)iSize * srcScale);
            pSize = (float)((double)pSize * srcScale);
            int maxPassSize = MAX_BOX_SIZES[this.blurPasses];
            if (pSize > (float)maxPassSize) {
                pSize = maxPassSize;
                srcScale = (float)maxPassSize / iSize;
            }
            this.passSize = pSize;
            this.samplevectors[0] = (float)((double)this.samplevectors[0] / srcScale);
            this.samplevectors[1] = (float)((double)this.samplevectors[1] / srcScale);
            Rectangle srcSize = src.getUntransformedBounds();
            this.swCompatible = pass == 0 ? BoxRenderState.nearOne(this.samplevectors[0], srcSize.width) && BoxRenderState.nearZero(this.samplevectors[1], srcSize.width) : BoxRenderState.nearZero(this.samplevectors[0], srcSize.height) && BoxRenderState.nearOne(this.samplevectors[1], srcSize.height);
        }
        Filterable f2 = src.getUntransformedImage();
        this.samplevectors[0] = this.samplevectors[0] / (float)f2.getPhysicalWidth();
        this.samplevectors[1] = this.samplevectors[1] / (float)f2.getPhysicalHeight();
        return src;
    }

    @Override
    public Rectangle getPassResultBounds(Rectangle srcdimension, Rectangle outputClip) {
        Rectangle ret = new Rectangle(srcdimension);
        if (this.validatedPass == 0) {
            ret.grow(this.getInputKernelSize(0) / 2, 0);
        } else {
            ret.grow(0, this.getInputKernelSize(1) / 2);
        }
        if (outputClip != null) {
            if (this.validatedPass == 0) {
                outputClip = new Rectangle(outputClip);
                outputClip.grow(0, this.getInputKernelSize(1) / 2);
            }
            ret.intersectWith(outputClip);
        }
        return ret;
    }

    @Override
    public float[] getPassVector() {
        float xoff = this.samplevectors[0];
        float yoff = this.samplevectors[1];
        int ksize = this.getPassKernelSize();
        int center = ksize / 2;
        float[] ret = new float[]{xoff, yoff, (float)(-center) * xoff, (float)(-center) * yoff};
        return ret;
    }

    @Override
    public int getPassWeightsArrayLength() {
        this.validateWeights();
        return this.weights.limit() / 4;
    }

    @Override
    public FloatBuffer getPassWeights() {
        this.validateWeights();
        this.weights.rewind();
        return this.weights;
    }

    private void validateWeights() {
        int i;
        int klen;
        float passSpread;
        float pSize;
        if (this.blurPasses == 0) {
            pSize = 1.0f;
        } else {
            pSize = this.passSize;
            if (pSize < 1.0f) {
                pSize = 1.0f;
            }
        }
        float f = passSpread = this.validatedPass == this.spreadPass ? this.spread : 0.0f;
        if (this.weights != null && this.weightsValidSize == pSize && this.weightsValidSpread == passSpread) {
            return;
        }
        int totalklen = klen = (int)Math.ceil(pSize) | 1;
        for (int p = 1; p < this.blurPasses; ++p) {
            totalklen += klen - 1;
        }
        double[] ik = new double[totalklen];
        for (int i2 = 0; i2 < klen; ++i2) {
            ik[i2] = 1.0;
        }
        double excess = (float)klen - pSize;
        if (excess > 0.0) {
            double d = 1.0 - excess * 0.5;
            ik[klen - 1] = d;
            ik[0] = d;
        }
        int filledklen = klen;
        for (int p = 1; p < this.blurPasses; ++p) {
            int k;
            double sum;
            int i3 = (filledklen += klen - 1) - 1;
            while (i3 > klen) {
                sum = ik[i3];
                for (k = 1; k < klen; ++k) {
                    sum += ik[i3 - k];
                }
                ik[i3--] = sum;
            }
            while (i3 > 0) {
                sum = ik[i3];
                for (k = 0; k < i3; ++k) {
                    sum += ik[k];
                }
                ik[i3--] = sum;
            }
        }
        double sum = 0.0;
        for (i = 0; i < ik.length; ++i) {
            sum += ik[i];
        }
        sum += (1.0 - sum) * (double)passSpread;
        if (this.weights == null) {
            int maxbufsize = BoxRenderState.getPeerSize(MAX_KERNEL_SIZE);
            maxbufsize = maxbufsize + 3 & 0xFFFFFFFC;
            this.weights = BufferUtil.newFloatBuffer(maxbufsize);
        }
        this.weights.clear();
        for (i = 0; i < ik.length; ++i) {
            this.weights.put((float)(ik[i] / sum));
        }
        int limit = BoxRenderState.getPeerSize(ik.length);
        while (this.weights.position() < limit) {
            this.weights.put(0.0f);
        }
        this.weights.limit(limit);
        this.weights.rewind();
    }

    @Override
    public int getInputKernelSize(int pass) {
        float size;
        float f = size = pass == 0 ? this.inputSizeH : this.inputSizeV;
        if (size < 1.0f) {
            size = 1.0f;
        }
        int klen = (int)Math.ceil(size) | 1;
        int totalklen = 1;
        for (int p = 0; p < this.blurPasses; ++p) {
            totalklen += klen - 1;
        }
        return totalklen;
    }

    @Override
    public int getPassKernelSize() {
        float size = this.passSize;
        if (size < 1.0f) {
            size = 1.0f;
        }
        int klen = (int)Math.ceil(size) | 1;
        int totalklen = 1;
        for (int p = 0; p < this.blurPasses; ++p) {
            totalklen += klen - 1;
        }
        return totalklen;
    }

    @Override
    public boolean isNop() {
        if (this.isShadow) {
            return false;
        }
        return this.blurPasses == 0 || this.inputSizeH <= 1.0f && this.inputSizeV <= 1.0f;
    }

    @Override
    public boolean isPassNop() {
        if (this.isShadow && this.validatedPass == 1) {
            return false;
        }
        return this.blurPasses == 0 || this.passSize <= 1.0f;
    }
}

