/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.util.Logging;
import com.sun.openpisces.Renderer;
import com.sun.pisces.PiscesRenderer;
import com.sun.prism.BasicStroke;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.OpenPiscesPrismUtils;
import com.sun.prism.impl.shape.ShapeUtil;
import com.sun.prism.sw.DirectRTPiscesAlphaConsumer;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWMaskTexture;
import com.sun.prism.sw.SWRTTexture;
import java.lang.ref.SoftReference;

final class SWContext {
    private final ResourceFactory factory;
    private final ShapeRenderer shapeRenderer;
    private SoftReference<SWRTTexture> readBackBufferRef;
    private SoftReference<SWArgbPreTexture> imagePaintTextureRef;

    SWContext(ResourceFactory factory) {
        this.factory = factory;
        this.shapeRenderer = PrismSettings.doNativePisces ? new NativeShapeRenderer() : new JavaShapeRenderer();
    }

    void renderShape(PiscesRenderer pr, Shape shape, BasicStroke stroke, BaseTransform tr, Rectangle clip, boolean antialiasedShape) {
        this.shapeRenderer.renderShape(pr, shape, stroke, tr, clip, antialiasedShape);
    }

    private SWRTTexture initRBBuffer(int width, int height) {
        SWRTTexture tex = (SWRTTexture)this.factory.createRTTexture(width, height, Texture.WrapMode.CLAMP_NOT_NEEDED);
        this.readBackBufferRef = new SoftReference<SWRTTexture>(tex);
        return tex;
    }

    private void disposeRBBuffer() {
        if (this.readBackBufferRef != null) {
            this.readBackBufferRef.clear();
            this.readBackBufferRef = null;
        }
    }

    SWRTTexture validateRBBuffer(int width, int height) {
        SWRTTexture tex;
        if (this.readBackBufferRef == null) {
            tex = this.initRBBuffer(width, height);
        } else {
            tex = this.readBackBufferRef.get();
            if (tex == null || tex.getPhysicalWidth() < width || tex.getPhysicalHeight() < height) {
                this.disposeRBBuffer();
                tex = this.initRBBuffer(width, height);
            }
            tex.setContentWidth(width);
            tex.setContentHeight(height);
        }
        return tex;
    }

    private SWArgbPreTexture initImagePaintTexture(int width, int height) {
        SWArgbPreTexture tex = (SWArgbPreTexture)this.factory.createTexture(PixelFormat.INT_ARGB_PRE, Texture.Usage.DEFAULT, Texture.WrapMode.REPEAT, width, height);
        this.imagePaintTextureRef = new SoftReference<SWArgbPreTexture>(tex);
        return tex;
    }

    private void disposeImagePaintTexture() {
        if (this.imagePaintTextureRef != null) {
            this.imagePaintTextureRef.clear();
            this.imagePaintTextureRef = null;
        }
    }

    SWArgbPreTexture validateImagePaintTexture(int width, int height) {
        SWArgbPreTexture tex;
        if (this.imagePaintTextureRef == null) {
            tex = this.initImagePaintTexture(width, height);
        } else {
            tex = this.imagePaintTextureRef.get();
            if (tex == null || tex.getPhysicalWidth() < width || tex.getPhysicalHeight() < height) {
                this.disposeImagePaintTexture();
                tex = this.initImagePaintTexture(width, height);
            }
            tex.setContentWidth(width);
            tex.setContentHeight(height);
        }
        return tex;
    }

    void dispose() {
        this.disposeRBBuffer();
        this.disposeImagePaintTexture();
        this.shapeRenderer.dispose();
    }

    class JavaShapeRenderer
    implements ShapeRenderer {
        private final DirectRTPiscesAlphaConsumer alphaConsumer = new DirectRTPiscesAlphaConsumer();

        JavaShapeRenderer() {
        }

        @Override
        public void renderShape(PiscesRenderer pr, Shape shape, BasicStroke stroke, BaseTransform tr, Rectangle clip, boolean antialiasedShape) {
            if (stroke != null && stroke.getType() != 0) {
                shape = stroke.createStrokedShape(shape);
                stroke = null;
            }
            try {
                Renderer r = OpenPiscesPrismUtils.setupRenderer(shape, stroke, tr, clip, antialiasedShape);
                this.alphaConsumer.initConsumer(r, pr);
                r.produceAlphas(this.alphaConsumer);
            }
            catch (Throwable ex) {
                if (PrismSettings.verbose) {
                    ex.printStackTrace();
                }
                Logging.getJavaFXLogger().warning("Cannot rasterize Shape: " + ex.toString());
            }
        }

        @Override
        public void dispose() {
        }
    }

    class NativeShapeRenderer
    implements ShapeRenderer {
        private SoftReference<SWMaskTexture> maskTextureRef;

        NativeShapeRenderer() {
        }

        @Override
        public void renderShape(PiscesRenderer pr, Shape shape, BasicStroke stroke, BaseTransform tr, Rectangle clip, boolean antialiasedShape) {
            try {
                MaskData mask = ShapeUtil.rasterizeShape(shape, stroke, clip.toRectBounds(), tr, true, antialiasedShape);
                SWMaskTexture tex = this.validateMaskTexture(mask.getWidth(), mask.getHeight());
                mask.uploadToTexture(tex, 0, 0, false);
                pr.fillAlphaMask(tex.getDataNoClone(), mask.getOriginX(), mask.getOriginY(), mask.getWidth(), mask.getHeight(), 0, tex.getPhysicalWidth());
            }
            catch (Throwable ex) {
                if (PrismSettings.verbose) {
                    ex.printStackTrace();
                }
                Logging.getJavaFXLogger().warning("Cannot rasterize Shape: " + ex.toString());
            }
        }

        private SWMaskTexture initMaskTexture(int width, int height) {
            SWMaskTexture tex = (SWMaskTexture)SWContext.this.factory.createMaskTexture(width, height, Texture.WrapMode.CLAMP_NOT_NEEDED);
            this.maskTextureRef = new SoftReference<SWMaskTexture>(tex);
            return tex;
        }

        private void disposeMaskTexture() {
            if (this.maskTextureRef != null) {
                this.maskTextureRef.clear();
                this.maskTextureRef = null;
            }
        }

        private SWMaskTexture validateMaskTexture(int width, int height) {
            SWMaskTexture tex;
            if (this.maskTextureRef == null) {
                tex = this.initMaskTexture(width, height);
            } else {
                tex = this.maskTextureRef.get();
                if (tex == null || tex.getPhysicalWidth() < width || tex.getPhysicalHeight() < height) {
                    this.disposeMaskTexture();
                    tex = this.initMaskTexture(width, height);
                }
            }
            return tex;
        }

        @Override
        public void dispose() {
            this.disposeMaskTexture();
        }
    }

    static interface ShapeRenderer {
        public void renderShape(PiscesRenderer var1, Shape var2, BasicStroke var3, BaseTransform var4, Rectangle var5, boolean var6);

        public void dispose();
    }
}

