/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismTrace;

class ES2TextureData
implements Disposer.Record {
    protected final ES2Context context;
    private int texID;
    private long size;
    private boolean lastAssociatedFilterMode = true;
    private Texture.WrapMode lastAssociatedWrapMode = Texture.WrapMode.REPEAT;

    protected ES2TextureData(ES2Context context, int texID, long size) {
        this.context = context;
        this.texID = texID;
        this.size = size;
    }

    ES2TextureData(ES2Context context, int texID, int w, int h, long size) {
        this.context = context;
        this.texID = texID;
        this.size = size;
        PrismTrace.textureCreated((long)texID, w, h, size);
    }

    public int getTexID() {
        return this.texID;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFiltered() {
        return this.lastAssociatedFilterMode;
    }

    public void setFiltered(boolean filterMode) {
        this.lastAssociatedFilterMode = filterMode;
    }

    public Texture.WrapMode getWrapMode() {
        return this.lastAssociatedWrapMode;
    }

    public void setWrapMode(Texture.WrapMode wrapMode) {
        this.lastAssociatedWrapMode = wrapMode;
    }

    void traceDispose() {
        PrismTrace.textureDisposed(this.texID);
    }

    @Override
    public void dispose() {
        if (this.texID != 0) {
            this.traceDispose();
            GLContext glCtx = this.context.getGLContext();
            for (int i = 0; i < glCtx.getNumBoundTexture(); ++i) {
                if (this.texID != glCtx.getBoundTexture(i)) continue;
                this.context.flushVertexBuffer();
                glCtx.updateActiveTextureUnit(i);
                glCtx.setBoundTexture(0);
            }
            glCtx.deleteTexture(this.texID);
            this.texID = 0;
        }
    }
}

