/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism.web;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.prism.Graphics;
import com.sun.prism.PrinterGraphics;
import com.sun.webkit.WebPage;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCRectangle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NGWebView
extends NGGroup {
    private static final Logger log = Logger.getLogger(NGWebView.class.getName());
    private volatile WebPage page;
    private volatile float width;
    private volatile float height;

    public void setPage(WebPage page) {
        this.page = page;
    }

    public void resize(float w, float h) {
        if (this.width != w || this.height != h) {
            this.width = w;
            this.height = h;
            this.geometryChanged();
            if (this.page != null) {
                this.page.setBounds(0, 0, (int)w, (int)h);
            }
        }
    }

    public void update() {
        BaseBounds clip;
        if (this.page != null && !(clip = this.getClippedBounds(new RectBounds(), BaseTransform.IDENTITY_TRANSFORM)).isEmpty()) {
            log.log(Level.FINEST, "updating rectangle: {0}", clip);
            this.page.updateContent(new WCRectangle(clip.getMinX(), clip.getMinY(), clip.getWidth(), clip.getHeight()));
        }
    }

    public void requestRender() {
        this.visualsChanged();
    }

    @Override
    protected void renderContent(Graphics g) {
        log.log(Level.FINEST, "rendering into {0}", g);
        if (g == null || this.page == null || this.width <= 0.0f || this.height <= 0.0f) {
            return;
        }
        WCGraphicsContext gc = WCGraphicsManager.getGraphicsManager().createGraphicsContext(g);
        try {
            if (g instanceof PrinterGraphics) {
                this.page.print(gc, 0, 0, (int)this.width, (int)this.height);
            } else {
                this.page.paint(gc, 0, 0, (int)this.width, (int)this.height);
            }
            gc.flush();
        }
        finally {
            gc.dispose();
        }
    }

    @Override
    public boolean hasOverlappingContents() {
        return false;
    }

    @Override
    protected boolean hasVisuals() {
        return true;
    }
}

