/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NodeEffectInput;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.prism.Graphics;
import com.sun.prism.Texture;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NGGroup
extends NGNode {
    private Blend.Mode blendMode = Blend.Mode.SRC_OVER;
    private List<NGNode> children = new ArrayList<NGNode>(1);
    private List<NGNode> unmod = Collections.unmodifiableList(this.children);
    private List<NGNode> removed;
    private static final int REGION_INTERSECTS_MASK = 0x15555555;

    public List<NGNode> getChildren() {
        return this.unmod;
    }

    public void add(int index, NGNode node) {
        if (index < -1 || index > this.children.size()) {
            throw new IndexOutOfBoundsException("invalid index");
        }
        NGNode child = node;
        child.setParent(this);
        this.childDirty = true;
        if (index == -1) {
            this.children.add(node);
        } else {
            this.children.add(index, node);
        }
        child.markDirty();
        this.markTreeDirtyNoIncrement();
        this.geometryChanged();
    }

    public void clearFrom(int fromIndex) {
        if (fromIndex < this.children.size()) {
            this.children.subList(fromIndex, this.children.size()).clear();
            this.geometryChanged();
            this.childDirty = true;
            this.markTreeDirtyNoIncrement();
        }
    }

    public List<NGNode> getRemovedChildren() {
        return this.removed;
    }

    public void addToRemoved(NGNode n) {
        if (this.removed == null) {
            this.removed = new ArrayList<NGNode>();
        }
        if (this.dirtyChildrenAccumulated > 12) {
            return;
        }
        this.removed.add(n);
        ++this.dirtyChildrenAccumulated;
        if (this.dirtyChildrenAccumulated > 12) {
            this.removed.clear();
        }
    }

    @Override
    protected void clearDirty() {
        super.clearDirty();
        if (this.removed != null) {
            this.removed.clear();
        }
    }

    public void remove(NGNode node) {
        this.children.remove(node);
        this.geometryChanged();
        this.childDirty = true;
        this.markTreeDirtyNoIncrement();
    }

    public void remove(int index) {
        this.children.remove(index);
        this.geometryChanged();
        this.childDirty = true;
        this.markTreeDirtyNoIncrement();
    }

    public void clear() {
        this.children.clear();
        this.childDirty = false;
        this.geometryChanged();
        this.markTreeDirtyNoIncrement();
    }

    public void setBlendMode(Object blendMode) {
        if (blendMode == null) {
            throw new IllegalArgumentException("Mode must be non-null");
        }
        if (this.blendMode != blendMode) {
            this.blendMode = (Blend.Mode)((Object)blendMode);
            this.visualsChanged();
        }
    }

    @Override
    public void renderForcedContent(Graphics gOptional) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).renderForcedContent(gOptional);
        }
    }

    @Override
    protected void renderContent(Graphics g) {
        int i;
        if (this.children == null) {
            return;
        }
        NodePath renderRoot = g.getRenderRoot();
        int startPos = 0;
        if (renderRoot != null) {
            if (renderRoot.hasNext()) {
                renderRoot.next();
                startPos = this.children.indexOf(renderRoot.getCurrentNode());
                for (i = 0; i < startPos; ++i) {
                    this.children.get(i).clearDirtyTree();
                }
            } else {
                g.setRenderRoot(null);
            }
        }
        if (this.blendMode == Blend.Mode.SRC_OVER || this.children.size() < 2) {
            for (i = startPos; i < this.children.size(); ++i) {
                NGNode child;
                try {
                    child = this.children.get(i);
                }
                catch (Exception e) {
                    child = null;
                }
                if (child == null) continue;
                child.render(g);
            }
            return;
        }
        Blend b = new Blend(this.blendMode, null, null);
        FilterContext fctx = NGGroup.getFilterContext(g);
        ImageData bot = null;
        boolean idValid = true;
        do {
            BaseTransform transform = g.getTransformNoClone().copy();
            if (bot != null) {
                bot.unref();
                bot = null;
            }
            Rectangle rclip = PrEffectHelper.getGraphicsClipNoClone(g);
            for (int i2 = startPos; i2 < this.children.size(); ++i2) {
                NGNode child = this.children.get(i2);
                ImageData top = NodeEffectInput.getImageDataForNode(fctx, child, false, transform, rclip);
                if (bot == null) {
                    bot = top;
                    continue;
                }
                ImageData newbot = b.filterImageDatas(fctx, transform, rclip, null, new ImageData[]{bot, top});
                bot.unref();
                top.unref();
                bot = newbot;
            }
            if (bot == null || !(idValid = bot.validate(fctx))) continue;
            Rectangle r = bot.getUntransformedBounds();
            PrDrawable botimg = (PrDrawable)bot.getUntransformedImage();
            g.setTransform(bot.getTransform());
            g.drawTexture((Texture)botimg.getTextureObject(), r.x, r.y, r.width, r.height);
        } while (bot == null || !idValid);
        if (bot != null) {
            bot.unref();
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        int n;
        if (this.blendMode != Blend.Mode.SRC_OVER) {
            return false;
        }
        int n2 = n = this.children == null ? 0 : this.children.size();
        if (n == 1) {
            return this.children.get(0).hasOverlappingContents();
        }
        return n != 0;
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    @Override
    protected boolean hasVisuals() {
        return false;
    }

    @Override
    protected boolean needsBlending() {
        Blend.Mode mode = this.getNodeBlendMode();
        return mode != null;
    }

    @Override
    protected NGNode.RenderRootResult computeRenderRoot(NodePath path, RectBounds dirtyRegion, int cullingIndex, BaseTransform tx, GeneralTransform3D pvTx) {
        if (cullingIndex != -1) {
            int bits = this.cullingBits >> cullingIndex * 2;
            if ((bits & 3) == 0) {
                return NGNode.RenderRootResult.NO_RENDER_ROOT;
            }
            if ((bits & 2) != 0) {
                cullingIndex = -1;
            }
        }
        if (!this.isVisible()) {
            return NGNode.RenderRootResult.NO_RENDER_ROOT;
        }
        if ((double)this.getOpacity() != 1.0 || this.getEffect() != null && this.getEffect().reducesOpaquePixels() || this.needsBlending()) {
            return NGNode.RenderRootResult.NO_RENDER_ROOT;
        }
        if (this.getClipNode() != null) {
            NGNode clip = this.getClipNode();
            RectBounds clipBounds = clip.getOpaqueRegion();
            if (clipBounds == null) {
                return NGNode.RenderRootResult.NO_RENDER_ROOT;
            }
            TEMP_TRANSFORM.deriveWithNewTransform(tx).deriveWithConcatenation(this.getTransform()).deriveWithConcatenation(clip.getTransform());
            if (!NGGroup.checkBoundsInQuad(clipBounds, dirtyRegion, TEMP_TRANSFORM, pvTx)) {
                return NGNode.RenderRootResult.NO_RENDER_ROOT;
            }
        }
        double mxx = tx.getMxx();
        double mxy = tx.getMxy();
        double mxz = tx.getMxz();
        double mxt = tx.getMxt();
        double myx = tx.getMyx();
        double myy = tx.getMyy();
        double myz = tx.getMyz();
        double myt = tx.getMyt();
        double mzx = tx.getMzx();
        double mzy = tx.getMzy();
        double mzz = tx.getMzz();
        double mzt = tx.getMzt();
        BaseTransform chTx = tx.deriveWithConcatenation(this.getTransform());
        NGNode.RenderRootResult result = NGNode.RenderRootResult.NO_RENDER_ROOT;
        boolean followingChildrenClean = true;
        for (int resultIdx = this.children.size() - 1; resultIdx >= 0; --resultIdx) {
            NGNode child = this.children.get(resultIdx);
            result = child.computeRenderRoot(path, dirtyRegion, cullingIndex, chTx, pvTx);
            followingChildrenClean &= child.isClean();
            if (result == NGNode.RenderRootResult.HAS_RENDER_ROOT) {
                path.add(this);
                break;
            }
            if (result != NGNode.RenderRootResult.HAS_RENDER_ROOT_AND_IS_CLEAN) continue;
            path.add(this);
            if (followingChildrenClean) break;
            result = NGNode.RenderRootResult.HAS_RENDER_ROOT;
            break;
        }
        tx.restoreTransform(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        return result;
    }

    @Override
    protected void markCullRegions(DirtyRegionContainer drc, int cullingRegionsBitsOfParent, BaseTransform tx, GeneralTransform3D pvTx) {
        super.markCullRegions(drc, cullingRegionsBitsOfParent, tx, pvTx);
        if (this.cullingBits == -1 || this.cullingBits != 0 && (this.cullingBits & 0x15555555) != 0) {
            double mxx = tx.getMxx();
            double mxy = tx.getMxy();
            double mxz = tx.getMxz();
            double mxt = tx.getMxt();
            double myx = tx.getMyx();
            double myy = tx.getMyy();
            double myz = tx.getMyz();
            double myt = tx.getMyt();
            double mzx = tx.getMzx();
            double mzy = tx.getMzy();
            double mzz = tx.getMzz();
            double mzt = tx.getMzt();
            BaseTransform chTx = tx.deriveWithConcatenation(this.getTransform());
            for (int chldIdx = 0; chldIdx < this.children.size(); ++chldIdx) {
                NGNode child = this.children.get(chldIdx);
                child.markCullRegions(drc, this.cullingBits, chTx, pvTx);
            }
            tx.restoreTransform(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        }
    }

    @Override
    public void drawDirtyOpts(BaseTransform tx, GeneralTransform3D pvTx, Rectangle clipBounds, int[] countBuffer, int dirtyRegionIndex) {
        super.drawDirtyOpts(tx, pvTx, clipBounds, countBuffer, dirtyRegionIndex);
        BaseTransform clone = tx.copy();
        clone = clone.deriveWithConcatenation(this.getTransform());
        for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
            NGNode child = this.children.get(childIndex);
            child.drawDirtyOpts(clone, pvTx, clipBounds, countBuffer, dirtyRegionIndex);
        }
    }
}

