/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TabOrderHelper;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class ContainerTabOrder
implements Algorithm {
    ContainerTabOrder() {
    }

    @Override
    public Node select(Node node, Direction dir, TraversalContext context) {
        switch (dir) {
            case NEXT: 
            case NEXT_IN_LINE: {
                return TabOrderHelper.findNextFocusablePeer(node, context.getRoot(), dir == Direction.NEXT);
            }
            case PREVIOUS: {
                return TabOrderHelper.findPreviousFocusablePeer(node, context.getRoot());
            }
            case UP: 
            case DOWN: 
            case LEFT: 
            case RIGHT: {
                List<Node> nodes = context.getAllTargetNodes();
                int target = this.trav2D(context.getSceneLayoutBounds(node), dir, nodes, context);
                if (target == -1) break;
                return nodes.get(target);
            }
        }
        return null;
    }

    @Override
    public Node selectFirst(TraversalContext context) {
        return TabOrderHelper.getFirstTargetNode(context.getRoot());
    }

    @Override
    public Node selectLast(TraversalContext context) {
        return TabOrderHelper.getLastTargetNode(context.getRoot());
    }

    private int trav2D(Bounds origin, Direction dir, List<Node> peers, TraversalContext context) {
        Bounds bestBounds = null;
        double bestMetric = 0.0;
        int bestIndex = -1;
        for (int i = 0; i < peers.size(); ++i) {
            double metric;
            Bounds targetBounds = context.getSceneLayoutBounds(peers.get(i));
            double outd = this.outDistance(dir, origin, targetBounds);
            if (this.isOnAxis(dir, origin, targetBounds)) {
                metric = outd + this.centerSideDistance(dir, origin, targetBounds) / 100.0;
            } else {
                double cosd = this.cornerSideDistance(dir, origin, targetBounds);
                metric = 100000.0 + outd * outd + 9.0 * cosd * cosd;
            }
            if (outd < 0.0 || bestBounds != null && !(metric < bestMetric)) continue;
            bestBounds = targetBounds;
            bestMetric = metric;
            bestIndex = i;
        }
        return bestIndex;
    }

    private boolean isOnAxis(Direction dir, Bounds cur, Bounds tgt) {
        double tmax;
        double tmin;
        double cmax;
        double cmin;
        if (dir == Direction.UP || dir == Direction.DOWN) {
            cmin = cur.getMinX();
            cmax = cur.getMaxX();
            tmin = tgt.getMinX();
            tmax = tgt.getMaxX();
        } else {
            cmin = cur.getMinY();
            cmax = cur.getMaxY();
            tmin = tgt.getMinY();
            tmax = tgt.getMaxY();
        }
        return tmin <= cmax && tmax >= cmin;
    }

    private double outDistance(Direction dir, Bounds cur, Bounds tgt) {
        double distance = dir == Direction.UP ? cur.getMinY() - tgt.getMaxY() : (dir == Direction.DOWN ? tgt.getMinY() - cur.getMaxY() : (dir == Direction.LEFT ? cur.getMinX() - tgt.getMaxX() : tgt.getMinX() - cur.getMaxX()));
        return distance;
    }

    private double centerSideDistance(Direction dir, Bounds cur, Bounds tgt) {
        double tc;
        double cc;
        if (dir == Direction.UP || dir == Direction.DOWN) {
            cc = cur.getMinX() + cur.getWidth() / 2.0;
            tc = tgt.getMinX() + tgt.getWidth() / 2.0;
        } else {
            cc = cur.getMinY() + cur.getHeight() / 2.0;
            tc = tgt.getMinY() + tgt.getHeight() / 2.0;
        }
        return Math.abs(tc - cc);
    }

    private double cornerSideDistance(Direction dir, Bounds cur, Bounds tgt) {
        double distance = dir == Direction.UP || dir == Direction.DOWN ? (tgt.getMinX() > cur.getMaxX() ? tgt.getMinX() - cur.getMaxX() : cur.getMinX() - tgt.getMaxX()) : (tgt.getMinY() > cur.getMaxY() ? tgt.getMinY() - cur.getMaxY() : cur.getMinY() - tgt.getMaxY());
        return distance;
    }
}

