/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public abstract class TableCellSkinBase<C extends IndexedCell, B extends CellBehaviorBase<C>>
extends CellSkinBase<C, B> {
    static final String DEFER_TO_PARENT_PREF_WIDTH = "deferToParentPrefWidth";
    boolean isDeferToParentForPrefWidth = false;
    private InvalidationListener columnWidthListener = valueModel -> ((IndexedCell)this.getSkinnable()).requestLayout();
    private WeakInvalidationListener weakColumnWidthListener = new WeakInvalidationListener(this.columnWidthListener);

    protected abstract ReadOnlyDoubleProperty columnWidthProperty();

    protected abstract BooleanProperty columnVisibleProperty();

    public TableCellSkinBase(C control, B behavior) {
        super(control, behavior);
    }

    protected void init(C control) {
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind(((Region)control).widthProperty());
        clip.heightProperty().bind(((Region)control).heightProperty());
        ((IndexedCell)this.getSkinnable()).setClip(clip);
        ReadOnlyDoubleProperty columnWidthProperty = this.columnWidthProperty();
        if (columnWidthProperty != null) {
            columnWidthProperty.addListener(this.weakColumnWidthListener);
        }
        this.registerChangeListener(((Node)control).visibleProperty(), "VISIBLE");
        if (((Node)control).getProperties().containsKey(DEFER_TO_PARENT_PREF_WIDTH)) {
            this.isDeferToParentForPrefWidth = true;
        }
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("VISIBLE".equals(p)) {
            ((IndexedCell)this.getSkinnable()).setVisible(this.columnVisibleProperty().get());
        }
    }

    @Override
    public void dispose() {
        ReadOnlyDoubleProperty columnWidthProperty = this.columnWidthProperty();
        if (columnWidthProperty != null) {
            columnWidthProperty.removeListener(this.weakColumnWidthListener);
        }
        super.dispose();
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        this.layoutLabelInArea(x, y, w, h - ((IndexedCell)this.getSkinnable()).getPadding().getBottom());
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isDeferToParentForPrefWidth) {
            return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        }
        return this.columnWidthProperty().get();
    }
}

