/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.Collections;
import javafx.geometry.Orientation;
import javafx.scene.control.Separator;
import javafx.scene.layout.Region;

public class SeparatorSkin
extends BehaviorSkinBase<Separator, BehaviorBase<Separator>> {
    private static final double DEFAULT_LENGTH = 10.0;
    private final Region line = new Region();

    public SeparatorSkin(Separator separator) {
        super(separator, new BehaviorBase<Separator>(separator, Collections.emptyList()));
        this.line.getStyleClass().setAll((String[])new String[]{"line"});
        this.getChildren().add(this.line);
        this.registerChangeListener(separator.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(separator.halignmentProperty(), "HALIGNMENT");
        this.registerChangeListener(separator.valignmentProperty(), "VALIGNMENT");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ORIENTATION".equals(p) || "HALIGNMENT".equals(p) || "VALIGNMENT".equals(p)) {
            ((Separator)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        Separator sep = (Separator)this.getSkinnable();
        if (sep.getOrientation() == Orientation.HORIZONTAL) {
            this.line.resize(w, this.line.prefHeight(-1.0));
        } else {
            this.line.resize(this.line.prefWidth(-1.0), h);
        }
        this.positionInArea(this.line, x, y, w, h, 0.0, sep.getHalignment(), sep.getValignment());
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computePrefWidth(double h, double topInset, double rightInset, double bottomInset, double leftInset) {
        Separator sep = (Separator)this.getSkinnable();
        double w = sep.getOrientation() == Orientation.VERTICAL ? this.line.prefWidth(-1.0) : 10.0;
        return w + leftInset + rightInset;
    }

    @Override
    protected double computePrefHeight(double w, double topInset, double rightInset, double bottomInset, double leftInset) {
        Separator sep = (Separator)this.getSkinnable();
        double h = sep.getOrientation() == Orientation.VERTICAL ? 10.0 : this.line.prefHeight(-1.0);
        return h + topInset + bottomInset;
    }

    @Override
    protected double computeMaxWidth(double h, double topInset, double rightInset, double bottomInset, double leftInset) {
        Separator sep = (Separator)this.getSkinnable();
        return sep.getOrientation() == Orientation.VERTICAL ? sep.prefWidth(h) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double w, double topInset, double rightInset, double bottomInset, double leftInset) {
        Separator sep = (Separator)this.getSkinnable();
        return sep.getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : sep.prefHeight(w);
    }
}

