/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ScrollPaneBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ScrollPaneSkin
extends BehaviorSkinBase<ScrollPane, ScrollPaneBehavior>
implements TraverseListener {
    private static final double DEFAULT_PREF_SIZE = 100.0;
    private static final double DEFAULT_MIN_SIZE = 36.0;
    private static final double DEFAULT_SB_BREADTH = 12.0;
    private static final double DEFAULT_EMBEDDED_SB_BREADTH = 8.0;
    private static final double PAN_THRESHOLD = 0.5;
    private Node scrollNode;
    private double nodeWidth;
    private double nodeHeight;
    private boolean nodeSizeInvalid = true;
    private double posX;
    private double posY;
    private boolean hsbvis;
    private boolean vsbvis;
    private double hsbHeight;
    private double vsbWidth;
    private StackPane viewRect;
    private StackPane viewContent;
    private double contentWidth;
    private double contentHeight;
    private StackPane corner;
    protected ScrollBar hsb;
    protected ScrollBar vsb;
    double pressX;
    double pressY;
    double ohvalue;
    double ovvalue;
    private Cursor saveCursor = null;
    private boolean dragDetected = false;
    private boolean touchDetected = false;
    private boolean mouseDown = false;
    Rectangle clipRect;
    private final InvalidationListener nodeListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable valueModel) {
            if (!ScrollPaneSkin.this.nodeSizeInvalid) {
                Bounds scrollNodeBounds = ScrollPaneSkin.this.scrollNode.getLayoutBounds();
                double scrollNodeWidth = scrollNodeBounds.getWidth();
                double scrollNodeHeight = scrollNodeBounds.getHeight();
                if (ScrollPaneSkin.this.vsbvis != ScrollPaneSkin.this.determineVerticalSBVisible() || ScrollPaneSkin.this.hsbvis != ScrollPaneSkin.this.determineHorizontalSBVisible() || scrollNodeWidth != 0.0 && ScrollPaneSkin.this.nodeWidth != scrollNodeWidth || scrollNodeHeight != 0.0 && ScrollPaneSkin.this.nodeHeight != scrollNodeHeight) {
                    ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).requestLayout();
                } else if (!ScrollPaneSkin.this.dragDetected) {
                    ScrollPaneSkin.this.updateVerticalSB();
                    ScrollPaneSkin.this.updateHorizontalSB();
                }
            }
        }
    };
    private final ChangeListener<Bounds> boundsChangeListener = new ChangeListener<Bounds>(){

        @Override
        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldBounds, Bounds newBounds) {
            double oldHeight = oldBounds.getHeight();
            double newHeight = newBounds.getHeight();
            if (oldHeight > 0.0 && oldHeight != newHeight) {
                double newPositionY;
                double oldPositionY = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.snappedTopInset() - ScrollPaneSkin.this.posY / (ScrollPaneSkin.this.vsb.getMax() - ScrollPaneSkin.this.vsb.getMin()) * (oldHeight - ScrollPaneSkin.this.contentHeight));
                double newValueY = oldPositionY / (newPositionY = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.snappedTopInset() - ScrollPaneSkin.this.posY / (ScrollPaneSkin.this.vsb.getMax() - ScrollPaneSkin.this.vsb.getMin()) * (newHeight - ScrollPaneSkin.this.contentHeight))) * ScrollPaneSkin.this.vsb.getValue();
                if (newValueY < 0.0) {
                    ScrollPaneSkin.this.vsb.setValue(0.0);
                } else if (newValueY < 1.0) {
                    ScrollPaneSkin.this.vsb.setValue(newValueY);
                } else if (newValueY > 1.0) {
                    ScrollPaneSkin.this.vsb.setValue(1.0);
                }
            }
            double oldWidth = oldBounds.getWidth();
            double newWidth = newBounds.getWidth();
            if (oldWidth > 0.0 && oldWidth != newWidth) {
                double newPositionX;
                double oldPositionX = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.snappedLeftInset() - ScrollPaneSkin.this.posX / (ScrollPaneSkin.this.hsb.getMax() - ScrollPaneSkin.this.hsb.getMin()) * (oldWidth - ScrollPaneSkin.this.contentWidth));
                double newValueX = oldPositionX / (newPositionX = ScrollPaneSkin.this.snapPosition(ScrollPaneSkin.this.snappedLeftInset() - ScrollPaneSkin.this.posX / (ScrollPaneSkin.this.hsb.getMax() - ScrollPaneSkin.this.hsb.getMin()) * (newWidth - ScrollPaneSkin.this.contentWidth))) * ScrollPaneSkin.this.hsb.getValue();
                if (newValueX < 0.0) {
                    ScrollPaneSkin.this.hsb.setValue(0.0);
                } else if (newValueX < 1.0) {
                    ScrollPaneSkin.this.hsb.setValue(newValueX);
                } else if (newValueX > 1.0) {
                    ScrollPaneSkin.this.hsb.setValue(1.0);
                }
            }
        }
    };
    Timeline sbTouchTimeline;
    KeyFrame sbTouchKF1;
    KeyFrame sbTouchKF2;
    Timeline contentsToViewTimeline;
    KeyFrame contentsToViewKF1;
    KeyFrame contentsToViewKF2;
    KeyFrame contentsToViewKF3;
    private boolean tempVisibility;
    private DoubleProperty contentPosX;
    private DoubleProperty contentPosY;

    public ScrollPaneSkin(ScrollPane scrollpane) {
        super(scrollpane, new ScrollPaneBehavior(scrollpane));
        this.initialize();
        this.registerChangeListener(scrollpane.contentProperty(), "NODE");
        this.registerChangeListener(scrollpane.fitToWidthProperty(), "FIT_TO_WIDTH");
        this.registerChangeListener(scrollpane.fitToHeightProperty(), "FIT_TO_HEIGHT");
        this.registerChangeListener(scrollpane.hbarPolicyProperty(), "HBAR_POLICY");
        this.registerChangeListener(scrollpane.vbarPolicyProperty(), "VBAR_POLICY");
        this.registerChangeListener(scrollpane.hvalueProperty(), "HVALUE");
        this.registerChangeListener(scrollpane.hmaxProperty(), "HMAX");
        this.registerChangeListener(scrollpane.hminProperty(), "HMIN");
        this.registerChangeListener(scrollpane.vvalueProperty(), "VVALUE");
        this.registerChangeListener(scrollpane.vmaxProperty(), "VMAX");
        this.registerChangeListener(scrollpane.vminProperty(), "VMIN");
        this.registerChangeListener(scrollpane.prefViewportWidthProperty(), "VIEWPORT_SIZE_HINT");
        this.registerChangeListener(scrollpane.prefViewportHeightProperty(), "VIEWPORT_SIZE_HINT");
        this.registerChangeListener(scrollpane.minViewportWidthProperty(), "VIEWPORT_SIZE_HINT");
        this.registerChangeListener(scrollpane.minViewportHeightProperty(), "VIEWPORT_SIZE_HINT");
    }

    private void initialize() {
        ScrollPane control = (ScrollPane)this.getSkinnable();
        this.scrollNode = control.getContent();
        ParentTraversalEngine traversalEngine = new ParentTraversalEngine((Parent)((Object)this.getSkinnable()));
        traversalEngine.addTraverseListener(this);
        ((ScrollPane)this.getSkinnable()).setImpl_traversalEngine(traversalEngine);
        if (this.scrollNode != null) {
            this.scrollNode.layoutBoundsProperty().addListener(this.nodeListener);
            this.scrollNode.layoutBoundsProperty().addListener(this.boundsChangeListener);
        }
        this.viewRect = new StackPane(){

            @Override
            protected void layoutChildren() {
                ScrollPaneSkin.this.viewContent.resize(this.getWidth(), this.getHeight());
            }
        };
        this.viewRect.setManaged(false);
        this.viewRect.setCache(true);
        this.viewRect.getStyleClass().add("viewport");
        this.clipRect = new Rectangle();
        this.viewRect.setClip(this.clipRect);
        this.hsb = new ScrollBar();
        this.vsb = new ScrollBar();
        this.vsb.setOrientation(Orientation.VERTICAL);
        EventHandler<MouseEvent> barHandler = ev -> ((ScrollPane)this.getSkinnable()).requestFocus();
        this.hsb.addEventFilter(MouseEvent.MOUSE_PRESSED, barHandler);
        this.vsb.addEventFilter(MouseEvent.MOUSE_PRESSED, barHandler);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.viewContent = new StackPane(){

            @Override
            public void requestLayout() {
                ScrollPaneSkin.this.nodeSizeInvalid = true;
                super.requestLayout();
                ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).requestLayout();
            }

            @Override
            protected void layoutChildren() {
                if (ScrollPaneSkin.this.nodeSizeInvalid) {
                    ScrollPaneSkin.this.computeScrollNodeSize(this.getWidth(), this.getHeight());
                }
                if (ScrollPaneSkin.this.scrollNode != null && ScrollPaneSkin.this.scrollNode.isResizable()) {
                    ScrollPaneSkin.this.scrollNode.resize(this.snapSize(ScrollPaneSkin.this.nodeWidth), this.snapSize(ScrollPaneSkin.this.nodeHeight));
                    if (ScrollPaneSkin.this.vsbvis != ScrollPaneSkin.this.determineVerticalSBVisible() || ScrollPaneSkin.this.hsbvis != ScrollPaneSkin.this.determineHorizontalSBVisible()) {
                        ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).requestLayout();
                    }
                }
                if (ScrollPaneSkin.this.scrollNode != null) {
                    ScrollPaneSkin.this.scrollNode.relocate(0.0, 0.0);
                }
            }
        };
        this.viewRect.getChildren().add(this.viewContent);
        if (this.scrollNode != null) {
            this.viewContent.getChildren().add(this.scrollNode);
            this.viewRect.nodeOrientationProperty().bind(this.scrollNode.nodeOrientationProperty());
        }
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.viewRect, this.vsb, this.hsb, this.corner});
        InvalidationListener vsbListener = valueModel -> {
            this.posY = !IS_TOUCH_SUPPORTED ? com.sun.javafx.util.Utils.clamp(((ScrollPane)this.getSkinnable()).getVmin(), this.vsb.getValue(), ((ScrollPane)this.getSkinnable()).getVmax()) : this.vsb.getValue();
            this.updatePosY();
        };
        this.vsb.valueProperty().addListener(vsbListener);
        InvalidationListener hsbListener = valueModel -> {
            this.posX = !IS_TOUCH_SUPPORTED ? com.sun.javafx.util.Utils.clamp(((ScrollPane)this.getSkinnable()).getHmin(), this.hsb.getValue(), ((ScrollPane)this.getSkinnable()).getHmax()) : this.hsb.getValue();
            this.updatePosX();
        };
        this.hsb.valueProperty().addListener(hsbListener);
        this.viewRect.setOnMousePressed(e -> {
            this.mouseDown = true;
            if (IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
            this.pressX = e.getX();
            this.pressY = e.getY();
            this.ohvalue = this.hsb.getValue();
            this.ovvalue = this.vsb.getValue();
        });
        this.viewRect.setOnDragDetected(e -> {
            if (IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
            if (((ScrollPane)this.getSkinnable()).isPannable()) {
                this.dragDetected = true;
                if (this.saveCursor == null) {
                    this.saveCursor = ((ScrollPane)this.getSkinnable()).getCursor();
                    if (this.saveCursor == null) {
                        this.saveCursor = Cursor.DEFAULT;
                    }
                    ((ScrollPane)this.getSkinnable()).setCursor(Cursor.MOVE);
                    ((ScrollPane)this.getSkinnable()).requestLayout();
                }
            }
        });
        this.viewRect.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
            this.mouseDown = false;
            if (this.dragDetected) {
                if (this.saveCursor != null) {
                    ((ScrollPane)this.getSkinnable()).setCursor(this.saveCursor);
                    this.saveCursor = null;
                    ((ScrollPane)this.getSkinnable()).requestLayout();
                }
                this.dragDetected = false;
            }
            if ((this.posY > ((ScrollPane)this.getSkinnable()).getVmax() || this.posY < ((ScrollPane)this.getSkinnable()).getVmin() || this.posX > ((ScrollPane)this.getSkinnable()).getHmax() || this.posX < ((ScrollPane)this.getSkinnable()).getHmin()) && !this.touchDetected) {
                this.startContentsToViewport();
            }
        });
        this.viewRect.setOnMouseDragged(e -> {
            if (IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
            if (((ScrollPane)this.getSkinnable()).isPannable() || IS_TOUCH_SUPPORTED) {
                double deltaX = this.pressX - e.getX();
                double deltaY = this.pressY - e.getY();
                if (this.hsb.getVisibleAmount() > 0.0 && this.hsb.getVisibleAmount() < this.hsb.getMax() && Math.abs(deltaX) > 0.5) {
                    if (this.isReverseNodeOrientation()) {
                        deltaX = -deltaX;
                    }
                    double newHVal = this.ohvalue + deltaX / (this.nodeWidth - this.viewRect.getWidth()) * (this.hsb.getMax() - this.hsb.getMin());
                    if (!IS_TOUCH_SUPPORTED) {
                        if (newHVal > this.hsb.getMax()) {
                            newHVal = this.hsb.getMax();
                        } else if (newHVal < this.hsb.getMin()) {
                            newHVal = this.hsb.getMin();
                        }
                        this.hsb.setValue(newHVal);
                    } else {
                        this.hsb.setValue(newHVal);
                    }
                }
                if (this.vsb.getVisibleAmount() > 0.0 && this.vsb.getVisibleAmount() < this.vsb.getMax() && Math.abs(deltaY) > 0.5) {
                    double newVVal = this.ovvalue + deltaY / (this.nodeHeight - this.viewRect.getHeight()) * (this.vsb.getMax() - this.vsb.getMin());
                    if (!IS_TOUCH_SUPPORTED) {
                        if (newVVal > this.vsb.getMax()) {
                            newVVal = this.vsb.getMax();
                        } else if (newVVal < this.vsb.getMin()) {
                            newVVal = this.vsb.getMin();
                        }
                        this.vsb.setValue(newVVal);
                    } else {
                        this.vsb.setValue(newVVal);
                    }
                }
            }
            e.consume();
        });
        EventDispatcher blockEventDispatcher = (event, tail) -> event;
        EventDispatcher oldHsbEventDispatcher = this.hsb.getEventDispatcher();
        this.hsb.setEventDispatcher((event, tail) -> {
            if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                tail = tail.prepend(blockEventDispatcher);
                tail = tail.prepend(oldHsbEventDispatcher);
                return tail.dispatchEvent(event);
            }
            return oldHsbEventDispatcher.dispatchEvent(event, tail);
        });
        EventDispatcher oldVsbEventDispatcher = this.vsb.getEventDispatcher();
        this.vsb.setEventDispatcher((event, tail) -> {
            if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                tail = tail.prepend(blockEventDispatcher);
                tail = tail.prepend(oldVsbEventDispatcher);
                return tail.dispatchEvent(event);
            }
            return oldVsbEventDispatcher.dispatchEvent(event, tail);
        });
        this.viewRect.addEventHandler(ScrollEvent.SCROLL, event -> {
            double newValue;
            if (IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
            if (this.vsb.getVisibleAmount() < this.vsb.getMax()) {
                double vRange = ((ScrollPane)this.getSkinnable()).getVmax() - ((ScrollPane)this.getSkinnable()).getVmin();
                double vPixelValue = this.nodeHeight > 0.0 ? vRange / this.nodeHeight : 0.0;
                newValue = this.vsb.getValue() + -event.getDeltaY() * vPixelValue;
                if (!IS_TOUCH_SUPPORTED) {
                    if (event.getDeltaY() > 0.0 && this.vsb.getValue() > this.vsb.getMin() || event.getDeltaY() < 0.0 && this.vsb.getValue() < this.vsb.getMax()) {
                        this.vsb.setValue(newValue);
                        event.consume();
                    }
                } else if (!event.isInertia() || event.isInertia() && (this.contentsToViewTimeline == null || this.contentsToViewTimeline.getStatus() == Animation.Status.STOPPED)) {
                    this.vsb.setValue(newValue);
                    if ((newValue > this.vsb.getMax() || newValue < this.vsb.getMin()) && !this.mouseDown && !this.touchDetected) {
                        this.startContentsToViewport();
                    }
                    event.consume();
                }
            }
            if (this.hsb.getVisibleAmount() < this.hsb.getMax()) {
                double hRange = ((ScrollPane)this.getSkinnable()).getHmax() - ((ScrollPane)this.getSkinnable()).getHmin();
                double hPixelValue = this.nodeWidth > 0.0 ? hRange / this.nodeWidth : 0.0;
                newValue = this.hsb.getValue() + -event.getDeltaX() * hPixelValue;
                if (!IS_TOUCH_SUPPORTED) {
                    if (event.getDeltaX() > 0.0 && this.hsb.getValue() > this.hsb.getMin() || event.getDeltaX() < 0.0 && this.hsb.getValue() < this.hsb.getMax()) {
                        this.hsb.setValue(newValue);
                        event.consume();
                    }
                } else if (!event.isInertia() || event.isInertia() && (this.contentsToViewTimeline == null || this.contentsToViewTimeline.getStatus() == Animation.Status.STOPPED)) {
                    this.hsb.setValue(newValue);
                    if ((newValue > this.hsb.getMax() || newValue < this.hsb.getMin()) && !this.mouseDown && !this.touchDetected) {
                        this.startContentsToViewport();
                    }
                    event.consume();
                }
            }
        });
        ((ScrollPane)this.getSkinnable()).addEventHandler(TouchEvent.TOUCH_PRESSED, e -> {
            this.touchDetected = true;
            this.startSBReleasedAnimation();
            e.consume();
        });
        ((ScrollPane)this.getSkinnable()).addEventHandler(TouchEvent.TOUCH_RELEASED, e -> {
            this.touchDetected = false;
            e.consume();
        });
        this.consumeMouseEvents(false);
        this.hsb.setValue(control.getHvalue());
        this.vsb.setValue(control.getVvalue());
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("NODE".equals(p)) {
            if (this.scrollNode != ((ScrollPane)this.getSkinnable()).getContent()) {
                if (this.scrollNode != null) {
                    this.scrollNode.layoutBoundsProperty().removeListener(this.nodeListener);
                    this.scrollNode.layoutBoundsProperty().removeListener(this.boundsChangeListener);
                    this.viewContent.getChildren().remove(this.scrollNode);
                }
                this.scrollNode = ((ScrollPane)this.getSkinnable()).getContent();
                if (this.scrollNode != null) {
                    this.nodeWidth = this.snapSize(this.scrollNode.getLayoutBounds().getWidth());
                    this.nodeHeight = this.snapSize(this.scrollNode.getLayoutBounds().getHeight());
                    this.viewContent.getChildren().setAll((Node[])new Node[]{this.scrollNode});
                    this.scrollNode.layoutBoundsProperty().addListener(this.nodeListener);
                    this.scrollNode.layoutBoundsProperty().addListener(this.boundsChangeListener);
                }
            }
            ((ScrollPane)this.getSkinnable()).requestLayout();
        } else if ("FIT_TO_WIDTH".equals(p) || "FIT_TO_HEIGHT".equals(p)) {
            ((ScrollPane)this.getSkinnable()).requestLayout();
            this.viewRect.requestLayout();
        } else if ("HBAR_POLICY".equals(p) || "VBAR_POLICY".equals(p)) {
            ((ScrollPane)this.getSkinnable()).requestLayout();
        } else if ("HVALUE".equals(p)) {
            this.hsb.setValue(((ScrollPane)this.getSkinnable()).getHvalue());
        } else if ("HMAX".equals(p)) {
            this.hsb.setMax(((ScrollPane)this.getSkinnable()).getHmax());
        } else if ("HMIN".equals(p)) {
            this.hsb.setMin(((ScrollPane)this.getSkinnable()).getHmin());
        } else if ("VVALUE".equals(p)) {
            this.vsb.setValue(((ScrollPane)this.getSkinnable()).getVvalue());
        } else if ("VMAX".equals(p)) {
            this.vsb.setMax(((ScrollPane)this.getSkinnable()).getVmax());
        } else if ("VMIN".equals(p)) {
            this.vsb.setMin(((ScrollPane)this.getSkinnable()).getVmin());
        } else if ("VIEWPORT_SIZE_HINT".equals(p)) {
            ((ScrollPane)this.getSkinnable()).requestLayout();
        }
    }

    void scrollBoundsIntoView(Bounds b) {
        double dx = 0.0;
        double dy = 0.0;
        if (b.getMaxX() > this.contentWidth) {
            dx = b.getMinX() - this.snappedLeftInset();
        }
        if (b.getMinX() < this.snappedLeftInset()) {
            dx = b.getMaxX() - this.contentWidth - this.snappedLeftInset();
        }
        if (b.getMaxY() > this.snappedTopInset() + this.contentHeight) {
            dy = b.getMinY() - this.snappedTopInset();
        }
        if (b.getMinY() < this.snappedTopInset()) {
            dy = b.getMaxY() - this.contentHeight - this.snappedTopInset();
        }
        if (dx != 0.0) {
            double sdx = dx * (this.hsb.getMax() - this.hsb.getMin()) / (this.nodeWidth - this.contentWidth);
            sdx += -1.0 * Math.signum(sdx) * this.hsb.getUnitIncrement() / 5.0;
            this.hsb.setValue(this.hsb.getValue() + sdx);
            ((ScrollPane)this.getSkinnable()).requestLayout();
        }
        if (dy != 0.0) {
            double sdy = dy * (this.vsb.getMax() - this.vsb.getMin()) / (this.nodeHeight - this.contentHeight);
            sdy += -1.0 * Math.signum(sdy) * this.vsb.getUnitIncrement() / 5.0;
            this.vsb.setValue(this.vsb.getValue() + sdy);
            ((ScrollPane)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    public void onTraverse(Node n, Bounds b) {
        this.scrollBoundsIntoView(b);
    }

    public void hsbIncrement() {
        if (this.hsb != null) {
            this.hsb.increment();
        }
    }

    public void hsbDecrement() {
        if (this.hsb != null) {
            this.hsb.decrement();
        }
    }

    public void hsbPageIncrement() {
        if (this.hsb != null) {
            this.hsb.increment();
        }
    }

    public void hsbPageDecrement() {
        if (this.hsb != null) {
            this.hsb.decrement();
        }
    }

    public void vsbIncrement() {
        if (this.vsb != null) {
            this.vsb.increment();
        }
    }

    public void vsbDecrement() {
        if (this.vsb != null) {
            this.vsb.decrement();
        }
    }

    public void vsbPageIncrement() {
        if (this.vsb != null) {
            this.vsb.increment();
        }
    }

    public void vsbPageDecrement() {
        if (this.vsb != null) {
            this.vsb.decrement();
        }
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        double vsbWidth = this.computeVsbSizeHint(sp);
        double minWidth = vsbWidth + this.snappedLeftInset() + this.snappedRightInset();
        if (sp.getPrefViewportWidth() > 0.0) {
            return sp.getPrefViewportWidth() + minWidth;
        }
        if (sp.getContent() != null) {
            return sp.getContent().prefWidth(height) + minWidth;
        }
        return Math.max(minWidth, 100.0);
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        double hsbHeight = this.computeHsbSizeHint(sp);
        double minHeight = hsbHeight + this.snappedTopInset() + this.snappedBottomInset();
        if (sp.getPrefViewportHeight() > 0.0) {
            return sp.getPrefViewportHeight() + minHeight;
        }
        if (sp.getContent() != null) {
            return sp.getContent().prefHeight(width) + minHeight;
        }
        return Math.max(minHeight, 100.0);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        double vsbWidth = this.computeVsbSizeHint(sp);
        double minWidth = vsbWidth + this.snappedLeftInset() + this.snappedRightInset();
        if (sp.getMinViewportWidth() > 0.0) {
            return sp.getMinViewportWidth() + minWidth;
        }
        double w = this.corner.minWidth(-1.0);
        return w > 0.0 ? 3.0 * w : 36.0;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        double hsbHeight = this.computeHsbSizeHint(sp);
        double minHeight = hsbHeight + this.snappedTopInset() + this.snappedBottomInset();
        if (sp.getMinViewportHeight() > 0.0) {
            return sp.getMinViewportHeight() + minHeight;
        }
        double h = this.corner.minHeight(-1.0);
        return h > 0.0 ? 3.0 * h : 36.0;
    }

    private double computeHsbSizeHint(ScrollPane sp) {
        return sp.getHbarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS || sp.getHbarPolicy() == ScrollPane.ScrollBarPolicy.AS_NEEDED && (sp.getPrefViewportHeight() > 0.0 || sp.getMinViewportHeight() > 0.0) ? this.hsb.prefHeight(-1.0) : 0.0;
    }

    private double computeVsbSizeHint(ScrollPane sp) {
        return sp.getVbarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS || sp.getVbarPolicy() == ScrollPane.ScrollBarPolicy.AS_NEEDED && (sp.getPrefViewportWidth() > 0.0 || sp.getMinViewportWidth() > 0.0) ? this.vsb.prefWidth(-1.0) : 0.0;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        ScrollPane control = (ScrollPane)this.getSkinnable();
        Insets padding = control.getPadding();
        double rightPadding = this.snapSize(padding.getRight());
        double leftPadding = this.snapSize(padding.getLeft());
        double topPadding = this.snapSize(padding.getTop());
        double bottomPadding = this.snapSize(padding.getBottom());
        this.vsb.setMin(control.getVmin());
        this.vsb.setMax(control.getVmax());
        this.hsb.setMin(control.getHmin());
        this.hsb.setMax(control.getHmax());
        this.contentWidth = w;
        this.contentHeight = h;
        double hsbWidth = 0.0;
        double vsbHeight = 0.0;
        this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
        this.computeScrollBarSize();
        for (int i = 0; i < 2; ++i) {
            this.vsbvis = this.determineVerticalSBVisible();
            this.hsbvis = this.determineHorizontalSBVisible();
            if (this.vsbvis && !IS_TOUCH_SUPPORTED) {
                this.contentWidth = w - this.vsbWidth;
            }
            hsbWidth = w + leftPadding + rightPadding - (this.vsbvis ? this.vsbWidth : 0.0);
            if (this.hsbvis && !IS_TOUCH_SUPPORTED) {
                this.contentHeight = h - this.hsbHeight;
            }
            vsbHeight = h + topPadding + bottomPadding - (this.hsbvis ? this.hsbHeight : 0.0);
        }
        if (this.scrollNode != null && this.scrollNode.isResizable()) {
            if (this.vsbvis && this.hsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
            } else if (this.hsbvis && !this.vsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                this.vsbvis = this.determineVerticalSBVisible();
                if (this.vsbvis) {
                    this.contentWidth -= this.vsbWidth;
                    hsbWidth -= this.vsbWidth;
                    this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                }
            } else if (this.vsbvis && !this.hsbvis) {
                this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                this.hsbvis = this.determineHorizontalSBVisible();
                if (this.hsbvis) {
                    this.contentHeight -= this.hsbHeight;
                    vsbHeight -= this.hsbHeight;
                    this.computeScrollNodeSize(this.contentWidth, this.contentHeight);
                }
            }
        }
        double cx = this.snappedLeftInset() - leftPadding;
        double cy = this.snappedTopInset() - topPadding;
        this.vsb.setVisible(this.vsbvis);
        if (this.vsbvis) {
            this.vsb.resizeRelocate(this.snappedLeftInset() + w - this.vsbWidth + (rightPadding < 1.0 ? 0.0 : rightPadding - 1.0), cy, this.vsbWidth, vsbHeight);
        }
        this.updateVerticalSB();
        this.hsb.setVisible(this.hsbvis);
        if (this.hsbvis) {
            this.hsb.resizeRelocate(cx, this.snappedTopInset() + h - this.hsbHeight + (bottomPadding < 1.0 ? 0.0 : bottomPadding - 1.0), hsbWidth, this.hsbHeight);
        }
        this.updateHorizontalSB();
        this.viewRect.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), this.snapSize(this.contentWidth), this.snapSize(this.contentHeight));
        this.resetClip();
        if (this.vsbvis && this.hsbvis) {
            this.corner.setVisible(true);
            double cornerWidth = this.vsbWidth;
            double cornerHeight = this.hsbHeight;
            this.corner.resizeRelocate(this.snapPosition(this.vsb.getLayoutX()), this.snapPosition(this.hsb.getLayoutY()), this.snapSize(cornerWidth), this.snapSize(cornerHeight));
        } else {
            this.corner.setVisible(false);
        }
        control.setViewportBounds(new BoundingBox(this.snapPosition(this.viewContent.getLayoutX()), this.snapPosition(this.viewContent.getLayoutY()), this.snapSize(this.contentWidth), this.snapSize(this.contentHeight)));
    }

    private void computeScrollNodeSize(double contentWidth, double contentHeight) {
        if (this.scrollNode != null) {
            if (this.scrollNode.isResizable()) {
                ScrollPane control = (ScrollPane)this.getSkinnable();
                Orientation bias = this.scrollNode.getContentBias();
                if (bias == null) {
                    this.nodeWidth = this.snapSize(Utils.boundedSize(control.isFitToWidth() ? contentWidth : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0)));
                    this.nodeHeight = this.snapSize(Utils.boundedSize(control.isFitToHeight() ? contentHeight : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0)));
                } else if (bias == Orientation.HORIZONTAL) {
                    this.nodeWidth = this.snapSize(Utils.boundedSize(control.isFitToWidth() ? contentWidth : this.scrollNode.prefWidth(-1.0), this.scrollNode.minWidth(-1.0), this.scrollNode.maxWidth(-1.0)));
                    this.nodeHeight = this.snapSize(Utils.boundedSize(control.isFitToHeight() ? contentHeight : this.scrollNode.prefHeight(this.nodeWidth), this.scrollNode.minHeight(this.nodeWidth), this.scrollNode.maxHeight(this.nodeWidth)));
                } else {
                    this.nodeHeight = this.snapSize(Utils.boundedSize(control.isFitToHeight() ? contentHeight : this.scrollNode.prefHeight(-1.0), this.scrollNode.minHeight(-1.0), this.scrollNode.maxHeight(-1.0)));
                    this.nodeWidth = this.snapSize(Utils.boundedSize(control.isFitToWidth() ? contentWidth : this.scrollNode.prefWidth(this.nodeHeight), this.scrollNode.minWidth(this.nodeHeight), this.scrollNode.maxWidth(this.nodeHeight)));
                }
            } else {
                this.nodeWidth = this.snapSize(this.scrollNode.getLayoutBounds().getWidth());
                this.nodeHeight = this.snapSize(this.scrollNode.getLayoutBounds().getHeight());
            }
            this.nodeSizeInvalid = false;
        }
    }

    private boolean isReverseNodeOrientation() {
        return this.scrollNode != null && ((ScrollPane)this.getSkinnable()).getEffectiveNodeOrientation() != this.scrollNode.getEffectiveNodeOrientation();
    }

    private boolean determineHorizontalSBVisible() {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        if (IS_TOUCH_SUPPORTED) {
            return this.tempVisibility && this.nodeWidth > this.contentWidth;
        }
        ScrollPane.ScrollBarPolicy hbarPolicy = sp.getHbarPolicy();
        return ScrollPane.ScrollBarPolicy.NEVER == hbarPolicy ? false : (ScrollPane.ScrollBarPolicy.ALWAYS == hbarPolicy ? true : (sp.isFitToWidth() && this.scrollNode != null && this.scrollNode.isResizable() ? this.nodeWidth > this.contentWidth && this.scrollNode.minWidth(-1.0) > this.contentWidth : this.nodeWidth > this.contentWidth));
    }

    private boolean determineVerticalSBVisible() {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        if (IS_TOUCH_SUPPORTED) {
            return this.tempVisibility && this.nodeHeight > this.contentHeight;
        }
        ScrollPane.ScrollBarPolicy vbarPolicy = sp.getVbarPolicy();
        return ScrollPane.ScrollBarPolicy.NEVER == vbarPolicy ? false : (ScrollPane.ScrollBarPolicy.ALWAYS == vbarPolicy ? true : (sp.isFitToHeight() && this.scrollNode != null && this.scrollNode.isResizable() ? this.nodeHeight > this.contentHeight && this.scrollNode.minHeight(-1.0) > this.contentHeight : this.nodeHeight > this.contentHeight));
    }

    private void computeScrollBarSize() {
        this.vsbWidth = this.snapSize(this.vsb.prefWidth(-1.0));
        if (this.vsbWidth == 0.0) {
            this.vsbWidth = IS_TOUCH_SUPPORTED ? 8.0 : 12.0;
        }
        this.hsbHeight = this.snapSize(this.hsb.prefHeight(-1.0));
        if (this.hsbHeight == 0.0) {
            this.hsbHeight = IS_TOUCH_SUPPORTED ? 8.0 : 12.0;
        }
    }

    private void updateHorizontalSB() {
        double contentRatio = this.nodeWidth * (this.hsb.getMax() - this.hsb.getMin());
        if (contentRatio > 0.0) {
            this.hsb.setVisibleAmount(this.contentWidth / contentRatio);
            this.hsb.setBlockIncrement(0.9 * this.hsb.getVisibleAmount());
            this.hsb.setUnitIncrement(0.1 * this.hsb.getVisibleAmount());
        } else {
            this.hsb.setVisibleAmount(0.0);
            this.hsb.setBlockIncrement(0.0);
            this.hsb.setUnitIncrement(0.0);
        }
        if (this.hsb.isVisible()) {
            this.updatePosX();
        } else if (this.nodeWidth > this.contentWidth) {
            this.updatePosX();
        } else {
            this.viewContent.setLayoutX(0.0);
        }
    }

    private void updateVerticalSB() {
        double contentRatio = this.nodeHeight * (this.vsb.getMax() - this.vsb.getMin());
        if (contentRatio > 0.0) {
            this.vsb.setVisibleAmount(this.contentHeight / contentRatio);
            this.vsb.setBlockIncrement(0.9 * this.vsb.getVisibleAmount());
            this.vsb.setUnitIncrement(0.1 * this.vsb.getVisibleAmount());
        } else {
            this.vsb.setVisibleAmount(0.0);
            this.vsb.setBlockIncrement(0.0);
            this.vsb.setUnitIncrement(0.0);
        }
        if (this.vsb.isVisible()) {
            this.updatePosY();
        } else if (this.nodeHeight > this.contentHeight) {
            this.updatePosY();
        } else {
            this.viewContent.setLayoutY(0.0);
        }
    }

    private double updatePosX() {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        double x = this.isReverseNodeOrientation() ? this.hsb.getMax() - (this.posX - this.hsb.getMin()) : this.posX;
        double minX = Math.min(-x / (this.hsb.getMax() - this.hsb.getMin()) * (this.nodeWidth - this.contentWidth), 0.0);
        this.viewContent.setLayoutX(this.snapPosition(minX));
        if (!sp.hvalueProperty().isBound()) {
            sp.setHvalue(com.sun.javafx.util.Utils.clamp(sp.getHmin(), this.posX, sp.getHmax()));
        }
        return this.posX;
    }

    private double updatePosY() {
        ScrollPane sp = (ScrollPane)this.getSkinnable();
        double minY = Math.min(-this.posY / (this.vsb.getMax() - this.vsb.getMin()) * (this.nodeHeight - this.contentHeight), 0.0);
        this.viewContent.setLayoutY(this.snapPosition(minY));
        if (!sp.vvalueProperty().isBound()) {
            sp.setVvalue(com.sun.javafx.util.Utils.clamp(sp.getVmin(), this.posY, sp.getVmax()));
        }
        return this.posY;
    }

    private void resetClip() {
        this.clipRect.setWidth(this.snapSize(this.contentWidth));
        this.clipRect.setHeight(this.snapSize(this.contentHeight));
    }

    protected void startSBReleasedAnimation() {
        if (this.sbTouchTimeline == null) {
            this.sbTouchTimeline = new Timeline();
            this.sbTouchKF1 = new KeyFrame(Duration.millis(0.0), event -> {
                this.tempVisibility = true;
                if (this.touchDetected || this.mouseDown) {
                    this.sbTouchTimeline.playFromStart();
                }
            }, new KeyValue[0]);
            this.sbTouchKF2 = new KeyFrame(Duration.millis(1000.0), event -> {
                this.tempVisibility = false;
                ((ScrollPane)this.getSkinnable()).requestLayout();
            }, new KeyValue[0]);
            this.sbTouchTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.sbTouchKF1, this.sbTouchKF2});
        }
        this.sbTouchTimeline.playFromStart();
    }

    protected void startContentsToViewport() {
        double newPosX = this.posX;
        double newPosY = this.posY;
        this.setContentPosX(this.posX);
        this.setContentPosY(this.posY);
        if (this.posY > ((ScrollPane)this.getSkinnable()).getVmax()) {
            newPosY = ((ScrollPane)this.getSkinnable()).getVmax();
        } else if (this.posY < ((ScrollPane)this.getSkinnable()).getVmin()) {
            newPosY = ((ScrollPane)this.getSkinnable()).getVmin();
        }
        if (this.posX > ((ScrollPane)this.getSkinnable()).getHmax()) {
            newPosX = ((ScrollPane)this.getSkinnable()).getHmax();
        } else if (this.posX < ((ScrollPane)this.getSkinnable()).getHmin()) {
            newPosX = ((ScrollPane)this.getSkinnable()).getHmin();
        }
        if (!IS_TOUCH_SUPPORTED) {
            this.startSBReleasedAnimation();
        }
        if (this.contentsToViewTimeline != null) {
            this.contentsToViewTimeline.stop();
        }
        this.contentsToViewTimeline = new Timeline();
        this.contentsToViewKF1 = new KeyFrame(Duration.millis(50.0), new KeyValue[0]);
        this.contentsToViewKF2 = new KeyFrame(Duration.millis(150.0), event -> ((ScrollPane)this.getSkinnable()).requestLayout(), new KeyValue(this.contentPosX, newPosX), new KeyValue(this.contentPosY, newPosY));
        this.contentsToViewKF3 = new KeyFrame(Duration.millis(1500.0), new KeyValue[0]);
        this.contentsToViewTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.contentsToViewKF1, this.contentsToViewKF2, this.contentsToViewKF3});
        this.contentsToViewTimeline.playFromStart();
    }

    private void setContentPosX(double value) {
        this.contentPosXProperty().set(value);
    }

    private double getContentPosX() {
        return this.contentPosX == null ? 0.0 : this.contentPosX.get();
    }

    private DoubleProperty contentPosXProperty() {
        if (this.contentPosX == null) {
            this.contentPosX = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ScrollPaneSkin.this.hsb.setValue(ScrollPaneSkin.this.getContentPosX());
                    ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).requestLayout();
                }

                @Override
                public Object getBean() {
                    return ScrollPaneSkin.this;
                }

                @Override
                public String getName() {
                    return "contentPosX";
                }
            };
        }
        return this.contentPosX;
    }

    private void setContentPosY(double value) {
        this.contentPosYProperty().set(value);
    }

    private double getContentPosY() {
        return this.contentPosY == null ? 0.0 : this.contentPosY.get();
    }

    private DoubleProperty contentPosYProperty() {
        if (this.contentPosY == null) {
            this.contentPosY = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ScrollPaneSkin.this.vsb.setValue(ScrollPaneSkin.this.getContentPosY());
                    ((ScrollPane)ScrollPaneSkin.this.getSkinnable()).requestLayout();
                }

                @Override
                public Object getBean() {
                    return ScrollPaneSkin.this;
                }

                @Override
                public String getName() {
                    return "contentPosY";
                }
            };
        }
        return this.contentPosY;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case VERTICAL_SCROLLBAR: {
                return this.vsb;
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.hsb;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }
}

