/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.scene.control.skin.FXVKCharEntities;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import com.sun.javafx.util.Utils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;

public class FXVKSkin
extends BehaviorSkinBase<FXVK, BehaviorBase<FXVK>> {
    private static final int GAP = 6;
    private List<List<Key>> currentBoard;
    private static HashMap<String, List<List<Key>>> boardMap = new HashMap();
    private int numCols;
    private boolean capsDown = false;
    private boolean shiftDown = false;
    private boolean isSymbol = false;
    long lastTime = -1L;
    private static Popup vkPopup;
    private static Popup secondaryPopup;
    private static FXVK primaryVK;
    private static Timeline slideInTimeline;
    private static Timeline slideOutTimeline;
    private static boolean hideAfterSlideOut;
    private static FXVK secondaryVK;
    private static Timeline secondaryVKDelay;
    private static CharKey secondaryVKKey;
    private static TextInputKey repeatKey;
    private static Timeline repeatInitialDelay;
    private static Timeline repeatSubsequentDelay;
    private static double KEY_REPEAT_DELAY;
    private static double KEY_REPEAT_DELAY_MIN;
    private static double KEY_REPEAT_DELAY_MAX;
    private static double KEY_REPEAT_RATE;
    private static double KEY_REPEAT_RATE_MIN;
    private static double KEY_REPEAT_RATE_MAX;
    private Node attachedNode;
    private String vkType = null;
    FXVK fxvk;
    static final double VK_HEIGHT = 243.0;
    static final double VK_SLIDE_MILLIS = 250.0;
    static final double PREF_PORTRAIT_KEY_WIDTH = 40.0;
    static final double PREF_KEY_HEIGHT = 56.0;
    static boolean vkAdjustWindow;
    static boolean vkLookup;
    private static DoubleProperty winY;
    EventHandler<InputEvent> unHideEventHandler;
    private boolean isVKHidden = false;
    private Double origWindowYPos = null;

    void clearShift() {
        if (this.shiftDown && !this.capsDown) {
            this.shiftDown = false;
            this.updateKeys();
        }
        this.lastTime = -1L;
    }

    void pressShift() {
        long time = System.currentTimeMillis();
        if (this.shiftDown && !this.capsDown) {
            if (this.lastTime > 0L && time - this.lastTime < 400L) {
                this.shiftDown = false;
                this.capsDown = true;
            } else {
                this.shiftDown = false;
                this.capsDown = false;
            }
        } else if (!this.shiftDown && !this.capsDown) {
            this.shiftDown = true;
        } else {
            this.shiftDown = false;
            this.capsDown = false;
        }
        this.updateKeys();
        this.lastTime = time;
    }

    void clearSymbolABC() {
        this.isSymbol = false;
        this.updateKeys();
    }

    void pressSymbolABC() {
        this.isSymbol = !this.isSymbol;
        this.updateKeys();
    }

    void clearStateKeys() {
        this.capsDown = false;
        this.shiftDown = false;
        this.isSymbol = false;
        this.lastTime = -1L;
        this.updateKeys();
    }

    private void updateKeys() {
        for (List<Key> row : this.currentBoard) {
            for (Key key : row) {
                key.update(this.capsDown, this.shiftDown, this.isSymbol);
            }
        }
    }

    private static void startSlideIn() {
        slideOutTimeline.stop();
        slideInTimeline.playFromStart();
    }

    private static void startSlideOut(boolean doHide) {
        hideAfterSlideOut = doHide;
        slideInTimeline.stop();
        slideOutTimeline.playFromStart();
    }

    private void adjustWindowPosition(Node node) {
        if (!(node instanceof TextInputControl)) {
            return;
        }
        double inputControlMinY = node.localToScene(0.0, 0.0).getY() + node.getScene().getY();
        double inputControlHeight = ((TextInputControl)node).getHeight();
        double inputControlMaxY = inputControlMinY + inputControlHeight;
        double screenHeight = Utils.getScreen(node).getBounds().getHeight();
        double visibleAreaMaxY = screenHeight - 243.0;
        double inputLineCenterY = 0.0;
        double inputLineBottomY = 0.0;
        double newWindowYPos = 0.0;
        double screenTopOffset = 10.0;
        if (node instanceof TextField) {
            inputLineCenterY = inputControlMinY + inputControlHeight / 2.0;
            inputLineBottomY = inputControlMaxY;
            Parent parent = this.attachedNode.getParent();
            newWindowYPos = parent instanceof ComboBoxBase ? Math.min(screenTopOffset - inputControlMinY, 0.0) : Math.min(visibleAreaMaxY / 2.0 - inputLineCenterY, 0.0);
        } else if (node instanceof TextArea) {
            TextAreaSkin textAreaSkin = (TextAreaSkin)((TextArea)node).getSkin();
            Bounds caretBounds = textAreaSkin.getCaretBounds();
            double caretMinY = caretBounds.getMinY();
            double caretMaxY = caretBounds.getMaxY();
            inputLineCenterY = inputControlMinY + (caretMinY + caretMaxY) / 2.0;
            inputLineBottomY = inputControlMinY + caretMaxY;
            newWindowYPos = inputControlHeight < visibleAreaMaxY ? visibleAreaMaxY / 2.0 - (inputControlMinY + inputControlHeight / 2.0) : visibleAreaMaxY / 2.0 - inputLineCenterY;
            newWindowYPos = Math.min(newWindowYPos, 0.0);
        } else {
            inputLineCenterY = inputControlMinY + inputControlHeight / 2.0;
            inputLineBottomY = inputControlMaxY;
            newWindowYPos = Math.min(visibleAreaMaxY / 2.0 - inputLineCenterY, 0.0);
        }
        Window w = node.getScene().getWindow();
        if (this.origWindowYPos + inputLineBottomY > visibleAreaMaxY) {
            w.setY(newWindowYPos);
        } else {
            w.setY(this.origWindowYPos);
        }
    }

    private void saveWindowPosition(Node node) {
        Window w = node.getScene().getWindow();
        this.origWindowYPos = w.getY();
    }

    private void restoreWindowPosition(Node node) {
        Window window;
        Scene scene;
        if (node != null && (scene = node.getScene()) != null && (window = scene.getWindow()) != null) {
            window.setY(this.origWindowYPos);
        }
    }

    private void registerUnhideHandler(Node node) {
        if (this.unHideEventHandler == null) {
            this.unHideEventHandler = event -> {
                if (this.attachedNode != null && this.isVKHidden) {
                    double screenHeight = Utils.getScreen(this.attachedNode).getBounds().getHeight();
                    if (this.fxvk.getHeight() > 0.0 && vkPopup.getY() > screenHeight - this.fxvk.getHeight() && slideInTimeline.getStatus() != Animation.Status.RUNNING) {
                        FXVKSkin.startSlideIn();
                        if (vkAdjustWindow) {
                            this.adjustWindowPosition(this.attachedNode);
                        }
                    }
                }
                this.isVKHidden = false;
            };
        }
        node.addEventHandler(TouchEvent.TOUCH_PRESSED, this.unHideEventHandler);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.unHideEventHandler);
    }

    private void unRegisterUnhideHandler(Node node) {
        if (this.unHideEventHandler != null) {
            node.removeEventHandler(TouchEvent.TOUCH_PRESSED, this.unHideEventHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.unHideEventHandler);
        }
    }

    private String getNodeVKType(Node node) {
        Object typeValue = node.getProperties().get("vkType");
        String typeStr = null;
        if (typeValue instanceof String) {
            typeStr = ((String)typeValue).toLowerCase(Locale.ROOT);
        }
        return typeStr != null ? typeStr : "text";
    }

    private void updateKeyboardType(Node node) {
        String oldType = this.vkType;
        this.vkType = this.getNodeVKType(node);
        if (oldType == null || !this.vkType.equals(oldType)) {
            this.rebuildPrimaryVK(this.vkType);
        }
    }

    private void closeSecondaryVK() {
        if (secondaryVK != null) {
            secondaryVK.setAttachedNode(null);
            secondaryPopup.hide();
        }
    }

    private void setupPrimaryVK() {
        this.fxvk.setFocusTraversable(false);
        this.fxvk.setVisible(true);
        if (vkPopup == null) {
            vkPopup = new Popup();
            vkPopup.setAutoFix(false);
        }
        vkPopup.getContent().setAll((Node[])new Node[]{this.fxvk});
        double screenHeight = Utils.getScreen(this.fxvk).getBounds().getHeight();
        double width = Utils.getScreen(this.fxvk).getBounds().getWidth();
        slideInTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(250.0), new KeyValue(winY, screenHeight - 243.0, Interpolator.EASE_BOTH))});
        slideOutTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(250.0), event -> {
            if (hideAfterSlideOut && vkPopup.isShowing()) {
                vkPopup.hide();
            }
        }, new KeyValue(winY, screenHeight, Interpolator.EASE_BOTH))});
        this.fxvk.setPrefWidth(width);
        this.fxvk.setMinWidth(Double.NEGATIVE_INFINITY);
        this.fxvk.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.fxvk.setPrefHeight(243.0);
        this.fxvk.setMinHeight(Double.NEGATIVE_INFINITY);
        if (secondaryVKDelay == null) {
            secondaryVKDelay = new Timeline();
        }
        KeyFrame kf = new KeyFrame(Duration.millis(500.0), event -> {
            if (secondaryVKKey != null) {
                this.showSecondaryVK(secondaryVKKey);
            }
        }, new KeyValue[0]);
        secondaryVKDelay.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{kf});
        if (KEY_REPEAT_RATE > 0.0) {
            repeatInitialDelay = new Timeline(new KeyFrame(Duration.millis(KEY_REPEAT_DELAY), event -> {
                repeatKey.sendKeyEvents();
                repeatSubsequentDelay.playFromStart();
            }, new KeyValue[0]));
            repeatSubsequentDelay = new Timeline(new KeyFrame(Duration.millis(1000.0 / KEY_REPEAT_RATE), event -> repeatKey.sendKeyEvents(), new KeyValue[0]));
            repeatSubsequentDelay.setCycleCount(-1);
        }
    }

    void prerender(Node node) {
        if (this.fxvk != primaryVK) {
            return;
        }
        this.loadBoard("text");
        this.loadBoard("numeric");
        this.loadBoard("url");
        this.loadBoard("email");
        this.updateKeyboardType(node);
        this.fxvk.setVisible(true);
        if (!vkPopup.isShowing()) {
            Rectangle2D screenBounds = Utils.getScreen(node).getBounds();
            vkPopup.setX((screenBounds.getWidth() - this.fxvk.prefWidth(-1.0)) / 2.0);
            winY.set(screenBounds.getHeight());
            vkPopup.show(node.getScene().getWindow());
        }
    }

    public FXVKSkin(final FXVK fxvk) {
        super(fxvk, new BehaviorBase<FXVK>(fxvk, Collections.emptyList()));
        this.fxvk = fxvk;
        if (fxvk == FXVK.vk) {
            primaryVK = fxvk;
        }
        if (fxvk == primaryVK) {
            this.setupPrimaryVK();
        }
        fxvk.attachedNodeProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable valueModel) {
                Node oldNode = FXVKSkin.this.attachedNode;
                FXVKSkin.this.attachedNode = fxvk.getAttachedNode();
                if (fxvk != primaryVK) {
                    return;
                }
                FXVKSkin.this.closeSecondaryVK();
                if (FXVKSkin.this.attachedNode != null) {
                    if (oldNode != null) {
                        FXVKSkin.this.unRegisterUnhideHandler(oldNode);
                    }
                    FXVKSkin.this.registerUnhideHandler(FXVKSkin.this.attachedNode);
                    FXVKSkin.this.updateKeyboardType(FXVKSkin.this.attachedNode);
                    if ((oldNode == null || oldNode.getScene() == null || oldNode.getScene().getWindow() != FXVKSkin.this.attachedNode.getScene().getWindow()) && vkPopup.isShowing()) {
                        vkPopup.hide();
                    }
                    if (!vkPopup.isShowing()) {
                        Rectangle2D screenBounds = Utils.getScreen(FXVKSkin.this.attachedNode).getBounds();
                        vkPopup.setX((screenBounds.getWidth() - fxvk.prefWidth(-1.0)) / 2.0);
                        if (oldNode == null || FXVKSkin.this.isVKHidden) {
                            winY.set(screenBounds.getHeight());
                        } else {
                            winY.set(screenBounds.getHeight() - 243.0);
                        }
                        vkPopup.show(FXVKSkin.this.attachedNode.getScene().getWindow());
                    }
                    if (oldNode == null || FXVKSkin.this.isVKHidden) {
                        FXVKSkin.startSlideIn();
                    }
                    if (vkAdjustWindow) {
                        if (oldNode == null || oldNode.getScene() == null || oldNode.getScene().getWindow() != FXVKSkin.this.attachedNode.getScene().getWindow()) {
                            FXVKSkin.this.saveWindowPosition(FXVKSkin.this.attachedNode);
                        }
                        FXVKSkin.this.adjustWindowPosition(FXVKSkin.this.attachedNode);
                    }
                } else {
                    if (oldNode != null) {
                        FXVKSkin.this.unRegisterUnhideHandler(oldNode);
                    }
                    FXVKSkin.startSlideOut(true);
                    if (vkAdjustWindow) {
                        FXVKSkin.this.restoreWindowPosition(oldNode);
                    }
                }
                FXVKSkin.this.isVKHidden = false;
            }
        });
    }

    private void rebuildSecondaryVK() {
        if (FXVKSkin.secondaryVK.chars != null) {
            int end;
            int start;
            int nKeys = FXVKSkin.secondaryVK.chars.length;
            int nRows = (int)Math.floor(Math.sqrt(Math.max(1, nKeys - 2)));
            int nKeysPerRow = (int)Math.ceil((double)nKeys / (double)nRows);
            ArrayList<List<Key>> rows = new ArrayList<List<Key>>(2);
            for (int i = 0; i < nRows && (start = i * nKeysPerRow) < (end = Math.min(start + nKeysPerRow, nKeys)); ++i) {
                ArrayList<CharKey> keys = new ArrayList<CharKey>(nKeysPerRow);
                for (int j = start; j < end; ++j) {
                    CharKey tmpKey = new CharKey(FXVKSkin.secondaryVK.chars[j], null, null);
                    tmpKey.col = (j - start) * 2;
                    tmpKey.colSpan = 2;
                    for (String sc : tmpKey.getStyleClass()) {
                        tmpKey.text.getStyleClass().add(sc + "-text");
                        tmpKey.altText.getStyleClass().add(sc + "-alttext");
                        tmpKey.icon.getStyleClass().add(sc + "-icon");
                    }
                    if (FXVKSkin.secondaryVK.chars[j] != null && FXVKSkin.secondaryVK.chars[j].length() > 1) {
                        tmpKey.text.getStyleClass().add("multi-char-text");
                    }
                    keys.add(tmpKey);
                }
                rows.add(keys);
            }
            this.currentBoard = rows;
            this.getChildren().clear();
            this.numCols = 0;
            for (List<Key> row : this.currentBoard) {
                for (Key key : row) {
                    this.numCols = Math.max(this.numCols, key.col + key.colSpan);
                }
                this.getChildren().addAll((Collection<Node>)row);
            }
        }
    }

    private void rebuildPrimaryVK(String type) {
        this.currentBoard = this.loadBoard(type);
        this.clearStateKeys();
        this.getChildren().clear();
        this.numCols = 0;
        for (List<Key> row : this.currentBoard) {
            for (Key key : row) {
                this.numCols = Math.max(this.numCols, key.col + key.colSpan);
            }
            this.getChildren().addAll((Collection<Node>)row);
        }
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + (double)(56 * this.numCols) + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + 400.0 + bottomInset;
    }

    @Override
    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        int numRows = this.currentBoard.size();
        double colWidth = (contentWidth - (double)((this.numCols - 1) * 6)) / (double)this.numCols;
        double rowHeight = (contentHeight - (double)((numRows - 1) * 6)) / (double)numRows;
        double rowY = contentY;
        for (List<Key> row : this.currentBoard) {
            for (Key key : row) {
                double startX = contentX + (double)key.col * (colWidth + 6.0);
                double width = (double)key.colSpan * (colWidth + 6.0) - 6.0;
                key.resizeRelocate((int)(startX + 0.5), (int)(rowY + 0.5), width, rowHeight);
            }
            rowY += rowHeight + 6.0;
        }
    }

    private void showSecondaryVK(CharKey key) {
        if (key != null) {
            Node textInput = primaryVK.getAttachedNode();
            if (secondaryVK == null) {
                secondaryVK = new FXVK();
                secondaryVK.setSkin(new FXVKSkin(secondaryVK));
                secondaryVK.getStyleClass().setAll((String[])new String[]{"fxvk-secondary"});
                secondaryPopup = new Popup();
                secondaryPopup.setAutoHide(true);
                secondaryPopup.getContent().add(secondaryVK);
            }
            FXVKSkin.secondaryVK.chars = null;
            ArrayList<String> secondaryList = new ArrayList<String>();
            if (!this.isSymbol && key.letterChars != null && key.letterChars.length() > 0) {
                if (this.shiftDown || this.capsDown) {
                    secondaryList.add(key.letterChars.toUpperCase());
                } else {
                    secondaryList.add(key.letterChars);
                }
            }
            if (key.altChars != null && key.altChars.length() > 0) {
                if (this.shiftDown || this.capsDown) {
                    secondaryList.add(key.altChars.toUpperCase());
                } else {
                    secondaryList.add(key.altChars);
                }
            }
            if (key.moreChars != null && key.moreChars.length > 0) {
                if (this.isSymbol) {
                    for (String ch : key.moreChars) {
                        if (Character.isLetter(ch.charAt(0))) continue;
                        secondaryList.add(ch);
                    }
                } else {
                    for (String ch : key.moreChars) {
                        if (!Character.isLetter(ch.charAt(0))) continue;
                        if (this.shiftDown || this.capsDown) {
                            secondaryList.add(ch.toUpperCase());
                            continue;
                        }
                        secondaryList.add(ch);
                    }
                }
            }
            boolean isMultiChar = false;
            for (String s : secondaryList) {
                if (s.length() <= 1) continue;
                isMultiChar = true;
            }
            FXVKSkin.secondaryVK.chars = secondaryList.toArray(new String[secondaryList.size()]);
            if (FXVKSkin.secondaryVK.chars.length > 1) {
                if (secondaryVK.getSkin() != null) {
                    ((FXVKSkin)secondaryVK.getSkin()).rebuildSecondaryVK();
                }
                secondaryVK.setAttachedNode(textInput);
                FXVKSkin primarySkin = (FXVKSkin)primaryVK.getSkin();
                FXVKSkin secondarySkin = (FXVKSkin)secondaryVK.getSkin();
                int nKeys = FXVKSkin.secondaryVK.chars.length;
                int nRows = (int)Math.floor(Math.sqrt(Math.max(1, nKeys - 2)));
                int nKeysPerRow = (int)Math.ceil((double)nKeys / (double)nRows);
                double w = this.snappedLeftInset() + this.snappedRightInset() + (double)nKeysPerRow * 40.0 * (double)(isMultiChar ? 2 : 1) + (double)((nKeysPerRow - 1) * 6);
                double h = this.snappedTopInset() + this.snappedBottomInset() + (double)nRows * 56.0 + (double)((nRows - 1) * 6);
                secondaryVK.setPrefWidth(w);
                secondaryVK.setMinWidth(Double.NEGATIVE_INFINITY);
                secondaryVK.setPrefHeight(h);
                secondaryVK.setMinHeight(Double.NEGATIVE_INFINITY);
                Platform.runLater(() -> {
                    Point2D nodePoint = Utils.pointRelativeTo(key, w, h, HPos.CENTER, VPos.TOP, 5.0, -3.0, true);
                    double x = nodePoint.getX();
                    double y = nodePoint.getY();
                    Scene scene = key.getScene();
                    x = Math.min(x, scene.getWindow().getX() + scene.getWidth() - w);
                    secondaryPopup.show(key.getScene().getWindow(), x, y);
                });
            }
        } else {
            this.closeSecondaryVK();
        }
    }

    private List<List<Key>> loadBoard(String type) {
        List<List<Key>> tmpBoard = boardMap.get(type);
        if (tmpBoard != null) {
            return tmpBoard;
        }
        String boardFileName = type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase() + "Board.txt";
        try {
            String line;
            tmpBoard = new ArrayList<List<Key>>(5);
            ArrayList<Key> keys = new ArrayList<Key>(20);
            InputStream boardFile = FXVKSkin.class.getResourceAsStream(boardFileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(boardFile));
            int c = 0;
            int col = 0;
            int colSpan = 1;
            boolean identifier = false;
            ArrayList<String> charsList = new ArrayList<String>(10);
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                for (int i = 0; i < line.length(); ++i) {
                    char ch = line.charAt(i);
                    if (ch == ' ') {
                        ++c;
                        continue;
                    }
                    if (ch == '[') {
                        col = c;
                        charsList = new ArrayList(10);
                        identifier = false;
                        continue;
                    }
                    if (ch == ']') {
                        Key key;
                        String chars = "";
                        String alt = null;
                        String[] moreChars = null;
                        for (int idx = 0; idx < charsList.size(); ++idx) {
                            charsList.set(idx, FXVKCharEntities.get((String)charsList.get(idx)));
                        }
                        int listSize = charsList.size();
                        if (listSize > 0) {
                            chars = (String)charsList.get(0);
                            if (listSize > 1) {
                                alt = (String)charsList.get(1);
                                if (listSize > 2) {
                                    moreChars = charsList.subList(2, listSize).toArray(new String[listSize - 2]);
                                }
                            }
                        }
                        colSpan = c - col;
                        if (identifier) {
                            if ("$shift".equals(chars)) {
                                key = new KeyboardStateKey("", null, "shift"){

                                    @Override
                                    protected void release() {
                                        FXVKSkin.this.pressShift();
                                    }

                                    @Override
                                    public void update(boolean capsDown, boolean shiftDown, boolean isSymbol) {
                                        if (isSymbol) {
                                            this.setDisable(true);
                                            this.setVisible(false);
                                        } else {
                                            if (capsDown) {
                                                this.icon.getStyleClass().remove("shift-icon");
                                                this.icon.getStyleClass().add("capslock-icon");
                                            } else {
                                                this.icon.getStyleClass().remove("capslock-icon");
                                                this.icon.getStyleClass().add("shift-icon");
                                            }
                                            this.setDisable(false);
                                            this.setVisible(true);
                                        }
                                    }
                                };
                                key.getStyleClass().add("shift");
                            } else if ("$SymbolABC".equals(chars)) {
                                key = new KeyboardStateKey("!#123", "ABC", "symbol"){

                                    @Override
                                    protected void release() {
                                        FXVKSkin.this.pressSymbolABC();
                                    }
                                };
                            } else if ("$backspace".equals(chars)) {
                                key = new KeyCodeKey("backspace", "\b", KeyCode.BACK_SPACE){

                                    @Override
                                    protected void press() {
                                        if (KEY_REPEAT_RATE > 0.0) {
                                            FXVKSkin.this.clearShift();
                                            this.sendKeyEvents();
                                            repeatKey = this;
                                            repeatInitialDelay.playFromStart();
                                        } else {
                                            super.press();
                                        }
                                    }

                                    @Override
                                    protected void release() {
                                        if (KEY_REPEAT_RATE > 0.0) {
                                            repeatInitialDelay.stop();
                                            repeatSubsequentDelay.stop();
                                        } else {
                                            super.release();
                                        }
                                    }
                                };
                                key.getStyleClass().add("backspace");
                            } else if ("$enter".equals(chars)) {
                                key = new KeyCodeKey("enter", "\n", KeyCode.ENTER);
                                key.getStyleClass().add("enter");
                            } else if ("$tab".equals(chars)) {
                                key = new KeyCodeKey("tab", "\t", KeyCode.TAB);
                            } else if ("$space".equals(chars)) {
                                key = new CharKey(" ", " ", null, "space");
                            } else if ("$clear".equals(chars)) {
                                key = new SuperKey("clear", "");
                            } else if ("$.org".equals(chars)) {
                                key = new SuperKey(".org", ".org");
                            } else if ("$.com".equals(chars)) {
                                key = new SuperKey(".com", ".com");
                            } else if ("$.net".equals(chars)) {
                                key = new SuperKey(".net", ".net");
                            } else if ("$oracle.com".equals(chars)) {
                                key = new SuperKey("oracle.com", "oracle.com");
                            } else if ("$gmail.com".equals(chars)) {
                                key = new SuperKey("gmail.com", "gmail.com");
                            } else if ("$hide".equals(chars)) {
                                key = new KeyboardStateKey("hide", null, "hide"){

                                    @Override
                                    protected void release() {
                                        FXVKSkin.this.isVKHidden = true;
                                        FXVKSkin.startSlideOut(false);
                                        if (vkAdjustWindow) {
                                            FXVKSkin.this.restoreWindowPosition(FXVKSkin.this.attachedNode);
                                        }
                                    }
                                };
                                key.getStyleClass().add("hide");
                            } else {
                                key = "$undo".equals(chars) ? new SuperKey("undo", "") : ("$redo".equals(chars) ? new SuperKey("redo", "") : null);
                            }
                        } else {
                            key = new CharKey(chars, alt, moreChars);
                        }
                        if (key == null) continue;
                        key.col = col;
                        key.colSpan = colSpan;
                        for (String sc : key.getStyleClass()) {
                            key.text.getStyleClass().add(sc + "-text");
                            key.altText.getStyleClass().add(sc + "-alttext");
                            key.icon.getStyleClass().add(sc + "-icon");
                        }
                        if (chars != null && chars.length() > 1) {
                            key.text.getStyleClass().add("multi-char-text");
                        }
                        if (alt != null && alt.length() > 1) {
                            key.altText.getStyleClass().add("multi-char-text");
                        }
                        keys.add(key);
                        continue;
                    }
                    for (int j = i; j < line.length(); ++j) {
                        char c2 = line.charAt(j);
                        boolean e = false;
                        if (c2 == '\\') {
                            ++i;
                            e = true;
                            c2 = line.charAt(++j);
                        }
                        if (c2 == '$' && !e) {
                            identifier = true;
                        }
                        if (c2 == '|' && !e) {
                            charsList.add(line.substring(i, j));
                            i = j + 1;
                            continue;
                        }
                        if (c2 != ']' && c2 != ' ' || e) continue;
                        charsList.add(line.substring(i, j));
                        i = j - 1;
                        break;
                    }
                    ++c;
                }
                c = 0;
                col = 0;
                tmpBoard.add(keys);
                keys = new ArrayList(20);
            }
            reader.close();
            boardMap.put(type, tmpBoard);
            return tmpBoard;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    static {
        slideInTimeline = new Timeline();
        slideOutTimeline = new Timeline();
        hideAfterSlideOut = false;
        KEY_REPEAT_DELAY = 400.0;
        KEY_REPEAT_DELAY_MIN = 100.0;
        KEY_REPEAT_DELAY_MAX = 1000.0;
        KEY_REPEAT_RATE = 25.0;
        KEY_REPEAT_RATE_MIN = 2.0;
        KEY_REPEAT_RATE_MAX = 50.0;
        vkAdjustWindow = false;
        vkLookup = false;
        AccessController.doPrivileged(() -> {
            String s = System.getProperty("com.sun.javafx.vk.adjustwindow");
            if (s != null) {
                vkAdjustWindow = Boolean.valueOf(s);
            }
            if ((s = System.getProperty("com.sun.javafx.sqe.vk.lookup")) != null) {
                vkLookup = Boolean.valueOf(s);
            }
            if ((s = System.getProperty("com.sun.javafx.virtualKeyboard.backspaceRepeatDelay")) != null) {
                Double delay = Double.valueOf(s);
                KEY_REPEAT_DELAY = Math.min(Math.max(delay, KEY_REPEAT_DELAY_MIN), KEY_REPEAT_DELAY_MAX);
            }
            if ((s = System.getProperty("com.sun.javafx.virtualKeyboard.backspaceRepeatRate")) != null) {
                Double rate = Double.valueOf(s);
                KEY_REPEAT_RATE = rate <= 0.0 ? 0.0 : Math.min(Math.max(rate, KEY_REPEAT_RATE_MIN), KEY_REPEAT_RATE_MAX);
            }
            return null;
        });
        winY = new SimpleDoubleProperty();
        winY.addListener(valueModel -> {
            if (vkPopup != null) {
                vkPopup.setY(winY.get());
            }
        });
    }

    private class KeyboardStateKey
    extends Key {
        private final String defaultText;
        private final String toggledText;

        private KeyboardStateKey(String defaultText, String toggledText, String id) {
            this.defaultText = defaultText;
            this.toggledText = toggledText;
            this.text.setText(this.defaultText);
            if (vkLookup && id != null) {
                this.setId(id);
            }
            this.getStyleClass().add("special");
        }

        @Override
        public void update(boolean capsDown, boolean shiftDown, boolean isSymbol) {
            if (isSymbol) {
                this.text.setText(this.toggledText);
            } else {
                this.text.setText(this.defaultText);
            }
        }
    }

    private class KeyCodeKey
    extends SuperKey {
        private KeyCode code;

        private KeyCodeKey(String letter, String c, KeyCode code) {
            super(letter, c);
            this.code = code;
            if (vkLookup) {
                this.setId(letter);
            }
        }

        @Override
        protected void sendKeyEvents() {
            Node target = FXVKSkin.this.fxvk.getAttachedNode();
            if (target instanceof EventTarget) {
                target.fireEvent(new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, this.chars, this.code, FXVKSkin.this.shiftDown, false, false, false));
                target.fireEvent(new KeyEvent(KeyEvent.KEY_TYPED, this.chars, "", KeyCode.UNDEFINED, FXVKSkin.this.shiftDown, false, false, false));
                target.fireEvent(new KeyEvent(KeyEvent.KEY_RELEASED, KeyEvent.CHAR_UNDEFINED, this.chars, this.code, FXVKSkin.this.shiftDown, false, false, false));
            }
        }
    }

    private class SuperKey
    extends TextInputKey {
        private SuperKey(String letter, String code) {
            this.chars = code;
            this.text.setText(letter);
            this.getStyleClass().add("special");
            if (vkLookup) {
                this.setId(letter);
            }
        }
    }

    private class CharKey
    extends TextInputKey {
        private final String letterChars;
        private final String altChars;
        private final String[] moreChars;

        private CharKey(String letter, String alt, String[] moreChars, String id) {
            this.letterChars = letter;
            this.altChars = alt;
            this.moreChars = moreChars;
            this.chars = this.letterChars;
            this.text.setText(this.chars);
            this.altText.setText(this.altChars);
            if (vkLookup) {
                this.setId((id != null ? id : this.chars).replaceAll("\\.", ""));
            }
        }

        private CharKey(String letter, String alt, String[] moreChars) {
            this(letter, alt, moreChars, (String)null);
        }

        @Override
        protected void press() {
            super.press();
            if (this.letterChars.equals(this.altChars) && this.moreChars == null) {
                return;
            }
            if (FXVKSkin.this.fxvk == primaryVK) {
                FXVKSkin.this.showSecondaryVK(null);
                secondaryVKKey = this;
                secondaryVKDelay.playFromStart();
            }
        }

        @Override
        protected void release() {
            super.release();
            if (this.letterChars.equals(this.altChars) && this.moreChars == null) {
                return;
            }
            if (FXVKSkin.this.fxvk == primaryVK) {
                secondaryVKDelay.stop();
            }
        }

        @Override
        public void update(boolean capsDown, boolean shiftDown, boolean isSymbol) {
            if (isSymbol) {
                this.chars = this.altChars;
                this.text.setText(this.chars);
                if (this.moreChars != null && this.moreChars.length > 0 && !Character.isLetter(this.moreChars[0].charAt(0))) {
                    this.altText.setText(this.moreChars[0]);
                } else {
                    this.altText.setText(null);
                }
            } else {
                this.chars = capsDown || shiftDown ? this.letterChars.toUpperCase() : this.letterChars.toLowerCase();
                this.text.setText(this.chars);
                this.altText.setText(this.altChars);
            }
        }
    }

    private class TextInputKey
    extends Key {
        String chars;

        private TextInputKey() {
            this.chars = "";
        }

        @Override
        protected void press() {
        }

        @Override
        protected void release() {
            if (FXVKSkin.this.fxvk != secondaryVK && secondaryPopup != null && secondaryPopup.isShowing()) {
                return;
            }
            this.sendKeyEvents();
            if (FXVKSkin.this.fxvk == secondaryVK) {
                FXVKSkin.this.showSecondaryVK(null);
            }
            super.release();
        }

        protected void sendKeyEvents() {
            Node target = FXVKSkin.this.fxvk.getAttachedNode();
            if (target instanceof EventTarget && this.chars != null) {
                target.fireEvent(new KeyEvent(KeyEvent.KEY_TYPED, this.chars, "", KeyCode.UNDEFINED, FXVKSkin.this.shiftDown, false, false, false));
            }
        }
    }

    private class Key
    extends Region {
        int col = 0;
        int colSpan = 1;
        protected final Text text;
        protected final Text altText;
        protected final Region icon = new Region();

        protected Key() {
            this.text = new Text();
            this.text.setTextOrigin(VPos.TOP);
            this.altText = new Text();
            this.altText.setTextOrigin(VPos.TOP);
            this.getChildren().setAll((Node[])new Node[]{this.text, this.altText, this.icon});
            this.getStyleClass().setAll((String[])new String[]{"key"});
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    this.press();
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
                if (event.getButton() == MouseButton.PRIMARY) {
                    this.release();
                }
            });
        }

        protected void press() {
        }

        protected void release() {
            FXVKSkin.this.clearShift();
        }

        public void update(boolean capsDown, boolean shiftDown, boolean isSymbol) {
        }

        @Override
        protected void layoutChildren() {
            double left = this.snappedLeftInset();
            double top = this.snappedTopInset();
            double width = this.getWidth() - left - this.snappedRightInset();
            double height = this.getHeight() - top - this.snappedBottomInset();
            this.text.setVisible(this.icon.getBackground() == null);
            double contentPrefWidth = this.text.prefWidth(-1.0);
            double contentPrefHeight = this.text.prefHeight(-1.0);
            this.text.resizeRelocate((int)(left + (width - contentPrefWidth) / 2.0 + 0.5), (int)(top + (height - contentPrefHeight) / 2.0 + 0.5), (int)contentPrefWidth, (int)contentPrefHeight);
            this.altText.setVisible(this.icon.getBackground() == null && this.altText.getText().length() > 0);
            contentPrefWidth = this.altText.prefWidth(-1.0);
            contentPrefHeight = this.altText.prefHeight(-1.0);
            this.altText.resizeRelocate((double)((int)left) + (width - contentPrefWidth) + 0.5, (int)(top + (height - contentPrefHeight) / 2.0 + 0.5 - height / 2.0), (int)contentPrefWidth, (int)contentPrefHeight);
            this.icon.resizeRelocate(left - 8.0, top - 8.0, width + 16.0, height + 16.0);
        }
    }
}

