/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.DatePickerContent;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.chrono.HijrahDate;
import java.time.chrono.IsoChronology;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import javafx.geometry.Pos;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;

class DatePickerHijrahContent
extends DatePickerContent {
    private Label hijrahMonthYearLabel;

    DatePickerHijrahContent(DatePicker datePicker) {
        super(datePicker);
    }

    @Override
    protected Chronology getPrimaryChronology() {
        return IsoChronology.INSTANCE;
    }

    @Override
    protected BorderPane createMonthYearPane() {
        BorderPane monthYearPane = super.createMonthYearPane();
        this.hijrahMonthYearLabel = new Label();
        this.hijrahMonthYearLabel.getStyleClass().add("secondary-label");
        monthYearPane.setBottom(this.hijrahMonthYearLabel);
        BorderPane.setAlignment(this.hijrahMonthYearLabel, Pos.CENTER);
        return monthYearPane;
    }

    @Override
    protected void updateMonthYearPane() {
        super.updateMonthYearPane();
        Locale locale = this.getLocale();
        HijrahChronology chrono = HijrahChronology.INSTANCE;
        long firstMonth = -1L;
        long firstYear = -1L;
        String firstMonthStr = null;
        String firstYearStr = null;
        String hijrahStr = null;
        YearMonth displayedYearMonth = (YearMonth)this.displayedYearMonthProperty().get();
        for (DateCell dayCell : this.dayCells) {
            LocalDate date = this.dayCellDate(dayCell);
            if (!displayedYearMonth.equals(YearMonth.from(date))) continue;
            try {
                HijrahDate cDate = chrono.date(date);
                long month = cDate.getLong(ChronoField.MONTH_OF_YEAR);
                long year = cDate.getLong(ChronoField.YEAR);
                if (hijrahStr != null && month == firstMonth) continue;
                String monthStr = this.monthFormatter.withLocale(locale).withChronology(chrono).withDecimalStyle(DecimalStyle.of(locale)).format(cDate);
                String yearStr = this.yearFormatter.withLocale(locale).withChronology(chrono).withDecimalStyle(DecimalStyle.of(locale)).format(cDate);
                if (hijrahStr == null) {
                    firstMonth = month;
                    firstYear = year;
                    firstMonthStr = monthStr;
                    firstYearStr = yearStr;
                    hijrahStr = firstMonthStr + " " + firstYearStr;
                    continue;
                }
                if (year > firstYear) {
                    hijrahStr = firstMonthStr + " " + firstYearStr + " - " + monthStr + " " + yearStr;
                    break;
                }
                hijrahStr = firstMonthStr + " - " + monthStr + " " + firstYearStr;
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        this.hijrahMonthYearLabel.setText(hijrahStr);
    }

    @Override
    protected void createDayCells() {
        super.createDayCells();
        for (DateCell dayCell : this.dayCells) {
            Text secondaryText = new Text();
            dayCell.getProperties().put("DateCell.secondaryText", secondaryText);
        }
    }

    @Override
    void updateDayCells() {
        super.updateDayCells();
        Locale locale = this.getLocale();
        HijrahChronology chrono = HijrahChronology.INSTANCE;
        int majorityMonth = -1;
        int visibleDaysInMajorityMonth = -1;
        int curMonth = -1;
        boolean visibleDaysInCurMonth = false;
        for (DateCell dayCell : this.dayCells) {
            Text secondaryText = (Text)dayCell.getProperties().get("DateCell.secondaryText");
            dayCell.getStyleClass().add("hijrah-day-cell");
            secondaryText.getStyleClass().setAll((String[])new String[]{"text", "secondary-text"});
            try {
                HijrahDate cDate = chrono.date(this.dayCellDate(dayCell));
                String hijrahStr = this.dayCellFormatter.withLocale(locale).withChronology(chrono).withDecimalStyle(DecimalStyle.of(locale)).format(cDate);
                secondaryText.setText(hijrahStr);
                dayCell.requestLayout();
            }
            catch (DateTimeException ex) {
                secondaryText.setText(" ");
                dayCell.setDisable(true);
            }
        }
    }
}

