/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.scene.traversal.Direction;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class DatePickerContent
extends VBox {
    protected DatePicker datePicker;
    private Button backMonthButton;
    private Button forwardMonthButton;
    private Button backYearButton;
    private Button forwardYearButton;
    private Label monthLabel;
    private Label yearLabel;
    protected GridPane gridPane;
    private int daysPerWeek;
    private List<DateCell> dayNameCells = new ArrayList<DateCell>();
    private List<DateCell> weekNumberCells = new ArrayList<DateCell>();
    protected List<DateCell> dayCells = new ArrayList<DateCell>();
    private LocalDate[] dayCellDates;
    private DateCell lastFocusedDayCell = null;
    final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM");
    final DateTimeFormatter monthFormatterSO = DateTimeFormatter.ofPattern("LLLL");
    final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("y");
    final DateTimeFormatter yearWithEraFormatter = DateTimeFormatter.ofPattern("GGGGy");
    final DateTimeFormatter weekNumberFormatter = DateTimeFormatter.ofPattern("w");
    final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("ccc");
    final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
    private ObjectProperty<YearMonth> displayedYearMonth = new SimpleObjectProperty<YearMonth>(this, "displayedYearMonth");

    static String getString(String key) {
        return ControlResources.getString("DatePicker." + key);
    }

    DatePickerContent(final DatePicker datePicker) {
        DateCell cell;
        int i;
        this.datePicker = datePicker;
        this.getStyleClass().add("date-picker-popup");
        this.daysPerWeek = this.getDaysPerWeek();
        LocalDate date = (LocalDate)datePicker.getValue();
        this.displayedYearMonth.set(date != null ? YearMonth.from(date) : YearMonth.now());
        this.displayedYearMonth.addListener((observable, oldValue, newValue) -> this.updateValues());
        this.getChildren().add(this.createMonthYearPane());
        this.gridPane = new GridPane(){

            @Override
            protected double computePrefWidth(double height) {
                double width = super.computePrefWidth(height);
                int nCols = DatePickerContent.this.daysPerWeek + (datePicker.isShowWeekNumbers() ? 1 : 0);
                double snaphgap = this.snapSpace(this.getHgap());
                double left = this.snapSpace(this.getInsets().getLeft());
                double right = this.snapSpace(this.getInsets().getRight());
                double hgaps = snaphgap * (double)(nCols - 1);
                double contentWidth = width - left - right - hgaps;
                return this.snapSize(contentWidth / (double)nCols) * (double)nCols + left + right + hgaps;
            }

            @Override
            protected void layoutChildren() {
                if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                    super.layoutChildren();
                }
            }
        };
        this.gridPane.setFocusTraversable(true);
        this.gridPane.getStyleClass().add("calendar-grid");
        this.gridPane.setVgap(-1.0);
        this.gridPane.setHgap(-1.0);
        WeakChangeListener<Node> weakFocusOwnerListener = new WeakChangeListener<Node>((ov2, oldFocusOwner, newFocusOwner) -> {
            if (newFocusOwner == this.gridPane) {
                if (oldFocusOwner instanceof DateCell) {
                    this.gridPane.impl_traverse(Direction.PREVIOUS);
                } else if (this.lastFocusedDayCell != null) {
                    Platform.runLater(() -> this.lastFocusedDayCell.requestFocus());
                } else {
                    this.clearFocus();
                }
            }
        });
        this.gridPane.sceneProperty().addListener(new WeakChangeListener<Scene>((ov, oldScene, newScene) -> {
            if (oldScene != null) {
                oldScene.focusOwnerProperty().removeListener(weakFocusOwnerListener);
            }
            if (newScene != null) {
                newScene.focusOwnerProperty().addListener(weakFocusOwnerListener);
            }
        }));
        if (this.gridPane.getScene() != null) {
            this.gridPane.getScene().focusOwnerProperty().addListener(weakFocusOwnerListener);
        }
        for (i = 0; i < this.daysPerWeek; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add("day-name-cell");
            this.dayNameCells.add(cell);
        }
        for (i = 0; i < 6; ++i) {
            cell = new DateCell();
            cell.getStyleClass().add("week-number-cell");
            this.weekNumberCells.add(cell);
        }
        this.createDayCells();
        this.updateGrid();
        this.getChildren().add(this.gridPane);
        this.refresh();
        this.addEventHandler(KeyEvent.ANY, e -> {
            Node node = this.getScene().getFocusOwner();
            if (node instanceof DateCell) {
                this.lastFocusedDayCell = (DateCell)node;
            }
            if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                switch (e.getCode()) {
                    case HOME: {
                        this.goToDate(LocalDate.now(), true);
                        e.consume();
                        break;
                    }
                    case PAGE_UP: {
                        if (PlatformUtil.isMac() && e.isMetaDown() || !PlatformUtil.isMac() && e.isControlDown()) {
                            if (!this.backYearButton.isDisabled()) {
                                this.forward(-1, ChronoUnit.YEARS, true);
                            }
                        } else if (!this.backMonthButton.isDisabled()) {
                            this.forward(-1, ChronoUnit.MONTHS, true);
                        }
                        e.consume();
                        break;
                    }
                    case PAGE_DOWN: {
                        if (PlatformUtil.isMac() && e.isMetaDown() || !PlatformUtil.isMac() && e.isControlDown()) {
                            if (!this.forwardYearButton.isDisabled()) {
                                this.forward(1, ChronoUnit.YEARS, true);
                            }
                        } else if (!this.forwardMonthButton.isDisabled()) {
                            this.forward(1, ChronoUnit.MONTHS, true);
                        }
                        e.consume();
                    }
                }
                node = this.getScene().getFocusOwner();
                if (node instanceof DateCell) {
                    this.lastFocusedDayCell = (DateCell)node;
                }
            }
            switch (e.getCode()) {
                case F4: 
                case F10: 
                case UP: 
                case DOWN: 
                case LEFT: 
                case RIGHT: 
                case TAB: {
                    break;
                }
                case ESCAPE: {
                    datePicker.hide();
                    e.consume();
                    break;
                }
                default: {
                    e.consume();
                }
            }
        });
    }

    ObjectProperty<YearMonth> displayedYearMonthProperty() {
        return this.displayedYearMonth;
    }

    protected BorderPane createMonthYearPane() {
        BorderPane monthYearPane = new BorderPane();
        monthYearPane.getStyleClass().add("month-year-pane");
        HBox monthSpinner = new HBox();
        monthSpinner.getStyleClass().add("spinner");
        this.backMonthButton = new Button();
        this.backMonthButton.getStyleClass().add("left-button");
        this.forwardMonthButton = new Button();
        this.forwardMonthButton.getStyleClass().add("right-button");
        StackPane leftMonthArrow = new StackPane();
        leftMonthArrow.getStyleClass().add("left-arrow");
        leftMonthArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backMonthButton.setGraphic(leftMonthArrow);
        StackPane rightMonthArrow = new StackPane();
        rightMonthArrow.getStyleClass().add("right-arrow");
        rightMonthArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardMonthButton.setGraphic(rightMonthArrow);
        this.backMonthButton.setOnAction(t -> this.forward(-1, ChronoUnit.MONTHS, false));
        this.monthLabel = new Label();
        this.monthLabel.getStyleClass().add("spinner-label");
        this.forwardMonthButton.setOnAction(t -> this.forward(1, ChronoUnit.MONTHS, false));
        monthSpinner.getChildren().addAll((Node[])new Node[]{this.backMonthButton, this.monthLabel, this.forwardMonthButton});
        monthYearPane.setLeft(monthSpinner);
        HBox yearSpinner = new HBox();
        yearSpinner.getStyleClass().add("spinner");
        this.backYearButton = new Button();
        this.backYearButton.getStyleClass().add("left-button");
        this.forwardYearButton = new Button();
        this.forwardYearButton.getStyleClass().add("right-button");
        StackPane leftYearArrow = new StackPane();
        leftYearArrow.getStyleClass().add("left-arrow");
        leftYearArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backYearButton.setGraphic(leftYearArrow);
        StackPane rightYearArrow = new StackPane();
        rightYearArrow.getStyleClass().add("right-arrow");
        rightYearArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardYearButton.setGraphic(rightYearArrow);
        this.backYearButton.setOnAction(t -> this.forward(-1, ChronoUnit.YEARS, false));
        this.yearLabel = new Label();
        this.yearLabel.getStyleClass().add("spinner-label");
        this.forwardYearButton.setOnAction(t -> this.forward(1, ChronoUnit.YEARS, false));
        yearSpinner.getChildren().addAll((Node[])new Node[]{this.backYearButton, this.yearLabel, this.forwardYearButton});
        yearSpinner.setFillHeight(false);
        monthYearPane.setRight(yearSpinner);
        return monthYearPane;
    }

    private void refresh() {
        this.updateMonthLabelWidth();
        this.updateDayNameCells();
        this.updateValues();
    }

    void updateValues() {
        this.updateWeeknumberDateCells();
        this.updateDayCells();
        this.updateMonthYearPane();
    }

    void updateGrid() {
        int i;
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getChildren().clear();
        int nCols = this.daysPerWeek + (this.datePicker.isShowWeekNumbers() ? 1 : 0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        for (i = 0; i < nCols; ++i) {
            this.gridPane.getColumnConstraints().add(columnConstraints);
        }
        for (i = 0; i < this.daysPerWeek; ++i) {
            this.gridPane.add(this.dayNameCells.get(i), i + nCols - this.daysPerWeek, 1);
        }
        if (this.datePicker.isShowWeekNumbers()) {
            for (i = 0; i < 6; ++i) {
                this.gridPane.add(this.weekNumberCells.get(i), 0, i + 2);
            }
        }
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                this.gridPane.add(this.dayCells.get(row * this.daysPerWeek + col), col + nCols - this.daysPerWeek, row + 2);
            }
        }
    }

    void updateDayNameCells() {
        int firstDayOfWeek = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        LocalDate date = LocalDate.of(2009, 7, 12 + firstDayOfWeek);
        for (int i = 0; i < this.daysPerWeek; ++i) {
            String name = this.weekDayNameFormatter.withLocale(this.getLocale()).format(date.plus(i, ChronoUnit.DAYS));
            this.dayNameCells.get(i).setText(this.titleCaseWord(name));
        }
    }

    void updateWeeknumberDateCells() {
        if (this.datePicker.isShowWeekNumbers()) {
            Locale locale = this.getLocale();
            int maxWeeksPerMonth = 6;
            LocalDate firstOfMonth = ((YearMonth)this.displayedYearMonth.get()).atDay(1);
            for (int i = 0; i < 6; ++i) {
                LocalDate date = firstOfMonth.plus(i, ChronoUnit.WEEKS);
                String cellText = this.weekNumberFormatter.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).format(date);
                this.weekNumberCells.get(i).setText(cellText);
            }
        }
    }

    void updateDayCells() {
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        int firstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        YearMonth curMonth = (YearMonth)this.displayedYearMonth.get();
        YearMonth prevMonth = null;
        YearMonth nextMonth = null;
        int daysInCurMonth = -1;
        int daysInPrevMonth = -1;
        int daysInNextMonth = -1;
        for (int i = 0; i < 6 * this.daysPerWeek; ++i) {
            DateCell dayCell = this.dayCells.get(i);
            dayCell.getStyleClass().setAll((String[])new String[]{"cell", "date-cell", "day-cell"});
            dayCell.setDisable(false);
            dayCell.setStyle(null);
            dayCell.setGraphic(null);
            dayCell.setTooltip(null);
            try {
                LocalDate date;
                if (daysInCurMonth == -1) {
                    daysInCurMonth = curMonth.lengthOfMonth();
                }
                YearMonth month = curMonth;
                int day = i - firstOfMonthIdx + 1;
                if (i < firstOfMonthIdx) {
                    if (prevMonth == null) {
                        prevMonth = curMonth.minusMonths(1L);
                        daysInPrevMonth = prevMonth.lengthOfMonth();
                    }
                    month = prevMonth;
                    day = i + daysInPrevMonth - firstOfMonthIdx + 1;
                    dayCell.getStyleClass().add("previous-month");
                } else if (i >= firstOfMonthIdx + daysInCurMonth) {
                    if (nextMonth == null) {
                        nextMonth = curMonth.plusMonths(1L);
                        daysInNextMonth = nextMonth.lengthOfMonth();
                    }
                    month = nextMonth;
                    day = i - daysInCurMonth - firstOfMonthIdx + 1;
                    dayCell.getStyleClass().add("next-month");
                }
                this.dayCellDates[i] = date = month.atDay(day);
                ChronoLocalDate cDate = chrono.date(date);
                dayCell.setDisable(false);
                if (this.isToday(date)) {
                    dayCell.getStyleClass().add("today");
                }
                if (date.equals(this.datePicker.getValue())) {
                    dayCell.getStyleClass().add("selected");
                }
                String cellText = this.dayCellFormatter.withLocale(locale).withChronology(chrono).withDecimalStyle(DecimalStyle.of(locale)).format(cDate);
                dayCell.setText(cellText);
                dayCell.updateItem(date, false);
                continue;
            }
            catch (DateTimeException ex) {
                dayCell.setText(" ");
                dayCell.setDisable(true);
            }
        }
    }

    private int getDaysPerWeek() {
        ValueRange range = this.getPrimaryChronology().range(ChronoField.DAY_OF_WEEK);
        return (int)(range.getMaximum() - range.getMinimum() + 1L);
    }

    private int getMonthsPerYear() {
        ValueRange range = this.getPrimaryChronology().range(ChronoField.MONTH_OF_YEAR);
        return (int)(range.getMaximum() - range.getMinimum() + 1L);
    }

    private void updateMonthLabelWidth() {
        if (this.monthLabel != null) {
            int monthsPerYear = this.getMonthsPerYear();
            double width = 0.0;
            for (int i = 0; i < monthsPerYear; ++i) {
                YearMonth yearMonth = ((YearMonth)this.displayedYearMonth.get()).withMonth(i + 1);
                String name = this.monthFormatterSO.withLocale(this.getLocale()).format(yearMonth);
                if (Character.isDigit(name.charAt(0))) {
                    name = this.monthFormatter.withLocale(this.getLocale()).format(yearMonth);
                }
                width = Math.max(width, Utils.computeTextWidth(this.monthLabel.getFont(), name, 0.0));
            }
            this.monthLabel.setMinWidth(width);
        }
    }

    protected void updateMonthYearPane() {
        LocalDate firstDayOfMonth;
        Chronology chrono;
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        String str = this.formatMonth(yearMonth);
        this.monthLabel.setText(str);
        str = this.formatYear(yearMonth);
        this.yearLabel.setText(str);
        double width = Utils.computeTextWidth(this.yearLabel.getFont(), str, 0.0);
        if (width > this.yearLabel.getMinWidth()) {
            this.yearLabel.setMinWidth(width);
        }
        this.backMonthButton.setDisable(!this.isValidDate(chrono = this.datePicker.getChronology(), firstDayOfMonth = yearMonth.atDay(1), -1, ChronoUnit.DAYS));
        this.forwardMonthButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth, 1, ChronoUnit.MONTHS));
        this.backYearButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth, -1, ChronoUnit.YEARS));
        this.forwardYearButton.setDisable(!this.isValidDate(chrono, firstDayOfMonth, 1, ChronoUnit.YEARS));
    }

    private String formatMonth(YearMonth yearMonth) {
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        try {
            ChronoLocalDate cDate = chrono.date(yearMonth.atDay(1));
            String str = this.monthFormatterSO.withLocale(this.getLocale()).withChronology(chrono).format(cDate);
            if (Character.isDigit(str.charAt(0))) {
                str = this.monthFormatter.withLocale(this.getLocale()).withChronology(chrono).format(cDate);
            }
            return this.titleCaseWord(str);
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    private String formatYear(YearMonth yearMonth) {
        Locale locale = this.getLocale();
        Chronology chrono = this.getPrimaryChronology();
        try {
            DateTimeFormatter formatter = this.yearFormatter;
            ChronoLocalDate cDate = chrono.date(yearMonth.atDay(1));
            int era = cDate.getEra().getValue();
            int nEras = chrono.eras().size();
            if (nEras == 2 && era == 0 || nEras > 2) {
                formatter = this.yearWithEraFormatter;
            }
            String str = formatter.withLocale(this.getLocale()).withChronology(chrono).withDecimalStyle(DecimalStyle.of(this.getLocale())).format(cDate);
            return str;
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    private String titleCaseWord(String str) {
        int firstChar;
        if (str.length() > 0 && !Character.isTitleCase(firstChar = str.codePointAt(0))) {
            str = new String(new int[]{Character.toTitleCase(firstChar)}, 0, 1) + str.substring(Character.offsetByCodePoints(str, 0, 1));
        }
        return str;
    }

    private int determineFirstOfMonthDayOfWeek() {
        int firstDayOfWeek = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        int firstOfMonthIdx = ((YearMonth)this.displayedYearMonth.get()).atDay(1).getDayOfWeek().getValue() - firstDayOfWeek;
        if (firstOfMonthIdx < 0) {
            firstOfMonthIdx += this.daysPerWeek;
        }
        return firstOfMonthIdx;
    }

    private boolean isToday(LocalDate localDate) {
        return localDate.equals(LocalDate.now());
    }

    protected LocalDate dayCellDate(DateCell dateCell) {
        assert (this.dayCellDates != null);
        return this.dayCellDates[this.dayCells.indexOf(dateCell)];
    }

    public void goToDayCell(DateCell dateCell, int offset, ChronoUnit unit, boolean focusDayCell) {
        this.goToDate(this.dayCellDate(dateCell).plus(offset, unit), focusDayCell);
    }

    protected void forward(int offset, ChronoUnit unit, boolean focusDayCell) {
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        DateCell dateCell = this.lastFocusedDayCell;
        if (dateCell == null || !this.dayCellDate(dateCell).getMonth().equals(yearMonth.getMonth())) {
            dateCell = this.findDayCellForDate(yearMonth.atDay(1));
        }
        this.goToDayCell(dateCell, offset, unit, focusDayCell);
    }

    public void goToDate(LocalDate date, boolean focusDayCell) {
        if (this.isValidDate(this.datePicker.getChronology(), date)) {
            this.displayedYearMonth.set(YearMonth.from(date));
            if (focusDayCell) {
                this.findDayCellForDate(date).requestFocus();
            }
        }
    }

    public void selectDayCell(DateCell dateCell) {
        this.datePicker.setValue(this.dayCellDate(dateCell));
        this.datePicker.hide();
    }

    private DateCell findDayCellForDate(LocalDate date) {
        for (int i = 0; i < this.dayCellDates.length; ++i) {
            if (!date.equals(this.dayCellDates[i])) continue;
            return this.dayCells.get(i);
        }
        return this.dayCells.get(this.dayCells.size() / 2 + 1);
    }

    void clearFocus() {
        LocalDate focusDate = (LocalDate)this.datePicker.getValue();
        if (focusDate == null) {
            focusDate = LocalDate.now();
        }
        if (YearMonth.from(focusDate).equals(this.displayedYearMonth.get())) {
            this.goToDate(focusDate, true);
        } else {
            this.backMonthButton.requestFocus();
        }
        if (this.backMonthButton.getWidth() == 0.0) {
            this.backMonthButton.requestLayout();
            this.forwardMonthButton.requestLayout();
            this.backYearButton.requestLayout();
            this.forwardYearButton.requestLayout();
        }
    }

    protected void createDayCells() {
        EventHandler<MouseEvent> dayCellActionHandler = ev -> {
            if (ev.getButton() != MouseButton.PRIMARY) {
                return;
            }
            DateCell dayCell = (DateCell)ev.getSource();
            this.selectDayCell(dayCell);
            this.lastFocusedDayCell = dayCell;
        };
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < this.daysPerWeek; ++col) {
                DateCell dayCell = this.createDayCell();
                dayCell.addEventHandler(MouseEvent.MOUSE_CLICKED, dayCellActionHandler);
                this.dayCells.add(dayCell);
            }
        }
        this.dayCellDates = new LocalDate[6 * this.daysPerWeek];
    }

    private DateCell createDayCell() {
        DateCell cell = null;
        if (this.datePicker.getDayCellFactory() != null) {
            cell = this.datePicker.getDayCellFactory().call(this.datePicker);
        }
        if (cell == null) {
            cell = new DateCell();
        }
        return cell;
    }

    protected Locale getLocale() {
        return Locale.getDefault(Locale.Category.FORMAT);
    }

    protected Chronology getPrimaryChronology() {
        return this.datePicker.getChronology();
    }

    protected boolean isValidDate(Chronology chrono, LocalDate date, int offset, ChronoUnit unit) {
        if (date != null) {
            try {
                return this.isValidDate(chrono, date.plus(offset, unit));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isValidDate(Chronology chrono, LocalDate date) {
        try {
            if (date != null) {
                chrono.date(date);
            }
            return true;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }
}

