/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;

public abstract class TableColumnComparatorBase<S, T>
implements Comparator<S> {
    private final List<? extends TableColumnBase> columns;

    public TableColumnComparatorBase(TableColumnBase<S, T> ... columns) {
        this(Arrays.asList(columns));
    }

    public TableColumnComparatorBase(List<? extends TableColumnBase> columns) {
        this.columns = new ArrayList<TableColumnBase>(columns);
    }

    public List<? extends TableColumnBase> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public int compare(S o1, S o2) {
        for (TableColumnBase tableColumnBase : this.columns) {
            Object value2;
            Object value1;
            int result;
            if (!this.isSortable(tableColumnBase) || (result = this.doCompare(tableColumnBase, value1 = tableColumnBase.getCellData(o1), value2 = tableColumnBase.getCellData(o2))) == 0) continue;
            return result;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.columns != null ? this.columns.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableColumnComparatorBase other = (TableColumnComparatorBase)obj;
        return this.columns == other.columns || this.columns != null && this.columns.equals(other.columns);
    }

    public String toString() {
        return "TableColumnComparatorBase [ columns: " + this.getColumns() + "] ";
    }

    public abstract boolean isSortable(TableColumnBase<S, T> var1);

    public abstract int doCompare(TableColumnBase<S, T> var1, T var2, T var3);

    public static final class TreeTableColumnComparator<S, T>
    extends TableColumnComparatorBase<S, T> {
        public TreeTableColumnComparator(TreeTableColumn<S, T> ... columns) {
            super(Arrays.asList(columns));
        }

        public TreeTableColumnComparator(List<TreeTableColumn<S, T>> columns) {
            super(columns);
        }

        @Override
        public boolean isSortable(TableColumnBase<S, T> tcb) {
            TreeTableColumn tc = (TreeTableColumn)tcb;
            return tc.getSortType() != null && tc.isSortable();
        }

        @Override
        public int doCompare(TableColumnBase<S, T> tcb, T value1, T value2) {
            TreeTableColumn tc = (TreeTableColumn)tcb;
            Comparator<T> c = tc.getComparator();
            switch (tc.getSortType()) {
                case ASCENDING: {
                    return c.compare(value1, value2);
                }
                case DESCENDING: {
                    return c.compare(value2, value1);
                }
            }
            return 0;
        }
    }

    public static final class TableColumnComparator<S, T>
    extends TableColumnComparatorBase<S, T> {
        public TableColumnComparator(TableColumn<S, T> ... columns) {
            super(Arrays.asList(columns));
        }

        public TableColumnComparator(List<TableColumn<S, T>> columns) {
            super(columns);
        }

        @Override
        public boolean isSortable(TableColumnBase<S, T> tcb) {
            TableColumn tc = (TableColumn)tcb;
            return tc.getSortType() != null && tc.isSortable();
        }

        @Override
        public int doCompare(TableColumnBase<S, T> tcb, T value1, T value2) {
            TableColumn tc = (TableColumn)tcb;
            Comparator<T> c = tc.getComparator();
            switch (tc.getSortType()) {
                case ASCENDING: {
                    return c.compare(value1, value2);
                }
                case DESCENDING: {
                    return c.compare(value2, value1);
                }
            }
            return 0;
        }
    }
}

